/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.cloud.datamodel.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tm.td.cloud.datamodel.CheckItemStateEnum;
import com.kingdee.eas.tm.td.cloud.datamodel.CheckItemTypeFactory;
import com.kingdee.eas.tm.td.cloud.datamodel.CheckItemTypeInfo;
import com.kingdee.eas.tm.td.cloud.datamodel.client.AbstractCheckItemTypeEditUI;
import com.kingdee.eas.tm.td.common.permsupport.IPermSupport4EditUI;
import com.kingdee.eas.tm.td.common.uihelper.EditUIHelper;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class CheckItemTypeEditUI
extends AbstractCheckItemTypeEditUI
implements IPermSupport4EditUI {
    private static final Logger logger = CoreUIObject.getLogger(CheckItemTypeEditUI.class);
    private EditUIHelper uiHelper = new EditUIHelper(this);
    private String currentCUID;
    private Map btnMap = new HashMap();

    public CheckItemTypeEditUI() throws Exception {
        this.btnMap.put("actionRemove", this.actionRemove);
        this.btnMap.put("actionCancel", this.actionCancel);
        this.btnMap.put("actionCancelCancel", this.actionCancelCancel);
        this.btnMap.put("actionEdit", this.actionEdit);
        this.btnMap.put("actionSave", this.actionSubmit);
        this.btnMap.put("actionCopy", this.actionCopy);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.txtDescription.setMaxLength(255);
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.currentCUID = SysContext.getSysContext().getCurrentCtrlUnit().getId().toString();
        this.initBtnStatus();
    }

    private void initBtnStatus() {
        this.btnCancel.setVisible(true);
        this.btnCancelCancel.setVisible(true);
        CheckItemStateEnum status = this.editData.getState();
        boolean isLight = false;
        if (CheckItemStateEnum.DISABLE.equals((Object)status)) {
            isLight = true;
        }
        this.uiHelper.initBtnStatus(this.btnMap, isLight);
    }

    protected IObjectValue createNewData() {
        CheckItemTypeInfo checkItemTypeInfo = new CheckItemTypeInfo();
        checkItemTypeInfo.setState(CheckItemStateEnum.ENABLE);
        checkItemTypeInfo.setCU(SysContext.getSysContext().getCurrentCtrlUnit());
        return checkItemTypeInfo;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return CheckItemTypeFactory.getRemoteInstance();
    }

    protected void setFieldsNull(AbstractObjectValue newData) {
        CheckItemTypeInfo editData = (CheckItemTypeInfo)newData;
        editData.setNumber(editData.getNumber() + "Copy");
        editData.setCU(SysContext.getSysContext().getCurrentCtrlUnit());
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.uiHelper.checkCanEdit(this.currentCUID, this.editData.getId().toString());
        super.actionEdit_actionPerformed(e);
        this.setOprtState(OprtState.EDIT);
        this.initBtnStatus();
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        this.uiHelper.checkCanAddnew(this.currentCUID);
        super.actionAddNew_actionPerformed(e);
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmit_actionPerformed(e);
        if (!this.getOprtState().equals(OprtState.ADDNEW)) {
            if (this.editData.getState() != null && CheckItemStateEnum.ENABLE.equals((Object)this.editData.getState())) {
                this.setOprtState("VIEW");
            } else {
                this.setOprtState("EDIT");
            }
        }
        this.setDataObject((IObjectValue)this.editData);
        this.loadFields();
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(this.editData.getId().toString());
        this.uiHelper.checkCanRemove(this.currentCUID, ids);
        super.actionRemove_actionPerformed(e);
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        String billId = this.editData.getId().toString();
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(billId);
        this.uiHelper.checkBaseDataPermission(this.currentCUID, ids);
        super.actionCancel_actionPerformed(e);
        this.initBtnStatus();
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        String billId = this.editData.getId().toString();
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(billId);
        this.uiHelper.checkBaseDataPermission(this.currentCUID, ids);
        if (!this.uiHelper.modifySaveOrExit((ItemAction)this.actionSubmit, this.btnSubmit, (ItemAction)this.actionSave, this.btnSave, this.isModifySave())) {
            return;
        }
        super.actionCancelCancel_actionPerformed(e);
        if (this.editData.getState() != null && CheckItemStateEnum.ENABLE.equals((Object)this.editData.getState())) {
            this.setOprtState("VIEW");
        } else {
            this.setOprtState("EDIT");
        }
        this.setDataObject((IObjectValue)this.editData);
        this.loadFields();
    }

    @Override
    public String getBizOrgProperty(OrgType orgType) throws BOSException, EASBizException {
        return "CU";
    }

    @Override
    public String getPermItem(String status) {
        return null;
    }

    @Override
    public KDBizPromptBox getPermMainBizOrg() {
        return null;
    }

    @Override
    public IObjectValue getValueObject() {
        return this.editData;
    }

    @Override
    public ICoreBase getPermInterface() throws Exception {
        return this.getBizInterface();
    }
}

