/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.cloud.datamodel.client;

import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.tm.td.TDUtils;
import com.kingdee.eas.tm.td.cloud.datamodel.CheckResultFactory;
import com.kingdee.eas.tm.td.cloud.datamodel.CheckResultStateEnum;
import com.kingdee.eas.tm.td.cloud.datamodel.CheckTypeEnum;
import com.kingdee.eas.tm.td.cloud.datamodel.client.AbstractCheckResultAuditUI;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class CheckResultAuditUI
extends AbstractCheckResultAuditUI {
    private static final Logger logger = CoreUIObject.getLogger(CheckResultAuditUI.class);

    public void onLoad() throws Exception {
        super.onLoad();
        this.rbAnalysis.setSelected(true);
        this.initBtnStatus();
    }

    protected void initBtnStatus() {
        this.btnConfirm.setEnabled(true);
        this.btnCancel.setEnabled(true);
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        Map uiCtx = this.getUIContext();
        ArrayList ids = (ArrayList)uiCtx.get("ids");
        CheckTypeEnum checkType = (CheckTypeEnum)((Object)uiCtx.get("checkType"));
        CheckResultStateEnum stateEnum = null;
        if (this.rbAnalysis.isSelected()) {
            stateEnum = CheckResultStateEnum.ANALYZED;
        }
        if (this.rbManualPass.isSelected()) {
            stateEnum = CheckResultStateEnum.MANUAL_PASS;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("ids", ids);
        params.put("checkType", (Object)checkType);
        params.put("state", (Object)stateEnum);
        params.put("prompt", this.txtPrompt.getText());
        Map result = CheckResultFactory.getRemoteInstance().updateCheckResult(params);
        ArrayList errMsgs = (ArrayList)result.get("errMsgs");
        this.actionExitCurrent_actionPerformed(e);
        if (errMsgs.size() > 0) {
            String msg = TDUtils.getString("com.kingdee.eas.tm.td.cloud.TDCloudResource", "OPERATION_ERROR", TDUtils.getLocale(), new Object[]{ids.size() - errMsgs.size(), errMsgs.size()});
            String errorDetail = this.buildErrorMsg(errMsgs);
            MsgBox.showDetailAndOK((Component)((Object)this), (String)msg, (String)errorDetail, (int)1);
        } else {
            MsgBox.showInfo((String)"\u5904\u7406\u6210\u529f\uff01");
        }
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.actionExitCurrent_actionPerformed(e);
    }

    public String buildErrorMsg(ArrayList msg) {
        StringBuffer retMsg = new StringBuffer();
        for (int i = 0; i < msg.size(); ++i) {
            retMsg.append(msg.get(i)).append("\r\n");
        }
        return retMsg.toString();
    }
}

