/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.cloud.datamodel.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tm.td.basedata.DataTypeEnum;
import com.kingdee.eas.tm.td.cloud.datamodel.BizDataTypeEnum;
import com.kingdee.eas.tm.td.cloud.datamodel.DataFetchEntryCollection;
import com.kingdee.eas.tm.td.cloud.datamodel.DataFetchEntryInfo;
import com.kingdee.eas.tm.td.cloud.datamodel.DataFetchFactory;
import com.kingdee.eas.tm.td.cloud.datamodel.DataFetchInfo;
import com.kingdee.eas.tm.td.cloud.datamodel.DataModelStateEnum;
import com.kingdee.eas.tm.td.cloud.datamodel.FetchTypeEnum;
import com.kingdee.eas.tm.td.cloud.datamodel.client.AbstractDataFetchEditUI;
import com.kingdee.eas.tm.td.cloud.datamodel.client.DataFetchEntryEditUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class DataFetchEditUI
extends AbstractDataFetchEditUI {
    private static final Logger logger = CoreUIObject.getLogger(DataFetchEditUI.class);
    private static final String COL_ID = "id";
    private static final String COL_SEQ = "seq";
    private static final String COL_NAME = "name";
    private static final String COL_ALIAS = "alias";
    private static final String COL_DATATYPE = "dataType";
    private static final String COL_BIZDATATYPE = "bizDataType";
    private static final String COL_LENGHT = "length";
    private static final String COL_DEFAULTVALUE = "defaultValue";
    private static final String COL_BASEDATABOSTYPE = "baseDataBOSType";
    private static final String COL_BASEDATAALIAS = "baseDataAlias";
    private static final String COL_CALEXPRESSION = "calExpression";
    private static final String COL_CALEXPRESSIONALIAS = "calExpressionAlias";
    private static final String COL_ISVISIBLE = "isVisible";
    private static final String COL_ISSCHEDULED = "isScheduled";
    private static final String COL_WIDTH = "width";
    private String copyDataFetchID = null;

    public DataFetchEditUI() throws Exception {
        this.getDetailTable().checkParsed();
        this.getDetailTable().setEditable(false);
        this.getDetailTable().getSelectManager().setSelectMode(10);
        this.getDetailTable().addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                if (("ADDNEW".equals(DataFetchEditUI.this.getOprtState()) || "EDIT".equals(DataFetchEditUI.this.getOprtState())) && e.getClickCount() == 2) {
                    DataFetchEditUI.this.doEditField();
                }
            }
        });
    }

    private void doEditField() {
        this.checkSelected();
        IRow row = KDTableUtil.getSelectedRow((KDTable)this.getDetailTable());
        DataFetchEntryInfo oldField = (DataFetchEntryInfo)row.getUserObject();
        if (oldField.isIsScheduled()) {
            return;
        }
        DataFetchEntryInfo newField = (DataFetchEntryInfo)oldField.clone();
        UIContext uiContext = new UIContext();
        uiContext.put("fetch", this.editData);
        uiContext.put("fetchEntry", newField);
        IUIWindow uiWindow = null;
        try {
            uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(DataFetchEntryEditUI.class.getName(), (Map)uiContext, null, OprtState.EDIT);
            uiWindow.show();
        }
        catch (Exception e) {
            this.handleException(e);
        }
        DataFetchEntryEditUI entryEditUI = (DataFetchEntryEditUI)uiWindow.getUIObject();
        if (entryEditUI.isConfirm()) {
            this.innerLoadFields();
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnSave.setVisible(false);
    }

    public void onLoad() throws Exception {
        if (this.getOprtState() == null) {
            this.setOprtState("ADDNEW");
        }
        super.onLoad();
        this.afterLoad();
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.initDataStatus();
    }

    private void afterLoad() {
        this.chkMenuItemSubmitAndAddNew.setSelected(false);
        this.initDataStatus();
    }

    protected void setFieldsNull(AbstractObjectValue newData) {
        super.setFieldsNull(newData);
        DataFetchInfo info = (DataFetchInfo)newData;
        info.setNumber(info.getNumber() + "_Copy");
        info.setName(info.getName() + "_Copy");
        info.setState(DataModelStateEnum.SAVE);
    }

    protected void innerLoadFields() {
        this.kdtEntry.removeRows();
        DataFetchEntryInfo fieldInfo = null;
        DataFetchEntryCollection coll = this.editData.getEntry();
        coll.sort(COL_SEQ);
        for (int i = 0; i < coll.size(); ++i) {
            fieldInfo = coll.get(i);
            this.appendNewLine(fieldInfo);
        }
    }

    private void appendNewLine(DataFetchEntryInfo fieldInfo) {
        if (fieldInfo == null) {
            return;
        }
        IRow row = this.kdtEntry.addRow();
        this.updateLineData(fieldInfo, row);
    }

    private void updateLineData(DataFetchEntryInfo fieldInfo, IRow row) {
        if (fieldInfo == null || row == null) {
            return;
        }
        row.getCell(COL_ID).setValue((Object)fieldInfo.getId());
        row.getCell(COL_SEQ).setValue((Object)fieldInfo.getSeq());
        row.getCell(COL_NAME).setValue((Object)fieldInfo.getName());
        row.getCell(COL_ALIAS).setValue((Object)fieldInfo.getAlias());
        row.getCell(COL_DATATYPE).setValue((Object)fieldInfo.getDataType());
        row.getCell(COL_BIZDATATYPE).setValue((Object)fieldInfo.getBizDataType());
        row.getCell(COL_LENGHT).setValue(fieldInfo.getLength() == 0 ? null : Integer.valueOf(fieldInfo.getLength()));
        row.getCell(COL_DEFAULTVALUE).setValue((Object)fieldInfo.getDefaultValue());
        row.getCell(COL_BASEDATABOSTYPE).setValue((Object)fieldInfo.getBaseDataBOSType());
        row.getCell(COL_BASEDATAALIAS).setValue((Object)fieldInfo.getBaseDataAlias());
        row.getCell(COL_CALEXPRESSION).setValue((Object)fieldInfo.getCalExpression());
        row.getCell(COL_CALEXPRESSIONALIAS).setValue((Object)fieldInfo.getCalExpressionAlias());
        row.getCell(COL_ISSCHEDULED).setValue((Object)fieldInfo.isIsScheduled());
        row.getCell(COL_ISVISIBLE).setValue((Object)fieldInfo.isIsVisible());
        row.getCell(COL_WIDTH).setValue((Object)fieldInfo.getWidth());
        row.setUserObject((Object)fieldInfo);
        if (fieldInfo.isIsScheduled()) {
            row.getStyleAttributes().setBackground(new Color(192, 192, 192));
        }
    }

    @Override
    public void addLineAction_actionPerformed(ActionEvent e) throws Exception {
        DataFetchEntryInfo entryInfo = (DataFetchEntryInfo)this.createNewDetailData();
        UIContext uiContext = new UIContext();
        uiContext.put("fetch", this.editData);
        uiContext.put("fetchEntry", entryInfo);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(DataFetchEntryEditUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
        uiWindow.show();
        DataFetchEntryEditUI entryEditUI = (DataFetchEntryEditUI)uiWindow.getUIObject();
        if (entryEditUI.isConfirm()) {
            this.innerLoadFields();
        }
    }

    protected IObjectValue createNewData() {
        DataFetchInfo dataFetchInfo = new DataFetchInfo();
        dataFetchInfo.setFetchType(this.getFetchType());
        return dataFetchInfo;
    }

    protected IObjectValue createNewDetailData() {
        DataFetchEntryInfo info = new DataFetchEntryInfo();
        info.setId(BOSUuid.create((BOSObjectType)info.getBOSType()));
        if (this.editData != null) {
            info.setSeq(this.editData.getEntry().size() + 1);
            info.setName("Field" + info.getSeq());
            info.setAlias(info.getName());
        }
        info.setDataType(DataTypeEnum.String);
        info.setBizDataType(BizDataTypeEnum.AssistInfo);
        info.setIsNullable(true);
        info.setIsVisible(true);
        info.setParent(this.editData);
        return info;
    }

    private String getEntryEditUI() {
        return "com.kingdee.eas.tm.td.cloud.datamodel.client.DataFetchEntryEditUI";
    }

    @Override
    public void removeLineAction_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        int[] rows = KDTableUtil.getSelectedRows((KDTable)this.getDetailTable());
        if (this.confirmRemove()) {
            for (int i = rows.length - 1; i >= 0; --i) {
                int rowIndex = rows[i];
                IRow row = this.kdtEntry.getRow(rowIndex);
                DataFetchEntryInfo entryInfo = (DataFetchEntryInfo)row.getUserObject();
                entryInfo.setSeq(rowIndex);
                if (entryInfo.isIsScheduled()) {
                    MsgBox.showWarning((Component)((Object)this), (String)"\u9884\u8bbe\u6570\u636e\u4e0d\u80fd\u5220\u9664\uff01");
                    SysUtil.abort();
                }
                if (row.getRowIndex() == this.getDetailTable().getRowCount() - 1) {
                    this.getDetailTable().removeRow(row.getRowIndex());
                    this.editData.getEntry().remove(entryInfo);
                    continue;
                }
                this.editData.getEntry().remove(entryInfo);
                this.adjustEntrySeq(entryInfo.getSeq());
                this.innerLoadFields();
            }
        }
    }

    @Override
    public void upLineAction_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        int rowIndex = this.getDetailTable().getSelectManager().get(0).getTop();
        if (rowIndex == 0) {
            return;
        }
        int toRowIndex = rowIndex - 1;
        this.getDetailTable().moveRow(rowIndex, toRowIndex);
        this.getDetailTable().getSelectManager().set(toRowIndex, toRowIndex);
        this.setSeq();
    }

    @Override
    public void downLineAction_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        int rowIndex = this.getDetailTable().getSelectManager().get(0).getTop();
        if (rowIndex == this.getDetailTable().getRowCount() - 1) {
            return;
        }
        int toRowIndex = rowIndex + 1;
        this.getDetailTable().moveRow(rowIndex, toRowIndex);
        this.getDetailTable().getSelectManager().set(toRowIndex, toRowIndex);
        this.setSeq();
    }

    @Override
    public void topLineAction_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        int rowIndex = this.getDetailTable().getSelectManager().get(0).getTop();
        if (rowIndex == 0) {
            return;
        }
        int toRowIndex = 0;
        this.getDetailTable().moveRow(rowIndex, toRowIndex);
        this.getDetailTable().getSelectManager().set(toRowIndex, toRowIndex);
        this.setSeq();
    }

    @Override
    public void bottomLineAction_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        int rowIndex = this.getDetailTable().getSelectManager().get(0).getTop();
        if (rowIndex == this.getDetailTable().getRowCount() - 1) {
            return;
        }
        int toRowIndex = this.getDetailTable().getRowCount() - 1;
        this.getDetailTable().moveRow(rowIndex, toRowIndex);
        this.getDetailTable().getSelectManager().set(toRowIndex, toRowIndex);
        this.setSeq();
    }

    private void setSeq() {
        for (int i = 0; i < this.kdtEntry.getRowCount(); ++i) {
            this.kdtEntry.getCell(i, COL_SEQ).setValue((Object)(i + 1));
        }
    }

    public void checkSelected() {
        if (this.getDetailTable().getRowCount() == 0 || this.getDetailTable().getSelectManager().size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
    }

    private void adjustEntrySeq(int beginIndex) {
        DataFetchEntryInfo fieldInfo = null;
        DataFetchEntryCollection coll = this.editData.getEntry();
        for (int i = beginIndex; i < coll.size(); ++i) {
            fieldInfo = coll.get(i);
            fieldInfo.setSeq(i + 1);
        }
    }

    protected void checkRequiredFields() {
        StringBuffer sb = new StringBuffer();
        if (this.txtNumber.getText().isEmpty()) {
            sb.append("\u3001\u7f16\u7801");
        }
        if (this.txtName.getText().isEmpty()) {
            sb.append("\u3001\u540d\u79f0");
        }
        if (this.txtTblName.getText().isEmpty()) {
            sb.append("\u3001\u8868\u540d");
        }
        if (sb.length() > 0) {
            sb.append("\u4e0d\u80fd\u4e3a\u7a7a");
            MsgBox.showWarning((String)sb.substring(1));
            SysUtil.abort();
        }
        if (this.getDetailTable().getRowCount() < 1) {
            MsgBox.showInfo((Component)((Object)this), (String)"\u5206\u5f55\u4e0d\u80fd\u4e3a\u7a7a");
            SysUtil.abort();
            return;
        }
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.checkRequiredFields();
        super.actionSubmit_actionPerformed(e);
    }

    protected void initDataStatus() {
        super.initDataStatus();
        if ("ADDNEW".equals(this.getOprtState()) || "EDIT".equals(this.getOprtState())) {
            this.btnAddLine.setEnabled(true);
            this.btnRemoveLine.setEnabled(true);
            this.btnUpLine.setEnabled(true);
            this.btnDownLine.setEnabled(true);
            this.btnTopLine.setEnabled(true);
            this.btnBottomLine.setEnabled(true);
            if (this.editData != null) {
                this.actionSubmit.setEnabled(DataModelStateEnum.DISABLE.equals((Object)this.editData.getState()) || DataModelStateEnum.SAVE.equals((Object)this.editData.getState()));
            }
            this.actionEdit.setEnabled(false);
        } else {
            this.btnAddLine.setEnabled(false);
            this.btnRemoveLine.setEnabled(false);
            this.btnUpLine.setEnabled(false);
            this.btnDownLine.setEnabled(false);
            this.btnTopLine.setEnabled(false);
            this.btnBottomLine.setEnabled(false);
            this.actionSave.setEnabled(false);
            if (this.editData != null) {
                this.actionEdit.setEnabled(DataModelStateEnum.DISABLE.equals((Object)this.editData.getState()) || DataModelStateEnum.SAVE.equals((Object)this.editData.getState()));
            }
        }
        if (this.editData != null && this.editData.getId() != null) {
            this.actionCancelCancel.setEnabled(DataModelStateEnum.DISABLE.equals((Object)this.editData.getState()) || DataModelStateEnum.SAVE.equals((Object)this.editData.getState()));
            this.actionCancel.setEnabled(DataModelStateEnum.ENABLE.equals((Object)this.editData.getState()));
            this.actionRemove.setEnabled(DataModelStateEnum.DISABLE.equals((Object)this.editData.getState()) || DataModelStateEnum.SAVE.equals((Object)this.editData.getState()));
        }
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkStateEnableEdit();
        super.actionEdit_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkStateEnableRemove();
        super.actionRemove_actionPerformed(e);
    }

    protected void checkStateEnableEdit() throws Exception {
        if (this.editData.getState().getValue() == 1) {
            MsgBox.showInfo((String)"\u542f\u7528\u72b6\u6001\u4e0d\u80fd\u7f16\u8f91\uff01");
            SysUtil.abort();
        }
    }

    protected void checkStateEnableRemove() throws Exception {
        if (this.editData.getState().getValue() == 1) {
            MsgBox.showInfo((String)"\u542f\u7528\u72b6\u6001\u4e0d\u80fd\u5220\u9664\uff01");
            SysUtil.abort();
        }
    }

    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData != null) {
            this.copyDataFetchID = this.editData.getId().toString();
        }
        super.actionCopy_actionPerformed(e);
    }

    protected void doAfterSubmit(IObjectPK pk) throws Exception {
        if (this.editData != null && this.getOprtState().equals(OprtState.ADDNEW) && !StringUtils.isEmpty((String)this.copyDataFetchID)) {
            DataFetchFactory.getRemoteInstance().copyDataSourceAndTakeDataCondition(this.copyDataFetchID, pk.toString());
            this.copyDataFetchID = null;
        }
        super.doAfterSubmit(pk);
    }

    protected KDTable getDetailTable() {
        return this.kdtEntry;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return DataFetchFactory.getRemoteInstance();
    }

    protected abstract FetchTypeEnum getFetchType();
}

