/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.cloud.datamodel.client;

import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.PreChangeEvent;
import com.kingdee.bos.ctrl.swing.event.PreChangeListener;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.resource.BizEnumInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.tm.td.TDUtils;
import com.kingdee.eas.tm.td.basedata.DataTypeEnum;
import com.kingdee.eas.tm.td.basedata.util.EntitySelector;
import com.kingdee.eas.tm.td.basedata.util.EntitySelectorType;
import com.kingdee.eas.tm.td.cloud.datamodel.BizDataTypeEnum;
import com.kingdee.eas.tm.td.cloud.datamodel.DataFetchEntryCollection;
import com.kingdee.eas.tm.td.cloud.datamodel.DataFetchEntryInfo;
import com.kingdee.eas.tm.td.cloud.datamodel.DataFetchInfo;
import com.kingdee.eas.tm.td.cloud.datamodel.DataModelStateEnum;
import com.kingdee.eas.tm.td.cloud.datamodel.FetchTypeEnum;
import com.kingdee.eas.tm.td.cloud.datamodel.client.AbstractDataFetchEntryEditUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class DataFetchEntryEditUI
extends AbstractDataFetchEntryEditUI {
    private static final Logger logger = CoreUIObject.getLogger(DataFetchEntryEditUI.class);
    private DataFetchInfo parent;
    private DataFetchEntryInfo editData;
    private boolean isConfirm = false;
    private SelectorListener baseDataSelectorListener = null;
    private PreChangeListener baseDataPreChangeListener = null;
    private DataChangeListener baseDataDataChangeListener = null;
    private SelectorListener fieldFormulaSelectorListener = null;
    private ItemListener dataTypeChangeListener = null;

    public void onLoad() throws Exception {
        super.onLoad();
        this.afterLoad();
    }

    private void afterLoad() {
        this.parent = (DataFetchInfo)this.getUIContext().get("fetch");
        this.editData = (DataFetchEntryInfo)this.getUIContext().get("fetchEntry");
        if (FetchTypeEnum.QingAnalysis.equals((Object)this.parent.getFetchType())) {
            this.comboDataType.removeAllItems();
            this.comboDataType.addItem((Object)DataTypeEnum.String);
            this.comboDataType.addItem((Object)DataTypeEnum.Integer);
            this.comboDataType.addItem((Object)DataTypeEnum.Boolean);
            this.comboDataType.addItem((Object)DataTypeEnum.Amount);
            this.comboDataType.addItem((Object)DataTypeEnum.Price);
            this.comboDataType.addItem((Object)DataTypeEnum.Qty);
            this.comboDataType.addItem((Object)DataTypeEnum.Date);
            this.comboDataType.addItem((Object)DataTypeEnum.Timestamp);
        }
        this.comboBizDataType.removeAllItems();
        this.comboBizDataType.addItem((Object)BizDataTypeEnum.AssistInfo);
        if (FetchTypeEnum.RiskScreening.equals((Object)this.parent.getFetchType())) {
            this.comboBizDataType.addItem((Object)BizDataTypeEnum.Dim);
        }
        if (DataTypeEnum.BOSUuid.equals((Object)this.editData.getDataType())) {
            this.prmtBaseData.setEnabled(true);
            this.prmtBaseData.setRequired(true);
            this.contBaseData.setBoundLabelText("\u5173\u8054\u5bf9\u8c61");
        } else if (DataTypeEnum.Enum.equals((Object)this.editData.getDataType())) {
            this.prmtBaseData.setEnabled(true);
            this.prmtBaseData.setRequired(true);
            this.contBaseData.setBoundLabelText("\u679a\u4e3e\u7c7b\u578b");
        } else {
            this.prmtBaseData.setEnabled(false);
        }
        if (FetchTypeEnum.RiskScreening.equals((Object)this.parent.getFetchType()) && !DataModelStateEnum.SAVE.equals((Object)this.parent.getState()) && !DataModelStateEnum.DISABLE.equals((Object)this.parent.getState())) {
            this.comboDataType.setEnabled(false);
        }
        this.setDataObject((IObjectValue)this.editData);
        this.loadFields();
    }

    @Override
    public void loadFields() {
        this.removeListeners();
        super.loadFields();
        this.initListeners();
    }

    private void initListeners() {
        if (this.baseDataSelectorListener == null) {
            this.baseDataSelectorListener = new SelectorListener(){

                public void willShow(SelectorEvent e) {
                    DataFetchEntryEditUI.this.initBaseDataSelector(e);
                }
            };
        }
        if (this.baseDataPreChangeListener == null) {
            this.baseDataPreChangeListener = new PreChangeListener(){

                public void preChange(PreChangeEvent e) {
                    DataFetchEntryEditUI.this.transBaseDataResult(e);
                }
            };
        }
        if (this.baseDataDataChangeListener == null) {
            this.baseDataDataChangeListener = new DataChangeListener(){

                public void dataChanged(DataChangeEvent eventObj) {
                    DataFetchEntryEditUI.this.baseDataDataChanged(eventObj);
                }
            };
        }
        if (this.fieldFormulaSelectorListener == null) {
            this.fieldFormulaSelectorListener = new SelectorListener(){

                public void willShow(SelectorEvent e) {
                }
            };
        }
        if (this.dataTypeChangeListener == null) {
            this.dataTypeChangeListener = new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    DataFetchEntryEditUI.this.dataTypeChanged(e);
                }
            };
        }
        this.prmtBaseData.addSelectorListener(this.baseDataSelectorListener);
        this.prmtBaseData.addPreChangeListener(this.baseDataPreChangeListener);
        this.prmtBaseData.addDataChangeListener(this.baseDataDataChangeListener);
        this.comboDataType.addItemListener(this.dataTypeChangeListener);
    }

    private void dataTypeChanged(ItemEvent e) {
        if (e.getStateChange() != 1) {
            return;
        }
        if (DataTypeEnum.String.equals(e.getItem())) {
            this.txtLength.setEnabled(true);
            this.txtLength.setRequired(true);
        } else {
            this.txtLength.setEnabled(false);
            this.txtLength.setValue((Object)0);
        }
        if (DataTypeEnum.BOSUuid.equals(e.getItem())) {
            this.prmtBaseData.setEnabled(true);
            this.prmtBaseData.setRequired(true);
            this.contBaseData.setBoundLabelText("\u5173\u8054\u5bf9\u8c61");
        } else if (DataTypeEnum.Enum.equals(e.getItem())) {
            this.prmtBaseData.setEnabled(true);
            this.prmtBaseData.setRequired(true);
            this.contBaseData.setBoundLabelText("\u679a\u4e3e\u7c7b\u578b");
        } else {
            this.prmtBaseData.setEnabled(false);
        }
        this.prmtBaseData.setValue(null);
        this.prmtBaseData.setSelector(null);
        if (DataTypeEnum.Qty.equals(e.getItem()) || DataTypeEnum.Amount.equals(e.getItem()) || DataTypeEnum.Price.equals(e.getItem()) || DataTypeEnum.Boolean.equals(e.getItem()) || DataTypeEnum.Integer.equals(e.getItem())) {
            this.txtDefaultValue.setText("0");
        } else {
            this.txtDefaultValue.setText("");
        }
    }

    private void removeListeners() {
        this.prmtBaseData.removeSelectorListener(this.baseDataSelectorListener);
        this.prmtBaseData.removePreChangeListener(this.baseDataPreChangeListener);
        this.prmtBaseData.removeDataChangeListener(this.baseDataDataChangeListener);
        this.comboDataType.removeItemListener(this.dataTypeChangeListener);
    }

    private void initBaseDataSelector(SelectorEvent e) {
        KDPromptBox f7Box = (KDPromptBox)e.getSource();
        if (f7Box.getSelector() == null || !(f7Box.getSelector() instanceof EntitySelector)) {
            DataTypeEnum dataItem = (DataTypeEnum)((Object)this.comboDataType.getSelectedItem());
            EntitySelector selector = null;
            if (DataTypeEnum.BOSUuid.equals((Object)dataItem)) {
                selector = new EntitySelector(this.getUIWindow(), "\u57fa\u7840\u8d44\u6599\u9009\u62e9", EntitySelectorType.BaseData);
            } else if (DataTypeEnum.Enum.equals((Object)dataItem)) {
                selector = new EntitySelector(this.getUIWindow(), "\u679a\u4e3e\u7c7b\u578b\u9009\u62e9", EntitySelectorType.BizEnum);
            }
            f7Box.setSelector(selector);
        }
    }

    private void transBaseDataResult(PreChangeEvent e) {
        KDPromptBox f7Box = (KDPromptBox)e.getSource();
        if (e.getData() != null) {
            if (e.getData() instanceof EntityObjectInfo) {
                EntityObjectInfo entity = (EntityObjectInfo)e.getData();
                e.setData((Object)entity.getDisplayName());
                f7Box.setUserObject((Object)entity);
            } else if (e.getData() instanceof BizEnumInfo) {
                BizEnumInfo bizInfo = (BizEnumInfo)e.getData();
                e.setData((Object)bizInfo.getAlias());
                f7Box.setUserObject((Object)bizInfo);
            }
        } else {
            e.setData(null);
            f7Box.setUserObject(null);
        }
    }

    @Override
    public void actionNew_actionPerformed(ActionEvent e) throws Exception {
        this.storeFields();
        this.checkRequiredFields();
        this.parent.getEntry().add(this.editData);
        this.isConfirm = true;
        this.editData = (DataFetchEntryInfo)this.createNewData();
        this.setDataObject((IObjectValue)this.editData);
        this.loadFields();
    }

    private void checkRequiredFields() {
        if (this.txtName.getText().isEmpty()) {
            this.txtName.requestFocus();
            MsgBox.showInfo((String)TDUtils.getString("com.kingdee.eas.tm.td.cloud.TDCloudResource", "fieldName_notNull", null));
            SysUtil.abort();
        }
        if (!this.checkFieldNameFormat(this.txtName.getText())) {
            this.txtName.requestFocus();
            MsgBox.showInfo((String)TDUtils.getString("com.kingdee.eas.tm.td.cloud.TDCloudResource", "fieldName_formatError", null));
            SysUtil.abort();
        }
        if (this.txtAlias.getEditor().getItem() == null || this.txtAlias.getEditor().getItem().toString().trim().length() == 0) {
            this.txtAlias.requestFocus();
            MsgBox.showInfo((String)TDUtils.getString("com.kingdee.eas.tm.td.cloud.TDCloudResource", "fieldAlias_notNull", null));
            SysUtil.abort();
        }
        this.checkFieldNameDup();
        if (DataTypeEnum.Enum.equals(this.comboDataType.getSelectedItem()) && this.prmtBaseData.getValue() == null) {
            MsgBox.showInfo((String)"\u6570\u636e\u7c7b\u578b\u4e3a\u679a\u4e3e\u578b\uff0c\u679a\u4e3e\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            this.prmtBaseData.requestFocus();
            SysUtil.abort();
        }
    }

    private boolean checkFieldNameFormat(String formulaString) {
        String pattern = "^[a-zA-Z][a-zA-Z0-9_]*$";
        Pattern patt = Pattern.compile(pattern);
        Matcher matcher = patt.matcher(formulaString);
        return matcher.find();
    }

    private void checkFieldNameDup() {
        DataFetchEntryInfo entryInfo = null;
        DataFetchEntryCollection coll = this.parent.getEntry();
        for (int i = 0; i < coll.size(); ++i) {
            entryInfo = coll.get(i);
            if (entryInfo.getId() == null || entryInfo.getId().equals((Object)this.editData.getId()) || !entryInfo.getName().equals(this.txtName.getText())) continue;
            MsgBox.showInfo((String)"\u5b57\u6bb5\u540d\u79f0\u91cd\u590d\uff01");
            this.txtName.requestFocus();
            SysUtil.abort();
        }
    }

    private void baseDataDataChanged(DataChangeEvent eventObj) {
        if (eventObj.getNewValue() == null) {
            this.editData.setBaseDataBOSType(null);
            this.editData.setBaseDataAlias(null);
            return;
        }
        if (eventObj.getNewValue().equals(eventObj.getOldValue())) {
            return;
        }
        DataTypeEnum dataItem = (DataTypeEnum)((Object)this.comboDataType.getSelectedItem());
        if (DataTypeEnum.BOSUuid.equals((Object)dataItem)) {
            EntityObjectInfo bdEntity = (EntityObjectInfo)this.prmtBaseData.getUserObject();
            this.editData.setBaseDataBOSType(bdEntity.getType().toString());
            this.editData.setBaseDataAlias(bdEntity.getDisplayName());
        } else if (DataTypeEnum.Enum.equals((Object)dataItem)) {
            BizEnumInfo bizInfo = (BizEnumInfo)this.prmtBaseData.getUserObject();
            this.editData.setBaseDataBOSType(bizInfo.getFullName());
            this.editData.setBaseDataAlias(bizInfo.getAlias());
        }
    }

    protected IObjectValue createNewData() {
        DataFetchEntryInfo info = new DataFetchEntryInfo();
        info.setId(BOSUuid.create((BOSObjectType)info.getBOSType()));
        info.setSeq(this.parent.getEntry().size() + 1);
        info.setName("Field" + info.getSeq());
        info.setIsNullable(true);
        info.setDataType(DataTypeEnum.String);
        info.setBizDataType(BizDataTypeEnum.AssistInfo);
        info.setIsNullable(true);
        info.setIsVisible(true);
        info.setParent(this.parent);
        return info;
    }

    @Override
    public void actionOK_actionPerformed(ActionEvent e) throws Exception {
        this.checkRequiredFields();
        this.storeFields();
        this.isConfirm = true;
        this.parent.getEntry().add(this.editData);
        this.getUIWindow().close();
    }

    @Override
    public void actionExit_actionPerformed(ActionEvent e) throws Exception {
        this.getUIWindow().close();
    }

    public boolean isConfirm() {
        return this.isConfirm;
    }
}

