/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.cloud.datamodel.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tm.td.cloud.datamodel.IndexTypeFactory;
import com.kingdee.eas.tm.td.cloud.datamodel.IndexTypeInfo;
import com.kingdee.eas.tm.td.cloud.datamodel.IndexTypeStateEnum;
import com.kingdee.eas.tm.td.cloud.datamodel.client.AbstractIndexTypeEditUI;
import com.kingdee.eas.tm.td.common.permsupport.IPermSupport4EditUI;
import com.kingdee.eas.tm.td.common.uihelper.EditUIHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class IndexTypeEditUI
extends AbstractIndexTypeEditUI
implements IPermSupport4EditUI {
    private static final Logger logger = CoreUIObject.getLogger(IndexTypeEditUI.class);
    private EditUIHelper uiHelper = new EditUIHelper(this);
    private String currentCUID;
    private Map btnMap = new HashMap();

    public IndexTypeEditUI() throws Exception {
        this.btnMap.put("actionRemove", this.actionRemove);
        this.btnMap.put("actionCancel", this.actionCancel);
        this.btnMap.put("actionCancelCancel", this.actionCancelCancel);
        this.btnMap.put("actionEdit", this.actionEdit);
        this.btnMap.put("actionSave", this.actionSubmit);
        this.btnMap.put("actionCopy", this.actionCopy);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.txtDecription.setMaxLength(255);
    }

    protected IObjectValue createNewData() {
        IndexTypeInfo info = new IndexTypeInfo();
        info.setState(IndexTypeStateEnum.ENABLE);
        return info;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return IndexTypeFactory.getRemoteInstance();
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.initBtnStatus();
        this.currentCUID = SysContext.getSysContext().getCurrentCtrlUnit().getId().toString();
    }

    private void initBtnStatus() {
        this.chkIsPreinstall.setEnabled(false);
        this.btnCancel.setVisible(true);
        this.btnCancelCancel.setVisible(true);
        IndexTypeStateEnum status = this.editData.getState();
        boolean isLight = false;
        if (IndexTypeStateEnum.DISABLE.equals((Object)status)) {
            isLight = true;
        }
        this.uiHelper.initBtnStatus(this.btnMap, isLight);
    }

    protected void setFieldsNull(AbstractObjectValue newData) {
        IndexTypeInfo editData = (IndexTypeInfo)newData;
        editData.setNumber(editData.getNumber() + "Copy");
        editData.setIsPreinstall(false);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData != null && this.editData.getId() != null) {
            this.uiHelper.checkCanEdit(this.currentCUID, this.editData.getId().toString());
        }
        if (this.editData != null && this.editData.getId() != null && !this.uiHelper.checkPermissionByBaseCU(this.editData.getId().toString(), "td_indextype_update")) {
            return;
        }
        if (this.editData.isIsPreinstall()) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.tm.td.cloud.TDCloudResource", (String)"Preinstall_Not_Edit", (Object[])new String[]{this.editData.getNumber()}));
            SysUtil.abort();
        }
        super.actionEdit_actionPerformed(e);
        this.setOprtState(OprtState.EDIT);
        this.initBtnStatus();
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        this.uiHelper.checkCanAddnew(this.currentCUID);
        super.actionAddNew_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData != null && this.editData.getId() != null) {
            ArrayList<String> ids = new ArrayList<String>();
            ids.add(this.editData.getId().toString());
            this.uiHelper.checkCanRemove(this.currentCUID, ids);
        }
        if (this.editData != null && this.editData.getId() != null && !this.uiHelper.checkPermissionByBaseCU(this.editData.getId().toString(), "td_indextype_delete")) {
            return;
        }
        if (this.editData.isIsPreinstall()) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.tm.td.cloud.TDCloudResource", (String)"Preinstall_Not_Remove", (Object[])new String[]{this.editData.getNumber()}));
            SysUtil.abort();
        }
        super.actionRemove_actionPerformed(e);
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        this.editData.setNumber(this.txtNumber.getText());
        boolean checkNumber = IndexTypeFactory.getRemoteInstance().checkNumber((IObjectValue)this.editData);
        if (!checkNumber) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.tm.td.cloud.TDCloudResource", (String)"Number_Not_Repeat", (Object[])new String[]{this.editData.getNumber()}));
            SysUtil.abort();
        }
        super.actionSave_actionPerformed(e);
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.editData.setNumber(this.txtNumber.getText());
        boolean checkNumber = IndexTypeFactory.getRemoteInstance().checkNumber((IObjectValue)this.editData);
        if (!checkNumber) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.tm.td.cloud.TDCloudResource", (String)"Number_Not_Repeat", (Object[])new String[]{this.editData.getNumber()}));
            SysUtil.abort();
        }
        super.actionSubmit_actionPerformed(e);
        if (!this.getOprtState().equals(OprtState.ADDNEW)) {
            if (this.editData.getState() != null && IndexTypeStateEnum.ENABLE.equals((Object)this.editData.getState())) {
                this.setOprtState("VIEW");
            } else {
                this.setOprtState("EDIT");
            }
        }
        this.setDataObject((IObjectValue)this.editData);
        this.loadFields();
    }

    @Override
    public String getBizOrgProperty(OrgType orgType) throws BOSException, EASBizException {
        return "CU";
    }

    @Override
    public String getPermItem(String status) {
        return null;
    }

    @Override
    public KDBizPromptBox getPermMainBizOrg() {
        return null;
    }

    @Override
    public IObjectValue getValueObject() {
        return this.editData;
    }

    @Override
    public ICoreBase getPermInterface() throws Exception {
        return this.getBizInterface();
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData != null && this.editData.getId() != null) {
            String billId = this.editData.getId().toString();
            ArrayList<String> ids = new ArrayList<String>();
            ids.add(billId);
            this.uiHelper.checkBaseDataPermission(this.currentCUID, ids);
        }
        if (this.editData != null && this.editData.getId() != null && !this.uiHelper.checkPermissionByBaseCU(this.editData.getId().toString(), "td_indextype_cancel")) {
            return;
        }
        super.actionCancel_actionPerformed(e);
        this.initBtnStatus();
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData != null && this.editData.getId() != null) {
            String billId = this.editData.getId().toString();
            ArrayList<String> ids = new ArrayList<String>();
            ids.add(billId);
            this.uiHelper.checkBaseDataPermission(this.currentCUID, ids);
        }
        if (this.editData != null && this.editData.getId() != null && !this.uiHelper.checkPermissionByBaseCU(this.editData.getId().toString(), "td_indextype_cancelcancel")) {
            return;
        }
        if (!this.uiHelper.modifySaveOrExit((ItemAction)this.actionSubmit, this.btnSubmit, (ItemAction)this.actionSave, this.btnSave, this.isModifySave())) {
            return;
        }
        super.actionCancelCancel_actionPerformed(e);
        if (this.editData.getState() != null && IndexTypeStateEnum.ENABLE.equals((Object)this.editData.getState())) {
            this.setOprtState("VIEW");
        } else {
            this.setOprtState("EDIT");
        }
        this.setDataObject((IObjectValue)this.editData);
        this.loadFields();
    }
}

