/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.cloud.datamodel.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ctrl.swing.event.PreChangeEvent;
import com.kingdee.bos.ctrl.swing.event.PreChangeListener;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.EditUI;
import com.kingdee.eas.tm.td.RecordTypeEnum;
import com.kingdee.eas.tm.td.basedata.AccountConfigInfo;
import com.kingdee.eas.tm.td.cloud.EnableStateEnum;
import com.kingdee.eas.tm.td.cloud.datamodel.ArchiveUrlInfo;
import com.kingdee.eas.tm.td.cloud.datamodel.ItemDimMergeEntryInfo;
import com.kingdee.eas.tm.td.cloud.datamodel.ItemDimensionEntryCollection;
import com.kingdee.eas.tm.td.cloud.datamodel.ItemDimensionEntryInfo;
import com.kingdee.eas.tm.td.cloud.datamodel.ItemDimensionFactory;
import com.kingdee.eas.tm.td.cloud.datamodel.ItemDimensionInfo;
import com.kingdee.eas.tm.td.cloud.datamodel.ItemFactory;
import com.kingdee.eas.tm.td.cloud.datamodel.ItemFormatEnum;
import com.kingdee.eas.tm.td.cloud.datamodel.ItemInfo;
import com.kingdee.eas.tm.td.cloud.datamodel.client.AbstractItemDimensionEditUI;
import com.kingdee.eas.tm.td.cloud.utils.TDCloudUtil;
import com.kingdee.eas.tm.td.common.permsupport.IPermSupport4EditUI;
import com.kingdee.eas.tm.td.common.uihelper.EditUIHelper;
import com.kingdee.eas.tm.td.est.RealEstateGroupInfo;
import com.kingdee.eas.tm.td.structure.ReportItemDimensionEnum;
import com.kingdee.eas.tm.td.structure.TaxReportItemInfo;
import com.kingdee.eas.tm.td.structure.TaxReportSheetInfo;
import com.kingdee.eas.tm.td.structure.client.TaxReportItemSelector;
import com.kingdee.eas.tm.td.structure.utils.StructureUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import com.kingdee.util.enums.EnumUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComboBox;
import org.apache.log4j.Logger;

public class ItemDimensionEditUI
extends AbstractItemDimensionEditUI
implements IPermSupport4EditUI {
    private static final Logger logger = CoreUIObject.getLogger(ItemDimensionEditUI.class);
    private EditUIHelper uiHelper = new EditUIHelper((EditUI)this);
    private String currentCUID;
    private static final String TB_ITEM = "item";
    private static final String TB_ITEMNUMBER = "itemNumber";
    private static final String TB_ALIAS = "alias";
    private static final String TB_SUMMARY = "isSummary";
    private static final String TB_ISHIDE = "isHide";
    private static final String TB_ARCHIVEURL = "archiveUrl";
    private static final String TB_ITEMFORMAT = "itemFormat";
    private static final String TB_STATPERIOD = "statPeriod";
    private static final String TB_TAXREPORTSHEET = "taxReportSheet";
    private static final String TB_REPORTROWITEM = "reportRowItem";
    private static final String TB_REPORTCOLUMNITEM = "reportColumnItem";
    private static final String TB_ACCOUNTCONFIG = "accountConfig";
    private static final String TB_BUILDINGTAXESGROUP = "buildingTaxesGroup";
    private static final String[] ENTRY_CHECK_COLUMN = new String[]{"itemNumber"};
    private static final String TB_STARTITEM = "startItem";
    private static final String[] MERGE_ENTRY_CHECK_COLUMN = new String[]{"startRow"};
    private KDTEditAdapter entryTableChange = null;

    public void onLoad() throws Exception {
        this.kdtEntry.checkParsed();
        this.mergeTable.checkParsed();
        super.onLoad();
        this.afterLoad();
    }

    protected void afterLoad() {
        this.chkMenuItemSubmitAndAddNew.setSelected(false);
        this.btnAuditResult.setVisible(false);
        this.initEntry();
        this.initEntryControls();
    }

    private void initEntry() {
        KDBizPromptBox box = new KDBizPromptBox();
        box.setEditable(true);
        box.setQueryInfo("com.kingdee.eas.tm.td.cloud.datamodel.app.ItemQuery");
        box.setEnabledMultiSelection(true);
        box.setDisplayFormat("$number$");
        box.setEditFormat("$number$");
        box.setCommitFormat("$number$");
        this.getDetailTable().getColumn(TB_ITEMNUMBER).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)box));
        ObjectValueRender avr = new ObjectValueRender();
        avr.setFormat((IDataFormat)new BizDataFormat("$number$"));
        this.getDetailTable().getColumn(TB_ITEMNUMBER).setRenderer((IBasicRender)avr);
        KDBizPromptBox box1 = new KDBizPromptBox();
        box1.setEditable(true);
        box1.setQueryInfo("com.kingdee.eas.tm.td.cloud.datamodel.app.ArchiveUrlQuery");
        box1.setEnabledMultiSelection(true);
        box1.setDisplayFormat("$name$");
        box1.setEditFormat("$number$");
        box1.setCommitFormat("$number$");
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("state", (Object)0, CompareType.EQUALS));
        entityViewInfo.setFilter(filterInfo);
        box1.setEntityViewInfo(entityViewInfo);
        this.getDetailTable().getColumn(TB_ARCHIVEURL).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)box1));
        ObjectValueRender avr1 = new ObjectValueRender();
        avr1.setFormat((IDataFormat)new BizDataFormat("$number$"));
        this.getDetailTable().getColumn(TB_ARCHIVEURL).setRenderer((IBasicRender)avr1);
        KDBizPromptBox box2 = new KDBizPromptBox();
        box2.setEditable(true);
        box2.setQueryInfo("com.kingdee.eas.tm.td.structure.app.TaxReportSheetQuery");
        box2.setEnabledMultiSelection(true);
        box2.setDisplayFormat("$name$");
        box2.setEditFormat("$number$");
        box2.setCommitFormat("$number$");
        box2.setEnabledMultiSelection(false);
        EntityViewInfo entityViewInfo1 = new EntityViewInfo();
        FilterInfo filterInfo1 = new FilterInfo();
        filterInfo1.getFilterItems().add(new FilterItemInfo("state", (Object)"2", CompareType.EQUALS));
        entityViewInfo1.setFilter(filterInfo1);
        box2.setEntityViewInfo(entityViewInfo1);
        this.getDetailTable().getColumn(TB_TAXREPORTSHEET).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)box2));
        ObjectValueRender avr2 = new ObjectValueRender();
        avr2.setFormat((IDataFormat)new BizDataFormat("$name$"));
        this.getDetailTable().getColumn(TB_TAXREPORTSHEET).setRenderer((IBasicRender)avr2);
        KDBizPromptBox box3 = new KDBizPromptBox();
        this.initItemF7(box3, this.kdtEntry);
        box3.setEditable(true);
        box3.setQueryInfo("com.kingdee.eas.tm.td.structure.app.TaxReportItemQuery");
        box3.setEnabledMultiSelection(true);
        box3.setDisplayFormat("$name$");
        box3.setEditFormat("$number$");
        box3.setCommitFormat("$number$");
        box3.setEnabledMultiSelection(false);
        EntityViewInfo entityViewInfo2 = new EntityViewInfo();
        FilterInfo filterInfo2 = new FilterInfo();
        filterInfo2.getFilterItems().add(new FilterItemInfo("itemDimension", (Object)0, CompareType.EQUALS));
        entityViewInfo2.setFilter(filterInfo2);
        box3.setEntityViewInfo(entityViewInfo2);
        this.getDetailTable().getColumn(TB_REPORTROWITEM).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)box3));
        ObjectValueRender avr3 = new ObjectValueRender();
        avr3.setFormat((IDataFormat)new BizDataFormat("$name$"));
        this.getDetailTable().getColumn(TB_REPORTROWITEM).setRenderer((IBasicRender)avr3);
        KDBizPromptBox box4 = new KDBizPromptBox();
        this.initItemF7(box4, this.kdtEntry);
        box4.setEditable(true);
        box4.setQueryInfo("com.kingdee.eas.tm.td.structure.app.TaxReportItemQuery");
        box4.setEnabledMultiSelection(true);
        box4.setDisplayFormat("$name$");
        box4.setEditFormat("$number$");
        box4.setCommitFormat("$number$");
        box4.setEnabledMultiSelection(false);
        EntityViewInfo entityViewInfo3 = new EntityViewInfo();
        FilterInfo filterInfo3 = new FilterInfo();
        filterInfo3.getFilterItems().add(new FilterItemInfo("itemDimension", (Object)1, CompareType.EQUALS));
        entityViewInfo3.setFilter(filterInfo3);
        box4.setEntityViewInfo(entityViewInfo3);
        this.getDetailTable().getColumn(TB_REPORTCOLUMNITEM).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)box4));
        ObjectValueRender avr4 = new ObjectValueRender();
        avr4.setFormat((IDataFormat)new BizDataFormat("$name$"));
        this.getDetailTable().getColumn(TB_REPORTCOLUMNITEM).setRenderer((IBasicRender)avr4);
        KDBizPromptBox box5 = new KDBizPromptBox();
        box5.setEditable(true);
        box5.setQueryInfo("com.kingdee.eas.tm.td.basedata.app.AccountConfigF7Query");
        box5.setEnabledMultiSelection(true);
        box5.setDisplayFormat("$name$");
        box5.setEditFormat("$number$");
        box5.setCommitFormat("$number$");
        box5.setEnabledMultiSelection(false);
        this.getDetailTable().getColumn(TB_ACCOUNTCONFIG).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)box5));
        ObjectValueRender avr5 = new ObjectValueRender();
        avr5.setFormat((IDataFormat)new BizDataFormat("$name$"));
        this.getDetailTable().getColumn(TB_ACCOUNTCONFIG).setRenderer((IBasicRender)avr5);
        KDBizPromptBox box6 = new KDBizPromptBox();
        box6.setEditable(true);
        box6.setQueryInfo("com.kingdee.eas.tm.td.ert.app.F7BuildingTaxesGroupQuery");
        box6.setEnabledMultiSelection(true);
        box6.setDisplayFormat("$name$");
        box6.setEditFormat("$number$");
        box6.setCommitFormat("$number$");
        box6.setEnabledMultiSelection(false);
        EntityViewInfo entityViewInfo4 = new EntityViewInfo();
        FilterInfo filterInfo4 = new FilterInfo();
        filterInfo4.getFilterItems().add(new FilterItemInfo("state", (Object)"1", CompareType.EQUALS));
        entityViewInfo4.setFilter(filterInfo4);
        box6.setEntityViewInfo(entityViewInfo4);
        this.getDetailTable().getColumn(TB_BUILDINGTAXESGROUP).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)box6));
        ObjectValueRender avr6 = new ObjectValueRender();
        avr6.setFormat((IDataFormat)new BizDataFormat("$name$"));
        this.getDetailTable().getColumn(TB_BUILDINGTAXESGROUP).setRenderer((IBasicRender)avr6);
        this.getDetailTable().getColumn(TB_ACCOUNTCONFIG).getStyleAttributes().setLocked(true);
        this.getDetailTable().getColumn(TB_BUILDINGTAXESGROUP).getStyleAttributes().setLocked(true);
        KDComboBox enumEditor = new KDComboBox();
        enumEditor.addItems(EnumUtils.getEnumList((String)ItemFormatEnum.class.getName()).toArray());
        this.kdtEntry.getColumn(TB_ITEMFORMAT).setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)enumEditor));
        this.setEnumEditor(this.kdtEntry, TB_STATPERIOD, "com.kingdee.eas.tm.td.cloud.datamodel.StatPeriodEnum");
    }

    protected void initItemF7(KDBizPromptBox box, final KDTable table) {
        box.setEditable(false);
        box.setRefresh(false);
        box.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                KDPromptBox f7Box = (KDPromptBox)e.getSource();
                int rowIndex = table.getEditManager().getEditRowIndex();
                int colIndex = table.getEditManager().getEditColIndex();
                IRow row = table.getRow(rowIndex);
                Object value = row.getCell(ItemDimensionEditUI.TB_TAXREPORTSHEET).getValue();
                TaxReportSheetInfo sheetInfo = null;
                if (value != null) {
                    if (value instanceof TaxReportSheetInfo) {
                        sheetInfo = (TaxReportSheetInfo)row.getCell(ItemDimensionEditUI.TB_TAXREPORTSHEET).getValue();
                    } else if (!StringUtils.isEmpty((String)value.toString())) {
                        try {
                            sheetInfo = StructureUtils.getTaxReportSheetByNumber(null, value.toString());
                        }
                        catch (BOSException e1) {
                            ItemDimensionEditUI.this.handUIException(e1);
                        }
                    }
                }
                if (sheetInfo == null) {
                    MsgBox.showInfo((String)"\u8bf7\u9009\u62e9\u8868\u9875\u7c7b\u578b!");
                    SysUtil.abort();
                }
                ReportItemDimensionEnum itemDimension = null;
                ArrayList<TaxReportItemInfo> rptItemSelected = new ArrayList<TaxReportItemInfo>();
                value = f7Box.getValue();
                TaxReportItemInfo itemInfo = null;
                if (value != null) {
                    if (value instanceof TaxReportItemInfo) {
                        itemInfo = (TaxReportItemInfo)value;
                        rptItemSelected.add(itemInfo);
                    } else if (!StringUtils.isEmpty((String)value.toString())) {
                        try {
                            itemInfo = StructureUtils.getTaxReportItemByNumber(null, value.toString());
                            rptItemSelected.add(itemInfo);
                        }
                        catch (BOSException e1) {
                            ItemDimensionEditUI.this.handUIException(e1);
                        }
                    }
                }
                if (colIndex == 3) {
                    itemDimension = ReportItemDimensionEnum.ROW;
                } else if (colIndex == 4) {
                    itemDimension = ReportItemDimensionEnum.COLUMN;
                }
                TaxReportItemSelector selector = new TaxReportItemSelector(sheetInfo, itemDimension, rptItemSelected);
                selector.setEnabledMultiSelection(false);
                f7Box.setSelector((KDPromptSelector)selector);
            }
        });
        box.addPreChangeListener(new PreChangeListener(){

            public void preChange(PreChangeEvent e) {
                KDPromptBox f7Box = (KDPromptBox)e.getSource();
                e.setResult(1);
            }
        });
    }

    private void initEntryControls() {
        int rowCount = this.getDetailTable().getRowCount();
        for (int row = 0; row < rowCount; ++row) {
            if (this.getDetailTable().getCell(row, TB_ITEMNUMBER) != null && this.getDetailTable().getCell(row, TB_ITEMNUMBER).getValue() != null) {
                this.getDetailTable().getCell(row, TB_TAXREPORTSHEET).getStyleAttributes().setLocked(true);
                this.getDetailTable().getCell(row, TB_REPORTROWITEM).getStyleAttributes().setLocked(true);
                this.getDetailTable().getCell(row, TB_REPORTCOLUMNITEM).getStyleAttributes().setLocked(true);
                this.getDetailTable().getCell(row, TB_ACCOUNTCONFIG).getStyleAttributes().setLocked(true);
                this.getDetailTable().getCell(row, TB_BUILDINGTAXESGROUP).getStyleAttributes().setLocked(true);
                continue;
            }
            if (this.getDetailTable().getCell(row, TB_TAXREPORTSHEET) == null && this.getDetailTable().getCell(row, TB_REPORTROWITEM).getValue() == null && this.getDetailTable().getCell(row, TB_REPORTCOLUMNITEM).getValue() == null && this.getDetailTable().getCell(row, TB_ACCOUNTCONFIG).getValue() == null && this.getDetailTable().getCell(row, TB_BUILDINGTAXESGROUP).getValue() == null) {
                this.getDetailTable().getCell(row, TB_ITEMNUMBER).getStyleAttributes().setLocked(false);
                continue;
            }
            this.getDetailTable().getCell(row, TB_ITEMNUMBER).getStyleAttributes().setLocked(true);
            TaxReportSheetInfo info = null;
            if (!(this.getDetailTable().getCell(row, TB_TAXREPORTSHEET).getValue() instanceof TaxReportSheetInfo)) continue;
            info = (TaxReportSheetInfo)this.getDetailTable().getCell(row, TB_TAXREPORTSHEET).getValue();
            if (RecordTypeEnum.Account.equals((Object)info.getRecordType())) {
                this.getDetailTable().getCell(row, TB_ACCOUNTCONFIG).getStyleAttributes().setLocked(false);
            } else {
                this.getDetailTable().getCell(row, TB_ACCOUNTCONFIG).getStyleAttributes().setLocked(true);
            }
            if (RecordTypeEnum.TaxDeclare.equals((Object)info.getRecordType()) && "006".equals(info.getTaxType().getNumber())) {
                this.getDetailTable().getCell(row, TB_ACCOUNTCONFIG).getStyleAttributes().setLocked(false);
                continue;
            }
            this.getDetailTable().getCell(row, TB_BUILDINGTAXESGROUP).getStyleAttributes().setLocked(true);
        }
    }

    protected void setEnumEditor(KDTable table, String columeName, String enumClazz) {
        KDComboBox enumEditor = new KDComboBox();
        enumEditor.addItems(EnumUtils.getEnumList((String)enumClazz).toArray());
        table.getColumn(columeName).setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)enumEditor));
    }

    private void initMergeTableItemF7() {
        ICellEditor cellEditor = this.mergeTable.getColumn(TB_STARTITEM).getEditor();
        if (cellEditor == null) {
            return;
        }
        KDBizPromptBox box = (KDBizPromptBox)cellEditor.getComponent();
        HashSet<String> idSet = new HashSet<String>();
        idSet.add("888888888888888888888888");
        int rowCount = this.getDetailTable().getRowCount();
        ItemInfo itemInfo = null;
        for (int i = 0; i < rowCount; ++i) {
            itemInfo = (ItemInfo)this.getDetailTable().getCell(i, TB_ITEMNUMBER).getValue();
            if (itemInfo == null) continue;
            idSet.add(itemInfo.getId().toString());
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        view.setFilter(filter);
        box.setEntityViewInfo(view);
    }

    @Override
    public void loadFields() {
        this.removeListener();
        ItemDimensionEntryCollection coll = this.editData.getEntry();
        coll.sort("seq");
        super.loadFields();
        this.currentCUID = SysContext.getSysContext().getCurrentCtrlUnit().getId().toString();
        this.chkIsPreinstall.setEnabled(false);
        this.initButtonStatus();
        this.initEntryControls();
        this.initListeners();
    }

    protected void setFieldsNull(AbstractObjectValue newData) {
        ItemDimensionInfo editData = (ItemDimensionInfo)newData;
        editData.setNumber(editData.getNumber() + "Copy");
        editData.setIsPreinstall(false);
    }

    private void initListeners() {
        if (this.entryTableChange == null) {
            this.entryTableChange = new KDTEditAdapter(){

                public void editStopped(KDTEditEvent e) {
                    try {
                        ItemDimensionEditUI.this.kdtEntry_ChangedStopped(e);
                    }
                    catch (Exception exc) {
                        ItemDimensionEditUI.this.handUIException(exc);
                    }
                }
            };
        }
        this.kdtEntry.addKDTEditListener((KDTEditListener)this.entryTableChange);
    }

    private void removeListener() {
        if (this.entryTableChange != null) {
            this.kdtEntry.removeKDTEditListener((KDTEditListener)this.entryTableChange);
        }
    }

    protected void kdtEntry_editStarted(KDTEditEvent e) throws Exception {
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        IRow row = this.mergeTable.getRow(rowIndex);
        String fieldName = this.mergeTable.getColumnKey(colIndex);
        if (TB_STARTITEM.equals(fieldName)) {
            this.initStartItemF7(e);
        }
    }

    private void initStartItemF7(KDTEditEvent e) {
        int colIndex;
        int rowIndex = e.getRowIndex();
        KDBizPromptBox f7Box = (KDBizPromptBox)this.mergeTable.getCell(rowIndex, colIndex = e.getColIndex()).getEditor();
        if (f7Box == null) {
            return;
        }
        HashSet<String> idSet = new HashSet<String>();
        idSet.add("888888888888888888888888");
        int rowCount = this.getDetailTable().getRowCount();
        ItemInfo itemInfo = null;
        for (int i = 0; i < rowCount; ++i) {
            itemInfo = (ItemInfo)this.getDetailTable().getCell(i, TB_ITEMNUMBER).getValue();
            if (itemInfo == null) continue;
            idSet.add(itemInfo.getId().toString());
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        view.setFilter(filter);
        f7Box.setEntityViewInfo(view);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void kdtEntry_ChangedStopped(KDTEditEvent e) throws Exception {
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        IRow row = this.kdtEntry.getRow(rowIndex);
        String fieldName = this.kdtEntry.getColumnKey(colIndex);
        if (TB_ITEMNUMBER.equals(fieldName)) {
            this.itemChanged(e);
            return;
        } else if (TB_ALIAS.equals(fieldName)) {
            String alias = (String)e.getValue();
            if (alias != null && !StringUtils.isEmpty((String)alias.trim())) return;
            row.getCell(TB_ALIAS).setValue(e.getOldValue());
            return;
        } else if (TB_ARCHIVEURL.equals(fieldName)) {
            if (TDCloudUtil.isEqual(e.getValue(), e.getOldValue())) {
                return;
            }
            if (e.getValue() == null) {
                row.getCell(TB_ARCHIVEURL).setValue(null);
                return;
            }
            ArchiveUrlInfo archiveinfo = null;
            if (e.getValue() instanceof ArchiveUrlInfo) {
                archiveinfo = (ArchiveUrlInfo)e.getValue();
                row.getCell(TB_ARCHIVEURL).setValue((Object)archiveinfo);
                return;
            } else {
                if (!(e.getValue() instanceof Object[])) return;
                Object[] objects = (Object[])e.getValue();
                if (objects.length == 0) {
                    return;
                }
                archiveinfo = (ArchiveUrlInfo)objects[0];
                row.getCell(TB_ARCHIVEURL).setValue((Object)archiveinfo);
            }
            return;
        } else if (TB_TAXREPORTSHEET.equals(fieldName)) {
            this.itemSetChange(e);
            this.setItemLock(e);
            return;
        } else if (TB_REPORTROWITEM.equals(fieldName)) {
            this.itemSetChange(e);
            this.setItemLock(e);
            return;
        } else if (TB_REPORTCOLUMNITEM.equals(fieldName)) {
            this.itemSetChange(e);
            this.setItemLock(e);
            return;
        } else if (TB_ACCOUNTCONFIG.equals(fieldName)) {
            this.itemSetChange(e);
            this.setItemLock(e);
            return;
        } else {
            if (!TB_BUILDINGTAXESGROUP.equals(fieldName)) return;
            this.itemSetChange(e);
            this.setItemLock(e);
        }
    }

    protected void setItemLock(KDTEditEvent e) {
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        IRow row = this.kdtEntry.getRow(rowIndex);
        if (row.getCell(TB_TAXREPORTSHEET).getValue() == null && row.getCell(TB_REPORTROWITEM).getValue() == null && row.getCell(TB_REPORTCOLUMNITEM).getValue() == null && row.getCell(TB_ACCOUNTCONFIG).getValue() == null && row.getCell(TB_BUILDINGTAXESGROUP).getValue() == null) {
            row.getCell(TB_ITEMNUMBER).getStyleAttributes().setLocked(false);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void itemSetChange(KDTEditEvent e) {
        if (TDCloudUtil.isEqual(e.getValue(), e.getOldValue())) {
            return;
        }
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        IRow row = this.kdtEntry.getRow(rowIndex);
        String fieldName = this.kdtEntry.getColumnKey(colIndex);
        if (TB_TAXREPORTSHEET.equals(fieldName)) {
            if (e.getValue() == null) {
                row.getCell(TB_TAXREPORTSHEET).setValue(null);
                row.getCell(TB_ACCOUNTCONFIG).setValue(null);
                row.getCell(TB_ACCOUNTCONFIG).getStyleAttributes().setLocked(true);
                row.getCell(TB_BUILDINGTAXESGROUP).setValue(null);
                row.getCell(TB_BUILDINGTAXESGROUP).getStyleAttributes().setLocked(true);
                return;
            }
            TaxReportSheetInfo info = null;
            if (!(e.getValue() instanceof TaxReportSheetInfo)) return;
            info = (TaxReportSheetInfo)e.getValue();
            row.getCell(TB_TAXREPORTSHEET).setValue((Object)info);
            row.getCell(TB_ACCOUNTCONFIG).setValue(null);
            row.getCell(TB_BUILDINGTAXESGROUP).setValue(null);
            row.getCell(TB_ITEMNUMBER).getStyleAttributes().setLocked(true);
            if (RecordTypeEnum.Account.equals((Object)info.getRecordType())) {
                row.getCell(TB_ACCOUNTCONFIG).getStyleAttributes().setLocked(false);
            } else {
                row.getCell(TB_ACCOUNTCONFIG).setValue(null);
                row.getCell(TB_ACCOUNTCONFIG).getStyleAttributes().setLocked(true);
            }
            if (RecordTypeEnum.TaxDeclare.equals((Object)info.getRecordType()) && "ZCyrvv6oAnPgU0ETqMCc49uK96Y=".equals(info.getTaxType().getId().toString())) {
                row.getCell(TB_ACCOUNTCONFIG).getStyleAttributes().setLocked(false);
                return;
            } else {
                row.getCell(TB_BUILDINGTAXESGROUP).setValue(null);
                row.getCell(TB_BUILDINGTAXESGROUP).getStyleAttributes().setLocked(true);
            }
            return;
        } else if (TB_REPORTROWITEM.equals(fieldName)) {
            if (e.getValue() == null) {
                row.getCell(TB_REPORTROWITEM).setValue(null);
                return;
            }
            TaxReportItemInfo info = null;
            if (!(e.getValue() instanceof TaxReportItemInfo)) return;
            info = (TaxReportItemInfo)e.getValue();
            row.getCell(TB_REPORTROWITEM).setValue((Object)info);
            row.getCell(TB_ITEMNUMBER).getStyleAttributes().setLocked(true);
            return;
        } else if (TB_REPORTCOLUMNITEM.equals(fieldName)) {
            if (e.getValue() == null) {
                row.getCell(TB_REPORTCOLUMNITEM).setValue(null);
                return;
            }
            TaxReportItemInfo info = null;
            if (!(e.getValue() instanceof TaxReportItemInfo)) return;
            info = (TaxReportItemInfo)e.getValue();
            row.getCell(TB_REPORTCOLUMNITEM).setValue((Object)info);
            row.getCell(TB_ITEMNUMBER).getStyleAttributes().setLocked(true);
            return;
        } else if (TB_ACCOUNTCONFIG.equals(fieldName)) {
            if (e.getValue() == null) {
                row.getCell(TB_ACCOUNTCONFIG).setValue(null);
                return;
            }
            AccountConfigInfo info = null;
            if (!(e.getValue() instanceof AccountConfigInfo)) return;
            info = (AccountConfigInfo)e.getValue();
            row.getCell(TB_ACCOUNTCONFIG).setValue((Object)info);
            row.getCell(TB_ITEMNUMBER).getStyleAttributes().setLocked(true);
            return;
        } else {
            if (!TB_BUILDINGTAXESGROUP.equals(fieldName)) return;
            if (e.getValue() == null) {
                row.getCell(TB_BUILDINGTAXESGROUP).setValue(null);
                return;
            }
            RealEstateGroupInfo info = null;
            if (!(e.getValue() instanceof RealEstateGroupInfo)) return;
            info = (RealEstateGroupInfo)e.getValue();
            row.getCell(TB_BUILDINGTAXESGROUP).setValue((Object)info);
            row.getCell(TB_ITEMNUMBER).getStyleAttributes().setLocked(true);
        }
    }

    protected void itemChanged(KDTEditEvent e) {
        try {
            int rowIndex = e.getRowIndex();
            IRow row = this.kdtEntry.getRow(rowIndex);
            if (TDCloudUtil.isEqual(e.getValue(), e.getOldValue())) {
                return;
            }
            if (e.getValue() == null) {
                this.clearRow(row);
                return;
            }
            ItemInfo[] infos = null;
            if (e.getValue() instanceof ItemInfo[]) {
                infos = (ItemInfo[])e.getValue();
            } else if (e.getValue() instanceof ItemInfo) {
                infos = new ItemInfo[]{(ItemInfo)e.getValue()};
            } else if (e.getValue() instanceof Object[]) {
                Object[] objects = (Object[])e.getValue();
                if (objects.length == 0) {
                    return;
                }
                infos = new ItemInfo[objects.length];
                System.arraycopy(objects, 0, infos, 0, objects.length);
            } else {
                return;
            }
            if (infos == null || infos.length == 0) {
                this.clearRow(row);
                return;
            }
            ItemInfo itemInfo = null;
            Map items = this.getItemCollection(infos);
            int index = 0;
            for (int i = 0; i < infos.length; ++i) {
                itemInfo = infos[i];
                if (itemInfo == null) {
                    this.getDetailTable().getRow(rowIndex + index).getCell(TB_ITEM).setValue(null);
                    this.getDetailTable().getRow(rowIndex + index).getCell(TB_ALIAS).setValue(null);
                    this.getDetailTable().getRow(rowIndex + index).getCell(TB_STATPERIOD).setValue(null);
                    this.getDetailTable().getRow(rowIndex + index).getCell(TB_TAXREPORTSHEET).setValue(null);
                    this.getDetailTable().getRow(rowIndex + index).getCell(TB_REPORTROWITEM).setValue(null);
                    this.getDetailTable().getRow(rowIndex + index).getCell(TB_REPORTCOLUMNITEM).setValue(null);
                    this.getDetailTable().getRow(rowIndex + index).getCell(TB_ACCOUNTCONFIG).setValue(null);
                    this.getDetailTable().getRow(rowIndex + index).getCell(TB_BUILDINGTAXESGROUP).setValue(null);
                    this.getDetailTable().getRow(rowIndex + index).getCell(TB_TAXREPORTSHEET).getStyleAttributes().setLocked(false);
                    this.getDetailTable().getRow(rowIndex + index).getCell(TB_REPORTROWITEM).getStyleAttributes().setLocked(false);
                    this.getDetailTable().getRow(rowIndex + index).getCell(TB_REPORTCOLUMNITEM).getStyleAttributes().setLocked(false);
                    this.getDetailTable().getRow(rowIndex + index).getCell(TB_ACCOUNTCONFIG).getStyleAttributes().setLocked(false);
                    this.getDetailTable().getRow(rowIndex + index).getCell(TB_BUILDINGTAXESGROUP).getStyleAttributes().setLocked(false);
                    continue;
                }
                if (index > 0) {
                    this.getDetailTable().addRow(rowIndex + index);
                }
                IRow irow = this.getDetailTable().getRow(rowIndex + index);
                irow.getCell(TB_ITEMNUMBER).setValue((Object)itemInfo);
                irow.getCell(TB_ITEM).setValue((Object)itemInfo.getName());
                irow.getCell(TB_ALIAS).setValue((Object)itemInfo.getName());
                irow.getCell(TB_STATPERIOD).setValue((Object)itemInfo.getStatPeriod());
                irow.getCell(TB_SUMMARY).setValue((Object)false);
                irow.getCell(TB_ISHIDE).setValue((Object)false);
                this.getDetailTable().getRow(rowIndex + index).getCell(TB_TAXREPORTSHEET).getStyleAttributes().setLocked(true);
                this.getDetailTable().getRow(rowIndex + index).getCell(TB_REPORTROWITEM).getStyleAttributes().setLocked(true);
                this.getDetailTable().getRow(rowIndex + index).getCell(TB_REPORTCOLUMNITEM).getStyleAttributes().setLocked(true);
                this.getDetailTable().getRow(rowIndex + index).getCell(TB_ACCOUNTCONFIG).getStyleAttributes().setLocked(true);
                this.getDetailTable().getRow(rowIndex + index).getCell(TB_BUILDINGTAXESGROUP).getStyleAttributes().setLocked(true);
                if (!itemInfo.isIsSumItem()) {
                    irow.getCell(TB_TAXREPORTSHEET).setValue((Object)((ItemInfo)items.get(itemInfo.getId().toString())).getTaxReportSheet());
                    irow.getCell(TB_REPORTROWITEM).setValue((Object)((ItemInfo)items.get(itemInfo.getId().toString())).getReportRowItem());
                    irow.getCell(TB_REPORTCOLUMNITEM).setValue((Object)((ItemInfo)items.get(itemInfo.getId().toString())).getReportColumnItem());
                    irow.getCell(TB_ACCOUNTCONFIG).setValue((Object)((ItemInfo)items.get(itemInfo.getId().toString())).getAccountConfig());
                    irow.getCell(TB_BUILDINGTAXESGROUP).setValue((Object)((ItemInfo)items.get(itemInfo.getId().toString())).getBuildTaxesGroup());
                }
                ++index;
            }
        }
        catch (Exception exc) {
            this.handUIException(exc);
        }
    }

    private Map getItemCollection(ItemInfo[] infos) throws BOSException {
        HashMap<String, ItemInfo> items = new HashMap<String, ItemInfo>();
        HashSet<String> itemIds = new HashSet<String>();
        ItemInfo itemInfo = null;
        for (int i = 0; i < infos.length; ++i) {
            itemInfo = infos[i];
            itemIds.add(itemInfo.getId().toString());
        }
        EntityViewInfo ev = new EntityViewInfo();
        SelectorItemCollection col = new SelectorItemCollection();
        col.add(new SelectorItemInfo("*"));
        col.add(new SelectorItemInfo("taxReportSheet.*"));
        col.add(new SelectorItemInfo("reportRowItem.*"));
        col.add(new SelectorItemInfo("reportColumnItem.*"));
        col.add(new SelectorItemInfo("accountConfig.*"));
        col.add(new SelectorItemInfo("buildTaxesGroup.*"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", itemIds, CompareType.INCLUDE));
        ev.setSelector(col);
        ev.setFilter(filter);
        CoreBaseCollection coll = ItemFactory.getRemoteInstance().getCollection(ev);
        if (coll.size() > 0) {
            for (int i = 0; i < coll.size(); ++i) {
                itemInfo = (ItemInfo)coll.get(i);
                items.put(itemInfo.getId().toString(), itemInfo);
            }
        }
        return items;
    }

    private void clearRow(IRow row) {
        row.getCell(TB_ITEMNUMBER).setValue(null);
        row.getCell(TB_ITEM).setValue(null);
        row.getCell(TB_ALIAS).setValue(null);
        row.getCell(TB_SUMMARY).setValue((Object)false);
        row.getCell(TB_ISHIDE).setValue((Object)false);
        row.getCell(TB_ARCHIVEURL).setValue(null);
        row.getCell(TB_STATPERIOD).setValue(null);
        row.getCell(TB_TAXREPORTSHEET).setValue(null);
        row.getCell(TB_REPORTROWITEM).setValue(null);
        row.getCell(TB_REPORTCOLUMNITEM).setValue(null);
        row.getCell(TB_ACCOUNTCONFIG).setValue(null);
        row.getCell(TB_BUILDINGTAXESGROUP).setValue(null);
        row.getCell(TB_TAXREPORTSHEET).getStyleAttributes().setLocked(false);
        row.getCell(TB_REPORTROWITEM).getStyleAttributes().setLocked(false);
        row.getCell(TB_REPORTCOLUMNITEM).getStyleAttributes().setLocked(false);
        row.getCell(TB_ACCOUNTCONFIG).getStyleAttributes().setLocked(false);
        row.getCell(TB_BUILDINGTAXESGROUP).getStyleAttributes().setLocked(false);
    }

    @Override
    public void initUIContentLayout() {
        KDWorkButton btn;
        int i;
        super.initUIContentLayout();
        this.actionAddLine.putValue("SmallIcon", (Object)EASResource.getIcon((String)"imgTbtn_addline"));
        this.actionInsertLine.putValue("SmallIcon", (Object)EASResource.getIcon((String)"imgTbtn_insert"));
        this.actionRemoveLine.putValue("SmallIcon", (Object)EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.actionUpLine.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_movetop"));
        this.actionDownLine.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_movedown"));
        this.ActionTopLine.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_movetop1"));
        this.actionBottomLine.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_movebottom"));
        ArrayList<JButton> btnList = new ArrayList<JButton>();
        btnList.add(this.tableContainer.add((Action)this.actionAddLine));
        btnList.add(this.tableContainer.add((Action)this.actionInsertLine));
        btnList.add(this.tableContainer.add((Action)this.actionRemoveLine));
        btnList.add(this.tableContainer.add((Action)((Object)this.actionUpLine)));
        btnList.add(this.tableContainer.add((Action)((Object)this.actionDownLine)));
        btnList.add(this.tableContainer.add((Action)((Object)this.ActionTopLine)));
        btnList.add(this.tableContainer.add((Action)((Object)this.actionBottomLine)));
        for (i = 0; i < btnList.size(); ++i) {
            btn = (KDWorkButton)btnList.get(i);
            btn.setText(null);
            btn.setSize(new Dimension(22, 19));
            btn.setEnabled(true);
        }
        this.actionMergeAddLine.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_addline"));
        this.actionMergeInsertLine.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_insert"));
        this.actionMergeRemoveLine.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_deleteline"));
        btnList = new ArrayList();
        btnList.add(this.kDContainer1.add((Action)((Object)this.actionMergeAddLine)));
        btnList.add(this.kDContainer1.add((Action)((Object)this.actionMergeInsertLine)));
        btnList.add(this.kDContainer1.add((Action)((Object)this.actionMergeRemoveLine)));
        for (i = 0; i < btnList.size(); ++i) {
            btn = (KDWorkButton)btnList.get(i);
            btn.setText(null);
            btn.setSize(new Dimension(22, 19));
            btn.setEnabled(true);
        }
    }

    protected void initButtonStatus() {
        this.btnSubmit.setVisible(false);
        this.btnTraceDown.setVisible(false);
        this.btnTraceUp.setVisible(false);
        this.btnCreateFrom.setVisible(false);
        this.btnAddLine.setVisible(false);
        this.btnRemoveLine.setVisible(false);
        this.btnInsertLine.setVisible(false);
        this.btnAuditResult.setVisible(false);
        this.btnMultiapprove.setVisible(false);
        this.btnNextPerson.setVisible(false);
        this.btnWorkFlowG.setVisible(false);
        this.btnWFViewSubmitProccess.setVisible(false);
        this.menuWorkflow.setVisible(false);
        this.menuTable1.setVisible(false);
        this.menuItemCreateFrom.setVisible(false);
        this.menuItemCreateTo.setVisible(false);
        this.menuItemSubmit.setVisible(false);
        this.menuItemCopyFrom.setVisible(false);
        this.menuSubmitOption.setVisible(false);
        this.initBtnStatus();
    }

    private void initBtnStatus() {
        this.btnCancel.setVisible(true);
        this.btnCancelCancel.setVisible(true);
        this.menuItemCancelCancel.setVisible(true);
        this.menuItemCancel.setVisible(true);
        if (this.editData == null || this.editData.getId() == null) {
            this.btnCancel.setEnabled(false);
            this.btnCancelCancel.setEnabled(false);
            this.menuItemCancelCancel.setEnabled(false);
            this.menuItemCancel.setEnabled(false);
            return;
        }
        if (this.editData.getState().equals((Object)EnableStateEnum.ENABLE)) {
            this.btnRemove.setEnabled(false);
            this.btnCancel.setEnabled(true);
            this.btnCancelCancel.setEnabled(false);
            this.menuItemCancel.setEnabled(true);
            this.menuItemCancelCancel.setEnabled(false);
            this.menuItemEdit.setEnabled(false);
            this.menuItemRemove.setEnabled(false);
            this.btnEdit.setEnabled(false);
        } else {
            this.btnRemove.setEnabled(true);
            this.btnCancel.setEnabled(false);
            this.btnCancelCancel.setEnabled(true);
            this.menuItemCancel.setEnabled(false);
            this.menuItemCancelCancel.setEnabled(true);
            this.menuItemEdit.setEnabled(true);
            this.menuItemRemove.setEnabled(false);
            this.btnEdit.setEnabled(true);
            if (OprtState.EDIT.equals(this.oprtState)) {
                this.btnEdit.setEnabled(false);
            }
        }
    }

    private void checkRequiredFields() throws Exception {
        int i;
        StringBuffer sb = new StringBuffer();
        if (this.txtNumber.getText().isEmpty()) {
            sb.append("\u3001\u7f16\u7801");
        }
        if (this.txtName.getText().isEmpty()) {
            sb.append("\u3001\u540d\u79f0");
        }
        if (sb.length() > 0) {
            sb.append("\u4e0d\u80fd\u4e3a\u7a7a");
            MsgBox.showWarning((String)sb.substring(1));
            SysUtil.abort();
        }
        int rowCount = this.getDetailTable().getRowCount();
        boolean hasVolidEntry = false;
        for (i = 0; i < rowCount; ++i) {
            if (this.isRowBlankOnTable(this.getDetailTable(), i)) continue;
            hasVolidEntry = true;
            break;
        }
        if (!hasVolidEntry) {
            MsgBox.showInfo((Component)((Object)this), (String)"\u81f3\u5c11\u5f55\u5165\u4e00\u6761\u6709\u6548\u5206\u5f55");
            SysUtil.abort();
        }
        for (i = 0; i < rowCount; ++i) {
            if (!this.isRowBlankOnTable(this.getDetailTable(), i)) continue;
            this.removeLine(this.getDetailTable(), i);
            --i;
            --rowCount;
        }
        rowCount = this.mergeTable.getRowCount();
        for (i = 0; i < rowCount; ++i) {
            if (!this.isRowBlankOnTable(this.mergeTable, i, MERGE_ENTRY_CHECK_COLUMN)) continue;
            this.removeLine(this.mergeTable, i);
            --i;
            --rowCount;
        }
    }

    private boolean isRowBlankOnTable(KDTable detailTable, int row, String[] cols) throws Exception {
        if (detailTable == null) {
            throw new Exception("table is null!");
        }
        if (cols == null) {
            return true;
        }
        for (int i = 0; i < cols.length; ++i) {
            if (detailTable.getCell(row, cols[i]) == null || detailTable.getCell(row, cols[i]).getValue() == null) continue;
            return false;
        }
        return true;
    }

    private boolean isRowBlankOnTable(KDTable detailTable, int row) throws Exception {
        if (detailTable == null) {
            throw new Exception("table is null!");
        }
        if (detailTable.getCell(row, TB_ITEMNUMBER) != null && detailTable.getCell(row, TB_ITEMNUMBER).getValue() != null) {
            return false;
        }
        if (detailTable.getCell(row, TB_TAXREPORTSHEET) != null && detailTable.getCell(row, TB_TAXREPORTSHEET).getValue() != null) {
            TaxReportSheetInfo info = null;
            if (detailTable.getCell(row, TB_TAXREPORTSHEET).getValue() instanceof TaxReportSheetInfo && (RecordTypeEnum.Account.equals((Object)(info = (TaxReportSheetInfo)detailTable.getCell(row, TB_TAXREPORTSHEET).getValue()).getRecordType()) ? detailTable.getCell(row, TB_REPORTROWITEM) != null && detailTable.getCell(row, TB_REPORTROWITEM).getValue() != null && detailTable.getCell(row, TB_REPORTCOLUMNITEM) != null && detailTable.getCell(row, TB_REPORTCOLUMNITEM).getValue() != null && detailTable.getCell(row, TB_ACCOUNTCONFIG) != null && detailTable.getCell(row, TB_ACCOUNTCONFIG).getValue() != null : (RecordTypeEnum.TaxDeclare.equals((Object)info.getRecordType()) && "006".equals(info.getTaxType().getNumber()) ? detailTable.getCell(row, TB_REPORTROWITEM) != null && detailTable.getCell(row, TB_REPORTROWITEM).getValue() != null && detailTable.getCell(row, TB_REPORTCOLUMNITEM) != null && detailTable.getCell(row, TB_REPORTCOLUMNITEM).getValue() != null && detailTable.getCell(row, TB_BUILDINGTAXESGROUP) != null && detailTable.getCell(row, TB_BUILDINGTAXESGROUP).getValue() != null : detailTable.getCell(row, TB_REPORTROWITEM) != null && detailTable.getCell(row, TB_REPORTROWITEM).getValue() != null && detailTable.getCell(row, TB_REPORTCOLUMNITEM) != null && detailTable.getCell(row, TB_REPORTCOLUMNITEM).getValue() != null))) {
                return false;
            }
        }
        return true;
    }

    protected void removeLine(KDTable table, int rowIndex) {
        if (this.getOprtState().equals(OprtState.VIEW)) {
            return;
        }
        if (table == null) {
            return;
        }
        if (table.getRow(rowIndex) != null) {
            table.getSelectManager().select(rowIndex, 0, rowIndex, 0, 2);
            IObjectValue detailData = (IObjectValue)table.getRow(rowIndex).getUserObject();
            table.removeRow(rowIndex);
            IObjectCollection collection = (IObjectCollection)table.getUserObject();
            if (collection == null) {
                logger.error((Object)"collection not be binded to table");
            } else if (detailData != null) {
                collection.removeObject(detailData);
            }
            this.afterRemoveLine(table, detailData);
        }
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        this.setSeq();
        this.checkRequiredFields();
        this.editData.setNumber(this.txtNumber.getText());
        boolean checkNumber = ItemDimensionFactory.getRemoteInstance().checkNumber((IObjectValue)this.editData);
        if (!checkNumber) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.tm.td.cloud.TDCloudResource", (String)"Number_Not_Repeat", (Object[])new String[]{this.editData.getNumber()}));
            SysUtil.abort();
        }
        super.actionSave_actionPerformed(e);
    }

    protected IObjectValue createNewData() {
        ItemDimensionInfo info = new ItemDimensionInfo();
        info.setState(EnableStateEnum.ENABLE);
        return info;
    }

    protected IObjectValue createNewDetailData(KDTable table) {
        if (table.getName().equals("kdtEntry")) {
            ItemDimensionEntryInfo entryInfo = new ItemDimensionEntryInfo();
            entryInfo.setIsSummary(false);
            entryInfo.setIsHide(false);
            entryInfo.setItemFormat(ItemFormatEnum.defaults);
            return entryInfo;
        }
        if (table.getName().equals("mergeTable")) {
            ItemDimMergeEntryInfo entryInfo = new ItemDimMergeEntryInfo();
            entryInfo.setRowSpan(2);
            return entryInfo;
        }
        return null;
    }

    protected KDTable getDetailTable() {
        return this.kdtEntry;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return ItemDimensionFactory.getRemoteInstance();
    }

    @Override
    public void actionUpLine_actionPerformed(ActionEvent e) throws Exception {
        if (this.getOprtState().equals(OprtState.VIEW)) {
            return;
        }
        this.checkSelected();
        int rowIndex = this.getDetailTable().getSelectManager().get(0).getTop();
        if (rowIndex == 0) {
            return;
        }
        int toRowIndex = rowIndex - 1;
        this.getDetailTable().moveRow(rowIndex, toRowIndex);
        this.getDetailTable().getSelectManager().set(toRowIndex, toRowIndex);
        this.setSeq();
    }

    @Override
    public void actionDownLine_actionPerformed(ActionEvent e) throws Exception {
        if (this.getOprtState().equals(OprtState.VIEW)) {
            return;
        }
        this.checkSelected();
        int rowIndex = this.getDetailTable().getSelectManager().get(0).getTop();
        if (rowIndex == this.getDetailTable().getRowCount() - 1) {
            return;
        }
        int toRowIndex = rowIndex + 1;
        this.getDetailTable().moveRow(rowIndex, toRowIndex);
        this.getDetailTable().getSelectManager().set(toRowIndex, toRowIndex);
        this.setSeq();
    }

    @Override
    public void actionTopLine_actionPerformed(ActionEvent e) throws Exception {
        if (this.getOprtState().equals(OprtState.VIEW)) {
            return;
        }
        this.checkSelected();
        int rowIndex = this.getDetailTable().getSelectManager().get(0).getTop();
        if (rowIndex == 0) {
            return;
        }
        int toRowIndex = 0;
        this.getDetailTable().moveRow(rowIndex, toRowIndex);
        this.getDetailTable().getSelectManager().set(toRowIndex, toRowIndex);
        this.setSeq();
    }

    @Override
    public void actionBottomLine_actionPerformed(ActionEvent e) throws Exception {
        if (this.getOprtState().equals(OprtState.VIEW)) {
            return;
        }
        this.checkSelected();
        int rowIndex = this.getDetailTable().getSelectManager().get(0).getTop();
        if (rowIndex == this.getDetailTable().getRowCount() - 1) {
            return;
        }
        int toRowIndex = this.getDetailTable().getRowCount() - 1;
        this.getDetailTable().moveRow(rowIndex, toRowIndex);
        this.getDetailTable().getSelectManager().set(toRowIndex, toRowIndex);
        this.setSeq();
    }

    private void setSeq() {
        for (int i = 0; i < this.kdtEntry.getRowCount(); ++i) {
            this.kdtEntry.getCell(i, "seq").setValue((Object)(i + 1));
        }
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.uiHelper.checkCanEdit(this.currentCUID, this.editData.getId().toString());
        if (this.editData.isIsPreinstall()) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.tm.td.cloud.TDCloudResource", (String)"Preinstall_Not_Edit", (Object[])new String[]{this.editData.getNumber()}));
            SysUtil.abort();
        }
        if (EnableStateEnum.ENABLE.equals((Object)this.editData.getState())) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.tm.td.cloud.TDCloudResource", (String)"Active_Not_Edit"));
            SysUtil.abort();
        }
        super.actionEdit_actionPerformed(e);
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        this.uiHelper.checkCanAddnew(this.currentCUID);
        super.actionAddNew_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(this.editData.getId().toString());
        this.uiHelper.checkCanRemove(this.currentCUID, ids);
        if (this.editData.isIsPreinstall()) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.tm.td.cloud.TDCloudResource", (String)"Preinstall_Not_Remove", (Object[])new String[]{this.editData.getNumber()}));
            SysUtil.abort();
        }
        super.actionRemove_actionPerformed(e);
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.setSeq();
        this.checkRequiredFields();
        this.editData.setNumber(this.txtNumber.getText());
        boolean checkNumber = ItemDimensionFactory.getRemoteInstance().checkNumber((IObjectValue)this.editData);
        if (!checkNumber) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.tm.td.cloud.TDCloudResource", (String)"Number_Not_Repeat", (Object[])new String[]{this.editData.getNumber()}));
            SysUtil.abort();
        }
        super.actionSubmit_actionPerformed(e);
    }

    private void refresh(IObjectPK pk) throws Exception {
        this.setDataObject(this.getValue(pk));
        this.loadFields();
        this.initOldData((IObjectValue)this.editData);
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        String billId = this.editData.getId().toString();
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(billId);
        ArrayList errors = ItemDimensionFactory.getRemoteInstance().cancelCancel(new HashSet(ids));
        if (errors.size() > 0) {
            MsgBox.showWarning((Component)((Object)this), (String)((String)errors.get(0)));
        } else {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Startup_OK"));
            this.setOprtState("VIEW");
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)billId));
            this.refresh((IObjectPK)pk);
        }
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        String billId = this.editData.getId().toString();
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(billId);
        ArrayList errors = ItemDimensionFactory.getRemoteInstance().cancel(new HashSet(ids));
        if (errors.size() > 0) {
            MsgBox.showWarning((Component)((Object)this), (String)((String)errors.get(0)));
        } else {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Forbid _OK"));
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)billId));
            this.refresh((IObjectPK)pk);
        }
    }

    @Override
    public void actionMergeAddLine_actionPerformed(ActionEvent e) throws Exception {
        this.addLine(this.mergeTable);
    }

    @Override
    public void actionMergeRemoveLine_actionPerformed(ActionEvent e) throws Exception {
        this.removeLine(this.mergeTable);
    }

    @Override
    public void actionMergeInsertLine_actionPerformed(ActionEvent e) throws Exception {
        this.insertLine(this.mergeTable);
    }

    @Override
    public String getBizOrgProperty(OrgType orgType) throws BOSException, EASBizException {
        return "CU";
    }

    @Override
    public String getPermItem(String status) {
        return null;
    }

    @Override
    public KDBizPromptBox getPermMainBizOrg() {
        return null;
    }

    @Override
    public IObjectValue getValueObject() {
        return this.editData;
    }

    @Override
    public ICoreBase getPermInterface() throws Exception {
        return this.getBizInterface();
    }
}

