/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.cloud.datamodel.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.PreChangeEvent;
import com.kingdee.bos.ctrl.swing.event.PreChangeListener;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.rpt.client.FormulaPickerUI;
import com.kingdee.eas.fi.rpt.client.IFormulaPickerListener;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tm.td.ItemResourceType;
import com.kingdee.eas.tm.td.TDUtils;
import com.kingdee.eas.tm.td.basedata.DataTypeEnum;
import com.kingdee.eas.tm.td.cloud.EnableStateEnum;
import com.kingdee.eas.tm.td.cloud.datamodel.ItemCollection;
import com.kingdee.eas.tm.td.cloud.datamodel.ItemFactory;
import com.kingdee.eas.tm.td.cloud.datamodel.ItemInfo;
import com.kingdee.eas.tm.td.cloud.datamodel.ItemMappingInfo;
import com.kingdee.eas.tm.td.cloud.datamodel.client.AbstractItemEditUI;
import com.kingdee.eas.tm.td.cloud.datamodel.client.SumItemFormulaPickerUI;
import com.kingdee.eas.tm.td.cloud.utils.TDCloudUtil;
import com.kingdee.eas.tm.td.common.permsupport.IPermSupport4EditUI;
import com.kingdee.eas.tm.td.common.uihelper.EditUIHelper;
import com.kingdee.eas.tm.td.structure.ReportItemDimensionEnum;
import com.kingdee.eas.tm.td.structure.TaxReportItemInfo;
import com.kingdee.eas.tm.td.structure.TaxReportSheetInfo;
import com.kingdee.eas.tm.td.structure.client.TaxReportItemSelector;
import com.kingdee.eas.tm.td.structure.utils.StructureUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import org.apache.log4j.Logger;
import org.springframework.util.StringUtils;

public class ItemEditUI
extends AbstractItemEditUI
implements IFormulaPickerListener,
IPermSupport4EditUI {
    private static final Logger logger = CoreUIObject.getLogger(ItemEditUI.class);
    public static final String UICTX_KEY_SUMITEMFORMULA = "SUMITEMFORMULA";
    private EditUIHelper uiHelper = new EditUIHelper(this);
    private String currentCUID;
    private ItemCollection subItems = null;
    private DataChangeListener reportSheetChangeListener = null;
    private ActionListener isSumItemListener = null;

    public void onLoad() throws Exception {
        super.onLoad();
        this.chkMenuItemSubmitAndAddNew.setSelected(false);
        this.initControl();
    }

    protected void initControl() {
        this.initItemF7(this.prmtRowItem);
        this.initItemF7(this.prmtColumnItem);
        this.isSumItemChange();
    }

    protected void initItemF7(KDBizPromptBox box) {
        box.setEditable(false);
        box.setRefresh(false);
        box.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                KDPromptBox f7Box = (KDPromptBox)e.getSource();
                Object value = ItemEditUI.this.prmtReportSheet.getValue();
                TaxReportSheetInfo sheetInfo = null;
                if (value != null) {
                    if (value instanceof TaxReportSheetInfo) {
                        sheetInfo = (TaxReportSheetInfo)ItemEditUI.this.prmtReportSheet.getValue();
                    } else if (!StringUtils.isEmpty((Object)value.toString())) {
                        try {
                            sheetInfo = StructureUtils.getTaxReportSheetByNumber(null, value.toString());
                        }
                        catch (BOSException e1) {
                            ItemEditUI.this.handUIException(e1);
                        }
                    }
                }
                if (sheetInfo == null) {
                    MsgBox.showInfo((String)"\u8bf7\u9009\u62e9\u8868\u9875\u7c7b\u578b!");
                    ItemEditUI.this.prmtReportSheet.requestFocus();
                    SysUtil.abort();
                }
                ReportItemDimensionEnum itemDimension = null;
                ArrayList<TaxReportItemInfo> rptItemSelected = new ArrayList<TaxReportItemInfo>();
                value = f7Box.getValue();
                TaxReportItemInfo itemInfo = null;
                if (value != null) {
                    if (value instanceof TaxReportItemInfo) {
                        itemInfo = (TaxReportItemInfo)value;
                        rptItemSelected.add(itemInfo);
                    } else if (!StringUtils.isEmpty((Object)value.toString())) {
                        try {
                            itemInfo = StructureUtils.getTaxReportItemByNumber(null, value.toString());
                            rptItemSelected.add(itemInfo);
                        }
                        catch (BOSException e1) {
                            ItemEditUI.this.handUIException(e1);
                        }
                    }
                }
                if (f7Box.getName().equals("prmtRowItem")) {
                    itemDimension = ReportItemDimensionEnum.ROW;
                } else if (f7Box.getName().equals("prmtColumnItem")) {
                    itemDimension = ReportItemDimensionEnum.COLUMN;
                }
                TaxReportItemSelector selector = new TaxReportItemSelector(sheetInfo, itemDimension, rptItemSelected);
                selector.setEnabledMultiSelection(false);
                f7Box.setSelector((KDPromptSelector)selector);
            }
        });
        box.addPreChangeListener(new PreChangeListener(){

            public void preChange(PreChangeEvent e) {
                KDPromptBox f7Box = (KDPromptBox)e.getSource();
                e.setResult(1);
            }
        });
    }

    protected void initDataStatus() {
        super.initDataStatus();
        this.btnSave.setVisible(false);
    }

    @Override
    public void loadFields() {
        this.removeEventLisener();
        super.loadFields();
        this.chkIsPreinstall.setEnabled(false);
        this.currentCUID = SysContext.getSysContext().getCurrentCtrlUnit().getId().toString();
        this.initLisener();
        this.isSumItemChange();
        this.initBtnStatus();
        this.setFilter();
    }

    private void setFilter() {
        this.setReportSheetF7Filter();
        this.setBuildingTaxesGroupFilter();
    }

    protected void setReportSheetF7Filter() {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("state", (Object)"2", CompareType.EQUALS));
        view.setFilter(filter);
        this.prmtReportSheet.setEntityViewInfo(view);
    }

    protected void setBuildingTaxesGroupFilter() {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("state", (Object)"1", CompareType.EQUALS));
        view.setFilter(filter);
        this.prmtBuildingTaxesGroup.setEntityViewInfo(view);
    }

    private void initBtnStatus() {
        this.btnCancel.setVisible(true);
        this.btnCancelCancel.setVisible(true);
        this.menuItemCancelCancel.setVisible(true);
        this.menuItemCancel.setVisible(true);
        if (this.editData == null || this.editData.getId() == null) {
            this.btnCancel.setEnabled(false);
            this.btnCancelCancel.setEnabled(false);
            this.menuItemCancelCancel.setEnabled(false);
            this.menuItemCancel.setEnabled(false);
            return;
        }
        if (this.editData.getState().equals((Object)EnableStateEnum.ENABLE)) {
            this.btnRemove.setEnabled(false);
            this.btnCancel.setEnabled(true);
            this.btnCancelCancel.setEnabled(false);
            this.menuItemCancel.setEnabled(true);
            this.menuItemCancelCancel.setEnabled(false);
            this.menuItemEdit.setEnabled(false);
            this.menuItemRemove.setEnabled(false);
            this.btnEdit.setEnabled(false);
        } else {
            this.btnRemove.setEnabled(true);
            this.btnCancel.setEnabled(false);
            this.btnCancelCancel.setEnabled(true);
            this.menuItemCancel.setEnabled(false);
            this.menuItemCancelCancel.setEnabled(true);
            this.menuItemEdit.setEnabled(true);
            this.menuItemRemove.setEnabled(false);
            this.btnEdit.setEnabled(true);
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
        if (this.txtSumItemFormula.getText().trim().length() == 0) {
            if (this.editData.getSumItems() != null) {
                this.editData.getSumItems().clear();
            }
        } else if (this.subItems != null && this.subItems.size() != 0) {
            ItemMappingInfo itemMapping = null;
            if (this.editData.getSumItems() != null) {
                this.editData.getSumItems().clear();
            }
            ItemInfo it = new ItemInfo();
            it.setId(this.editData.getId());
            for (int i = 0; i < this.subItems.size(); ++i) {
                itemMapping = new ItemMappingInfo();
                itemMapping.setTargetItem(it);
                if (this.subItems.get(i).getNumber().equals(this.editData.getNumber())) {
                    MsgBox.showWarning((Component)((Object)this), (String)"\u603b\u8ba1\u9879\u516c\u5f0f\u4e2d\u7684\u5b50\u9879\u4e0d\u80fd\u662f\u81ea\u8eab\uff01");
                    SysUtil.abort();
                }
                itemMapping.setSourceItem(this.subItems.get(i));
                this.editData.getSumItems().add(itemMapping);
            }
        }
    }

    private void removeEventLisener() {
        if (this.isSumItemListener != null) {
            this.chkIsSumItem.removeActionListener(this.isSumItemListener);
        }
        if (this.reportSheetChangeListener != null) {
            this.prmtReportSheet.removeDataChangeListener(this.reportSheetChangeListener);
        }
    }

    private void initLisener() {
        if (this.isSumItemListener == null) {
            this.isSumItemListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ItemEditUI.this.isSumItemChange();
                    ItemEditUI.this.txtSumItemFormula.setText("");
                }
            };
        }
        this.chkIsSumItem.addActionListener(this.isSumItemListener);
        this.reportSheetChangeListener = new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                if (TDCloudUtil.isEqual(e.getNewValue(), e.getOldValue())) {
                    return;
                }
                ItemEditUI.this.reportSheet_dataChanged(e);
            }
        };
        this.prmtReportSheet.addDataChangeListener(this.reportSheetChangeListener);
    }

    private void isSumItemChange() {
        if (this.chkIsSumItem.isSelected()) {
            this.txtFormula.setEnabled(false);
            this.btnEditFormula.setEnabled(false);
            this.txtSumItemFormula.setEnabled(true);
            this.btnEditSumItem.setEnabled(true);
            this.prmtReportSheet.setEnabled(false);
            this.prmtRowItem.setEnabled(false);
            this.prmtColumnItem.setEnabled(false);
            this.prmtAccount.setEnabled(false);
            this.prmtBuildingTaxesGroup.setEnabled(false);
            this.prmtReportSheet.setValue(null);
            this.prmtRowItem.setValue(null);
            this.prmtColumnItem.setValue(null);
            this.prmtAccount.setValue(null);
            this.prmtBuildingTaxesGroup.setValue(null);
            this.prmtReportSheet.setRequired(false);
            this.prmtRowItem.setRequired(false);
            this.prmtColumnItem.setRequired(false);
        } else {
            this.txtFormula.setEnabled(true);
            this.btnEditFormula.setEnabled(true);
            this.txtSumItemFormula.setEnabled(false);
            this.btnEditSumItem.setEnabled(false);
            this.prmtReportSheet.setEnabled(true);
            this.prmtRowItem.setEnabled(true);
            this.prmtColumnItem.setEnabled(true);
            this.prmtAccount.setEnabled(true);
            this.prmtBuildingTaxesGroup.setEnabled(true);
            this.prmtReportSheet.setRequired(true);
            this.prmtRowItem.setRequired(true);
            this.prmtColumnItem.setRequired(true);
        }
    }

    protected void reportSheet_dataChanged(DataChangeEvent e) {
        this.prmtRowItem.setValue(null);
        this.prmtColumnItem.setValue(null);
    }

    @Override
    public void actionEditFormula_actionPerformed(ActionEvent e) throws Exception {
        if (this.getOprtState().equals(OprtState.VIEW)) {
            return;
        }
        FormulaPickerUI picker = FormulaPickerUI.creatFormulaPicker((CoreUIObject)this);
        picker.addFormulaPickerListener((IFormulaPickerListener)this);
        picker.open();
    }

    @Override
    public void actionEditSumItems_actionPerformed(ActionEvent e) throws Exception {
        if (this.getOprtState().equals(OprtState.VIEW)) {
            return;
        }
        IUIWindow window = null;
        UIContext uiCtx = new UIContext((Object)this);
        uiCtx.put((Object)UICTX_KEY_SUMITEMFORMULA, (Object)this.txtSumItemFormula.getText().toString().trim());
        window = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(SumItemFormulaPickerUI.class.getName(), (Map)uiCtx, null);
        window.show();
        SumItemFormulaPickerUI pickerUI = (SumItemFormulaPickerUI)window.getUIObject();
        this.txtSumItemFormula.setText(pickerUI.sumItemFormula.toString());
        this.subItems = pickerUI.subItems;
    }

    protected IObjectValue createNewData() {
        ItemInfo itemInfo = new ItemInfo();
        itemInfo.setDataType(DataTypeEnum.Amount);
        itemInfo.setResourceType(ItemResourceType.MANUAL);
        return itemInfo;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return ItemFactory.getRemoteInstance();
    }

    public void pickerSetout(FormulaPickerUI picker) {
    }

    public void pickerReturnee(FormulaPickerUI picker, String formulaLine, boolean isOk) {
        if (isOk) {
            this.txtFormula.setText(this.txtFormula.getText() + formulaLine);
        }
    }

    protected void setFieldsNull(AbstractObjectValue newData) {
        ItemInfo editData = (ItemInfo)newData;
        editData.setNumber(editData.getNumber() + "Copy");
        editData.setIsPreinstall(false);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.uiHelper.checkCanEdit(this.currentCUID, this.editData.getId().toString());
        if (this.editData.isIsPreinstall()) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.tm.td.cloud.TDCloudResource", (String)"Preinstall_Not_Edit", (Object[])new String[]{this.editData.getNumber()}));
            SysUtil.abort();
        }
        super.actionEdit_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(this.editData.getId().toString());
        this.uiHelper.checkCanRemove(this.currentCUID, ids);
        if (this.editData.isIsPreinstall()) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.tm.td.cloud.TDCloudResource", (String)"Preinstall_Not_Remove", (Object[])new String[]{this.editData.getNumber()}));
            SysUtil.abort();
        } else if (this.editData.isIsReference()) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.tm.td.cloud.TDCloudResource", (String)"Reference_Not_Remove", (Object[])new String[]{this.editData.getNumber()}));
            SysUtil.abort();
        }
        super.actionRemove_actionPerformed(e);
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        this.uiHelper.checkCanAddnew(this.currentCUID);
        super.actionAddNew_actionPerformed(e);
    }

    private void beforeSaveCheck() {
        if (this.chkIsSumItem.isSelected()) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        if (this.prmtReportSheet.getValue() == null) {
            sb.append("\u3001" + this.kDLabelContainer5.getBoundLabelText());
        }
        if (this.prmtRowItem.getValue() == null) {
            sb.append("\u3001" + this.kDLabelContainer6.getBoundLabelText());
        }
        if (this.prmtColumnItem.getValue() == null) {
            sb.append("\u3001" + this.kDLabelContainer7.getBoundLabelText());
        }
        if (sb.length() > 0) {
            sb.append(TDUtils.getString("com.kingdee.eas.tm.td.basedata.TaxBaseResource", "Data_NotNull", TDUtils.getLocale())).append("\r\n");
            MsgBox.showWarning((String)sb.substring(1));
            SysUtil.abort();
        }
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        this.editData.setNumber(this.txtNumber.getText());
        this.beforeSaveCheck();
        boolean checkNumber = ItemFactory.getRemoteInstance().checkNumber((IObjectValue)this.editData);
        if (!checkNumber) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.tm.td.cloud.TDCloudResource", (String)"Number_Not_Repeat", (Object[])new String[]{this.editData.getNumber()}));
            SysUtil.abort();
        }
        super.actionSave_actionPerformed(e);
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.editData.setNumber(this.txtNumber.getText());
        this.beforeSaveCheck();
        boolean checkNumber = ItemFactory.getRemoteInstance().checkNumber((IObjectValue)this.editData);
        if (!checkNumber) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.tm.td.cloud.TDCloudResource", (String)"Number_Not_Repeat", (Object[])new String[]{this.editData.getNumber()}));
            SysUtil.abort();
        }
        super.actionSubmit_actionPerformed(e);
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        String billId = this.editData.getId().toString();
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(billId);
        ArrayList errors = ItemFactory.getRemoteInstance().cancelCancel(new HashSet(ids));
        if (errors.size() > 0) {
            MsgBox.showWarning((Component)((Object)this), (String)((String)errors.get(0)));
        } else {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Startup_OK"));
            this.setOprtState("VIEW");
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)billId));
            this.refresh((IObjectPK)pk);
        }
    }

    private void refresh(IObjectPK pk) throws Exception {
        this.setDataObject(this.getValue(pk));
        this.loadFields();
        this.initOldData((IObjectValue)this.editData);
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        String billId = this.editData.getId().toString();
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(billId);
        ArrayList errors = ItemFactory.getRemoteInstance().cancel(new HashSet(ids));
        if (errors.size() > 0) {
            MsgBox.showWarning((Component)((Object)this), (String)((String)errors.get(0)));
        } else {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Forbid _OK"));
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)billId));
            this.refresh((IObjectPK)pk);
        }
    }

    @Override
    public String getBizOrgProperty(OrgType orgType) throws BOSException, EASBizException {
        return "CU";
    }

    @Override
    public String getPermItem(String status) {
        return null;
    }

    @Override
    public KDBizPromptBox getPermMainBizOrg() {
        return null;
    }

    @Override
    public IObjectValue getValueObject() {
        return this.editData;
    }

    @Override
    public ICoreBase getPermInterface() throws Exception {
        return this.getBizInterface();
    }
}

