/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.directdeclare.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.appframework.syncUI.MonitorInfo;
import com.kingdee.bos.appframework.syncUI.SwingWorker;
import com.kingdee.bos.ctrl.swing.KDMenuItem;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tm.td.TDUtils;
import com.kingdee.eas.tm.td.client.MySwingWork;
import com.kingdee.eas.tm.td.client.MyThreadPool;
import com.kingdee.eas.tm.td.directdeclare.TeLogStatus;
import com.kingdee.eas.tm.td.directdeclare.TePwyLogFactory;
import com.kingdee.eas.tm.td.directdeclare.TePwyLogInfo;
import com.kingdee.eas.tm.td.directdeclare.client.AbstractTePwyLogListUI;
import com.kingdee.eas.tm.td.directdeclare.comm.model.TePwyParam;
import com.kingdee.eas.tm.td.directdeclare.comm.util.TePwyHelper;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class TePwyLogListUI
extends AbstractTePwyLogListUI {
    private static final Logger logger = CoreUIObject.getLogger(TePwyLogListUI.class);
    private int invoicePercent = 0;

    public void onLoad() throws Exception {
        super.onLoad();
        this.initBtnStatus();
    }

    private void initBtnStatus() throws EASBizException, BOSException {
        this.btnAddNew.setVisible(false);
        this.menuItemAddNew.setVisible(false);
        this.btnEdit.setVisible(false);
        this.menuItemEdit.setVisible(false);
        this.btnRemove.setVisible(false);
        this.menuItemRemove.setVisible(false);
        this.menuEdit.setVisible(false);
    }

    protected String getEditUIName() {
        return "com.kingdee.eas.tm.td.directdeclare.client.TePwyLogEditUI";
    }

    protected ICoreBase getBizInterface() throws Exception {
        return TePwyLogFactory.getRemoteInstance();
    }

    @Override
    public void actionRetry_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.doActionWithLock(0);
    }

    @Override
    public void actionConfirmSuccess_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.doActionWithLock(1);
    }

    @Override
    public void actionConfirmFailure_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.doActionWithLock(2);
    }

    @Override
    public void actionMarkComplete_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.doActionInDeamon(e, 3);
    }

    private void doActionInDeamon(ActionEvent e, final int actionType) {
        this.invoicePercent = 30;
        String parentTxt = "";
        if (e.getSource() instanceof KDWorkButton) {
            KDWorkButton button = (KDWorkButton)e.getSource();
            parentTxt = button.getText();
        } else {
            KDMenuItem item = (KDMenuItem)e.getSource();
            item.getText();
            parentTxt = item.getText();
        }
        final MonitorInfo info = new MonitorInfo(parentTxt, null, (Object)this, true);
        MySwingWork worker = new MySwingWork(){

            public Object construct() {
                try {
                    TePwyLogListUI.this.doActionWithLock(actionType);
                    TePwyLogListUI.this.refreshList();
                }
                catch (Exception ex) {
                    TePwyLogListUI.this.handUIException(ex);
                }
                return null;
            }

            public void finished() {
                this.timerStop();
                MyThreadPool.destroyMonitor(info);
                MyThreadPool.destroyPorgressDialog();
            }

            @Override
            public void refreshProgress() {
                MyThreadPool.refreshProgress(TePwyLogListUI.this.invoicePercent);
            }
        };
        info.setWorker((SwingWorker)worker);
        MyThreadPool.getInstance();
        MyThreadPool.addActionThread(info);
        MyThreadPool.setBackgroundRunButtonEnabled(false);
    }

    private void doActionWithLock(int actionType) throws Exception {
        ArrayList ids = this.getSelectedIdValues();
        try {
            TDUtils.tryLock(ids);
            this.doAction(actionType);
        }
        finally {
            TDUtils.releaseLock(ids);
        }
    }

    private void doAction(int actionType) throws Exception {
        ArrayList billIds = this.getAllSelecteIDListValues();
        Map ret = TePwyLogFactory.getRemoteInstance().buildLogParam(billIds, actionType);
        List list = (List)ret.get("list");
        BigDecimal a = new BigDecimal(90);
        BigDecimal b = new BigDecimal(list.size());
        BigDecimal c = BigDecimal.ZERO;
        if (list.size() > 0) {
            c = a.divide(b, 2, RoundingMode.HALF_UP);
        }
        ArrayList<Object> errorMsg = new ArrayList<Object>();
        TePwyLogInfo logInfo = null;
        for (int i = 0; i < list.size(); ++i) {
            Map resultMap = (Map)list.get(i);
            this.invoicePercent = 10 + c.multiply(new BigDecimal(i)).intValue();
            if (resultMap.containsKey("error")) {
                errorMsg.add(resultMap.get("exception"));
                continue;
            }
            try {
                logInfo = (TePwyLogInfo)resultMap.get("logInfo");
                if (0 == actionType) {
                    TePwyParam pwyParam = (TePwyParam)resultMap.get("pwyParam");
                    TePwyHelper.invoke(pwyParam, logInfo);
                } else if (1 == actionType) {
                    logInfo.setStatus(TeLogStatus.SUCCESS);
                } else if (2 == actionType) {
                    logInfo.setStatus(TeLogStatus.FAILURE);
                } else if (3 == actionType) {
                    logInfo.setStatus(TeLogStatus.FINISH);
                }
                if (logInfo == null) continue;
                TePwyLogFactory.getRemoteInstance().addLog2Queue((IObjectValue)logInfo);
                continue;
            }
            catch (Exception e) {
                errorMsg.add(e.getMessage());
            }
        }
        String msg = EASResource.getString((String)"com.kingdee.eas.tm.td.directdeclare.TeResource", (String)"LOGMSGBILL", (Object[])new Object[]{billIds.size() - errorMsg.size(), errorMsg.size()});
        MsgBox.showDetailAndOK((Component)((Object)this), (String)msg, (String)TDUtils.buildErrorMsg(errorMsg), (int)1);
        this.actionRefresh_actionPerformed(null);
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }
}

