/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.directdeclare.comm.util;

import com.kingdee.eas.tm.td.directdeclare.comm.model.TeInterface;
import com.kingdee.eas.tm.td.directdeclare.comm.model.VmModule;
import com.kingdee.eas.tm.td.directdeclare.comm.util.XMLReader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jdom2.Element;

public class TeDefinition {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.td.directdeclare.utils.TeDefinition");
    public static final String BASEPATH = "com/kingdee/eas/tm/td/directdeclare/comm/config/";
    private Map<String, TeInterface> teMap = new HashMap<String, TeInterface>();
    private static TeDefinition _instance = new TeDefinition();

    private TeDefinition() {
        this.init();
    }

    public static TeDefinition getInstance() {
        return _instance;
    }

    private void init() {
        try {
            this.parseXML("te.xml");
        }
        catch (Exception e) {
            logger.error((Object)"directdeclare parse te.xml error!");
        }
    }

    private void parseXML(String source) throws Exception {
        Element root = new XMLReader().readXML(BASEPATH + source);
        List eleList = root.getChildren();
        TeInterface te = null;
        for (Element e : eleList) {
            te = this.parserNode(e);
            this.teMap.put(te.getName(), te);
        }
    }

    private TeInterface parserNode(Element ele) {
        TeInterface te = new TeInterface();
        te.setName(ele.getAttributeValue("name"));
        te.setAlias(ele.getAttributeValue("alias"));
        List eleList = ele.getChildren();
        VmModule vm = null;
        for (Element e : eleList) {
            vm = new VmModule();
            vm.setName(e.getAttributeValue("name"));
            vm.setAlias(e.getAttributeValue("alias"));
            vm.setType(e.getAttributeValue("type"));
            vm.setSource(e.getAttributeValue("source"));
            te.getVms().add(vm);
        }
        return te;
    }

    public Map<String, TeInterface> getTeMap() {
        return this.teMap;
    }
}

