/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.est.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IItemAction;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.FrameWorkException;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.query.QuickFilteringSupportItems;
import com.kingdee.eas.tm.td.TDUtils;
import com.kingdee.eas.tm.td.common.permsupport.IPermSupport4ListUI;
import com.kingdee.eas.tm.td.common.uihelper.ListUIHelper;
import com.kingdee.eas.tm.td.est.EstStateEnum;
import com.kingdee.eas.tm.td.est.LandDataFactory;
import com.kingdee.eas.tm.td.est.LandDataInfo;
import com.kingdee.eas.tm.td.est.client.AbstractLandDataListUI;
import com.kingdee.eas.tm.td.est.client.LandDataEditUI;
import com.kingdee.eas.tools.datatask.DatataskParameter;
import com.kingdee.eas.tools.datatask.client.DatataskCaller;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import javax.swing.AbstractButton;
import org.apache.log4j.Logger;

public class LandDataListUI
extends AbstractLandDataListUI
implements IPermSupport4ListUI {
    private static final Logger logger = CoreUIObject.getLogger(LandDataListUI.class);
    private static final String[] MONEYCOLUMNS = new String[]{"area", "taxStandard", "landPrice", "usageAmount", "landCost"};
    private ListUIHelper uiHelper = null;
    private QuickFilteringSupportItems qfsi = new QuickFilteringSupportItems(true, true);

    public LandDataListUI() throws Exception {
        logger.info((Object)this.getName());
        this.uiHelper = new ListUIHelper(this);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        int j = MONEYCOLUMNS.length;
        for (int i = 0; i < j; ++i) {
            this.getMainTable().getColumn(MONEYCOLUMNS[i]).getStyleAttributes().setNumberFormat("#,##0.00");
        }
    }

    protected FilterInfo getDefaultFilterForQuery() {
        return this.uiHelper.getHasPermissionOrgFilterForQuery();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        LandDataInfo info = LandDataFactory.getRemoteInstance().getLandDataInfo((IObjectPK)new ObjectUuidPK(this.getSelectedKeyValue()));
        if (EstStateEnum.USING.equals((Object)info.getState())) {
            MsgBox.showInfo((String)TDUtils.getString("com.kingdee.eas.tm.td.est.ESTResource", "Error_USINGEdit", this.getLocale()));
            return;
        }
        super.actionEdit_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        if (this.confirmRemove()) {
            ArrayList errorMsg = LandDataFactory.getRemoteInstance().deleteBatch(new HashSet(this.getSelectedIdValues()));
            if (errorMsg != null && !errorMsg.isEmpty()) {
                String error = EASResource.getString((String)"com.kingdee.eas.tm.td.est.ESTResource", (String)"REMOVE_ERROR");
                String detailMsg = TDUtils.buildErrorMsg(errorMsg);
                MsgBox.showDetailAndOK(null, (String)error, (String)detailMsg, (int)1);
            }
            this.refreshList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList ids = this.getSelectedIdValues();
        String cancelMsg = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Cancel");
        try {
            TDUtils.tryLock(ids);
            ArrayList error = LandDataFactory.getRemoteInstance().cancel(new HashSet(ids));
            if (error.size() > 0) {
                String cancelError = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_CancelError");
                String errorDetailMSG = TDUtils.buildErrorMsg(error);
                MsgBox.showDetailAndOK((Component)((Object)this), (String)cancelError, (String)errorDetailMSG, (int)8188);
            }
            this.actionRefresh_actionPerformed(e);
        }
        finally {
            TDUtils.releaseLock(ids);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList ids = this.getSelectedIdValues();
        try {
            TDUtils.tryLock(ids);
            ArrayList error = LandDataFactory.getRemoteInstance().cancelCancel(new HashSet(this.getSelectedIdValues()));
            if (error.size() > 0) {
                String cancelError = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_CancelCancelError");
                String errorDetailMSG = TDUtils.buildErrorMsg(error);
                MsgBox.showDetailAndOK((Component)((Object)this), (String)cancelError, (String)errorDetailMSG, (int)8188);
            }
            this.actionRefresh_actionPerformed(e);
        }
        finally {
            TDUtils.releaseLock(ids);
        }
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return LandDataFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
    }

    protected String getEditUIName() {
        return LandDataEditUI.class.getName();
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Company;
    }

    protected ArrayList getImportParam() {
        String solutionName;
        DatataskParameter param = new DatataskParameter();
        param.solutionName = solutionName = "landData";
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        return paramList;
    }

    public void actionImportData_actionPerformed(ActionEvent e) throws Exception {
        super.actionImportData_actionPerformed(e);
    }

    public void actionExportData_actionPerformed(ActionEvent e) throws Exception {
        ArrayList para = this.getExportParam();
        if (para == null || para.size() <= 0) {
            throw new FrameWorkException(FrameWorkException.EXPORTDATAPARANULL);
        }
        DatataskCaller task = new DatataskCaller();
        task.setParentComponent((Component)((Object)this));
        task.setMainOrgContext(this.getMainOrgContext());
        task.invoke(para, 1);
    }

    protected ArrayList getExportParam() {
        DatataskParameter param = new DatataskParameter();
        param.solutionName = "landData";
        param.datataskMode = 1;
        param.alias = EASResource.getString((String)"com.kingdee.eas.tm.td.est.landDataResource", (String)"LANDDATAEXPORTEXCELNAME");
        param.varList = new ArrayList();
        Hashtable<String, FilterInfo> hashtable = new Hashtable<String, FilterInfo>();
        HashSet selectIds = new HashSet(this.getSelectedIdValues());
        try {
            if (selectIds.size() > 0) {
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("id", selectIds, CompareType.INCLUDE));
                hashtable.put("filter", filter);
            } else if (this.mainQuery != null) {
                hashtable.put("filter", this.mainQuery.getFilter());
            }
        }
        catch (Exception filter) {
            // empty catch block
        }
        param.setContextParam(hashtable);
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        return paramList;
    }

    protected QuickFilteringSupportItems getQuickFilteringSupport() {
        this.qfsi.setMustQueryAtFirst(true);
        return this.qfsi;
    }

    @Override
    public String getBizOrgProperty(OrgType orgType) throws BOSException, EASBizException {
        return "company";
    }

    @Override
    public ICoreBase getPermInterface() throws Exception {
        return this.getBizInterface();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        try {
            this.initPermActions();
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public void initPermActions() throws BOSException, EASBizException {
        this.uiHelper.bindPermission((AbstractButton)this.btnRemove, (IItemAction)this.actionRemove, this.getServiceContext());
        this.uiHelper.bindPermission((AbstractButton)this.btnCancelCancel, (IItemAction)this.actionCancelCancel, this.getServiceContext());
        this.uiHelper.bindPermission((AbstractButton)this.btnCancel, (IItemAction)this.actionCancel, this.getServiceContext());
        this.uiHelper.bindPermission((AbstractButton)this.menuItemRemove, (IItemAction)this.actionRemove, this.getServiceContext());
        this.uiHelper.bindPermission((AbstractButton)this.menuItemCancelCancel, (IItemAction)this.actionCancelCancel, this.getServiceContext());
        this.uiHelper.bindPermission((AbstractButton)this.menuItemCancel, (IItemAction)this.actionCancel, this.getServiceContext());
    }

    @Override
    public void initPermMainOrgContext(String orgID) throws Exception {
        this.initUIMainOrgContext(orgID);
    }

    protected IObjectPK getOrgPK(ItemAction action) {
        ObjectUuidPK pk = null;
        if (this.isSupportedBatchActions()) {
            LandDataInfo info = null;
            try {
                if (!StringUtils.isEmpty((String)this.getSelectedKeyValue()) && this.getBizInterface().exists((IObjectPK)new ObjectUuidPK(this.getSelectedKeyValue())) && (info = LandDataFactory.getRemoteInstance().getLandDataInfo((IObjectPK)new ObjectUuidPK(this.getSelectedKeyValue()))) != null && info.getCompany() != null) {
                    pk = new ObjectUuidPK(info.getCompany().getId().toString());
                }
            }
            catch (Exception e) {
                this.handUIException(e);
            }
            if (pk != null) {
                return pk;
            }
        }
        if (this.getMainOrgContext() != null && this.getMainOrgContext().get((Object)this.getMainBizOrgType()) != null) {
            pk = new ObjectUuidPK(((OrgUnitInfo)this.getMainOrgContext().get((Object)this.getMainBizOrgType())).getId().toString());
            return pk;
        }
        return super.getOrgPK(action);
    }

    public boolean isSupportedBatchActions() {
        return true;
    }
}

