/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.est.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleInfo;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.EditUI;
import com.kingdee.eas.tm.td.TDUtils;
import com.kingdee.eas.tm.td.common.permsupport.IPermSupport4EditUI;
import com.kingdee.eas.tm.td.common.uihelper.EditUIHelper;
import com.kingdee.eas.tm.td.est.AbstractRealEstateGroupEntryInfo;
import com.kingdee.eas.tm.td.est.CalcFormulaFactory;
import com.kingdee.eas.tm.td.est.CalcFormulaInfo;
import com.kingdee.eas.tm.td.est.EstStateEnum;
import com.kingdee.eas.tm.td.est.LandDataInfo;
import com.kingdee.eas.tm.td.est.MonthEnum;
import com.kingdee.eas.tm.td.est.RealEstateFactory;
import com.kingdee.eas.tm.td.est.RealEstateGroupEntryCollection;
import com.kingdee.eas.tm.td.est.RealEstateGroupInfo;
import com.kingdee.eas.tm.td.est.RealEstateInfo;
import com.kingdee.eas.tm.td.est.TaxCycleEnum;
import com.kingdee.eas.tm.td.est.TaxMethodEnum;
import com.kingdee.eas.tm.td.est.client.AbstractRealEstateEditUI;
import com.kingdee.eas.tm.td.est.client.util.EstClientUtils;
import com.kingdee.eas.tm.td.est.util.EstConstant;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.log4j.Logger;

public class RealEstateEditUI
extends AbstractRealEstateEditUI
implements IPermSupport4EditUI {
    protected boolean isNumberEditable = false;
    private static final Logger logger = CoreUIObject.getLogger(RealEstateEditUI.class);
    private static Map<KDBizPromptBox, DataChangeListener> listenerCache = new HashMap<KDBizPromptBox, DataChangeListener>();
    private DataChangeListener prmtLandDataListener = null;
    private DataChangeListener prmtRealEstateGroupListener = null;
    private DataChangeListener prmtCompanyListener = null;
    private EditUIHelper uiHelper = new EditUIHelper((EditUI)this);
    private Map btnMap = new HashMap();

    public RealEstateEditUI() throws Exception {
        this.btnMap.put("actionRemove", this.actionRemove);
        this.btnMap.put("actionCancel", this.actionCancel);
        this.btnMap.put("actionCancelCancel", this.actionCancelCancel);
        this.btnMap.put("actionEdit", this.actionEdit);
        this.btnMap.put("actionSave", this.actionSave);
        this.btnMap.put("actionCopy", this.actionCopy);
    }

    @Override
    public void loadFields() {
        this.removeListener();
        super.loadFields();
        this.initNumber();
        EstClientUtils.initProvinceFilter(this.prmtProvince, this.prmtCountry);
        EstClientUtils.initCityFilter(this.prmtCity, this.prmtProvince);
        EstClientUtils.initRegionFilter(this.prmtRegion, this.prmtCity);
        this.initCalcFormulaFilter();
        this.initLandDataFilter();
        this.initCompanyFilter();
        this.initActionEnableByState();
        this.initListeners();
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        EstClientUtils.textFieldTrim(this.getComponents());
        this.checkRequiredFields();
    }

    protected void initDataStatus() {
        super.initDataStatus();
    }

    private void initCalcFormulaFilter() {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("taxItemType.id", (Object)"ZCyrvv6oAnPgU0ETqMCc49uK96Y=", CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("taxMethod", (Object)"1", CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("state", (Object)"1", CompareType.EQUALS));
        view.setFilter(filter);
        this.prmtCalcFormula.setEntityViewInfo(view);
    }

    protected void initCompanyFilter() {
        try {
            this.uiHelper.setMainBizOrgFilter();
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initToolBtn();
        this.initTaxCycle();
        this.initLandDataF7();
        this.initEditor();
        this.initRate();
    }

    private void initToolBtn() {
        this.btnAuditResult.setVisible(false);
        this.btnAuditResult.setEnabled(false);
    }

    private void initTaxCycle() {
        this.comboTaxCycle.removeItem((Object)TaxCycleEnum.ONCE);
    }

    private void initLandDataF7() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("country.*"));
        sic.add(new SelectorItemInfo("province.*"));
        sic.add(new SelectorItemInfo("city.*"));
        sic.add(new SelectorItemInfo("region.*"));
        this.prmtLandData.setSelectorCollection(sic);
    }

    protected void initEditor() {
        this.txtOriginalValue.setRemoveingZeroInDispaly(false);
        this.txtOriginalValue.setHorizontalAlignment(4);
        this.txtTaxValue.setRemoveingZeroInDispaly(false);
        this.txtTaxValue.setHorizontalAlignment(4);
        this.txtRentArea.setRemoveingZeroInDispaly(false);
        this.txtRentArea.setHorizontalAlignment(4);
        this.txtRentOriginalValue.setRemoveingZeroInDispaly(false);
        this.txtRentOriginalValue.setHorizontalAlignment(4);
        this.txtBuildingArea.setRemoveingZeroInDispaly(false);
        this.txtBuildingArea.setHorizontalAlignment(4);
        this.txtTaxRate.setRemoveingZeroInDispaly(false);
        this.txtTaxRate.setPrecision(EstConstant.PRECISION_4);
        this.txtTaxRate.setHorizontalAlignment(4);
        this.txtCalcRate.setRemoveingZeroInDispaly(false);
        this.txtCalcRate.setPrecision(EstConstant.PRECISION_4);
        this.txtCalcRate.setHorizontalAlignment(4);
    }

    protected void removeListener() {
        if (this.prmtLandDataListener != null) {
            this.prmtLandData.removeDataChangeListener(this.prmtLandDataListener);
        }
        if (this.prmtRealEstateGroupListener != null) {
            this.prmtRealEstateGroup.removeDataChangeListener(this.prmtRealEstateGroupListener);
        }
    }

    private void initActionEnableByState() {
        this.btnCancel.setVisible(true);
        this.btnCancelCancel.setVisible(true);
        this.menuItemCancel.setVisible(true);
        this.menuItemCancelCancel.setVisible(true);
        this.txtNumber.setEditable(this.isNumberEditable);
        EstStateEnum state = this.editData.getState();
        boolean isLight = false;
        if (EstStateEnum.FORBIDDEN.equals((Object)state)) {
            isLight = true;
        }
        this.uiHelper.initBtnStatus(this.btnMap, isLight);
    }

    protected IObjectValue createNewData() {
        RealEstateInfo info = new RealEstateInfo();
        info.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        info.setCU(SysContext.getSysContext().getCurrentCtrlUnit());
        info.setState(EstStateEnum.USING);
        info.setIsReference(true);
        info.setTaxCycle(TaxCycleEnum.HALFYEAR);
        try {
            this.initCalcFormula(info);
        }
        catch (BOSException e) {
            logger.error((Object)e);
            this.handUIException(e);
        }
        return info;
    }

    private void initCalcFormula(RealEstateInfo realEstateInfo) throws BOSException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("taxItemType", "ZCyrvv6oAnPgU0ETqMCc49uK96Y=");
        params.put("taxMethod", "1");
        CalcFormulaInfo calcInfo = CalcFormulaFactory.getRemoteInstance().getDefaultCalcFormula(params);
        realEstateInfo.setCalcFormula(calcInfo);
    }

    private void initRate() {
        this.txtTaxRate.setDataType(1);
        this.txtTaxRate.setMaximumValue((Comparable)BigDecimal.ONE);
        this.txtTaxRate.setMinimumValue((Comparable)BigDecimal.ZERO);
        this.txtTaxRate.setPrecision(4);
        this.txtTaxRate.setRemoveingZeroInEdit(false);
        this.txtTaxRate.setRemoveingZeroInDispaly(false);
        this.txtTaxRate.setHorizontalAlignment(4);
        this.txtCalcRate.setDataType(1);
        this.txtCalcRate.setMaximumValue((Comparable)BigDecimal.ONE);
        this.txtCalcRate.setMinimumValue((Comparable)BigDecimal.ZERO);
        this.txtCalcRate.setPrecision(4);
        this.txtCalcRate.setRemoveingZeroInEdit(false);
        this.txtCalcRate.setRemoveingZeroInDispaly(false);
        this.txtCalcRate.setHorizontalAlignment(4);
    }

    private void initLandDataFilter() {
        CompanyOrgUnitInfo companyInfo = (CompanyOrgUnitInfo)this.prmtCompany.getValue();
        RealEstateGroupInfo groupInfo = (RealEstateGroupInfo)this.prmtRealEstateGroup.getValue();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (companyInfo != null) {
            filter.getFilterItems().add(new FilterItemInfo("company.number", (Object)companyInfo.getNumber(), CompareType.EQUALS));
        }
        if (groupInfo != null) {
            filter.getFilterItems().add(new FilterItemInfo("realEstateGroup.id", (Object)groupInfo.getId().toString(), CompareType.EQUALS));
        }
        view.setFilter(filter);
        this.prmtLandData.setEntityViewInfo(view);
    }

    protected void initListeners() {
        EstClientUtils.initCountryListener(listenerCache, this.prmtProvince, this.prmtCountry);
        EstClientUtils.initProvinceListener(listenerCache, this.prmtCountry, this.prmtProvince, this.prmtCity);
        EstClientUtils.initCityListener(listenerCache, this.prmtProvince, this.prmtCountry, this.prmtCity, this.prmtRegion);
        EstClientUtils.initRegionListener(listenerCache, this.prmtProvince, this.prmtCountry, this.prmtCity, this.prmtRegion);
        if (this.prmtLandDataListener == null) {
            this.prmtLandDataListener = new DataChangeListener(){

                public void dataChanged(DataChangeEvent eventObj) {
                    RealEstateEditUI.this.landDataChange(eventObj);
                }
            };
        }
        this.prmtLandData.addDataChangeListener(this.prmtLandDataListener);
        if (this.prmtRealEstateGroupListener == null) {
            this.prmtRealEstateGroupListener = new DataChangeListener(){

                public void dataChanged(DataChangeEvent eventObj) {
                    RealEstateEditUI.this.realEstateGroupChanged(eventObj);
                }
            };
        }
        this.prmtRealEstateGroup.addDataChangeListener(this.prmtRealEstateGroupListener);
        if (this.prmtCompanyListener == null) {
            this.prmtCompanyListener = new DataChangeListener(){

                public void dataChanged(DataChangeEvent eventObj) {
                    RealEstateEditUI.this.companyChange(eventObj);
                }
            };
        }
        this.prmtCompany.addDataChangeListener(this.prmtCompanyListener);
    }

    protected void companyChange(DataChangeEvent e) {
        if (TDUtils.isEqual(e.getNewValue(), e.getOldValue())) {
            return;
        }
        if (e.getNewValue() instanceof CompanyOrgUnitInfo) {
            CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)e.getNewValue();
            RealEstateGroupInfo groupInfo = (RealEstateGroupInfo)this.prmtRealEstateGroup.getValue();
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("company.number", (Object)company.getNumber(), CompareType.EQUALS));
            if (groupInfo != null) {
                filter.getFilterItems().add(new FilterItemInfo("realEstateGroup.id", (Object)groupInfo.getId().toString(), CompareType.EQUALS));
            }
            view.setFilter(filter);
            this.prmtLandData.setEntityViewInfo(view);
            this.prmtLandData.setValue(null);
        }
    }

    private void checkRequiredFields() {
        StringBuffer msgSB = new StringBuffer();
        StringBuffer notNullSB = new StringBuffer();
        if (this.prmtCompany.getValue() == null) {
            notNullSB.append(EASResource.getString((String)"com.kingdee.eas.tm.td.est.ESTResource", (String)"Company"));
        }
        if (this.txtNumber.getText().isEmpty()) {
            notNullSB.append(EASResource.getString((String)"com.kingdee.eas.tm.td.est.ESTResource", (String)"Number"));
        }
        if (this.prmtRealEstateGroup.getValue() == null) {
            notNullSB.append(EASResource.getString((String)"com.kingdee.eas.tm.td.est.ESTResource", (String)"RealEstateGroup"));
        }
        if (this.txtName.getText().isEmpty()) {
            notNullSB.append(EASResource.getString((String)"com.kingdee.eas.tm.td.est.ESTResource", (String)"Name"));
        }
        if (this.prmtLandData.getValue() == null) {
            notNullSB.append(EASResource.getString((String)"com.kingdee.eas.tm.td.est.ESTResource", (String)"LandData"));
        }
        if (this.comboTaxPayerType.getSelectedItem() == null) {
            notNullSB.append(EASResource.getString((String)"com.kingdee.eas.tm.td.est.ESTResource", (String)"TaxPayerType_Asset"));
        }
        if (this.comboPurpose.getSelectedItem() == null) {
            notNullSB.append(EASResource.getString((String)"com.kingdee.eas.tm.td.est.ESTResource", (String)"Purpose"));
        }
        if (this.prmtCalcFormula.getValue() == null) {
            notNullSB.append(EASResource.getString((String)"com.kingdee.eas.tm.td.est.ESTResource", (String)"CalcFormula"));
        }
        if (this.comboFirstPaymentMonth.getSelectedItem() == null || MonthEnum.Null.equals(this.comboFirstPaymentMonth.getSelectedItem())) {
            notNullSB.append(EASResource.getString((String)"com.kingdee.eas.tm.td.est.ESTResource", (String)"FirstPaymentMonth"));
        }
        if (notNullSB.length() > 0) {
            notNullSB.append(EASResource.getString((String)"com.kingdee.eas.tm.td.est.ESTResource", (String)"NOTNULL"));
        }
        String largerZeroSB = EstClientUtils.largerZero(new Object[]{this.contOriginalValue, this.contTaxValue, this.contBuildingArea}, false);
        if (notNullSB.length() > 0) {
            msgSB.append(notNullSB.toString().substring(1)).append("\n");
        }
        if (largerZeroSB.length() > 0) {
            msgSB.append(largerZeroSB).append("\n");
        }
        if (msgSB.length() > 0) {
            MsgBox.showWarning((String)msgSB.toString());
            SysUtil.abort();
        }
    }

    protected String transmitNumber(String number) {
        if (number == null || number.length() == 0) {
            return "";
        }
        return number.replace(",", "");
    }

    protected void setFieldsNull(AbstractObjectValue newData) {
        RealEstateInfo editData = (RealEstateInfo)newData;
        editData.setNumber(editData.getNumber() + "copy");
        editData.setName(editData.getName() + "copy");
        editData.setSysNumber(null);
        editData.setCertificateNumber(null);
        editData.setAcqTime(null);
        editData.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        editData.setLastUpdateUser(null);
        Timestamp tt = new Timestamp(System.currentTimeMillis());
        editData.setCreateTime(tt);
        editData.setLastUpdateTime(null);
        editData.setCU(SysContext.getSysContext().getCurrentCtrlUnit());
        editData.setState(EstStateEnum.USING);
        editData.setIsReference(true);
        String companyID = editData.getCU().getId().toString();
        try {
            String number = TDUtils.getNewNumber((IObjectValue)editData, companyID);
            if (!StringUtils.isEmpty((String)number)) {
                editData.setNumber(number);
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    private void landDataChange(DataChangeEvent e) {
        if (this.prmtLandData.getValue() != null) {
            LandDataInfo landDataInfo = (LandDataInfo)this.prmtLandData.getValue();
            this.prmtCountry.setValue((Object)landDataInfo.getCountry());
            this.prmtProvince.setValue((Object)landDataInfo.getProvince());
            this.prmtCity.setValue((Object)landDataInfo.getCity());
            this.prmtRegion.setValue((Object)landDataInfo.getRegion());
            this.txtUnitNumber.setText(landDataInfo.getUnitNumber());
            this.txtCertificateNumber.setText(landDataInfo.getCertificateNumber());
        } else {
            this.prmtCountry.setValue(null);
            this.prmtProvince.setValue(null);
            this.prmtCity.setValue(null);
            this.prmtRegion.setValue(null);
            this.txtUnitNumber.setText(null);
            this.txtCertificateNumber.setText(null);
        }
    }

    private void realEstateGroupChanged(DataChangeEvent e) {
        if (e.getNewValue() == null) {
            this.txtTaxBureau.setText("");
            this.comboFirstPaymentMonth.setSelectedItem((Object)MonthEnum.Null);
            this.comboTaxCycle.setSelectedItem((Object)TaxCycleEnum.MONTH);
            this.txtTaxRate.setValue((Object)BigDecimal.ZERO);
        } else {
            RealEstateGroupInfo realEstateGroupInfo = (RealEstateGroupInfo)e.getNewValue();
            this.txtTaxBureau.setText(realEstateGroupInfo.getTaxBureau());
            AbstractRealEstateGroupEntryInfo realEstateGroupEntryInfo = null;
            RealEstateGroupEntryCollection regEntryColl = realEstateGroupInfo.getEntry();
            if (regEntryColl != null) {
                int j = regEntryColl.size();
                for (int i = 0; i < j; ++i) {
                    if (!"ZCyrvv6oAnPgU0ETqMCc49uK96Y=".equals(regEntryColl.get(i).getTaxItemType().getId().toString()) || !TaxMethodEnum.PRICE.equals((Object)regEntryColl.get(i).getTaxMethod())) continue;
                    realEstateGroupEntryInfo = regEntryColl.get(i);
                    break;
                }
            }
            if (realEstateGroupEntryInfo == null) {
                this.comboFirstPaymentMonth.setSelectedItem((Object)MonthEnum.Null);
                this.txtTaxRate.setValue((Object)BigDecimal.ZERO);
                this.comboTaxCycle.setSelectedItem((Object)TaxCycleEnum.MONTH);
            } else {
                this.comboFirstPaymentMonth.setSelectedItem((Object)realEstateGroupEntryInfo.getFirstPaymentMonth());
                this.txtTaxRate.setValue((Object)realEstateGroupEntryInfo.getTaxRate());
                this.comboTaxCycle.setSelectedItem((Object)TaxCycleEnum.getEnum(realEstateGroupEntryInfo.getTaxCycle().getValue()));
            }
        }
        if (e.getNewValue() instanceof RealEstateGroupInfo) {
            RealEstateGroupInfo groupInfo = (RealEstateGroupInfo)e.getNewValue();
            CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)this.prmtCompany.getValue();
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("realEstateGroup.id", (Object)groupInfo.getId().toString(), CompareType.EQUALS));
            if (company != null) {
                filter.getFilterItems().add(new FilterItemInfo("company.number", (Object)company.getNumber(), CompareType.EQUALS));
            }
            view.setFilter(filter);
            this.prmtLandData.setEntityViewInfo(view);
            this.prmtLandData.setValue(null);
        }
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        super.actionSave_actionPerformed(e);
        if (!this.getOprtState().equals(OprtState.ADDNEW)) {
            if (this.editData.getState() != null && EstStateEnum.USING.equals((Object)this.editData.getState())) {
                this.setOprtState("VIEW");
            } else {
                this.setOprtState("EDIT");
            }
        }
        this.setDataObject((IObjectValue)this.editData);
        this.loadFields();
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
        this.initActionEnableByState();
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemove_actionPerformed(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        String billId = this.editData.getId().toString();
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(billId);
        if (!this.uiHelper.modifySaveOrExit((ItemAction)this.actionSubmit, this.btnSubmit, (ItemAction)this.actionSave, this.btnSave, this.isModifySave())) {
            return;
        }
        try {
            TDUtils.tryLock(ids);
            ArrayList errors = RealEstateFactory.getRemoteInstance().cancelCancel(new HashSet(ids));
            if (errors.size() > 0) {
                MsgBox.showWarning((Component)((Object)this), (String)((String)errors.get(0)));
            } else {
                this.setDataObject(this.getValue((IObjectPK)new ObjectUuidPK(billId)));
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Startup_OK"));
                if (this.editData.getState() != null && EstStateEnum.USING.equals((Object)this.editData.getState())) {
                    this.setOprtState("VIEW");
                } else {
                    this.setOprtState("EDIT");
                }
                this.setDataObject((IObjectValue)this.editData);
                this.loadFields();
            }
        }
        finally {
            TDUtils.releaseLock(ids);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        String billId = this.editData.getId().toString();
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(billId);
        try {
            TDUtils.tryLock(ids);
            ArrayList errors = RealEstateFactory.getRemoteInstance().cancel(new HashSet(ids));
            if (errors.size() > 0) {
                MsgBox.showWarning((Component)((Object)this), (String)((String)errors.get(0)));
            } else {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Forbid _OK"));
                ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)billId));
                this.refresh((IObjectPK)pk);
                this.initActionEnableByState();
            }
        }
        finally {
            TDUtils.releaseLock(ids);
        }
    }

    private void initNumber() {
        try {
            String companyID = SysContext.getSysContext().getCurrentCtrlUnit().getId().toString();
            ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
            CodingRuleInfo codingRule = iCodingRuleManager.getCodingRule((IObjectValue)this.editData, companyID);
            if (codingRule == null) {
                this.isNumberEditable = true;
                return;
            }
            if (codingRule.isIsModifiable()) {
                this.isNumberEditable = true;
            }
            if (codingRule.isIsAddView() && this.txtNumber.getText().trim().isEmpty()) {
                this.txtNumber.setText(iCodingRuleManager.getNumber((IObjectValue)this.editData, companyID));
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    private void refresh(IObjectPK pk) throws Exception {
        this.setDataObject(this.getValue(pk));
        this.loadFields();
        this.initOldData((IObjectValue)this.editData);
    }

    protected IObjectPK getOrgPK(ItemAction action) {
        IObjectPK pk = null;
        try {
            pk = this.uiHelper.getOrgPK();
        }
        catch (Exception e) {
            logger.error((Object)e);
            this.handUIException(e);
        }
        if (pk != null) {
            return pk;
        }
        if (this.getMainOrgContext() != null && this.getMainOrgContext().get((Object)this.getMainBizOrgType()) != null) {
            pk = new ObjectUuidPK(((OrgUnitInfo)this.getMainOrgContext().get((Object)this.getMainBizOrgType())).getId().toString());
            return pk;
        }
        return super.getOrgPK(action);
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Company;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return RealEstateFactory.getRemoteInstance();
    }

    protected IObjectValue createNewDetailData(KDTable table) {
        return null;
    }

    protected KDTable getDetailTable() {
        return null;
    }

    @Override
    public String getBizOrgProperty(OrgType orgType) throws BOSException, EASBizException {
        return "company";
    }

    @Override
    public ICoreBase getPermInterface() throws Exception {
        return this.getBizInterface();
    }

    @Override
    public String getPermItem(String status) {
        return "ert_realEstate_new";
    }

    @Override
    public KDBizPromptBox getPermMainBizOrg() {
        return this.prmtCompany;
    }

    @Override
    public IObjectValue getValueObject() {
        return this.editData;
    }
}

