/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.est.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.codingrule.CodingRuleInfo;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.EditUI;
import com.kingdee.eas.tm.td.TDUtils;
import com.kingdee.eas.tm.td.basedata.TaxItemTypeInfo;
import com.kingdee.eas.tm.td.common.permsupport.IPermSupport4EditUI;
import com.kingdee.eas.tm.td.common.uihelper.EditUIHelper;
import com.kingdee.eas.tm.td.est.EstStateEnum;
import com.kingdee.eas.tm.td.est.EstTaxCycleEnum;
import com.kingdee.eas.tm.td.est.LandLevelEnum;
import com.kingdee.eas.tm.td.est.MonthEnum;
import com.kingdee.eas.tm.td.est.RealEstateGroupFactory;
import com.kingdee.eas.tm.td.est.RealEstateGroupInfo;
import com.kingdee.eas.tm.td.est.TaxMethodEnum;
import com.kingdee.eas.tm.td.est.client.AbstractRealEstateGroupEditUI;
import com.kingdee.eas.tm.td.est.client.util.EstClientUtils;
import com.kingdee.eas.tm.td.est.util.EstConstant;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class RealEstateGroupEditUI
extends AbstractRealEstateGroupEditUI
implements IPermSupport4EditUI {
    private static final Logger logger = CoreUIObject.getLogger(RealEstateGroupEditUI.class);
    protected boolean isNumberEditable = false;
    private static final String TB_TAXITEMTYPE = "taxItemType";
    private static final String TB_TAXMETHOD = "taxMethod";
    private static final String TB_TAXRATE = "taxRate";
    private static final String TB_TAXCYCLE = "taxCycle";
    private static final String TB_FIRSTMONTH = "firstPaymentMonth";
    private static final String TB_ACCOUNTTEMPLATE = "accountTemplate";
    private static final String TB_TAXDECLARETEMPLATE = "taxDeclareTemplate";
    private static final String TB_LAND_LANDLEVEL = "landLevel";
    private static final String TB_LAND_TAXSTANDARD = "taxStandard";
    private static Map<KDBizPromptBox, DataChangeListener> listenerCache = new HashMap<KDBizPromptBox, DataChangeListener>();
    private KDTEditAdapter kdtEntryAdapter = null;
    private KDTEditAdapter kdtLandTaxEntryAdapter = null;
    private SelectorListener templateSelector = null;
    private ChangeListener entrySelectListener;
    private EditUIHelper uiHelper = new EditUIHelper((EditUI)this);
    private String currentCUID;
    private Map btnMap = new HashMap();

    public RealEstateGroupEditUI() throws Exception {
        this.btnMap.put("actionRemove", this.actionRemove);
        this.btnMap.put("actionCancel", this.actionCancel);
        this.btnMap.put("actionCancelCancel", this.actionCancelCancel);
        this.btnMap.put("actionEdit", this.actionEdit);
        this.btnMap.put("actionSave", this.actionSave);
        this.btnMap.put("actionCopy", this.actionCopy);
        this.btnMap.put("actionAddLine", this.actionAddRow);
        this.btnMap.put("actionRemoveLine", this.actionDelRow);
        this.btnMap.put("actionInsertLine", this.actionInsertRow);
    }

    protected IObjectPK getOrgPK(ItemAction action) {
        IObjectPK pk = null;
        try {
            pk = this.uiHelper.getOrgPK();
        }
        catch (Exception e) {
            logger.error((Object)e);
            this.handUIException(e);
        }
        if (pk != null) {
            return pk;
        }
        if (this.getMainOrgContext() != null && this.getMainOrgContext().get((Object)this.getMainBizOrgType()) != null) {
            pk = new ObjectUuidPK(((OrgUnitInfo)this.getMainOrgContext().get((Object)this.getMainBizOrgType())).getId().toString());
            return pk;
        }
        return super.getOrgPK(action);
    }

    public void onLoad() throws Exception {
        this.kdtEntry.checkParsed();
        this.kdtLandTaxEntry.checkParsed();
        super.onLoad();
        if (this.getOprtState() == null) {
            this.setOprtState("ADDNEW");
        }
        this.initEntryEditor();
        this.kdtEntry.getActionMap().remove("Paste");
        this.kdtLandTaxEntry.getActionMap().remove("Paste");
        this.kdtEntry.getActionMap().remove("Delete");
        this.kdtLandTaxEntry.getActionMap().remove("Delete");
        this.currentCUID = SysContext.getSysContext().getCurrentCtrlUnit().getId().toString();
    }

    private void initEntryEditor() {
        KDBizPromptBox taxItemType = EstClientUtils.getF7Box("com.kingdee.eas.tm.td.basedata.app.TaxItemTypeQuery");
        this.kdtEntry.getColumn(TB_TAXITEMTYPE).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)taxItemType));
        this.kdtEntry.getColumn(TB_TAXITEMTYPE).setRenderer(EstClientUtils.getNameRander());
        EstClientUtils.setEnumEditor(this.kdtEntry, TB_TAXMETHOD, "com.kingdee.eas.tm.td.est.TaxMethodEnum");
        EstClientUtils.setRateEditor(this.kdtEntry, TB_TAXRATE, EstConstant.PRECISION_4);
        EstClientUtils.setEnumEditor(this.kdtEntry, TB_TAXCYCLE, "com.kingdee.eas.tm.td.est.EstTaxCycleEnum");
        EstClientUtils.setEnumEditor(this.kdtEntry, TB_FIRSTMONTH, "com.kingdee.eas.tm.td.est.MonthEnum");
        KDBizPromptBox templateF7 = EstClientUtils.getF7Box("com.kingdee.eas.tm.td.structure.app.TaxReportTemplateQuery");
        templateF7.addSelectorListener(this.templateSelector);
        this.kdtEntry.getColumn(TB_ACCOUNTTEMPLATE).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)templateF7));
        this.kdtEntry.getColumn(TB_ACCOUNTTEMPLATE).setRenderer(EstClientUtils.getNameRander());
        this.kdtEntry.getColumn(TB_TAXDECLARETEMPLATE).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)templateF7));
        this.kdtEntry.getColumn(TB_TAXDECLARETEMPLATE).setRenderer(EstClientUtils.getNameRander());
        EstClientUtils.setBigDecimalEditor(this.kdtLandTaxEntry, TB_LAND_TAXSTANDARD, EstConstant.PRECISION_2);
        EstClientUtils.setEnumEditor(this.kdtLandTaxEntry, TB_LAND_LANDLEVEL, "com.kingdee.eas.tm.td.est.LandLevelEnum");
    }

    protected void removeListener() {
        if (this.kdtEntryAdapter != null) {
            this.kdtEntry.removeKDTEditListener((KDTEditListener)this.kdtEntryAdapter);
        }
        if (this.kdtLandTaxEntryAdapter != null) {
            this.kdtLandTaxEntry.removeKDTEditListener((KDTEditListener)this.kdtLandTaxEntryAdapter);
        }
        if (this.entrySelectListener != null) {
            this.kDTabbedPane1.removeChangeListener(this.entrySelectListener);
        }
    }

    protected void initDataStatus() {
        super.initDataStatus();
        if (this.editData != null) {
            this.initActionEnableByState();
        }
    }

    @Override
    public void loadFields() {
        this.removeListener();
        super.loadFields();
        this.initNumber();
        EstClientUtils.initProvinceFilter(this.prmtProvince, this.prmtCountry);
        EstClientUtils.initCityFilter(this.prmtCity, this.prmtProvince);
        EstClientUtils.initRegionFilter(this.prmtRegion, this.prmtCity);
        this.initPrmtParentFilter();
        this.initActionEnableByState();
        this.initTableCellLocked();
        this.initListeners();
    }

    private void initTableCellLocked() {
        for (int i = 0; i < this.kdtEntry.getRowCount3(); ++i) {
            IRow row = this.kdtEntry.getRow(i);
            if (EstTaxCycleEnum.ASRENTCYCLE.equals(row.getCell(TB_TAXCYCLE).getValue()) || EstTaxCycleEnum.ONCE.equals(row.getCell(TB_TAXCYCLE).getValue())) {
                EstClientUtils.setCellLocked(row, TB_FIRSTMONTH, true);
            } else {
                EstClientUtils.setCellLocked(row, TB_FIRSTMONTH, false);
            }
            TaxItemTypeInfo taxItemType = (TaxItemTypeInfo)row.getCell(TB_TAXITEMTYPE).getValue();
            if (taxItemType != null && "ZCyrvv6oAnPgU0ETqMCc49uK96Y=".equals(taxItemType.getId().toString())) {
                EstClientUtils.setCellLocked(row, TB_TAXMETHOD, false);
                continue;
            }
            EstClientUtils.setCellLocked(row, TB_TAXMETHOD, true);
        }
    }

    private void initPrmtParentFilter() {
        if (this.getOprtState() != "ADDNEW" && this.editData.getId() != null) {
            EntityViewInfo entityViewInfo = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)this.editData.getId().toString(), CompareType.NOTEQUALS));
            entityViewInfo.setFilter(filter);
            this.prmtParent.setEntityViewInfo(entityViewInfo);
        }
    }

    private void initActionEnableByState() {
        EstStateEnum state = this.editData.getState();
        boolean isLight = false;
        if (EstStateEnum.FORBIDDEN.equals((Object)state)) {
            isLight = true;
        }
        this.uiHelper.initBtnStatus(this.btnMap, isLight);
        this.txtNumber.setEditable(this.isNumberEditable);
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmit_actionPerformed(e);
        if (!this.getOprtState().equals(OprtState.ADDNEW)) {
            if (this.editData.getState() != null && EstStateEnum.USING.equals((Object)this.editData.getState())) {
                this.setOprtState("VIEW");
            } else {
                this.setOprtState("EDIT");
            }
        }
        this.setDataObject((IObjectValue)this.editData);
        this.loadFields();
    }

    protected void initListeners() {
        EstClientUtils.initCountryListener(listenerCache, this.prmtCountry, this.prmtProvince);
        EstClientUtils.initProvinceListener(listenerCache, this.prmtCountry, this.prmtProvince, this.prmtCity);
        EstClientUtils.initCityListener(listenerCache, this.prmtProvince, this.prmtCountry, this.prmtCity, this.prmtRegion);
        EstClientUtils.initRegionListener(listenerCache, this.prmtProvince, this.prmtCountry, this.prmtCity, this.prmtRegion);
        if (this.kdtEntryAdapter == null) {
            this.kdtEntryAdapter = new KDTEditAdapter(){

                public void editStarted(KDTEditEvent e) {
                    RealEstateGroupEditUI.this.kdtEntry_editStarted(e);
                }

                public void editStopped(KDTEditEvent e) {
                    try {
                        RealEstateGroupEditUI.this.kdtEntry_editStopped(e);
                    }
                    catch (Exception exc) {
                        logger.error((Object)exc);
                        RealEstateGroupEditUI.this.handUIException(exc);
                    }
                }
            };
        }
        this.kdtEntry.addKDTEditListener((KDTEditListener)this.kdtEntryAdapter);
        if (this.kdtLandTaxEntryAdapter == null) {
            this.kdtLandTaxEntryAdapter = new KDTEditAdapter(){

                public void editStopped(KDTEditEvent e) {
                    try {
                        RealEstateGroupEditUI.this.kdtLandTaxEntry_editStopped(e);
                    }
                    catch (Exception exc) {
                        logger.error((Object)exc);
                        RealEstateGroupEditUI.this.handUIException(exc);
                    }
                }
            };
        }
        this.kdtLandTaxEntry.addKDTEditListener((KDTEditListener)this.kdtLandTaxEntryAdapter);
        if (this.templateSelector == null) {
            this.templateSelector = new SelectorListener(){

                public void willShow(SelectorEvent e) {
                    int rowIndex = RealEstateGroupEditUI.this.kdtEntry.getEditManager().getEditRowIndex();
                    int colIndex = RealEstateGroupEditUI.this.kdtEntry.getEditManager().getEditColIndex();
                    String fieldName = RealEstateGroupEditUI.this.kdtEntry.getColumnKey(colIndex);
                    IRow row = RealEstateGroupEditUI.this.kdtEntry.getRow(rowIndex);
                    TaxItemTypeInfo taxItemTypeInfo = (TaxItemTypeInfo)row.getCell(RealEstateGroupEditUI.TB_TAXITEMTYPE).getValue();
                    if (taxItemTypeInfo == null) {
                        MsgBox.showInfo((String)RealEstateGroupEditUI.this.getResource("Msg_NoTaxItemType"));
                        RealEstateGroupEditUI.this.abort();
                    }
                }
            };
        }
        if (this.entrySelectListener == null) {
            this.entrySelectListener = new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    RealEstateGroupEditUI.this.initActionEnableByState();
                }
            };
        }
        this.kDTabbedPane1.addChangeListener(this.entrySelectListener);
    }

    protected void kdtEntry_editStarted(KDTEditEvent e) {
        int rowIndex = e.getRowIndex();
        IRow row = this.kdtEntry.getRow(rowIndex);
        int colIndex = e.getColIndex();
        int taxItemTypeColumnIndex = this.kdtEntry.getColumnIndex(TB_TAXITEMTYPE);
        String fieldName = this.kdtEntry.getColumnKey(colIndex);
        TaxItemTypeInfo taxItemTypeInfo = (TaxItemTypeInfo)row.getCell(TB_TAXITEMTYPE).getValue();
        if (!TB_TAXITEMTYPE.equals(fieldName) && taxItemTypeInfo == null) {
            MsgBox.showInfo((String)TDUtils.getString("com.kingdee.eas.tm.td.est.ESTResource", "Msg_NoTaxItemType", this.getLocale()));
            this.kdtEntry.getEditManager().editCellAt(rowIndex, taxItemTypeColumnIndex);
            this.abort();
        }
        if (TB_ACCOUNTTEMPLATE.equals(fieldName) || TB_TAXDECLARETEMPLATE.equals(fieldName)) {
            String taxItemTypeID = taxItemTypeInfo.getId().toString();
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("taxType.id", (Object)taxItemTypeID, CompareType.EQUALS));
            if (fieldName.equals(TB_ACCOUNTTEMPLATE)) {
                filter.getFilterItems().add(new FilterItemInfo("recordType", (Object)0, CompareType.EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("state", (Object)"2", CompareType.EQUALS));
            } else if (fieldName.equals(TB_TAXDECLARETEMPLATE)) {
                filter.getFilterItems().add(new FilterItemInfo("recordType", (Object)2, CompareType.EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("state", (Object)"2", CompareType.EQUALS));
            }
            view.setFilter(filter);
            if (TB_ACCOUNTTEMPLATE.equals(fieldName)) {
                ((KDBizPromptBox)this.kdtEntry.getColumn(TB_ACCOUNTTEMPLATE).getEditor().getComponent()).setEntityViewInfo(view);
            }
            if (TB_TAXDECLARETEMPLATE.equals(fieldName)) {
                ((KDBizPromptBox)this.kdtEntry.getColumn(TB_TAXDECLARETEMPLATE).getEditor().getComponent()).setEntityViewInfo(view);
            }
        }
    }

    protected void kdtEntry_editStopped(KDTEditEvent e) {
        if (e.getValue() == null || e.getValue().equals(e.getOldValue())) {
            return;
        }
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        IRow row = this.kdtEntry.getRow(rowIndex);
        String fieldName = this.kdtEntry.getColumnKey(colIndex);
        if (TB_TAXCYCLE.equals(fieldName)) {
            if (EstTaxCycleEnum.ASRENTCYCLE.equals(row.getCell(fieldName).getValue()) || EstTaxCycleEnum.ONCE.equals(row.getCell(fieldName).getValue())) {
                EstClientUtils.setCellLocked(row, TB_FIRSTMONTH, true);
                row.getCell(TB_FIRSTMONTH).setValue((Object)MonthEnum.Null);
            } else {
                EstClientUtils.setCellLocked(row, TB_FIRSTMONTH, false);
                row.getCell(TB_FIRSTMONTH).setValue((Object)MonthEnum.Jan);
            }
        } else if (TB_TAXITEMTYPE.equals(fieldName)) {
            this.taxItemTypeChanged(e);
            TaxItemTypeInfo taxItemType = (TaxItemTypeInfo)row.getCell(TB_TAXITEMTYPE).getValue();
            if (taxItemType != null && "ZCyrvv6oAnPgU0ETqMCc49uK96Y=".equals(taxItemType.getId().toString())) {
                EstClientUtils.setCellLocked(row, TB_TAXMETHOD, false);
                boolean hasRent = false;
                boolean hasPrice = false;
                for (int i = 0; i < this.kdtEntry.getRowCount3(); ++i) {
                    if (rowIndex == i) continue;
                    Object value = this.kdtEntry.getCell(i, TB_TAXMETHOD).getValue();
                    if (TaxMethodEnum.RENT.equals(value)) {
                        hasRent = true;
                        continue;
                    }
                    if (!TaxMethodEnum.PRICE.equals(value)) continue;
                    hasPrice = true;
                }
                if (!hasPrice) {
                    row.getCell(TB_TAXMETHOD).setValue((Object)TaxMethodEnum.PRICE);
                } else if (!hasRent) {
                    row.getCell(TB_TAXMETHOD).setValue((Object)TaxMethodEnum.RENT);
                } else {
                    MsgBox.showWarning((String)this.getResource("Error_DuplicatedEstTax"));
                    this.kdtEntry.getCell(rowIndex, TB_TAXITEMTYPE).setValue(null);
                    this.taxItemTypeChanged(e);
                    return;
                }
                EstClientUtils.setCellLocked(row, TB_ACCOUNTTEMPLATE, false);
            } else if (taxItemType != null && ("d8umkg7qNn3gU0ETqMCsX9uK96Y=".equals(taxItemType.getId().toString()) || "Xip0em3cA6rgU0ETqMAGKduK96Y=".equals(taxItemType.getId().toString()))) {
                EstClientUtils.setCellLocked(row, TB_TAXMETHOD, true);
                row.getCell(TB_TAXMETHOD).setValue(null);
                EstClientUtils.setCellLocked(row, TB_ACCOUNTTEMPLATE, false);
            } else {
                EstClientUtils.setCellLocked(row, TB_TAXMETHOD, true);
                row.getCell(TB_TAXMETHOD).setValue(null);
                EstClientUtils.setCellLocked(row, TB_ACCOUNTTEMPLATE, false);
                row.getCell(TB_ACCOUNTTEMPLATE).getStyleAttributes().setBackground(new Color(255, 255, 255, 0));
            }
            this.checkDupEntry(rowIndex);
        } else if (TB_TAXMETHOD.equals(fieldName)) {
            this.taxMethodChanged(e);
            this.checkDupEntry(rowIndex);
        }
    }

    private void taxItemTypeChanged(KDTEditEvent e) {
        if (e.getOldValue() != e.getValue()) {
            int rowIndex = e.getRowIndex();
            String[] taxChangedCleanCloumns = new String[]{TB_TAXRATE, TB_TAXMETHOD, TB_TAXCYCLE, TB_FIRSTMONTH, TB_ACCOUNTTEMPLATE, TB_TAXDECLARETEMPLATE};
            IRow row = this.kdtEntry.getRow(rowIndex);
            int j = taxChangedCleanCloumns.length;
            for (int i = 0; i < j; ++i) {
                row.getCell(taxChangedCleanCloumns[i]).setValue(null);
            }
        }
    }

    private void taxMethodChanged(KDTEditEvent e) {
        if (e.getOldValue() != e.getValue()) {
            int rowIndex = e.getRowIndex();
            String[] taxChangedCleanCloumns = new String[]{TB_TAXRATE, TB_TAXCYCLE, TB_FIRSTMONTH, TB_ACCOUNTTEMPLATE, TB_TAXDECLARETEMPLATE};
            IRow row = this.kdtEntry.getRow(rowIndex);
            int j = taxChangedCleanCloumns.length;
            for (int i = 0; i < j; ++i) {
                row.getCell(taxChangedCleanCloumns[i]).setValue(null);
            }
        }
    }

    private void checkDupEntry(int rowIndex) {
        TaxItemTypeInfo newTaxItemType = (TaxItemTypeInfo)this.kdtEntry.getCell(rowIndex, TB_TAXITEMTYPE).getValue();
        TaxMethodEnum newTaxMethod = (TaxMethodEnum)((Object)this.kdtEntry.getCell(rowIndex, TB_TAXMETHOD).getValue());
        if (newTaxItemType != null) {
            for (int i = 0; i < this.kdtEntry.getRowCount3(); ++i) {
                if (rowIndex == i) continue;
                TaxItemTypeInfo taxItemType = (TaxItemTypeInfo)this.kdtEntry.getCell(i, TB_TAXITEMTYPE).getValue();
                TaxMethodEnum taxMethod = (TaxMethodEnum)((Object)this.kdtEntry.getCell(i, TB_TAXMETHOD).getValue());
                if (taxItemType == null || !newTaxItemType.equals(taxItemType)) continue;
                if ("ZCyrvv6oAnPgU0ETqMCc49uK96Y=".equals(newTaxItemType.getId().toString())) {
                    if (newTaxMethod == null || !newTaxMethod.equals((Object)taxMethod)) continue;
                    MsgBox.showWarning((String)this.getResource("Error_DuplicatedTax", new Object[]{i + 1}));
                    this.kdtEntry.getCell(rowIndex, TB_TAXMETHOD).setValue(null);
                    continue;
                }
                MsgBox.showWarning((String)this.getResource("Error_DuplicatedTax", new Object[]{i + 1}));
                this.kdtEntry.getCell(rowIndex, TB_TAXITEMTYPE).setValue(null);
            }
        }
    }

    protected void kdtLandTaxEntry_editStopped(KDTEditEvent e) {
        if (e.getValue() == null || e.getValue().equals(e.getOldValue())) {
            return;
        }
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        String fieldName = this.kdtLandTaxEntry.getColumnKey(colIndex);
        if (TB_LAND_LANDLEVEL.equals(fieldName)) {
            this.checkLandLevel(rowIndex);
        }
    }

    private void checkLandLevel(int rowIndex) {
        LandLevelEnum landLevel = (LandLevelEnum)((Object)this.kdtLandTaxEntry.getCell(rowIndex, TB_LAND_LANDLEVEL).getValue());
        if (landLevel != null) {
            LandLevelEnum tempLandLevel = null;
            for (int i = 0; i < this.kdtLandTaxEntry.getRowCount3(); ++i) {
                if (rowIndex == i || (tempLandLevel = (LandLevelEnum)((Object)this.kdtLandTaxEntry.getCell(i, TB_LAND_LANDLEVEL).getValue())) == null || tempLandLevel.getValue() != landLevel.getValue()) continue;
                this.kdtLandTaxEntry.getCell(rowIndex, TB_LAND_LANDLEVEL).setValue(null);
                MsgBox.showWarning((String)this.getResource("Error_DuplicatedLandLevel", new Object[]{i + 1}));
                break;
            }
        }
    }

    private void initNumber() {
        try {
            String companyID = SysContext.getSysContext().getCurrentCtrlUnit().getId().toString();
            ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
            CodingRuleInfo codingRule = iCodingRuleManager.getCodingRule((IObjectValue)this.editData, companyID);
            if (codingRule == null) {
                this.isNumberEditable = true;
                return;
            }
            if (codingRule.isIsModifiable()) {
                this.isNumberEditable = true;
            }
            if (codingRule.isIsAddView() && this.txtNumber.getText().trim().isEmpty()) {
                this.txtNumber.setText(iCodingRuleManager.getNumber((IObjectValue)this.editData, companyID));
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    protected IObjectValue createNewData() {
        RealEstateGroupInfo info = new RealEstateGroupInfo();
        info.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        info.setCU(SysContext.getSysContext().getCurrentCtrlUnit());
        info.setState(EstStateEnum.USING);
        return info;
    }

    protected void setFieldsNull(AbstractObjectValue newData) {
        RealEstateGroupInfo info = (RealEstateGroupInfo)newData;
        info.setNumber(info.getNumber() + "copy");
        info.setName(info.getName() + "copy");
        info.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        info.setLastUpdateUser(null);
        Timestamp tt = new Timestamp(System.currentTimeMillis());
        info.setCreateTime(tt);
        info.setLastUpdateTime(null);
        info.setCU(SysContext.getSysContext().getCurrentCtrlUnit());
        info.setState(EstStateEnum.USING);
        String companyID = info.getCU().getId().toString();
        try {
            String number = TDUtils.getNewNumber((IObjectValue)info, companyID);
            if (!StringUtils.isEmpty((String)number)) {
                info.setNumber(number);
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    protected ICoreBase getBizInterface() throws Exception {
        return RealEstateGroupFactory.getRemoteInstance();
    }

    protected BOSObjectType getBOSObjectType() {
        return BOSObjectType.create((String)"D5C621B2");
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        this.uiHelper.checkCanAddnew(this.currentCUID);
        super.actionAddNew_actionPerformed(e);
    }

    @Override
    public void actionAddRow_actionPerformed(ActionEvent e) throws Exception {
        this.getDetailTable().addRow();
        this.actionDelRow.setEnabled(this.getDetailTable().getRowCount() != 0);
    }

    @Override
    public void actionInsertRow_actionPerformed(ActionEvent e) throws Exception {
        KDTable kdTable = this.getDetailTable();
        if (kdTable.getSelectManager().size() > 0) {
            int top = kdTable.getSelectManager().get().getTop();
            kdTable.addRow(top);
        } else {
            kdTable.addRow();
        }
        this.actionDelRow.setEnabled(kdTable.getRowCount() != 0);
    }

    @Override
    public void actionDelRow_actionPerformed(ActionEvent e) throws Exception {
        KDTable kdTable = this.getDetailTable();
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)kdTable);
        if (selectRows == null || selectRows.length == 0) {
            return;
        }
        for (int i = 0; i < selectRows.length; ++i) {
            kdTable.removeRow(selectRows[i]);
        }
        this.actionDelRow.setEnabled(kdTable.getRowCount() != 0);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.uiHelper.checkCanEdit(this.currentCUID, this.editData.getId().toString());
        if (EstStateEnum.USING.equals((Object)this.editData.getState())) {
            MsgBox.showInfo((String)this.getResource("Error_USINGEdit"));
            return;
        }
        super.actionEdit_actionPerformed(e);
        this.initActionEnableByState();
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(this.editData.getId().toString());
        this.uiHelper.checkCanRemove(this.currentCUID, ids);
        super.actionRemove_actionPerformed(e);
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(this.editData.getId().toString());
        this.uiHelper.checkBaseDataPermission(this.currentCUID, ids);
        try {
            TDUtils.tryLock(ids);
            super.actionCancel_actionPerformed(e);
            this.initActionEnableByState();
        }
        finally {
            TDUtils.releaseLock(ids);
        }
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(this.editData.getId().toString());
        this.uiHelper.checkBaseDataPermission(this.currentCUID, ids);
        if (!this.uiHelper.modifySaveOrExit((ItemAction)this.actionSubmit, this.btnSubmit, (ItemAction)this.actionSave, this.btnSave, this.isModifySave())) {
            return;
        }
        try {
            TDUtils.tryLock(ids);
            super.actionCancelCancel_actionPerformed(e);
            if (this.editData.getState() != null && EstStateEnum.USING.equals((Object)this.editData.getState())) {
                this.setOprtState("VIEW");
            } else {
                this.setOprtState("EDIT");
            }
            this.setDataObject((IObjectValue)this.editData);
            this.loadFields();
        }
        catch (Exception e2) {
            TDUtils.releaseLock(ids);
        }
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        TDUtils.removeNullRow(this.kdtEntry, new String[]{TB_TAXITEMTYPE}, false);
        TDUtils.removeNullRow(this.kdtLandTaxEntry, new String[]{TB_LAND_LANDLEVEL}, false);
        EstClientUtils.textFieldTrim(this.getComponents());
        ArrayList<String> errorList = new ArrayList<String>();
        if (this.txtNumber.getText() == null || this.txtNumber.getText().isEmpty()) {
            errorList.add(this.getResource("Error_FieldsNull", new Object[]{this.txtNumber.getBoundLabelText()}));
        }
        if (this.txtName.getText() == null || this.txtName.getText().isEmpty()) {
            errorList.add(this.getResource("Error_FieldsNull", new Object[]{this.txtName.getBoundLabelText()}));
        }
        Map<Integer, String> reqMap = EstClientUtils.getRequiredColName(this.kdtEntry);
        KDTRow head = this.kdtEntry.getHead().getRow(0);
        int methodIndex = this.kdtEntry.getColumnIndex(TB_TAXMETHOD);
        int monthIndex = this.kdtEntry.getColumnIndex(TB_FIRSTMONTH);
        int accountIndex = this.kdtEntry.getColumnIndex(TB_ACCOUNTTEMPLATE);
        String entryName = this.getResource("Title_Tax");
        for (int i = 0; i < this.kdtEntry.getRowCount(); ++i) {
            IRow row = this.kdtEntry.getRow(i);
            if (!row.getCell(TB_TAXMETHOD).getStyleAttributes().isLocked() && row.getCell(TB_TAXMETHOD).getValue() == null) {
                errorList.add(this.getResource("Error_EntryFieldsNull", new Object[]{entryName, i + 1, head.getCell(methodIndex).getValue()}));
            }
            if (!row.getCell(TB_FIRSTMONTH).getStyleAttributes().isLocked() && MonthEnum.Null.equals(row.getCell(TB_FIRSTMONTH).getValue())) {
                errorList.add(this.getResource("Error_EntryFieldsNull", new Object[]{entryName, i + 1, head.getCell(monthIndex).getValue()}));
            }
            if (EstClientUtils.NECCESSCOLOR.equals(row.getCell(TB_ACCOUNTTEMPLATE).getStyleAttributes().getBackground()) && row.getCell(TB_ACCOUNTTEMPLATE).getValue() == null) {
                errorList.add(this.getResource("Error_EntryFieldsNull", new Object[]{entryName, i + 1, head.getCell(accountIndex).getValue()}));
            }
            for (int j : reqMap.keySet()) {
                if (row.getCell(j).getValue() != null) continue;
                errorList.add(this.getResource("Error_EntryFieldsNull", new Object[]{entryName, i + 1, reqMap.get(j)}));
            }
        }
        Map<Integer, String> landReqMap = EstClientUtils.getRequiredColName(this.kdtLandTaxEntry);
        String entryLandName = this.getResource("Title_LandTax");
        int len = this.kdtLandTaxEntry.getRowCount();
        for (int i = 0; i < len; ++i) {
            IRow row = this.kdtLandTaxEntry.getRow(i);
            int size = landReqMap.size();
            for (int j = 0; j < size; ++j) {
                if (row.getCell(j).getValue() != null) continue;
                errorList.add(this.getResource("Error_EntryFieldsNull", new Object[]{entryLandName, i + 1, landReqMap.get(j)}));
            }
        }
        if (errorList.size() > 0) {
            MsgBox.showWarning((String)TDUtils.buildErrorMsg(errorList));
            SysUtil.abort();
        }
    }

    protected KDTable getDetailTable() {
        if (this.kDPanel1.isShowing()) {
            return this.kdtEntry;
        }
        if (this.kDPanel2.isShowing()) {
            return this.kdtLandTaxEntry;
        }
        return this.kdtEntry;
    }

    private String getResource(String key) {
        return TDUtils.getString("com.kingdee.eas.tm.td.est.ESTResource", key, this.getLocale());
    }

    private String getResource(String key, Object[] objects) {
        return TDUtils.getString("com.kingdee.eas.tm.td.est.ESTResource", key, this.getLocale(), objects);
    }

    @Override
    public String getBizOrgProperty(OrgType orgType) throws BOSException, EASBizException {
        return "CU";
    }

    @Override
    public ICoreBase getPermInterface() throws Exception {
        return this.getBizInterface();
    }

    @Override
    public String getPermItem(String status) {
        return null;
    }

    @Override
    public KDBizPromptBox getPermMainBizOrg() {
        return null;
    }

    @Override
    public IObjectValue getValueObject() {
        return this.editData;
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.ControlUnit;
    }
}

