/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.est.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.event.TreePopupMenuEvent;
import com.kingdee.bos.ctrl.swing.event.TreePopupMenuListener;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.ITreeBase;
import com.kingdee.eas.framework.client.ListUI;
import com.kingdee.eas.framework.client.TreePathUtil;
import com.kingdee.eas.framework.query.QuickFilteringSupportItems;
import com.kingdee.eas.tm.td.TDUtils;
import com.kingdee.eas.tm.td.common.permsupport.IPermSupport4ListUI;
import com.kingdee.eas.tm.td.common.uihelper.ListUIHelper;
import com.kingdee.eas.tm.td.est.EstStateEnum;
import com.kingdee.eas.tm.td.est.RealEstateGroupFactory;
import com.kingdee.eas.tm.td.est.RealEstateGroupInfo;
import com.kingdee.eas.tm.td.est.client.AbstractRealEstateGroupListUI;
import com.kingdee.eas.tm.td.est.client.RealEstateGroupEditUI;
import com.kingdee.eas.tools.datatask.DatataskParameter;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Hashtable;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class RealEstateGroupListUI
extends AbstractRealEstateGroupListUI
implements IPermSupport4ListUI {
    private static final Logger logger = CoreUIObject.getLogger(RealEstateGroupListUI.class);
    private ListUIHelper uiHelper = null;
    private String currentCUID;
    private QuickFilteringSupportItems qfsi = new QuickFilteringSupportItems(true, true);

    public RealEstateGroupListUI() throws Exception {
        logger.info((Object)this.getName());
        this.uiHelper = new ListUIHelper((ListUI)this);
    }

    public void onLoad() throws Exception {
        this.setMergeColumn();
        super.onLoad();
        this.currentCUID = SysContext.getSysContext().getCurrentCtrlUnit().getId().toString();
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filter = this.uiHelper.getHasPermissionOrgFilterForQuery();
        return filter;
    }

    public void actionImportData_actionPerformed(ActionEvent e) throws Exception {
        super.actionImportData_actionPerformed(e);
        this.refreshList();
    }

    protected ArrayList getImportParam() {
        String solutionName;
        DatataskParameter param = new DatataskParameter();
        param.solutionName = solutionName = "realEstateGroup";
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        return paramList;
    }

    public void actionExportData_actionPerformed(ActionEvent e) throws Exception {
        super.actionExportData_actionPerformed(e);
    }

    protected ArrayList getExportParam() {
        DatataskParameter param = new DatataskParameter();
        param.solutionName = "realEstateGroup";
        param.datataskMode = 1;
        param.alias = EASResource.getString((String)"com.kingdee.eas.tm.td.est.ESTResource", (String)"RealEstateGroupLabel");
        param.varList = new ArrayList();
        Hashtable<String, FilterInfo> hashtable = new Hashtable<String, FilterInfo>();
        HashSet selectIds = new HashSet(this.getSelectedIdValues());
        try {
            if (selectIds.size() > 0) {
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("id", selectIds, CompareType.INCLUDE));
                hashtable.put("filter", filter);
            } else if (this.mainQuery != null) {
                hashtable.put("filter", this.mainQuery.getFilter());
            }
        }
        catch (Exception filter) {
            // empty catch block
        }
        param.setContextParam(hashtable);
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        return paramList;
    }

    private void setMergeColumn() {
        String[] mergeColumnKeys = this.getMergeColumnKeys();
        if (mergeColumnKeys != null && mergeColumnKeys.length > 0) {
            this.tblMain.checkParsed();
            this.tblMain.getGroupManager().setGroup(true);
            IColumn col = null;
            for (int i = 0; i < mergeColumnKeys.length; ++i) {
                col = this.tblMain.getColumn(mergeColumnKeys[i]);
                if (col != null) {
                    col.setGroup(true);
                    col.setMergeable(true);
                    continue;
                }
                logger.info((Object)("mergeColumn no found:" + mergeColumnKeys[i]));
            }
        }
    }

    private String[] getMergeColumnKeys() {
        String[] columns = new String[]{"id", "number", "name", "parent.number", "parent.name", "country.number", "country.name", "province.number", "province.name", "city.number", "city.name", "region.number", "region.name", "address", "taxBureau", "taxBureauTel", "state", "payee", "bank", "bankAccount", "description", "creator.number", "creator.name", "createTime", "lastUpdateUser.number", "lastUpdateUser.name", "lastUpdateTime", "CU.name", "entry.id"};
        return columns;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList ids = this.getSelectedIdValues();
        this.uiHelper.checkBaseDataPermission(this.currentCUID, ids);
        String cancelMsg = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Cancel");
        try {
            TDUtils.tryLock(ids);
            ArrayList error = RealEstateGroupFactory.getRemoteInstance().cancel(new HashSet(ids));
            if (error.size() > 0) {
                String cancelError = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_CancelError");
                String errorDetailMSG = TDUtils.buildErrorMsg(error);
                MsgBox.showDetailAndOK((Component)((Object)this), (String)cancelError, (String)errorDetailMSG, (int)8188);
            }
            this.actionRefresh_actionPerformed(e);
        }
        finally {
            TDUtils.releaseLock(ids);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList ids = this.getSelectedIdValues();
        this.uiHelper.checkBaseDataPermission(this.currentCUID, ids);
        try {
            TDUtils.tryLock(ids);
            ArrayList error = RealEstateGroupFactory.getRemoteInstance().cancelCancel(new HashSet(ids));
            if (error.size() > 0) {
                String cancelError = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_CancelCancelError");
                String errorDetailMSG = TDUtils.buildErrorMsg(error);
                MsgBox.showDetailAndOK((Component)((Object)this), (String)cancelError, (String)errorDetailMSG, (int)8188);
            }
            this.actionRefresh_actionPerformed(e);
        }
        finally {
            TDUtils.releaseLock(ids);
        }
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        this.uiHelper.checkCanAddnew(this.currentCUID);
        super.actionAddNew_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.uiHelper.checkCanRemove(this.currentCUID, this.getSelectedIdValues());
        if (this.confirmRemove()) {
            ArrayList errorMsg = RealEstateGroupFactory.getRemoteInstance().deleteBatch(new HashSet(this.getSelectedIdValues()));
            if (errorMsg != null && !errorMsg.isEmpty()) {
                String error = EASResource.getString((String)"com.kingdee.eas.tm.td.est.ESTResource", (String)"REMOVE_ERROR");
                String detailMsg = TDUtils.buildErrorMsg(errorMsg);
                MsgBox.showDetailAndOK(null, (String)error, (String)detailMsg, (int)1);
            }
            this.refreshList();
        }
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.uiHelper.checkCanEdit(this.currentCUID, this.getSelectedKeyValue());
        RealEstateGroupInfo info = RealEstateGroupFactory.getRemoteInstance().getRealEstateGroupInfo((IObjectPK)new ObjectUuidPK(this.getSelectedKeyValue()));
        if (EstStateEnum.USING.equals((Object)info.getState())) {
            MsgBox.showInfo((String)TDUtils.getString("com.kingdee.eas.tm.td.est.ESTResource", "Error_USINGEdit", this.getLocale()));
            return;
        }
        super.actionEdit_actionPerformed(e);
    }

    protected ITreeBase getTreeInterface() throws Exception {
        return RealEstateGroupFactory.getRemoteInstance();
    }

    protected IObjectPK getSelectedTreeKeyValue() {
        return null;
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    protected String getGroupEditUIName() {
        return null;
    }

    protected String getQueryFieldName() {
        return "id";
    }

    protected String getRootName() {
        return TDUtils.getString("com.kingdee.eas.tm.td.est.ESTResource", "Title_GroupRoot", this.getLocale());
    }

    protected String getEditUIModal() {
        return "com.kingdee.eas.base.uiframe.client.UINewFrameFactory";
    }

    protected ICoreBase getBizInterface() throws Exception {
        return RealEstateGroupFactory.getRemoteInstance();
    }

    protected String getEditUIName() {
        return RealEstateGroupEditUI.class.getName();
    }

    protected void initGroupButton() {
        this.treeView.getControlPane().add((Component)this.btnGroupMoveTree);
    }

    protected void initPopmenu() {
        JPopupMenu menu = this.treeMain.getPopupMenu();
        EventListener[] ls = this.treeMain.getListeners(TreePopupMenuListener.class);
        if (ls == null || ls.length == 0) {
            this.treeMain.addTreePopupMenu(new TreePopupMenuListener(){

                public boolean popMenu(TreePopupMenuEvent event) {
                    return true;
                }
            });
        }
    }

    protected void refresh(ActionEvent e) throws Exception {
        super.refresh(e);
        ItemAction action = null;
        if (e != null) {
            action = this.getActionFromActionEvent(e);
        }
        if (action == null) {
            return;
        }
        if (action.equals(this.actionAddNew) || action.equals(this.actionView) || action.equals(this.actionEdit)) {
            TreePath oldPath = null;
            if (!this.isDefaultTreeModelUsed(this.treeMain)) {
                oldPath = this.treeMain.getSelectionPath();
            }
            this.initTree();
            this.treeMain.setSelectionPath(TreePathUtil.getNewTreePath((JTree)this.treeMain, (TreeModel)this.treeMain.getModel(), (TreePath)oldPath));
        }
    }

    protected boolean isDefaultTreeModelUsed(KDTree tree) {
        DefaultKingdeeTreeNode root;
        boolean result = false;
        if (tree.getModel() != null && tree.getModel().getRoot() instanceof DefaultKingdeeTreeNode && (root = (DefaultKingdeeTreeNode)tree.getModel().getRoot()) != null && "KDTree".equals(root.getText()) && root.getChildCount() == 3) {
            result = true;
        }
        return result;
    }

    protected boolean isIgnoreTreeCUFilter() {
        return true;
    }

    protected QuickFilteringSupportItems getQuickFilteringSupport() {
        this.qfsi.setMustQueryAtFirst(true);
        return this.qfsi;
    }

    @Override
    public String getBizOrgProperty(OrgType orgType) throws BOSException, EASBizException {
        return "CU";
    }

    @Override
    public ICoreBase getPermInterface() throws Exception {
        return this.getBizInterface();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        try {
            this.initPermActions();
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public void initPermActions() throws BOSException, EASBizException {
    }

    @Override
    public void initPermMainOrgContext(String orgID) throws Exception {
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.ControlUnit;
    }
}

