/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.est.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IItemAction;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.FrameWorkException;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.ITreeBase;
import com.kingdee.eas.framework.client.ListUI;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.framework.query.QuickFilteringSupportItems;
import com.kingdee.eas.tm.td.TDUtils;
import com.kingdee.eas.tm.td.common.permsupport.IPermSupport4ListUI;
import com.kingdee.eas.tm.td.common.uihelper.ListUIHelper;
import com.kingdee.eas.tm.td.est.EstStateEnum;
import com.kingdee.eas.tm.td.est.RealEstateFactory;
import com.kingdee.eas.tm.td.est.RealEstateGroupFactory;
import com.kingdee.eas.tm.td.est.RealEstateGroupInfo;
import com.kingdee.eas.tm.td.est.RealEstateInfo;
import com.kingdee.eas.tm.td.est.client.AbstractRealEstateListUI;
import com.kingdee.eas.tm.td.est.client.RealEstateEditUI;
import com.kingdee.eas.tools.datatask.DatataskParameter;
import com.kingdee.eas.tools.datatask.client.DatataskCaller;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import javax.swing.AbstractButton;
import javax.swing.event.TreeSelectionEvent;
import org.apache.log4j.Logger;

public class RealEstateListUI
extends AbstractRealEstateListUI
implements IPermSupport4ListUI {
    private static final Logger logger = CoreUIObject.getLogger(RealEstateListUI.class);
    private static final String[] MONEYCOLUMNS = new String[]{"buildingArea", "rentArea", "originalValue", "rentOriginalValue", "taxValue", "taxRate", "calcRate"};
    private ListUIHelper uiHelper = null;
    private QuickFilteringSupportItems qfsi = new QuickFilteringSupportItems(true, true);

    public RealEstateListUI() throws Exception {
        logger.info((Object)this.getName());
        this.uiHelper = new ListUIHelper((ListUI)this);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initToolBtn();
        int j = MONEYCOLUMNS.length;
        for (int i = 0; i < j; ++i) {
            this.getMainTable().getColumn(MONEYCOLUMNS[i]).getStyleAttributes().setNumberFormat("#,##0.0000");
        }
    }

    private void initToolBtn() {
        this.MenuItemAttachment.setVisible(true);
        this.MenuItemAttachment.setEnabled(true);
        this.btnAttachment.setVisible(true);
        this.btnAttachment.setEnabled(true);
    }

    protected void initGroupButton() {
        this.treeView.getControlPane().add((Component)this.btnGroupMoveTree);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        if (this.confirmRemove()) {
            this.checkSelected();
            ArrayList result = RealEstateFactory.getRemoteInstance().batchDelete(new HashSet(this.getSelectedIdValues()));
            String error = "";
            String errorDetail = "";
            if (result != null && !result.isEmpty()) {
                error = EASResource.getString((String)"com.kingdee.eas.tm.td.est.ESTResource", (String)"REMOVE_ERROR");
                errorDetail = TDUtils.buildErrorMsg(result);
                MsgBox.showDetailAndOK(null, (String)error, (String)errorDetail, (int)1);
            }
            this.refreshList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList ids = this.getSelectedIdValues();
        String cancelMsg = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Cancel");
        try {
            TDUtils.tryLock(ids);
            ArrayList errorList = RealEstateFactory.getRemoteInstance().cancel(new HashSet(ids));
            if (errorList.size() > 0) {
                String cancelError = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_CancelError");
                String errorDetailMSG = TDUtils.buildErrorMsg(errorList);
                MsgBox.showDetailAndOK((Component)((Object)this), (String)cancelError, (String)errorDetailMSG, (int)8188);
            }
            this.actionRefresh_actionPerformed(e);
        }
        finally {
            TDUtils.releaseLock(ids);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList ids = this.getSelectedIdValues();
        try {
            TDUtils.tryLock(ids);
            ArrayList errorList = RealEstateFactory.getRemoteInstance().cancelCancel(new HashSet(ids));
            if (errorList.size() > 0) {
                String cancelCancelError = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_CancelCancelError");
                String errorDetailMSG = TDUtils.buildErrorMsg(errorList);
                MsgBox.showDetailAndOK((Component)((Object)this), (String)cancelCancelError, (String)errorDetailMSG, (int)8188);
            }
            this.actionRefresh_actionPerformed(e);
        }
        finally {
            TDUtils.releaseLock(ids);
        }
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        RealEstateInfo info = RealEstateFactory.getRemoteInstance().getRealEstateInfo((IObjectPK)new ObjectUuidPK(this.getSelectedKeyValue()));
        if (EstStateEnum.USING.equals((Object)info.getState())) {
            MsgBox.showInfo((String)TDUtils.getString("com.kingdee.eas.tm.td.est.ESTResource", "Error_USINGEdit", this.getLocale()));
            return;
        }
        super.actionEdit_actionPerformed(e);
    }

    protected ICoreBase getBizInterface() throws Exception {
        return RealEstateFactory.getRemoteInstance();
    }

    protected void treeMain_valueChanged(TreeSelectionEvent e) throws Exception {
        super.treeMain_valueChanged(e);
    }

    protected boolean isIgnoreTreeCUFilter() {
        return true;
    }

    protected FilterInfo getSelectedNodeFilterForQuery() {
        FilterInfo filterInfo = new FilterInfo();
        if (this.getSelectedNodeKeyValue() != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("realEstateGroup.longNumber", (Object)this.getSelectedNodeKeyValue(), CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("realEstateGroup.longNumber", (Object)(this.getSelectedNodeKeyValue() + "!%"), CompareType.LIKE));
            filterInfo.setMaskString("(#0 OR #1)");
        }
        return filterInfo;
    }

    protected IObjectPK getSelectedTreeKeyValue() {
        return null;
    }

    protected String getSelectedNodeKeyValue() {
        KDTreeNode treeNode = this.getSelectedTreeNode();
        String realEstateGroupLongNumber = "";
        if (treeNode != null && treeNode.getUserObject() instanceof RealEstateGroupInfo) {
            RealEstateGroupInfo info = (RealEstateGroupInfo)treeNode.getUserObject();
            realEstateGroupLongNumber = info.getLongNumber().toString();
            return realEstateGroupLongNumber;
        }
        return null;
    }

    protected int getTreeInitialLevel() {
        return 6;
    }

    protected String getRootName() {
        return TDUtils.getString("com.kingdee.eas.tm.td.est.ESTResource", "Title_GroupRoot", this.getLocale());
    }

    protected String getEditUIName() {
        return RealEstateEditUI.class.getName();
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Company;
    }

    protected FilterInfo getDefaultFilterForQuery() {
        return this.uiHelper.getHasPermissionOrgFilterForQuery();
    }

    protected ArrayList getImportParam() {
        String solutionName;
        DatataskParameter param = new DatataskParameter();
        param.solutionName = solutionName = "realEstate";
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        return paramList;
    }

    public void actionImportData_actionPerformed(ActionEvent e) throws Exception {
        super.actionImportData_actionPerformed(e);
        super.actionRefresh_actionPerformed(e);
    }

    public void actionExportData_actionPerformed(ActionEvent e) throws Exception {
        ArrayList para = this.getExportParam();
        if (para == null || para.size() <= 0) {
            throw new FrameWorkException(FrameWorkException.EXPORTDATAPARANULL);
        }
        DatataskCaller task = new DatataskCaller();
        task.setParentComponent((Component)((Object)this));
        task.setMainOrgContext(this.getMainOrgContext());
        task.invoke(para, 1);
    }

    protected ArrayList getExportParam() {
        DatataskParameter param = new DatataskParameter();
        param.solutionName = "realEstate";
        param.datataskMode = 1;
        param.alias = EASResource.getString((String)"com.kingdee.eas.tm.td.est.RealEstateResource", (String)"REALESTATEEXPORTEXCELNAME");
        param.varList = new ArrayList();
        Hashtable<String, FilterInfo> hashtable = new Hashtable<String, FilterInfo>();
        HashSet selectIds = new HashSet(this.getSelectedIdValues());
        try {
            if (selectIds.size() > 0) {
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("id", selectIds, CompareType.INCLUDE));
                hashtable.put("filter", filter);
            } else if (this.mainQuery != null) {
                hashtable.put("filter", this.mainQuery.getFilter());
            }
        }
        catch (Exception filter) {
            // empty catch block
        }
        param.setContextParam(hashtable);
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        return paramList;
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    protected QuickFilteringSupportItems getQuickFilteringSupport() {
        this.qfsi.setMustQueryAtFirst(true);
        return this.qfsi;
    }

    public boolean isSupportedBatchActions() {
        return true;
    }

    protected ITreeBase getTreeInterface() throws Exception {
        return RealEstateGroupFactory.getRemoteInstance();
    }

    protected String getGroupEditUIName() {
        return RealEstateEditUI.class.getName();
    }

    protected String getQueryFieldName() {
        return "realEstateGroup.id";
    }

    @Override
    public String getBizOrgProperty(OrgType orgType) throws BOSException, EASBizException {
        return "company";
    }

    @Override
    public ICoreBase getPermInterface() throws Exception {
        return this.getBizInterface();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        try {
            this.initPermActions();
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public void initPermActions() throws BOSException, EASBizException {
        this.uiHelper.bindPermission((AbstractButton)this.btnRemove, (IItemAction)this.actionRemove, this.getServiceContext());
        this.uiHelper.bindPermission((AbstractButton)this.btnCancelCancel, (IItemAction)this.actionCancelCancel, this.getServiceContext());
        this.uiHelper.bindPermission((AbstractButton)this.btnCancel, (IItemAction)this.actionCancel, this.getServiceContext());
        this.uiHelper.bindPermission((AbstractButton)this.menuItemRemove, (IItemAction)this.actionRemove, this.getServiceContext());
        this.uiHelper.bindPermission((AbstractButton)this.menuItemCancelCancel, (IItemAction)this.actionCancelCancel, this.getServiceContext());
        this.uiHelper.bindPermission((AbstractButton)this.menuItemCancel, (IItemAction)this.actionCancel, this.getServiceContext());
    }

    @Override
    public void initPermMainOrgContext(String orgID) throws Exception {
        this.initUIMainOrgContext(orgID);
    }

    protected IObjectPK getOrgPK(ItemAction action) {
        ObjectUuidPK pk = null;
        if (this.isSupportedBatchActions()) {
            RealEstateInfo info = null;
            try {
                if (!StringUtils.isEmpty((String)this.getSelectedKeyValue()) && this.getBizInterface().exists((IObjectPK)new ObjectUuidPK(this.getSelectedKeyValue())) && (info = RealEstateFactory.getRemoteInstance().getRealEstateInfo((IObjectPK)new ObjectUuidPK(this.getSelectedKeyValue()))) != null && info.getCompany() != null) {
                    pk = new ObjectUuidPK(info.getCompany().getId().toString());
                }
            }
            catch (Exception e) {
                this.handUIException(e);
            }
            if (pk != null) {
                return pk;
            }
        }
        if (this.getMainOrgContext() != null && this.getMainOrgContext().get((Object)this.getMainBizOrgType()) != null) {
            pk = new ObjectUuidPK(((OrgUnitInfo)this.getMainOrgContext().get((Object)this.getMainBizOrgType())).getId().toString());
            return pk;
        }
        return super.getOrgPK(action);
    }
}

