/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.est.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleInfo;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.EditUI;
import com.kingdee.eas.tm.td.TDUtils;
import com.kingdee.eas.tm.td.basedata.TaxItemTypeInfo;
import com.kingdee.eas.tm.td.common.permsupport.IPermSupport4EditUI;
import com.kingdee.eas.tm.td.common.uihelper.EditUIHelper;
import com.kingdee.eas.tm.td.est.CalcFormulaFactory;
import com.kingdee.eas.tm.td.est.CalcFormulaInfo;
import com.kingdee.eas.tm.td.est.ContractEntryCollection;
import com.kingdee.eas.tm.td.est.ContractEntryInfo;
import com.kingdee.eas.tm.td.est.ContractEntryStateEnum;
import com.kingdee.eas.tm.td.est.ContractTaxEntryInfo;
import com.kingdee.eas.tm.td.est.EstStateEnum;
import com.kingdee.eas.tm.td.est.EstTaxCycleEnum;
import com.kingdee.eas.tm.td.est.MonthEnum;
import com.kingdee.eas.tm.td.est.RealEstateGroupEntryCollection;
import com.kingdee.eas.tm.td.est.RealEstateGroupEntryInfo;
import com.kingdee.eas.tm.td.est.RealEstateGroupFactory;
import com.kingdee.eas.tm.td.est.RealEstateGroupInfo;
import com.kingdee.eas.tm.td.est.RealEstateInfo;
import com.kingdee.eas.tm.td.est.RentTypeEnum;
import com.kingdee.eas.tm.td.est.RentalEstateFactory;
import com.kingdee.eas.tm.td.est.RentalEstateInfo;
import com.kingdee.eas.tm.td.est.TaxCycleEnum;
import com.kingdee.eas.tm.td.est.TaxMethodEnum;
import com.kingdee.eas.tm.td.est.client.AbstractRentalEstateEditUI;
import com.kingdee.eas.tm.td.est.client.util.EstClientUtils;
import com.kingdee.eas.tm.td.est.util.EstConstant;
import com.kingdee.eas.tm.td.est.util.EstUtils;
import com.kingdee.eas.tm.td.utils.TDPermissionUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class RentalEstateEditUI
extends AbstractRentalEstateEditUI
implements IPermSupport4EditUI {
    private static final Logger logger = CoreUIObject.getLogger(RentalEstateEditUI.class);
    protected boolean isNumberEditable = false;
    private static final String TB_CONTRACTNUMBER = "contractNumber";
    private static final String TB_CUSTOMER = "customer";
    private static final String TB_LEASEHOLDER = "leaseholder";
    private static final String TB_TAXNUMBER = "taxNumber";
    private static final String TB_STATE = "state";
    private static final String TB_SIGNDATE = "signDate";
    private static final String TB_FIRSTDATE = "firstDate";
    private static final String TB_LASTDATE = "lastDate";
    private static final String TB_TOTALAMOUNT = "totalAmount";
    private static final String TB_CURRENCY = "currency";
    private static final String TB_MONTHRENT = "monthRent";
    private static final String TB_TAXCYCLE = "taxCycle";
    private static final String TB_RENTTYPE = "rentType";
    private static final String TB_FIRSTRENT = "firstRent";
    private static final String TB_LASTRENT = "lastRent";
    private static final String TB_TX_TAXITEMTYPE = "taxItemType";
    private static final String TB_TX_TAXRATE = "taxRate";
    private static final String TB_TX_DEDUCTDATE = "deductRate";
    private static final String TB_TX_TAXCYCLE = "taxCycle";
    private static final String TB_TX_FIRSTPAYMENTMONTH = "firstPaymentMonth";
    private static final String TB_TX_CALCFORMULA = "calcFormula";
    private KDTEditAdapter entryTableChange = null;
    private KDTEditAdapter taxEntryTableChange = null;
    private DataChangeListener prmtCompanyListener;
    private ChangeListener entrySelectListener;
    private DataChangeListener prmtRealEstateListener;
    private EditUIHelper uiHelper = new EditUIHelper((EditUI)this);
    private Map btnMap = new HashMap();

    public RentalEstateEditUI() throws Exception {
        this.btnMap.put("actionRemove", this.actionRemove);
        this.btnMap.put("actionCancel", this.actionCancel);
        this.btnMap.put("actionCancelCancel", this.actionCancelCancel);
        this.btnMap.put("actionEdit", this.actionEdit);
        this.btnMap.put("actionSave", this.actionSave);
        this.btnMap.put("actionCopy", this.actionCopy);
        this.btnMap.put("actionAddLine", this.actionAddLine);
        this.btnMap.put("actionRemoveLine", this.actionRemoveLine);
        this.btnMap.put("actionInsertLine", this.actionInsertLine);
    }

    public void onLoad() throws Exception {
        this.kdtContractEntry.checkParsed();
        this.kdtContractTaxEntry.checkParsed();
        super.onLoad();
        this.btnAuditResult.setVisible(false);
        this.txtRentalArea.setMinimumValue((Comparable)BigDecimal.ZERO);
        this.initEntryEditor();
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        EstClientUtils.textFieldTrim(this.getComponents());
        StringBuffer msgSB = new StringBuffer();
        StringBuffer notNullSB = new StringBuffer();
        if (this.prmtCompany.getValue() == null) {
            notNullSB.append(EASResource.getString((String)"com.kingdee.eas.tm.td.est.ESTResource", (String)"Company"));
        }
        if (this.txtNumber.getText().isEmpty()) {
            notNullSB.append(EASResource.getString((String)"com.kingdee.eas.tm.td.est.ESTResource", (String)"Number"));
        }
        if (this.prmtRealEstate.getValue() == null) {
            notNullSB.append(EASResource.getString((String)"com.kingdee.eas.tm.td.est.ESTResource", (String)"RealEstate"));
        }
        if (this.txtName.getText().isEmpty()) {
            notNullSB.append(EASResource.getString((String)"com.kingdee.eas.tm.td.est.ESTResource", (String)"Name"));
        }
        if (notNullSB.length() > 0) {
            notNullSB.append(EASResource.getString((String)"com.kingdee.eas.tm.td.est.ESTResource", (String)"NOTNULL"));
        }
        String largerZeroSB = EstClientUtils.largerZero(new Object[]{this.contRentalArea}, false);
        if (notNullSB.length() > 0) {
            msgSB.append(notNullSB.toString().substring(1)).append("\n");
        }
        if (largerZeroSB.length() > 0) {
            msgSB.append(largerZeroSB);
        }
        if (msgSB.length() > 0) {
            MsgBox.showWarning((String)msgSB.toString());
            SysUtil.abort();
        }
        ArrayList errorList = new ArrayList();
        this.checkEntry(errorList);
        this.checkTaxEntry(errorList);
        if (errorList.size() > 0) {
            String saveError = EASResource.getString((String)"com.kingdee.eas.tm.td.est.ESTResource", (String)"Msg_SaveError");
            MsgBox.showDetailAndOK((Component)((Object)this), (String)saveError, (String)TDUtils.buildErrorMsg(errorList), (int)8188);
            SysUtil.abort();
        }
    }

    protected String transmitNumber(String number) {
        if (number == null || number.length() == 0) {
            return "";
        }
        return number.replace(",", "");
    }

    protected void initDataStatus() {
        super.initDataStatus();
        if (this.editData != null) {
            this.initActionEnableByState();
        }
    }

    private void initEntryEditor() {
        KDTextField txtContractNumber = new KDTextField();
        txtContractNumber.setMaxLength(80);
        this.kdtContractEntry.getColumn(TB_CONTRACTNUMBER).setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtContractNumber));
        KDTextField txtLeaseholder = new KDTextField();
        txtLeaseholder.setMaxLength(80);
        this.kdtContractEntry.getColumn(TB_LEASEHOLDER).setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtLeaseholder));
        KDTextField txtTaxNumber = new KDTextField();
        txtTaxNumber.setMaxLength(80);
        this.kdtContractEntry.getColumn(TB_TAXNUMBER).setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtTaxNumber));
        KDBizPromptBox customer = EstClientUtils.getF7Box("com.kingdee.eas.basedata.master.cssp.app.F7CustomerQuery");
        this.kdtContractEntry.getColumn(TB_CUSTOMER).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)customer));
        this.kdtContractEntry.getColumn(TB_CUSTOMER).setRenderer(EstClientUtils.getNameRander());
        EstClientUtils.setEnumEditor(this.kdtContractEntry, TB_STATE, "com.kingdee.eas.tm.td.est.ContractEntryStateEnum");
        EstClientUtils.setDateEditor(this.kdtContractEntry, TB_SIGNDATE);
        EstClientUtils.setDateEditor(this.kdtContractEntry, TB_FIRSTDATE);
        EstClientUtils.setDateEditor(this.kdtContractEntry, TB_LASTDATE);
        EstClientUtils.setBigDecimalEditor(this.kdtContractEntry, TB_TOTALAMOUNT, EstConstant.PRECISION_2);
        KDBizPromptBox currency = EstClientUtils.getF7Box("com.kingdee.eas.basedata.assistant.app.CurrencyQuery");
        this.kdtContractEntry.getColumn(TB_CURRENCY).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)currency));
        this.kdtContractEntry.getColumn(TB_CURRENCY).setRenderer(EstClientUtils.getNameRander());
        EstClientUtils.setBigDecimalEditor(this.kdtContractEntry, TB_MONTHRENT, EstConstant.PRECISION_2);
        EstClientUtils.setEnumEditor(this.kdtContractEntry, "taxCycle", "com.kingdee.eas.tm.td.est.TaxCycleEnum");
        EstClientUtils.setEnumEditor(this.kdtContractEntry, TB_RENTTYPE, "com.kingdee.eas.tm.td.est.RentTypeEnum");
        EstClientUtils.setBigDecimalEditor(this.kdtContractEntry, TB_FIRSTRENT, EstConstant.PRECISION_2);
        EstClientUtils.setBigDecimalEditor(this.kdtContractEntry, TB_LASTRENT, EstConstant.PRECISION_2);
        KDBizPromptBox taxItemType = EstClientUtils.getF7Box("com.kingdee.eas.tm.td.basedata.app.TaxItemTypeQuery");
        this.kdtContractTaxEntry.getColumn(TB_TX_TAXITEMTYPE).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)taxItemType));
        this.kdtContractTaxEntry.getColumn(TB_TX_TAXITEMTYPE).setRenderer(EstClientUtils.getNameRander());
        EstClientUtils.setRateEditor(this.kdtContractTaxEntry, TB_TX_TAXRATE, EstConstant.PRECISION_4);
        EstClientUtils.setRateEditor(this.kdtContractTaxEntry, TB_TX_DEDUCTDATE, EstConstant.PRECISION_4);
        EstClientUtils.setEnumEditor(this.kdtContractTaxEntry, "taxCycle", "com.kingdee.eas.tm.td.est.EstTaxCycleEnum");
        EstClientUtils.setEnumEditor(this.kdtContractTaxEntry, TB_TX_FIRSTPAYMENTMONTH, "com.kingdee.eas.tm.td.est.MonthEnum");
        KDBizPromptBox calcFormula = EstClientUtils.getF7Box("com.kingdee.eas.tm.td.est.app.CalcFormulaF7Query");
        this.kdtContractTaxEntry.getColumn(TB_TX_CALCFORMULA).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)calcFormula));
        this.kdtContractTaxEntry.getColumn(TB_TX_CALCFORMULA).setRenderer(EstClientUtils.getRander("$displayExpr$"));
    }

    private void initEntryCellRequire() throws BOSException {
        IRow row;
        int i;
        int rowCount = this.kdtContractTaxEntry.getRowCount();
        for (i = 0; i < rowCount; ++i) {
            row = this.kdtContractTaxEntry.getRow(i);
            EstTaxCycleEnum taxCycle = (EstTaxCycleEnum)((Object)row.getCell("taxCycle").getValue());
            if (EstTaxCycleEnum.ONCE.equals((Object)taxCycle) || EstTaxCycleEnum.ASRENTCYCLE.equals((Object)taxCycle)) {
                EstClientUtils.setCellLocked(row, TB_TX_FIRSTPAYMENTMONTH, true);
            } else {
                EstClientUtils.setCellLocked(row, TB_TX_FIRSTPAYMENTMONTH, false);
            }
            this.taxItemTypeChanged(row);
        }
        rowCount = this.kdtContractEntry.getRowCount();
        for (i = 0; i < rowCount; ++i) {
            row = this.kdtContractEntry.getRow(i);
            this.handleRentType(row);
        }
        this.kdtContractTaxEntry.repaint();
    }

    @Override
    public void loadFields() {
        this.removeListeners();
        super.loadFields();
        this.initNumber();
        this.initActionEnableByState();
        try {
            this.initEntryCellRequire();
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        this.initRealEstateFilter();
        this.initCompanyFilter();
        this.initListeners();
    }

    private void initListeners() {
        if (this.entryTableChange == null) {
            this.entryTableChange = new KDTEditAdapter(){

                public void editStopped(KDTEditEvent e) {
                    try {
                        RentalEstateEditUI.this.kdtEntries_ChangedStopped(e);
                    }
                    catch (Exception exc) {
                        RentalEstateEditUI.this.handUIException(exc);
                    }
                }
            };
        }
        this.kdtContractEntry.addKDTEditListener((KDTEditListener)this.entryTableChange);
        if (this.taxEntryTableChange == null) {
            this.taxEntryTableChange = new KDTEditAdapter(){

                public void editStopped(KDTEditEvent e) {
                    try {
                        RentalEstateEditUI.this.kdtTaxEntries_ChangedStopped(e);
                    }
                    catch (Exception exc) {
                        logger.error((Object)exc);
                        RentalEstateEditUI.this.handUIException(exc);
                    }
                }
            };
        }
        this.kdtContractTaxEntry.addKDTEditListener((KDTEditListener)this.taxEntryTableChange);
        if (this.prmtCompanyListener == null) {
            this.prmtCompanyListener = new DataChangeListener(){

                public void dataChanged(DataChangeEvent eventObj) {
                    RentalEstateEditUI.this.prmtCompany_dataChanged(eventObj);
                }
            };
        }
        this.prmtCompany.addDataChangeListener(this.prmtCompanyListener);
        if (this.entrySelectListener == null) {
            this.entrySelectListener = new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    RentalEstateEditUI.this.initActionEnableByState();
                }
            };
        }
        this.kDTabbedPane1.addChangeListener(this.entrySelectListener);
        if (this.prmtRealEstateListener == null) {
            this.prmtRealEstateListener = new DataChangeListener(){

                public void dataChanged(DataChangeEvent eventObj) {
                    RentalEstateEditUI.this.prmtRealEstate_dataChanged(eventObj);
                }
            };
        }
        this.prmtRealEstate.addDataChangeListener(this.prmtRealEstateListener);
    }

    protected void prmtCompany_dataChanged(DataChangeEvent e) {
        if (TDUtils.isEqual(e.getNewValue(), e.getOldValue())) {
            return;
        }
        this.prmtRealEstate.setValue(null);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (e.getNewValue() != null && e.getNewValue() instanceof CompanyOrgUnitInfo) {
            CompanyOrgUnitInfo info = (CompanyOrgUnitInfo)e.getNewValue();
            filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)info.getId().toString(), CompareType.EQUALS));
        }
        view.setFilter(filter);
        this.prmtRealEstate.setEntityViewInfo(view);
        this.prmtRealEstate.setValue(null);
    }

    protected void prmtRealEstate_dataChanged(DataChangeEvent e) {
        if (TDUtils.isEqual(e.getNewValue(), e.getOldValue())) {
            return;
        }
        this.kdtContractTaxEntry.removeRows();
        if (e.getNewValue() == null) {
            return;
        }
        RealEstateInfo realEstateInfo = (RealEstateInfo)e.getNewValue();
        if (realEstateInfo != null) {
            try {
                RealEstateGroupInfo realEstateGroupInfo = RealEstateGroupFactory.getRemoteInstance().getRealEstateGroupInfo((IObjectPK)new ObjectUuidPK(realEstateInfo.getRealEstateGroup().getId().toString()), this.getRealEstateGroupSelector());
                if (realEstateGroupInfo != null) {
                    RealEstateGroupEntryCollection realEstateGroupEntryCollection = realEstateGroupInfo.getEntry();
                    int j = realEstateGroupEntryCollection.size();
                    for (int i = 0; i < j; ++i) {
                        RealEstateGroupEntryInfo realEstateGroupEntryInfo = realEstateGroupEntryCollection.get(i);
                        if (!this.checkTaxItemType(realEstateGroupEntryInfo)) continue;
                        ContractTaxEntryInfo contractTaxEntryInfo = new ContractTaxEntryInfo();
                        contractTaxEntryInfo.setTaxItemType(realEstateGroupEntryInfo.getTaxItemType());
                        contractTaxEntryInfo.setTaxRate(realEstateGroupEntryInfo.getTaxRate());
                        contractTaxEntryInfo.setTaxCycle(realEstateGroupEntryInfo.getTaxCycle());
                        contractTaxEntryInfo.setFirstPaymentMonth(realEstateGroupEntryInfo.getFirstPaymentMonth());
                        IRow row = this.kdtContractTaxEntry.addRow();
                        this.getUILifeCycleHandler().fireOnAddNewLine((Object)this.kdtContractTaxEntry, (IObjectValue)contractTaxEntryInfo);
                        this.dataBinder.loadLineFields(this.kdtContractTaxEntry, row, (IObjectValue)contractTaxEntryInfo);
                    }
                }
                this.initEntryCellRequire();
            }
            catch (EASBizException e1) {
                this.handUIException(e1);
            }
            catch (BOSException e1) {
                this.handUIException(e1);
            }
        }
    }

    private SelectorItemCollection getRealEstateGroupSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("entry.*"));
        sic.add(new SelectorItemInfo("entry.taxItemType.*"));
        return sic;
    }

    private boolean checkTaxItemType(RealEstateGroupEntryInfo realEstateGroupEntryInfo) {
        if ("ZCyrvv6oAnPgU0ETqMCc49uK96Y=".equals(realEstateGroupEntryInfo.getTaxItemType().getId().toString()) && TaxMethodEnum.RENT.equals((Object)realEstateGroupEntryInfo.getTaxMethod())) {
            return true;
        }
        return "Xip0em3cA6rgU0ETqMAGKduK96Y=".equals(realEstateGroupEntryInfo.getTaxItemType().getId().toString()) || "ZCyrvv6mAnPgU0ETqMCc49uK96Y=".equals(realEstateGroupEntryInfo.getTaxItemType().getId().toString());
    }

    protected void initRealEstateFilter() {
        if (this.prmtCompany.getValue() == null) {
            return;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        CompanyOrgUnitInfo info = (CompanyOrgUnitInfo)this.prmtCompany.getValue();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)info.getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo(TB_STATE, (Object)"1", CompareType.EQUALS));
        view.setFilter(filter);
        this.prmtRealEstate.setEntityViewInfo(view);
    }

    protected void initCompanyFilter() {
        try {
            this.uiHelper.setMainBizOrgFilter();
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
    }

    private void removeListeners() {
        if (this.entryTableChange != null) {
            this.kdtContractEntry.removeKDTEditListener((KDTEditListener)this.entryTableChange);
        }
        if (this.taxEntryTableChange != null) {
            this.kdtContractTaxEntry.removeKDTEditListener((KDTEditListener)this.taxEntryTableChange);
        }
        if (this.prmtCompanyListener != null) {
            this.prmtCompany.removeDataChangeListener(this.prmtCompanyListener);
        }
        if (this.entrySelectListener != null) {
            this.kDTabbedPane1.removeChangeListener(this.entrySelectListener);
        }
        if (this.prmtRealEstateListener != null) {
            this.prmtRealEstate.removeDataChangeListener(this.prmtRealEstateListener);
        }
    }

    protected void kdtEntries_ChangedStopped(KDTEditEvent e) throws Exception {
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        IRow row = this.kdtContractEntry.getRow(rowIndex);
        String fieldName = this.kdtContractEntry.getColumnKey(colIndex);
        if (TB_CUSTOMER.equals(fieldName)) {
            if (TDUtils.isEqual(e.getValue(), e.getOldValue())) {
                return;
            }
            Object obj = row.getCell(TB_CUSTOMER).getValue();
            if (obj != null && obj instanceof CustomerInfo) {
                CustomerInfo customer = (CustomerInfo)obj;
                row.getCell(TB_LEASEHOLDER).setValue((Object)customer.getName());
                row.getCell(TB_TAXNUMBER).setValue((Object)customer.getTaxRegisterNo());
            }
            if (obj == null) {
                row.getCell(TB_LEASEHOLDER).setValue(null);
                row.getCell(TB_TAXNUMBER).setValue(null);
            }
        } else if (TB_MONTHRENT.equals(fieldName)) {
            this.totalAmtReCalc(row);
        } else if (TB_FIRSTRENT.equals(fieldName) || TB_LASTRENT.equals(fieldName)) {
            BigDecimal monthRent = (BigDecimal)row.getCell(TB_MONTHRENT).getValue();
            BigDecimal firstRent = (BigDecimal)row.getCell(TB_FIRSTRENT).getValue();
            BigDecimal lastRent = (BigDecimal)row.getCell(TB_LASTRENT).getValue();
            if (monthRent == null) {
                monthRent = BigDecimal.ZERO;
            }
            if (firstRent == null) {
                firstRent = BigDecimal.ZERO;
            }
            if (lastRent == null) {
                lastRent = BigDecimal.ZERO;
            }
            Date firstDate = (Date)row.getCell(TB_FIRSTDATE).getValue();
            Date lastDate = (Date)row.getCell(TB_LASTDATE).getValue();
            int monthSpan = EstUtils.getMonthSpan(firstDate, lastDate);
            BigDecimal totalAmt = monthRent.multiply(new BigDecimal(monthSpan - 2)).setScale(EstConstant.PRECISION_2, RoundingMode.HALF_UP).add(firstRent).add(lastRent);
            row.getCell(TB_TOTALAMOUNT).setValue((Object)totalAmt);
        } else if (TB_FIRSTDATE.equals(fieldName)) {
            Date end = (Date)row.getCell(TB_LASTDATE).getValue();
            if (((Date)e.getValue()).after(end)) {
                MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.tm.td.est.ESTResource", (String)"Error_ContractDate"));
                row.getCell(TB_FIRSTDATE).setValue(e.getOldValue());
            } else {
                this.totalAmtReCalc(row);
            }
            this.handleRentType(row);
        } else if (TB_LASTDATE.equals(fieldName)) {
            Date start = (Date)row.getCell(TB_FIRSTDATE).getValue();
            if (((Date)e.getValue()).before(start)) {
                MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.tm.td.est.ESTResource", (String)"Error_ContractDate"));
                row.getCell(TB_LASTDATE).setValue(e.getOldValue());
            } else {
                this.totalAmtReCalc(row);
            }
        } else if ("taxCycle".equals(fieldName)) {
            this.handleRentType(row);
        }
    }

    private void handleRentType(IRow row) {
        TaxCycleEnum cycle = (TaxCycleEnum)((Object)row.getCell("taxCycle").getValue());
        Date start = (Date)row.getCell(TB_FIRSTDATE).getValue();
        if (TaxCycleEnum.MONTH.equals((Object)cycle) || EstUtils.isFirstDay(start)) {
            row.getCell(TB_RENTTYPE).setValue((Object)RentTypeEnum.LAST);
            row.getCell(TB_RENTTYPE).getStyleAttributes().setLocked(true);
        } else {
            row.getCell(TB_RENTTYPE).getStyleAttributes().setLocked(false);
        }
    }

    private void totalAmtReCalc(IRow row) {
        Date lastDate;
        BigDecimal monthRent = (BigDecimal)row.getCell(TB_MONTHRENT).getValue();
        if (monthRent == null) {
            return;
        }
        Date firstDate = (Date)row.getCell(TB_FIRSTDATE).getValue();
        int monthSpan = EstUtils.getMonthSpan(firstDate, lastDate = (Date)row.getCell(TB_LASTDATE).getValue());
        if (monthSpan == 1) {
            row.getCell(TB_FIRSTRENT).setValue((Object)monthRent);
            row.getCell(TB_LASTRENT).setValue((Object)monthRent);
            row.getCell(TB_TOTALAMOUNT).setValue((Object)monthRent);
            row.getCell(TB_FIRSTRENT).getStyleAttributes().setLocked(true);
            row.getCell(TB_LASTRENT).getStyleAttributes().setLocked(true);
        } else if (monthSpan >= 2) {
            BigDecimal afterDays = EstUtils.getAfterDays(firstDate);
            BigDecimal firstRent = afterDays.multiply(monthRent).setScale(EstConstant.PRECISION_2, RoundingMode.HALF_UP);
            BigDecimal beforeDays = EstUtils.getBeforeDays(lastDate);
            BigDecimal lastRent = beforeDays.multiply(monthRent).setScale(EstConstant.PRECISION_2, RoundingMode.HALF_UP);
            row.getCell(TB_FIRSTRENT).setValue((Object)firstRent);
            row.getCell(TB_LASTRENT).setValue((Object)lastRent);
            BigDecimal totalAmt = monthRent.multiply(new BigDecimal(monthSpan - 2)).setScale(EstConstant.PRECISION_2, RoundingMode.HALF_UP).add((BigDecimal)row.getCell(TB_FIRSTRENT).getValue()).add((BigDecimal)row.getCell(TB_LASTRENT).getValue());
            row.getCell(TB_TOTALAMOUNT).setValue((Object)totalAmt);
            row.getCell(TB_FIRSTRENT).getStyleAttributes().setLocked(false);
            row.getCell(TB_LASTRENT).getStyleAttributes().setLocked(false);
        } else {
            return;
        }
    }

    protected void kdtTaxEntries_ChangedStopped(KDTEditEvent e) throws Exception {
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        IRow row = this.kdtContractTaxEntry.getRow(rowIndex);
        String fieldName = this.kdtContractTaxEntry.getColumnKey(colIndex);
        if (TB_TX_TAXITEMTYPE.equals(fieldName)) {
            this.taxItemTypeChanged(row);
        }
        if ("taxCycle".equals(fieldName)) {
            if (EstTaxCycleEnum.ONCE.equals(row.getCell("taxCycle").getValue()) || EstTaxCycleEnum.ASRENTCYCLE.equals(row.getCell("taxCycle").getValue())) {
                EstClientUtils.setCellLocked(row, TB_TX_FIRSTPAYMENTMONTH, true);
                row.getCell(TB_TX_FIRSTPAYMENTMONTH).setValue(null);
            } else {
                EstClientUtils.setCellLocked(row, TB_TX_FIRSTPAYMENTMONTH, false);
            }
            this.kdtContractTaxEntry.repaint();
        }
    }

    private void taxItemTypeChanged(IRow row) throws BOSException {
        Object obj = row.getCell(TB_TX_TAXITEMTYPE).getValue();
        if (obj != null && obj instanceof TaxItemTypeInfo) {
            TaxItemTypeInfo taxItemType = (TaxItemTypeInfo)obj;
            String taxItemTypeId = taxItemType.getId().toString();
            EntityViewInfo entityViewInfo = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            HashMap<String, String> params = new HashMap<String, String>();
            filter.getFilterItems().add(new FilterItemInfo("taxItemType.id", (Object)taxItemTypeId));
            params.put(TB_TX_TAXITEMTYPE, taxItemTypeId);
            if ("ZCyrvv6oAnPgU0ETqMCc49uK96Y=".equals(taxItemTypeId)) {
                filter.getFilterItems().add(new FilterItemInfo("taxMethod", (Object)"2", CompareType.EQUALS));
                params.put("taxMethod", "2");
            }
            filter.getFilterItems().add(new FilterItemInfo(TB_STATE, (Object)"1", CompareType.EQUALS));
            entityViewInfo.setFilter(filter);
            KDBizPromptBox calcBox = EstClientUtils.getF7Box("com.kingdee.eas.tm.td.est.app.CalcFormulaF7Query");
            calcBox.setEntityViewInfo(entityViewInfo);
            row.getCell(TB_TX_CALCFORMULA).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)calcBox));
            CalcFormulaInfo calc = CalcFormulaFactory.getRemoteInstance().getDefaultCalcFormula(params);
            row.getCell(TB_TX_CALCFORMULA).setValue((Object)calc);
        }
    }

    private void initActionEnableByState() {
        this.btnCancel.setVisible(true);
        this.btnCancelCancel.setVisible(true);
        this.menuItemCancel.setVisible(true);
        this.menuItemCancelCancel.setVisible(true);
        this.txtNumber.setEditable(this.isNumberEditable);
        EstStateEnum state = this.editData.getState();
        boolean isLight = false;
        if (EstStateEnum.FORBIDDEN.equals((Object)state)) {
            isLight = true;
        }
        this.uiHelper.initBtnStatus(this.btnMap, isLight);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void actionAddLine_actionPerformed(ActionEvent e) throws Exception {
        IObjectValue detailData;
        KDTable table = this.getDetailTable();
        if (table != null && (detailData = this.createNewDetailData(table)) != null) {
            IRow row;
            if (detailData instanceof ContractEntryInfo) {
                if (table.getRowCount3() > 0) {
                    this.resetDate(table.getRow(0), detailData);
                }
                row = table.addRow(0);
            } else {
                row = table.addRow();
            }
            this.getUILifeCycleHandler().fireOnAddNewLine((Object)table, detailData);
            this.dataBinder.loadLineFields(table, row, detailData);
        }
    }

    public void actionInsertLine_actionPerformed(ActionEvent e) throws Exception {
        KDTable table = this.getDetailTable();
        IObjectValue detailData = this.createNewDetailData(table);
        if (detailData instanceof ContractEntryInfo && table.getRowCount3() > 0) {
            this.resetDate(table.getRow(0), detailData);
        }
        if (table.getSelectManager().size() > 0) {
            if (detailData != null) {
                int top = table.getSelectManager().get().getTop();
                this.getUILifeCycleHandler().fireOnAddNewLine((Object)table, detailData);
                IRow row = table.addRow(top);
                this.dataBinder.loadLineFields(table, row, detailData);
            }
        } else {
            IRow row = table.addRow();
            this.dataBinder.loadLineFields(table, row, detailData);
        }
    }

    public void actionRemoveLine_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemoveLine_actionPerformed(e);
    }

    private void resetDate(IRow preRow, IObjectValue detailData) {
        ContractEntryInfo info = (ContractEntryInfo)detailData;
        Date preEndDate = (Date)preRow.getCell(TB_LASTDATE).getValue();
        Date newBeginDate = new Date(preEndDate.getTime());
        newBeginDate.setDate(newBeginDate.getDate() + 1);
        Date newEndDate = new Date(newBeginDate.getTime());
        newEndDate.setMonth(newEndDate.getMonth() + 1);
        newEndDate.setDate(newEndDate.getDate() - 1);
        info.setSignDate(newBeginDate);
        info.setFirstDate(newBeginDate);
        info.setLastDate(newEndDate);
    }

    private void initNumber() {
        try {
            String companyID = SysContext.getSysContext().getCurrentCtrlUnit().getId().toString();
            ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
            CodingRuleInfo codingRule = iCodingRuleManager.getCodingRule((IObjectValue)this.editData, companyID);
            if (codingRule == null) {
                this.isNumberEditable = true;
                return;
            }
            if (codingRule.isIsModifiable()) {
                this.isNumberEditable = true;
            }
            if (codingRule.isIsAddView() && this.txtNumber.getText().trim().isEmpty()) {
                this.txtNumber.setText(iCodingRuleManager.getNumber((IObjectValue)this.editData, companyID));
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    protected IObjectValue createNewData() {
        RentalEstateInfo info = new RentalEstateInfo();
        try {
            info.setCompany(TDPermissionUtil.getPermissionCompany("ert_rentalEstate_view"));
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        info.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        info.setCU(SysContext.getSysContext().getCurrentCtrlUnit());
        info.setState(EstStateEnum.USING);
        info.getContractEntry().add((ContractEntryInfo)this.createNewDetailData(this.kdtContractEntry));
        info.getContractTaxEntry().add((ContractTaxEntryInfo)this.createNewDetailData(this.kdtContractTaxEntry));
        return info;
    }

    protected IObjectValue createNewDetailData(KDTable table) {
        if (table.equals(this.kdtContractEntry)) {
            ContractEntryInfo entryInfo = new ContractEntryInfo();
            Date now = new Date();
            entryInfo.setSignDate(now);
            entryInfo.setFirstDate(now);
            Date end = new Date();
            end.setMonth(end.getMonth() + 1);
            end.setDate(end.getDate() - 1);
            entryInfo.setLastDate(end);
            entryInfo.setTaxCycle(TaxCycleEnum.MONTH);
            entryInfo.setRentType(RentTypeEnum.LAST);
            entryInfo.setState(ContractEntryStateEnum.EFFECTIVE);
            return entryInfo;
        }
        ContractTaxEntryInfo taxEntryInfo = new ContractTaxEntryInfo();
        taxEntryInfo.setTaxCycle(EstTaxCycleEnum.ASRENTCYCLE);
        return taxEntryInfo;
    }

    protected KDTable getDetailTable() {
        if (this.kDPanel1.isShowing()) {
            return this.kdtContractEntry;
        }
        if (this.kDPanel2.isShowing()) {
            return this.kdtContractTaxEntry;
        }
        return this.kdtContractEntry;
    }

    private void checkEntry(ArrayList errorList) {
        String entryName = EASResource.getString((String)"com.kingdee.eas.tm.td.est.ESTResource", (String)"EntryRentName");
        int rowCount = this.kdtContractEntry.getRowCount();
        HashMap<Object, Object> numberMap = new HashMap<Object, Object>();
        KDTRow head = this.kdtContractEntry.getHead().getRow(0);
        Map<Integer, String> reqMap = EstClientUtils.getRequiredColName(this.kdtContractEntry);
        int numberIndex = this.kdtContractEntry.getColumnIndex(TB_CONTRACTNUMBER);
        for (int i = 0; i < rowCount; ++i) {
            IRow row = this.kdtContractEntry.getRow(i);
            if (numberMap.containsKey(row.getCell(TB_CONTRACTNUMBER).getValue())) {
                MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.tm.td.est.ESTResource", (String)"RentNumber_Exit"));
                SysUtil.abort();
            } else {
                numberMap.put(row.getCell(TB_CONTRACTNUMBER).getValue(), row.getCell(TB_CONTRACTNUMBER).getValue());
            }
            for (int j : reqMap.keySet()) {
                if (row.getCell(j).getValue() != null) continue;
                errorList.add(EASResource.getString((String)"com.kingdee.eas.tm.td.est.ESTResource", (String)"Error_EntryFieldsNull", (Object[])new Object[]{entryName, i + 1, reqMap.get(j)}));
            }
        }
        this.checkRentDateConflict(errorList);
    }

    private void checkTaxEntry(ArrayList errorList) {
        String entryName = EASResource.getString((String)"com.kingdee.eas.tm.td.est.ESTResource", (String)"EntryTaxName");
        int rowCount = this.kdtContractTaxEntry.getRowCount();
        TaxItemTypeInfo taxItemType = null;
        HashMap<String, TaxItemTypeInfo> taxItemTypeMap = new HashMap<String, TaxItemTypeInfo>();
        KDTRow head = this.kdtContractTaxEntry.getHead().getRow(0);
        int monthIndex = this.kdtContractTaxEntry.getColumnIndex(TB_TX_FIRSTPAYMENTMONTH);
        int taxRateIndex = this.kdtContractTaxEntry.getColumnIndex(TB_TX_TAXRATE);
        int taxPaymentCycleIndex = this.kdtContractTaxEntry.getColumnIndex("taxCycle");
        int calcFormulaIndex = this.kdtContractTaxEntry.getColumnIndex(TB_TX_CALCFORMULA);
        for (int i = 0; i < rowCount; ++i) {
            IRow row = this.kdtContractTaxEntry.getRow(i);
            if (row.getCell(TB_TX_TAXITEMTYPE).getValue() == null) {
                errorList.add(EASResource.getString((String)"com.kingdee.eas.tm.td.est.ESTResource", (String)"Error_EntryFieldsNull", (Object[])new Object[]{entryName, i + 1, head.getCell(taxRateIndex).getValue()}));
            } else {
                taxItemType = (TaxItemTypeInfo)row.getCell(TB_TX_TAXITEMTYPE).getValue();
                if (taxItemTypeMap.containsKey(taxItemType.getNumber())) {
                    MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.tm.td.est.ESTResource", (String)"TAXITEMTYPR_EXIST"));
                    SysUtil.abort();
                } else {
                    taxItemTypeMap.put(taxItemType.getNumber(), taxItemType);
                }
            }
            if (row.getCell(TB_TX_TAXRATE).getValue() == null) {
                errorList.add(EASResource.getString((String)"com.kingdee.eas.tm.td.est.ESTResource", (String)"Error_EntryFieldsNull", (Object[])new Object[]{entryName, i + 1, head.getCell(taxRateIndex).getValue()}));
            }
            if (row.getCell("taxCycle").getValue() == null) {
                errorList.add(EASResource.getString((String)"com.kingdee.eas.tm.td.est.ESTResource", (String)"Error_EntryFieldsNull", (Object[])new Object[]{entryName, i + 1, head.getCell(taxPaymentCycleIndex).getValue()}));
            }
            if (!row.getCell(TB_TX_FIRSTPAYMENTMONTH).getStyleAttributes().isLocked() && MonthEnum.Null.equals(row.getCell(TB_TX_FIRSTPAYMENTMONTH).getValue())) {
                errorList.add(EASResource.getString((String)"com.kingdee.eas.tm.td.est.ESTResource", (String)"Error_EntryFieldsNull", (Object[])new Object[]{entryName, i + 1, head.getCell(monthIndex).getValue()}));
            }
            if (row.getCell(TB_TX_CALCFORMULA).getValue() != null) continue;
            errorList.add(EASResource.getString((String)"com.kingdee.eas.tm.td.est.ESTResource", (String)"Error_EntryFieldsNull", (Object[])new Object[]{entryName, i + 1, head.getCell(calcFormulaIndex).getValue()}));
        }
    }

    private void checkRentDateConflict(ArrayList errorList) {
        ContractEntryCollection contractEntry = this.editData.getContractEntry();
        TDUtils.sort((IObjectCollection)contractEntry, TB_FIRSTDATE, false);
        for (int i = 0; i < contractEntry.size() - 1; ++i) {
            ContractEntryInfo after = contractEntry.get(i);
            ContractEntryInfo before = contractEntry.get(i + 1);
            if (ContractEntryStateEnum.TERMINATION.equals((Object)after.getState()) || ContractEntryStateEnum.TERMINATION.equals((Object)before.getState()) || after.getFirstDate().after(before.getLastDate())) continue;
            errorList.add(EASResource.getString((String)"com.kingdee.eas.tm.td.est.ESTResource", (String)"Error_DuplicatedDate", (Object[])new Object[]{before.getContractNumber(), after.getContractNumber()}));
        }
    }

    protected void setFieldsNull(AbstractObjectValue newData) {
        RentalEstateInfo editData = (RentalEstateInfo)newData;
        editData.setNumber(editData.getNumber() + "copy");
        editData.setName(editData.getName() + "Copy");
        editData.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        editData.setLastUpdateUser(null);
        Timestamp tt = new Timestamp(System.currentTimeMillis());
        editData.setCreateTime(tt);
        editData.setLastUpdateTime(null);
        editData.setCU(SysContext.getSysContext().getCurrentCtrlUnit());
        editData.setState(EstStateEnum.USING);
        ContractEntryCollection entryColl = editData.getContractEntry();
        int len = entryColl.size();
        for (int i = 0; i < len; ++i) {
            entryColl.removeObject(0);
        }
        ContractEntryInfo entryInfo = new ContractEntryInfo();
        Date now = new Date();
        entryInfo.setFirstDate(now);
        Date end = new Date();
        end.setMonth(end.getMonth() + 1);
        end.setDate(end.getDate() - 1);
        entryInfo.setLastDate(end);
        entryInfo.setTaxCycle(TaxCycleEnum.MONTH);
        entryInfo.setRentType(RentTypeEnum.FIRST);
        entryInfo.setState(ContractEntryStateEnum.EFFECTIVE);
        entryColl.add(entryInfo);
        String companyID = editData.getCU().getId().toString();
        try {
            String number = TDUtils.getNewNumber((IObjectValue)editData, companyID);
            if (!StringUtils.isEmpty((String)number)) {
                editData.setNumber(number);
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        super.actionSave_actionPerformed(e);
        if (!this.getOprtState().equals(OprtState.ADDNEW)) {
            if (this.editData.getState() != null && EstStateEnum.USING.equals((Object)this.editData.getState())) {
                this.setOprtState("VIEW");
            } else {
                this.setOprtState("EDIT");
            }
        }
        this.setDataObject((IObjectValue)this.editData);
        this.loadFields();
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
        this.initActionEnableByState();
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemove_actionPerformed(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        String billId = this.editData.getId().toString();
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(billId);
        if (!this.uiHelper.modifySaveOrExit((ItemAction)this.actionSubmit, this.btnSubmit, (ItemAction)this.actionSave, this.btnSave, this.isModifySave())) {
            return;
        }
        try {
            TDUtils.tryLock(ids);
            ArrayList errors = RentalEstateFactory.getRemoteInstance().cancelCancel(new HashSet(ids));
            if (errors.size() > 0) {
                MsgBox.showWarning((Component)((Object)this), (String)((String)errors.get(0)));
            } else {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Startup_OK"));
                ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)billId));
                this.setDataObject(this.getValue((IObjectPK)pk));
                if (this.editData.getState() != null && EstStateEnum.USING.equals((Object)this.editData.getState())) {
                    this.setOprtState("VIEW");
                } else {
                    this.setOprtState("EDIT");
                }
                this.loadFields();
                this.initOldData((IObjectValue)this.editData);
            }
        }
        finally {
            TDUtils.releaseLock(ids);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        String billId = this.editData.getId().toString();
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(billId);
        try {
            TDUtils.tryLock(ids);
            ArrayList errors = RentalEstateFactory.getRemoteInstance().cancel(new HashSet(ids));
            if (errors.size() > 0) {
                MsgBox.showWarning((Component)((Object)this), (String)((String)errors.get(0)));
            } else {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Forbid _OK"));
                ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)billId));
                this.refresh((IObjectPK)pk);
            }
        }
        finally {
            TDUtils.releaseLock(ids);
        }
    }

    private void refresh(IObjectPK pk) throws Exception {
        this.setDataObject(this.getValue(pk));
        this.loadFields();
        this.initOldData((IObjectValue)this.editData);
    }

    protected IObjectPK getOrgPK(ItemAction action) {
        IObjectPK pk = null;
        try {
            pk = this.uiHelper.getOrgPK();
        }
        catch (Exception e) {
            logger.error((Object)e);
            this.handUIException(e);
        }
        if (pk != null) {
            return pk;
        }
        if (this.getMainOrgContext() != null && this.getMainOrgContext().get((Object)this.getMainBizOrgType()) != null) {
            pk = new ObjectUuidPK(((OrgUnitInfo)this.getMainOrgContext().get((Object)this.getMainBizOrgType())).getId().toString());
            return pk;
        }
        return super.getOrgPK(action);
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Company;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return RentalEstateFactory.getRemoteInstance();
    }

    @Override
    public String getBizOrgProperty(OrgType orgType) throws BOSException, EASBizException {
        return "company";
    }

    @Override
    public ICoreBase getPermInterface() throws Exception {
        return this.getBizInterface();
    }

    @Override
    public String getPermItem(String status) {
        return "ert_rentalEstate_new";
    }

    @Override
    public KDBizPromptBox getPermMainBizOrg() {
        return this.prmtCompany;
    }

    @Override
    public IObjectValue getValueObject() {
        return this.editData;
    }
}

