/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.est.client.util;

import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTColumns;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.CityInfo;
import com.kingdee.eas.basedata.assistant.CountryInfo;
import com.kingdee.eas.basedata.assistant.ProvinceInfo;
import com.kingdee.eas.basedata.assistant.RegionInfo;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.StringUtils;
import com.kingdee.util.enums.EnumUtils;
import java.awt.Color;
import java.awt.Component;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTextField;

public class EstClientUtils {
    public static final Color NECCESSCOLOR = new Color(252, 251, 223);
    public static final Color NULLCOLOR = new Color(255, 255, 255, 0);
    public static final String NUMFORMAT = "###,##0.##########";
    public static final String STRDATEFORMAT = "%{yyyy-MM-dd}t";
    public static final String NUMBERRANDER = "$number$";
    public static final String NAMERANDER = "$name$";

    public static Map<Integer, String> getRequiredColName(KDTable table) {
        KDTColumns columns = table.getColumns();
        KDTRow head = table.getHead().getRow(0);
        HashMap<Integer, String> reqMap = new HashMap<Integer, String>();
        for (int i = 0; i < columns.size(); ++i) {
            if (!columns.getColumn(i).isRequired()) continue;
            reqMap.put(i, (String)head.getCell(i).getValue());
        }
        return reqMap;
    }

    public static void textFieldTrim(Component[] comps) {
        for (int i = 0; i < comps.length; ++i) {
            KDTextField txt;
            JComponent boundEditor;
            if (!(comps[i] instanceof KDLabelContainer) || !((boundEditor = ((KDLabelContainer)comps[i]).getBoundEditor()) instanceof KDTextField) || (txt = (KDTextField)boundEditor).getText() == null) continue;
            txt.setText(txt.getText().trim());
        }
    }

    public static KDBizPromptBox getF7Box(String queryInfoStr) {
        KDBizPromptBox f7Box = new KDBizPromptBox();
        f7Box.setQueryInfo(queryInfoStr);
        f7Box.setEditFormat(NUMBERRANDER);
        f7Box.setDisplayFormat(NAMERANDER);
        f7Box.setCommitFormat(NUMBERRANDER);
        return f7Box;
    }

    public static void setBigDecimalEditor(KDTable table, String column, int precision) {
        KDFormattedTextField formattedField = new KDFormattedTextField();
        formattedField.setDataType(1);
        formattedField.setPrecision(precision);
        formattedField.setNegatived(false);
        formattedField.setSupportedEmpty(true);
        formattedField.setRemoveingZeroInEdit(true);
        formattedField.setRemoveingZeroInDispaly(true);
        formattedField.setHorizontalAlignment(4);
        table.getColumn(column).setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)formattedField));
        table.getColumn(column).getStyleAttributes().setNumberFormat(NUMFORMAT);
        table.getColumn(column).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
    }

    public static void setRateEditor(KDTable table, String column, int precision) {
        KDFormattedTextField formattedField = new KDFormattedTextField();
        formattedField.setDataType(1);
        formattedField.setPrecision(precision);
        formattedField.setNegatived(false);
        formattedField.setRemoveingZeroInEdit(true);
        formattedField.setRemoveingZeroInDispaly(true);
        formattedField.setHorizontalAlignment(4);
        formattedField.setMaximumValue((Comparable)BigDecimal.ONE);
        formattedField.setMinimumValue((Comparable)BigDecimal.ZERO);
        table.getColumn(column).setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)formattedField));
        table.getColumn(column).getStyleAttributes().setNumberFormat(NUMFORMAT);
        table.getColumn(column).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
    }

    public static void setDateEditor(KDTable table, String columeName) {
        KDDatePicker kdDatePicker = new KDDatePicker();
        kdDatePicker.setSupportedEmpty(false);
        KDTDefaultCellEditor dateEditor = new KDTDefaultCellEditor(kdDatePicker);
        table.getColumn(columeName).setEditor((ICellEditor)dateEditor);
        table.getColumn(columeName).getStyleAttributes().setNumberFormat(STRDATEFORMAT);
    }

    public static void setEnumEditor(KDTable table, String columeName, String enumClazz) {
        KDComboBox enumEditor = new KDComboBox();
        enumEditor.addItems(EnumUtils.getEnumList((String)enumClazz).toArray());
        table.getColumn(columeName).setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)enumEditor));
    }

    public static IBasicRender getRander(String bizString) {
        ObjectValueRender avr = new ObjectValueRender();
        avr.setFormat((IDataFormat)new BizDataFormat(bizString));
        return avr;
    }

    public static IBasicRender getNameRander() {
        ObjectValueRender avr = new ObjectValueRender();
        avr.setFormat((IDataFormat)new BizDataFormat(NAMERANDER));
        return avr;
    }

    public static void setCellLocked(IRow row, String columnKey, Boolean locked) {
        if (locked.booleanValue()) {
            row.getCell(columnKey).getStyleAttributes().setLocked(true);
            row.getCell(columnKey).getStyleAttributes().setBackground(NULLCOLOR);
        } else {
            row.getCell(columnKey).getStyleAttributes().setLocked(false);
            row.getCell(columnKey).getStyleAttributes().setBackground(NECCESSCOLOR);
        }
    }

    public static BigDecimal getBigDecimalValue(String valueStr) {
        BigDecimal value = new BigDecimal(0);
        if (valueStr != null && valueStr.length() > 0) {
            value = new BigDecimal(valueStr);
        }
        return value;
    }

    public static void initProvinceFilter(KDBizPromptBox prmtProvince, KDBizPromptBox prmtCountry) {
        if (prmtProvince.getSelectorCollection() == null) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("name"));
            sic.add(new SelectorItemInfo("number"));
            sic.add(new SelectorItemInfo("country.id"));
            sic.add(new SelectorItemInfo("country.name"));
            sic.add(new SelectorItemInfo("country.number"));
            prmtProvince.setSelectorCollection(sic);
        }
        if (prmtCountry.getValue() != null) {
            CountryInfo country = (CountryInfo)prmtCountry.getValue();
            EntityViewInfo entityViewInfo = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("COUNTRY.NUMBER", (Object)country.getNumber(), CompareType.EQUALS));
            entityViewInfo.setFilter(filter);
            prmtProvince.setEntityViewInfo(entityViewInfo);
        }
    }

    public static void initCityFilter(KDBizPromptBox prmtCity, KDBizPromptBox prmtProvince) {
        if (prmtCity.getSelectorCollection() == null) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("name"));
            sic.add(new SelectorItemInfo("number"));
            sic.add(new SelectorItemInfo("province.id"));
            sic.add(new SelectorItemInfo("province.name"));
            sic.add(new SelectorItemInfo("province.number"));
            sic.add(new SelectorItemInfo("province.country.id"));
            sic.add(new SelectorItemInfo("province.country.name"));
            sic.add(new SelectorItemInfo("province.country.number"));
            prmtCity.setSelectorCollection(sic);
        }
        if (prmtProvince.getValue() != null) {
            ProvinceInfo province = (ProvinceInfo)prmtProvince.getValue();
            EntityViewInfo entityViewInfo = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("PROVINCE.NUMBER", (Object)province.getNumber(), CompareType.EQUALS));
            entityViewInfo.setFilter(filter);
            prmtCity.setEntityViewInfo(entityViewInfo);
        }
    }

    public static void initRegionFilter(KDBizPromptBox prmtRegion, KDBizPromptBox prmtCity) {
        if (prmtRegion.getSelectorCollection() == null) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("name"));
            sic.add(new SelectorItemInfo("number"));
            sic.add(new SelectorItemInfo("city.id"));
            sic.add(new SelectorItemInfo("city.name"));
            sic.add(new SelectorItemInfo("city.number"));
            sic.add(new SelectorItemInfo("city.province.id"));
            sic.add(new SelectorItemInfo("city.province.name"));
            sic.add(new SelectorItemInfo("city.province.number"));
            sic.add(new SelectorItemInfo("city.province.country.id"));
            sic.add(new SelectorItemInfo("city.province.country.name"));
            sic.add(new SelectorItemInfo("city.province.country.number"));
            prmtRegion.setSelectorCollection(sic);
        }
        if (prmtCity.getValue() != null) {
            CityInfo city = (CityInfo)prmtCity.getValue();
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("CITY.NUMBER", (Object)city.getNumber(), CompareType.EQUALS));
            view.setFilter(filter);
            prmtRegion.setEntityViewInfo(view);
        }
    }

    public static void initCountryListener(Map<KDBizPromptBox, DataChangeListener> listenerCache, final KDBizPromptBox prmtCountry, final KDBizPromptBox prmtProvince) {
        DataChangeListener prmtCountryListener = new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                if (e.getNewValue() == null) {
                    prmtProvince.setEntityViewInfo(null);
                    prmtProvince.setValue(null);
                } else if (!e.getNewValue().equals(e.getOldValue()) && e.getNewValue() instanceof CountryInfo) {
                    EstClientUtils.initProvinceFilter(prmtProvince, prmtCountry);
                    prmtProvince.setValue(null);
                }
            }
        };
        prmtCountry.addDataChangeListener(prmtCountryListener);
        listenerCache.put(prmtCountry, prmtCountryListener);
    }

    public static void initProvinceListener(final Map<KDBizPromptBox, DataChangeListener> listenerCache, final KDBizPromptBox prmtCountry, final KDBizPromptBox prmtProvince, final KDBizPromptBox prmtCity) {
        DataChangeListener prmtProvinceListener = new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                if (e.getNewValue() == null) {
                    prmtCity.setEntityViewInfo(null);
                    prmtCity.setValue(null);
                } else if (!e.getNewValue().equals(e.getOldValue()) && e.getNewValue() instanceof ProvinceInfo) {
                    ProvinceInfo province = (ProvinceInfo)e.getNewValue();
                    CountryInfo country = province.getCountry();
                    EstClientUtils.removeDataChangeListener(listenerCache);
                    prmtCountry.setValue((Object)country);
                    EstClientUtils.initProvinceFilter(prmtProvince, prmtCountry);
                    EstClientUtils.initCityFilter(prmtCity, prmtProvince);
                    EstClientUtils.addDataChangeListener(listenerCache);
                    prmtCity.setValue(null);
                }
            }
        };
        prmtProvince.addDataChangeListener(prmtProvinceListener);
        listenerCache.put(prmtProvince, prmtProvinceListener);
    }

    public static void initCityListener(final Map<KDBizPromptBox, DataChangeListener> listenerCache, final KDBizPromptBox prmtProvince, final KDBizPromptBox prmtCountry, final KDBizPromptBox prmtCity, final KDBizPromptBox prmtRegion) {
        DataChangeListener prmtCityListener = new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                if (e.getNewValue() == null) {
                    prmtRegion.setEntityViewInfo(null);
                    prmtRegion.setValue(null);
                } else if (!e.getNewValue().equals(e.getOldValue()) && e.getNewValue() instanceof CityInfo) {
                    CityInfo city = (CityInfo)e.getNewValue();
                    ProvinceInfo province = city.getProvince();
                    CountryInfo country = province.getCountry();
                    EstClientUtils.removeDataChangeListener(listenerCache);
                    prmtCountry.setValue((Object)country);
                    EstClientUtils.initProvinceFilter(prmtProvince, prmtCountry);
                    prmtProvince.setValue((Object)province);
                    EstClientUtils.initCityFilter(prmtCity, prmtProvince);
                    EstClientUtils.initRegionFilter(prmtRegion, prmtCity);
                    EstClientUtils.addDataChangeListener(listenerCache);
                    prmtRegion.setValue(null);
                }
            }
        };
        prmtCity.addDataChangeListener(prmtCityListener);
        listenerCache.put(prmtCity, prmtCityListener);
    }

    public static void initRegionListener(final Map<KDBizPromptBox, DataChangeListener> listenerCache, final KDBizPromptBox prmtProvince, final KDBizPromptBox prmtCountry, final KDBizPromptBox prmtCity, final KDBizPromptBox prmtRegion) {
        DataChangeListener prmtRegionListener = new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                if (e.getNewValue() != null && e.getNewValue() instanceof RegionInfo) {
                    RegionInfo region = (RegionInfo)e.getNewValue();
                    CityInfo city = region.getCity();
                    ProvinceInfo province = city.getProvince();
                    CountryInfo country = province.getCountry();
                    EstClientUtils.removeDataChangeListener(listenerCache);
                    prmtCountry.setValue((Object)country);
                    EstClientUtils.initProvinceFilter(prmtProvince, prmtCountry);
                    prmtProvince.setValue((Object)province);
                    EstClientUtils.initCityFilter(prmtCity, prmtProvince);
                    prmtCity.setValue((Object)city);
                    EstClientUtils.initRegionFilter(prmtRegion, prmtCity);
                    EstClientUtils.addDataChangeListener(listenerCache);
                }
            }
        };
        prmtRegion.addDataChangeListener(prmtRegionListener);
        listenerCache.put(prmtRegion, prmtRegionListener);
    }

    public static void removeDataChangeListener(Map<KDBizPromptBox, DataChangeListener> listenerCache) {
        for (KDBizPromptBox f7 : listenerCache.keySet()) {
            f7.removeDataChangeListener(listenerCache.get(f7));
        }
    }

    public static void addDataChangeListener(Map<KDBizPromptBox, DataChangeListener> listenerCache) {
        for (KDBizPromptBox f7 : listenerCache.keySet()) {
            f7.addDataChangeListener(listenerCache.get(f7));
        }
    }

    public static String largerZero(Object[] containers, boolean isAllowZero) {
        KDLabelContainer container = null;
        StringBuffer sb = new StringBuffer();
        String label = null;
        KDFormattedTextField field = null;
        String msg = "";
        int len = containers.length;
        for (int i = 0; i < len; ++i) {
            if (!(containers[i] instanceof KDLabelContainer)) continue;
            container = (KDLabelContainer)containers[i];
            int count = container.getComponentCount();
            for (int j = 0; j < count; ++j) {
                if (!(container.getComponent(j) instanceof KDFormattedTextField)) continue;
                if (isAllowZero) {
                    field = (KDFormattedTextField)container.getComponent(j);
                    if (StringUtils.isEmpty((String)field.getText()) || BigDecimal.ZERO.compareTo(new BigDecimal(EstClientUtils.transmitNumber(field.getText()))) <= 0) continue;
                    label = container.getBoundLabelText();
                    sb.append(label).append(",");
                    continue;
                }
                field = (KDFormattedTextField)container.getComponent(j);
                if (!StringUtils.isEmpty((String)field.getText()) && BigDecimal.ZERO.compareTo(new BigDecimal(EstClientUtils.transmitNumber(field.getText()))) < 0) continue;
                label = container.getBoundLabelText();
                sb.append(label).append(",");
            }
        }
        if (sb.toString().length() > 0) {
            msg = isAllowZero ? sb.substring(0, sb.toString().length() - 1) + EASResource.getString((String)"com.kingdee.eas.tm.td.est.ESTResource", (String)"SmallerZero_NotAllowed") : sb.substring(0, sb.toString().length() - 1) + EASResource.getString((String)"com.kingdee.eas.tm.td.est.ESTResource", (String)"LargerZero");
        }
        return msg;
    }

    public static String transmitNumber(String number) {
        if (number == null || number.length() == 0) {
            return "";
        }
        return number.replace(",", "");
    }
}

