/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.est.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.tm.td.DraftRecordTypeEnum;
import com.kingdee.eas.tm.td.DraftStatusEnum;
import com.kingdee.eas.tm.td.RecordTypeEnum;
import com.kingdee.eas.tm.td.ReportSrcSystem;
import com.kingdee.eas.tm.td.TDUtils;
import com.kingdee.eas.tm.td.TaxDraftRecordCollection;
import com.kingdee.eas.tm.td.TaxDraftRecordFactory;
import com.kingdee.eas.tm.td.TaxDraftRecordInfo;
import com.kingdee.eas.tm.td.basedata.TaxItemTypeInfo;
import com.kingdee.eas.tm.td.est.EstCalculateRecordCollection;
import com.kingdee.eas.tm.td.est.EstCalculateRecordFactory;
import com.kingdee.eas.tm.td.est.EstCalculateRecordInfo;
import com.kingdee.eas.tm.td.est.RealEstateGroupEntryCollection;
import com.kingdee.eas.tm.td.est.RealEstateGroupEntryFactory;
import com.kingdee.eas.tm.td.est.RealEstateGroupEntryInfo;
import com.kingdee.eas.tm.td.est.TaxMethodEnum;
import com.kingdee.eas.tm.td.est.util.EstTaxDeclareParam;
import com.kingdee.eas.tm.td.structure.TaxReportTemplateFactory;
import com.kingdee.eas.tm.td.structure.TaxReportTemplateInfo;
import com.kingdee.eas.tm.td.utils.AccountTakeDataUtil;
import com.kingdee.eas.tm.td.utils.CollectionUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class EstReportHelper {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.td.est.util.EstReportHelper");
    public static final String SPLIT = "_";

    public static List<String> getCreateReportRange(Context ctx, Set companyIds, int periodFrom, int periodTo) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" Select period.FID as FPeriodID,company.FID as FCompanyID from T_BD_PERIOD period ");
        sql.append(" left join T_ORG_COMPANY company on period.FTypeID = company.FAccountPeriodID ");
        sql.append(" where period.FIsAdjustPeriod = 0  ");
        sql.append(" and period.FNumber Between " + periodFrom + " and " + periodTo);
        sql.append(" and company.FID in (").append(CollectionUtil.convertSet2String(companyIds, ",", true)).append(") ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        ArrayList<String> ids = new ArrayList<String>();
        String companyID = null;
        String periodID = null;
        try {
            while (rs.next()) {
                companyID = rs.getString("FCompanyID");
                periodID = rs.getString("FPeriodID");
                ids.add(companyID + SPLIT + periodID);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        return ids;
    }

    public static void removeOldReport(Context ctx, String companyID, String taxPeriodID, Set groupIds) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("companyOrgUnit.id", (Object)companyID, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("rptPeriod.id", (Object)taxPeriodID, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("srcSystem", (Object)2, CompareType.EQUALS));
        if (groupIds.size() > 0) {
            filter.getFilterItems().add(new FilterItemInfo("buildingTaxesGroup.id", (Object)groupIds, CompareType.INCLUDE));
        }
        view.setFilter(filter);
        TaxDraftRecordCollection coll = TaxDraftRecordFactory.getLocalInstance(ctx).getTaxDraftRecordCollection(view);
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            ObjectUuidPK pk = new ObjectUuidPK(coll.get(i).getId().toString());
            TaxDraftRecordFactory.getLocalInstance(ctx).delete((IObjectPK)pk);
        }
    }

    public static Map<String, RealEstateGroupEntryInfo> initRealEstateGroupEntryMap(Context ctx, EstCalculateRecordCollection recordColl) throws EASBizException, BOSException {
        HashSet<String> groupIds = new HashSet<String>();
        EstCalculateRecordInfo recordInfo = null;
        int size = recordColl.size();
        for (int i = 0; i < size; ++i) {
            recordInfo = recordColl.get(i);
            groupIds.add(recordInfo.getRealEstateGroup().getId().toString());
        }
        HashMap<String, RealEstateGroupEntryInfo> groupEntryMap = new HashMap<String, RealEstateGroupEntryInfo>();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("realEstateGroup.id", groupIds, CompareType.INCLUDE));
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        RealEstateGroupEntryCollection groupEntryColl = RealEstateGroupEntryFactory.getLocalInstance(ctx).getRealEstateGroupEntryCollection(view);
        RealEstateGroupEntryInfo groupEntryInfo = null;
        String groupEntryKey = null;
        int size2 = groupEntryColl.size();
        for (int i = 0; i < size2; ++i) {
            groupEntryInfo = groupEntryColl.get(i);
            groupEntryKey = EstReportHelper.getGroupEntryKey(groupEntryInfo);
            groupEntryMap.put(groupEntryKey, groupEntryInfo);
        }
        return groupEntryMap;
    }

    public static EstCalculateRecordCollection getEstCalculateRecordColl(Context ctx, String companyID, String taxPeriodID, Set groupIds) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyID, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("taxPeriod.id", (Object)taxPeriodID, CompareType.EQUALS));
        if (groupIds.size() > 0) {
            filter.getFilterItems().add(new FilterItemInfo("realEstateGroup.id", (Object)groupIds, CompareType.INCLUDE));
        }
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("realEstateGroup.id"));
        sic.add(new SelectorItemInfo("realEstateGroup.name"));
        sic.add(new SelectorItemInfo("realEstateGroup.number"));
        sic.add(new SelectorItemInfo("realEstate.id"));
        sic.add(new SelectorItemInfo("realEstate.name"));
        sic.add(new SelectorItemInfo("realEstate.number"));
        sic.add(new SelectorItemInfo("landData.id"));
        sic.add(new SelectorItemInfo("landData.name"));
        sic.add(new SelectorItemInfo("landData.number"));
        sic.add(new SelectorItemInfo("rentalEstate.id"));
        sic.add(new SelectorItemInfo("rentalEstate.name"));
        sic.add(new SelectorItemInfo("rentalEstate.number"));
        sic.add(new SelectorItemInfo("taxPeriod.id"));
        sic.add(new SelectorItemInfo("taxPeriod.number"));
        sic.add(new SelectorItemInfo("taxPeriod.beginDate"));
        sic.add(new SelectorItemInfo("taxPeriod.endDate"));
        sic.add(new SelectorItemInfo("taxPeriod.periodYear"));
        sic.add(new SelectorItemInfo("taxPeriod.periodNumber"));
        sic.add(new SelectorItemInfo("firstPeriod.id"));
        sic.add(new SelectorItemInfo("firstPeriod.number"));
        sic.add(new SelectorItemInfo("firstPeriod.beginDate"));
        sic.add(new SelectorItemInfo("firstPeriod.endDate"));
        sic.add(new SelectorItemInfo("firstPeriod.periodYear"));
        sic.add(new SelectorItemInfo("firstPeriod.periodNumber"));
        view.setSelector(sic);
        SorterItemCollection sorter = new SorterItemCollection();
        SorterItemInfo tpSorterItemInfo = new SorterItemInfo("taxPeriod.number");
        tpSorterItemInfo.setSortType(SortType.ASCEND);
        sorter.add(tpSorterItemInfo);
        SorterItemInfo fpSorterItemInfo = new SorterItemInfo("firstPeriod.number");
        fpSorterItemInfo.setSortType(SortType.ASCEND);
        sorter.add(fpSorterItemInfo);
        view.setSorter(sorter);
        EstCalculateRecordCollection recordColl = EstCalculateRecordFactory.getLocalInstance(ctx).getEstCalculateRecordCollection(view);
        return recordColl;
    }

    public static void createAccountReport(Context ctx, EstCalculateRecordInfo recordInfo, TaxDraftRecordCollection accountColl, Map<String, RealEstateGroupEntryInfo> groupEntryMap, Map accountMap) throws EASBizException, BOSException {
        TaxReportTemplateInfo template;
        String groupEntryKey;
        RealEstateGroupEntryInfo groupEntryInfo;
        String accountKey = EstReportHelper.getAccountKey(recordInfo);
        if (!accountMap.containsKey(accountKey) && (groupEntryInfo = groupEntryMap.get(groupEntryKey = EstReportHelper.getGroupEntryKey(recordInfo, false))) != null && (template = groupEntryInfo.getAccountTemplate()) != null) {
            TaxDraftRecordInfo accountInfo = EstReportHelper.getNewRecordInfo(ctx, recordInfo, template);
            accountColl.add(accountInfo);
            accountMap.put(accountKey, accountInfo);
        }
    }

    public static void createTaxDeclareReport(Context ctx, EstCalculateRecordInfo recordInfo, TaxDraftRecordCollection taxDeclareColl, Map<String, RealEstateGroupEntryInfo> groupEntryMap, Map taxDeclareMap) throws EASBizException, BOSException {
        TaxReportTemplateInfo template;
        String groupEntryKey;
        RealEstateGroupEntryInfo groupEntryInfo;
        String taxDeclareKey = EstReportHelper.getTaxDeclareKey(recordInfo);
        if (!taxDeclareMap.containsKey(taxDeclareKey) && (groupEntryInfo = groupEntryMap.get(groupEntryKey = EstReportHelper.getGroupEntryKey(recordInfo, true))) != null && (template = groupEntryInfo.getTaxDeclareTemplate()) != null) {
            TaxDraftRecordInfo taxDeclareInfo = EstReportHelper.getNewRecordInfo(ctx, recordInfo, template);
            taxDeclareColl.add(taxDeclareInfo);
            taxDeclareMap.put(taxDeclareKey, taxDeclareInfo);
        }
    }

    public static void taxDeclarePriceHandle(Context ctx, EstCalculateRecordInfo recordInfo, Map taxDeclareMap, Map taxDeclarePriceMap) throws BOSException {
        String taxDeclarePriceKey = EstReportHelper.getTaxDeclarePriceKey(recordInfo);
        if (!StringUtils.isEmpty((String)taxDeclarePriceKey) && !taxDeclarePriceMap.containsKey(taxDeclarePriceKey)) {
            String taxDeclareKey = EstReportHelper.getTaxDeclareKey(recordInfo);
            TaxDraftRecordInfo taxDeclareInfo = (TaxDraftRecordInfo)taxDeclareMap.get(taxDeclareKey);
            try {
                String priceSheetName = TDUtils.getString("com.kingdee.eas.tm.td.est.ESTResource", "priceSheetName", ctx.getLocale());
                Book templateBook = TDUtils.getReportBook(ctx, (IObjectValue)taxDeclareInfo.getTempletReport());
                Sheet templateSheet = templateBook.getSheet(priceSheetName);
                Book book = TDUtils.getReportBook(ctx, (IObjectValue)taxDeclareInfo);
                String preSheetName = priceSheetName + (taxDeclarePriceMap.size() > 0 ? Integer.valueOf(taxDeclarePriceMap.size()) : "");
                int preIndex = book.getSheetIndexByName(preSheetName);
                Sheet sheet = new Sheet(book, priceSheetName + (taxDeclarePriceMap.size() + 1));
                sheet.copySheetFrom(templateSheet);
                TDUtils.fillFormula(ctx, sheet, recordInfo);
                book.insertSheet(preIndex + 1, sheet);
                book.removeSheet(priceSheetName);
                taxDeclareInfo.setBook(book);
                taxDeclarePriceMap.put(taxDeclarePriceKey, taxDeclareInfo);
            }
            catch (Exception e) {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
        }
    }

    public static void taxDeclareRentHandle(Context ctx, EstCalculateRecordInfo recordInfo, Map taxDeclareMap, Map taxDeclareRentMap) throws BOSException {
        String taxDeclareRentKey = EstReportHelper.getTaxDeclareRentKey(recordInfo);
        if (!StringUtils.isEmpty((String)taxDeclareRentKey) && !taxDeclareRentMap.containsKey(taxDeclareRentKey)) {
            String taxDeclareKey = EstReportHelper.getTaxDeclareKey(recordInfo);
            TaxDraftRecordInfo taxDeclareInfo = (TaxDraftRecordInfo)taxDeclareMap.get(taxDeclareKey);
            try {
                String rentSheetName = TDUtils.getString("com.kingdee.eas.tm.td.est.ESTResource", "rentSheetName", ctx.getLocale());
                Book templateBook = TDUtils.getReportBook(ctx, (IObjectValue)taxDeclareInfo.getTempletReport());
                Sheet templateSheet = templateBook.getSheet(rentSheetName);
                Book book = TDUtils.getReportBook(ctx, (IObjectValue)taxDeclareInfo);
                String preSheetName = rentSheetName + (taxDeclareRentMap.size() > 0 ? Integer.valueOf(taxDeclareRentMap.size()) : "");
                int preIndex = book.getSheetIndexByName(preSheetName);
                Sheet sheet = new Sheet(book, rentSheetName + (taxDeclareRentMap.size() + 1));
                sheet.copySheetFrom(templateSheet);
                TDUtils.fillFormula(ctx, sheet, recordInfo);
                book.insertSheet(preIndex + 1, sheet);
                book.removeSheet(rentSheetName);
                taxDeclareInfo.setBook(book);
                taxDeclareRentMap.put(taxDeclareRentKey, taxDeclareInfo);
            }
            catch (Exception e) {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
        }
    }

    private static TaxDraftRecordInfo getNewRecordInfo(Context ctx, EstCalculateRecordInfo recordInfo, TaxReportTemplateInfo template) throws EASBizException, BOSException {
        TaxReportTemplateInfo templateInfo = TaxReportTemplateFactory.getLocalInstance(ctx).getTaxReportTemplateInfo((IObjectPK)new ObjectUuidPK(template.getId().toString()), TaxReportTemplateInfo.getSelectors());
        TaxDraftRecordInfo newInfo = new TaxDraftRecordInfo();
        newInfo.setId(BOSUuid.create((String)"2A607F02"));
        RecordTypeEnum recordType = templateInfo.getRecordType();
        newInfo.setOwnerMenu(TDUtils.getOwnMenu(recordInfo.getTaxItemType(), recordType));
        newInfo.setCompanyOrgUnit(recordInfo.getCompany());
        TaxItemTypeInfo taxItemType = recordInfo.getTaxItemType();
        if (RecordTypeEnum.TaxDeclare.equals((Object)recordType) && "d8umkg7qNn3gU0ETqMCsX9uK96Y=".equals(taxItemType.getId().toString())) {
            taxItemType = new TaxItemTypeInfo();
            taxItemType.setId(BOSUuid.read((String)"ZCyrvv6oAnPgU0ETqMCc49uK96Y="));
        }
        newInfo.setTaxType(taxItemType);
        newInfo.setRecordType(templateInfo.getRecordType());
        newInfo.setName(templateInfo.getName());
        newInfo.setRptPeriod(recordInfo.getTaxPeriod());
        newInfo.setRelateAccount(templateInfo.getAccountConfig());
        Date startDate = recordInfo.getTaxPeriod().getBeginDate();
        Timestamp endDate = recordInfo.getTaxPeriod().getEndDate();
        newInfo.setStartDate(startDate);
        newInfo.setEndDate(endDate);
        newInfo.setYear(recordInfo.getTaxPeriod().getPeriodYear());
        newInfo.setPeriod((short)recordInfo.getTaxPeriod().getPeriodNumber());
        newInfo.setDraftStatus(DraftStatusEnum.SAVE);
        newInfo.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
        newInfo.setCreateTime(new Timestamp(new Date().getTime()));
        newInfo.setDraftRecordType(DraftRecordTypeEnum.normalRecord);
        newInfo.setData(templateInfo.getData());
        newInfo.setTempletReport(templateInfo);
        newInfo.setBillRange(templateInfo.getBillRange());
        newInfo.setSubPeriodType(recordInfo.getPeriodType());
        newInfo.setBuildingTaxesGroup(recordInfo.getRealEstateGroup());
        newInfo.setSrcSystem(ReportSrcSystem.SYSTEM);
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        String number = iCodingRuleManager.getNumber((IObjectValue)newInfo, newInfo.getCompanyOrgUnit().getId().toString(), "ownerMenu", "ownerMenu");
        newInfo.setNumber(number);
        return newInfo;
    }

    public static String getGroupEntryKey(RealEstateGroupEntryInfo groupEntryInfo) {
        StringBuffer key = new StringBuffer();
        key.append(groupEntryInfo.getRealEstateGroup().getId().toString()).append(SPLIT).append(groupEntryInfo.getTaxItemType().getId().toString());
        if (groupEntryInfo.getTaxMethod() != null) {
            key.append(SPLIT).append(groupEntryInfo.getTaxMethod().getValue());
        }
        return key.toString();
    }

    public static String getGroupEntryKey(EstCalculateRecordInfo recordInfo, boolean taxDeclare) {
        StringBuffer key = new StringBuffer();
        String taxItemTypeID = recordInfo.getTaxItemType().getId().toString();
        TaxMethodEnum taxMethod = recordInfo.getTaxMethod();
        if (taxDeclare && "d8umkg7qNn3gU0ETqMCsX9uK96Y=".equals(taxItemTypeID)) {
            taxItemTypeID = "ZCyrvv6oAnPgU0ETqMCc49uK96Y=";
            taxMethod = TaxMethodEnum.PRICE;
        }
        key.append(recordInfo.getRealEstateGroup().getId().toString()).append(SPLIT).append(taxItemTypeID);
        if (taxMethod != null) {
            key.append(SPLIT).append(taxMethod.getValue());
        }
        return key.toString();
    }

    public static String getAccountKey(EstCalculateRecordInfo recordInfo) {
        StringBuffer key = new StringBuffer();
        key.append(recordInfo.getCompany().getId().toString()).append(SPLIT).append(recordInfo.getTaxItemType().getId().toString()).append(SPLIT).append(recordInfo.getTaxPeriod().getId().toString()).append(SPLIT).append(recordInfo.getRealEstateGroup().getId().toString());
        if (recordInfo.getTaxMethod() != null) {
            key.append(SPLIT).append(recordInfo.getTaxMethod().getValue());
        }
        return key.toString();
    }

    public static String getTaxDeclareKey(EstCalculateRecordInfo recordInfo) {
        StringBuffer key = new StringBuffer();
        String taxItemTypeID = recordInfo.getTaxItemType().getId().toString();
        if ("d8umkg7qNn3gU0ETqMCsX9uK96Y=".equals(taxItemTypeID)) {
            taxItemTypeID = "ZCyrvv6oAnPgU0ETqMCc49uK96Y=";
        }
        key.append(recordInfo.getCompany().getId().toString()).append(SPLIT).append(taxItemTypeID).append(SPLIT).append(recordInfo.getTaxPeriod().getId().toString()).append(SPLIT).append(recordInfo.getRealEstateGroup().getId().toString());
        return key.toString();
    }

    public static String getTaxDeclarePriceKey(EstCalculateRecordInfo recordInfo) {
        if (recordInfo.getRealEstate() == null) {
            return null;
        }
        String key = EstReportHelper.getTaxDeclareKey(recordInfo) + SPLIT + recordInfo.getRealEstate().getId().toString();
        return key;
    }

    public static String getTaxDeclareRentKey(EstCalculateRecordInfo recordInfo) {
        if (recordInfo.getRentalEstate() == null) {
            return null;
        }
        String key = EstReportHelper.getTaxDeclarePriceKey(recordInfo) + SPLIT + recordInfo.getRentalEstate().getId().toString() + SPLIT + recordInfo.getContractNumber();
        return key;
    }

    public static String getTaxDeclareVatKey(EstCalculateRecordInfo recordInfo) {
        if (recordInfo.getRentalEstate() == null) {
            return null;
        }
        String key = EstReportHelper.getTaxDeclarePriceKey(recordInfo) + SPLIT + recordInfo.getRentalEstate().getId().toString();
        return key;
    }

    public static String getTaxDeclareLandKey(EstCalculateRecordInfo recordInfo) {
        if (recordInfo.getLandData() == null) {
            return null;
        }
        String key = EstReportHelper.getTaxDeclareKey(recordInfo) + SPLIT + recordInfo.getLandData().getId().toString();
        return key;
    }

    public static Map getExceptionNumber(Context ctx, List ids) throws BOSException {
        Iterator lter = ids.iterator();
        HashSet<String> companyIds = new HashSet<String>();
        HashSet<String> periodIds = new HashSet<String>();
        while (lter.hasNext()) {
            String id = (String)lter.next();
            String[] arr = id.split(SPLIT);
            String companyID = arr[0];
            String taxPeriodID = arr[1];
            companyIds.add(companyID);
            periodIds.add(taxPeriodID);
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", companyIds, CompareType.INCLUDE));
        view.setFilter(filter);
        CompanyOrgUnitCollection companyColl = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitCollection(view);
        CompanyOrgUnitInfo company = null;
        HashMap<String, CompanyOrgUnitInfo> companyMap = new HashMap<String, CompanyOrgUnitInfo>();
        int size = companyColl.size();
        for (int i = 0; i < size; ++i) {
            company = companyColl.get(i);
            companyMap.put(company.getId().toString(), company);
        }
        view = new EntityViewInfo();
        filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", periodIds, CompareType.INCLUDE));
        view.setFilter(filter);
        PeriodCollection periodColl = PeriodFactory.getLocalInstance((Context)ctx).getPeriodCollection(view);
        PeriodInfo period = null;
        HashMap<String, PeriodInfo> periodMap = new HashMap<String, PeriodInfo>();
        int size2 = periodColl.size();
        for (int i = 0; i < size2; ++i) {
            period = periodColl.get(i);
            periodMap.put(period.getId().toString(), period);
        }
        HashMap<String, String> exceptionNumber = new HashMap<String, String>();
        String id2 = null;
        StringBuffer number = null;
        for (String id2 : ids) {
            String[] arr = id2.split(SPLIT);
            String companyID = arr[0];
            String taxPeriodID = arr[1];
            company = (CompanyOrgUnitInfo)companyMap.get(companyID);
            period = (PeriodInfo)periodMap.get(taxPeriodID);
            number = new StringBuffer();
            number.append("\u3010");
            number.append(company.getName()).append(",");
            number.append(period.toString());
            number.append("\u3011");
            exceptionNumber.put(id2, number.toString());
        }
        return exceptionNumber;
    }

    public static void saveAndCalcReport(Context ctx, TaxDraftRecordCollection accountColl, TaxDraftRecordCollection taxDeclareColl) throws Exception {
        Book book;
        int i;
        TaxDraftRecordInfo reportInfo = null;
        int size = accountColl.size();
        for (i = 0; i < size; ++i) {
            reportInfo = accountColl.get(i);
            TaxDraftRecordFactory.getLocalInstance(ctx).save((CoreBaseInfo)reportInfo);
            book = TDUtils.getReportBook(ctx, (IObjectValue)reportInfo);
            AccountTakeDataUtil.accountTakeData(ctx, reportInfo, book);
            TDUtils.calculateBook(ctx, reportInfo, book);
            reportInfo.setBook(book);
            TaxDraftRecordFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(reportInfo.getId().toString()), reportInfo);
        }
        size = taxDeclareColl.size();
        for (i = 0; i < size; ++i) {
            reportInfo = taxDeclareColl.get(i);
            TaxDraftRecordFactory.getLocalInstance(ctx).save((CoreBaseInfo)reportInfo);
            book = TDUtils.getReportBook(ctx, (IObjectValue)reportInfo);
            TDUtils.calculateBook(ctx, reportInfo, book);
            reportInfo.setBook(book);
            TaxDraftRecordFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(reportInfo.getId().toString()), reportInfo);
        }
    }

    public static void taxDeclareEstHandle(Context ctx, EstTaxDeclareParam param, Map taxDeclareMap, String estSheetName) throws BOSException {
        TaxDraftRecordInfo taxDeclareInfo = (TaxDraftRecordInfo)taxDeclareMap.get(param.getTaxDeclareKey());
        if (taxDeclareInfo == null) {
            return;
        }
        try {
            Book templateBook = TDUtils.getReportBook(ctx, (IObjectValue)taxDeclareInfo.getTempletReport());
            Sheet templateSheet = templateBook.getSheet(estSheetName);
            Book book = TDUtils.getReportBook(ctx, (IObjectValue)taxDeclareInfo);
            Map<String, EstCalculateRecordInfo> taxDeclareLandMap = param.getTaxDeclareLandMap();
            Map<String, List<EstCalculateRecordInfo>> taxDeclarePriceMap = param.getTaxDeclarePriceMap();
            Map<String, EstCalculateRecordInfo> taxDeclareRentMap = param.getTaxDeclareRentMap();
            ArrayList<String> landKey = new ArrayList<String>();
            ArrayList<String> priceKey = new ArrayList<String>();
            int seq = 0;
            for (EstCalculateRecordInfo recordInfo : taxDeclareRentMap.values()) {
                seq = EstReportHelper.copySheet(ctx, estSheetName, templateSheet, book, seq, recordInfo);
                landKey.add(EstReportHelper.getTaxDeclareLandKey(recordInfo));
                priceKey.add(EstReportHelper.getTaxDeclarePriceKey(recordInfo));
            }
            for (String key : taxDeclarePriceMap.keySet()) {
                List<EstCalculateRecordInfo> recordList = taxDeclarePriceMap.get(key);
                for (int i = 0; i < recordList.size(); ++i) {
                    EstCalculateRecordInfo recordInfo = recordList.get(i);
                    if (BigDecimal.ZERO.compareTo(recordInfo.getRentArea()) != 0 && priceKey.contains(key)) continue;
                    seq = EstReportHelper.copySheet(ctx, estSheetName, templateSheet, book, seq, recordInfo);
                    landKey.add(EstReportHelper.getTaxDeclareLandKey(recordInfo));
                }
            }
            for (String key : taxDeclareLandMap.keySet()) {
                EstCalculateRecordInfo recordInfo = taxDeclareLandMap.get(key);
                if (landKey.contains(key)) continue;
                seq = EstReportHelper.copySheet(ctx, estSheetName, templateSheet, book, seq, recordInfo);
                landKey.add(EstReportHelper.getTaxDeclareLandKey(recordInfo));
            }
            book.removeSheet(estSheetName);
            taxDeclareInfo.setBook(book);
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
    }

    public static void taxDeclareVatHandle(Context ctx, EstTaxDeclareParam param, Map taxDeclareMap, String[] vatSheetNames) throws BOSException {
        TaxDraftRecordInfo taxDeclareInfo = (TaxDraftRecordInfo)taxDeclareMap.get(param.getTaxDeclareKey());
        if (taxDeclareInfo == null) {
            return;
        }
        try {
            Book templateBook = TDUtils.getReportBook(ctx, (IObjectValue)taxDeclareInfo.getTempletReport());
            Book book = TDUtils.getReportBook(ctx, (IObjectValue)taxDeclareInfo);
            for (int i = 0; i < vatSheetNames.length; ++i) {
                Sheet templateSheet = templateBook.getSheet(vatSheetNames[i]);
                Map<String, EstCalculateRecordInfo> taxDeclareVatMap = param.getTaxDeclareVatMap();
                int seq = 0;
                for (EstCalculateRecordInfo recordInfo : taxDeclareVatMap.values()) {
                    seq = EstReportHelper.copySheet(ctx, vatSheetNames[i], templateSheet, book, seq, recordInfo);
                }
                book.removeSheet(vatSheetNames[i]);
            }
            taxDeclareInfo.setBook(book);
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
    }

    private static int copySheet(Context ctx, String sheetName, Sheet templateSheet, Book book, int seq, EstCalculateRecordInfo recordInfo) {
        if (templateSheet == null) {
            return seq;
        }
        Sheet sheet = new Sheet(book, sheetName + seq);
        sheet.copySheetFrom(templateSheet);
        TDUtils.fillFormula(ctx, sheet, recordInfo);
        book.addSheet(sheet);
        return ++seq;
    }
}

