/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.formula;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.excel.model.struct.Parameter;
import com.kingdee.bos.ctrl.excel.model.util.SortedParameterArray;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.util.DBUtil;
import com.kingdee.eas.fi.newrpt.formula.ICalculateContextProvider;
import com.kingdee.eas.fi.newrpt.formula.IReportPropertyAdapter;
import com.kingdee.eas.fi.rpt.ReportBaseInfo;
import com.kingdee.eas.tm.td.TDUtils;
import com.kingdee.eas.tm.td.basedata.DataFilterTypeEnum;
import com.kingdee.eas.tm.td.basedata.DataSourceCollection;
import com.kingdee.eas.tm.td.basedata.DataSourceFactory;
import com.kingdee.eas.tm.td.basedata.DataSourceInfo;
import com.kingdee.eas.tm.td.basedata.DraftItemToDataSourceFactory;
import com.kingdee.eas.tm.td.basedata.TakeDataContditionCollection;
import com.kingdee.eas.tm.td.basedata.TakeDataContditionFactory;
import com.kingdee.eas.tm.td.basedata.TakeDataContditionInfo;
import com.kingdee.eas.tm.td.formula.AbstractBatchCalculater;
import com.kingdee.eas.tm.td.formula.ParamsInfo;
import com.kingdee.eas.tm.td.utils.CollectionUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class DraftItemBatchCalculater
extends AbstractBatchCalculater {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.td.formula.DraftItemBatchCalculater");

    public DraftItemBatchCalculater(ICalculateContextProvider contextProvider) {
        this.contextProvider = contextProvider;
    }

    @Override
    public void execute(SortedParameterArray paramArray) {
        super.execute(paramArray);
        this.ctx = this.contextProvider.getServerContext();
        IReportPropertyAdapter reportAdapter = this.contextProvider.getReportAdapter();
        String rptID = reportAdapter.getReportProperty("Report.ID").toString();
        ReportBaseInfo info = (ReportBaseInfo)reportAdapter.getReportProperty("editData");
        int querySize = paramArray.size();
        for (int i = 0; i < querySize; ++i) {
            int queryIndex = 0;
            Parameter params = paramArray.getParameter(i);
            ParamsInfo formulaParam = new ParamsInfo();
            formulaParam.buildTaxDraftItemParam(params);
            formulaParam.setInfo(info);
            this.innerExecute(formulaParam);
            ++queryIndex;
        }
    }

    protected void innerExecute(ParamsInfo param) {
        try {
            ReportBaseInfo info = param.getInfo();
            Date startDate = info.getStartDate();
            Date endDate = info.getEndDate();
            PeriodInfo periodinfo = (PeriodInfo)info.get("rptPeriod");
            Set orgID = this.getCompanyOrgIds(info, param);
            if (orgID.isEmpty()) {
                orgID.add(((CompanyOrgUnitInfo)info.get("companyOrgUnit")).getId().toString());
            }
            String itemNum = param.getDraftItem();
            String calType = param.getCalType();
            Map retValue = DraftItemToDataSourceFactory.getLocalInstance(this.ctx).getDataSourceRelationByParam(itemNum, orgID);
            Set dsRs = (Set)retValue.get("dsSet");
            Map dsOrgRelationMap = (Map)retValue.get("dsOrgRelationMap");
            EntityViewInfo ev = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)dsRs, CompareType.INCLUDE));
            ev.setFilter(filter);
            DataSourceCollection ds = DataSourceFactory.getLocalInstance(this.ctx).getDataSourceCollection(ev);
            BigDecimal totalValue = BigDecimal.ZERO;
            SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd");
            int dsSize = ds.size();
            if (dsSize == 0) {
                param.getBackFiller().setValue((Object)BigDecimal.ZERO);
                return;
            }
            String periodIdstr = null;
            for (int i = 0; i < dsSize; ++i) {
                BigDecimal value;
                Object rs;
                String filterSql;
                DataSourceInfo dsInfo = ds.get(i);
                String direction = dsInfo.getDataDirection().getValue();
                String dsID = dsInfo.getId().toString();
                Set orgSet = (Set)dsOrgRelationMap.get(dsID);
                String orgids = TDUtils.getInStringFromSet(orgSet);
                filter.getFilterItems().clear();
                filter.getFilterItems().add(new FilterItemInfo("dataSource.id", (Object)dsID, CompareType.EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("status", (Object)"1", CompareType.EQUALS));
                ev.setFilter(filter);
                TakeDataContditionCollection takeDataColl = TakeDataContditionFactory.getLocalInstance(this.ctx).getTakeDataContditionCollection(ev);
                TakeDataContditionInfo takeDataInfo = takeDataColl.get(0);
                if (takeDataInfo == null) continue;
                FilterInfo takeFilterInfo = takeDataInfo.getQueryFilterInfo();
                FilterInfo filterInfo = dsInfo.getFilterInfo();
                takeFilterInfo.mergeFilter(filterInfo, "and");
                String where = filterSql = takeFilterInfo.toSql();
                if (where == null || "".equals(where)) {
                    where = " 1=1 ";
                }
                String sql = dsInfo.getFromSQL();
                DataFilterTypeEnum filterType = takeDataInfo.getDateFilterType();
                String orgFiled = takeDataInfo.getOrgField();
                String dateFiled = takeDataInfo.getBizDateField();
                String periodField = takeDataInfo.getPeriodIdField();
                String fieldName = takeDataInfo.getGetDataForm();
                String yearField = takeDataInfo.getPeriodYear();
                String monthField = takeDataInfo.getPeriodMonth();
                String opType = "sum";
                StringBuffer sb = new StringBuffer();
                if ("1".equals(calType)) {
                    opType = "count";
                    sb.append(" SELECT count(*)  as sumValue FROM  ( ");
                    sb.append(" select ").append(fieldName).append(" ");
                } else {
                    sb.append(" select " + opType + "(").append(fieldName).append(") as sumValue ");
                }
                sb.append(sql);
                sb.append(" where ").append(where);
                if (filterType.getValue() == "0") {
                    sb.append(" and ").append(dateFiled).append(" >= to_date('").append(sf.format(startDate)).append(" 00:00:00')");
                    sb.append(" and ").append(dateFiled).append(" <= to_date('").append(sf.format(endDate)).append(" 23:59:59')");
                } else if (filterType.getValue() == "2") {
                    if (info.get("rptPeriodFrom") != null && info.get("rptPeriodTo") != null) {
                        if (periodIdstr == null) {
                            periodIdstr = this.getPeriodBetween(info);
                        }
                        sb.append(" and ").append(periodField).append(" in (").append(periodIdstr).append(")");
                    } else if (periodinfo != null) {
                        sb.append(" and ").append(periodField).append(" = '").append(periodinfo.getId().toString()).append("'");
                    }
                } else if (filterType.getValue() == "1") {
                    sb.append(" and ").append(yearField).append(" = ").append(info.getYear()).append(" ");
                    sb.append(" and ").append(monthField).append(" = ").append(info.getPeriod()).append(" ");
                }
                sb.append(" and ").append(orgFiled).append(" in ").append(orgids);
                if ("1".equals(calType)) {
                    sb.append(" group by ").append(fieldName).append(" ) as T");
                }
                if (this.isDebug()) {
                    rs = "" + param.getBackFiller().getValue() + " ; " + sb.toString();
                    param.getBackFiller().setValue(rs);
                    continue;
                }
                rs = DBUtil.executeQuery((Context)this.ctx, (String)sb.toString(), null);
                if (!rs.next() || (value = rs.getBigDecimal("sumValue")) == null) continue;
                totalValue = "0".equals(direction) ? totalValue.add(value) : totalValue.subtract(value);
            }
            if (!this.isDebug()) {
                param.getBackFiller().setValue((Object)totalValue);
            }
        }
        catch (Exception e) {
            param.getBackFiller().setValue((Object)e);
        }
    }

    private String getPeriodBetween(ReportBaseInfo info) throws BOSException, EASBizException, SQLException {
        PeriodInfo periodFrom = PeriodFactory.getLocalInstance((Context)this.ctx).getPeriodInfo((IObjectPK)new ObjectUuidPK(((PeriodInfo)info.get("rptPeriodFrom")).getId().toString()));
        PeriodInfo periodTo = PeriodFactory.getLocalInstance((Context)this.ctx).getPeriodInfo((IObjectPK)new ObjectUuidPK(((PeriodInfo)info.get("rptPeriodTo")).getId().toString()));
        StringBuffer periodSql = new StringBuffer();
        periodSql.append(" select fid  FROM T_BD_Period WHERE fnumber>=").append(periodFrom.getNumber()).append(" and fnumber<=").append(periodTo.getNumber());
        IRowSet rs = DBUtil.executeQuery((Context)this.ctx, (String)periodSql.toString(), null);
        HashSet<String> periodIds = new HashSet<String>();
        while (rs.next()) {
            periodIds.add(rs.getString("fid"));
        }
        String periodIdstr = CollectionUtil.convertSet2String(periodIds, ",", true);
        return periodIdstr;
    }

    private Set getCompanyOrgIds(ReportBaseInfo info, ParamsInfo param) throws BOSException, SQLException {
        Set ids = new HashSet();
        String numbers = null;
        String[] strArr = null;
        boolean byOrg = false;
        String orgManage = param.getOrgManager();
        if (!StringUtils.isEmpty((String)orgManage)) {
            strArr = param.getOrgManager().replace(" ", "").split(";");
        } else if (!StringUtils.isEmpty((String)param.getCompany())) {
            strArr = param.getCompany().replace(" ", "").split(";");
            byOrg = true;
        } else if (info.getOrgTree() != null) {
            strArr = new String[]{info.getOrgTree().getNumber()};
        }
        if (strArr == null) {
            return ids;
        }
        numbers = TDUtils.getInStringFromArray(strArr);
        ids = byOrg ? this.getComyanyOrgIDByNumber(this.ctx, numbers) : this.getCompanyOrgIDByParam(this.ctx, numbers);
        return ids;
    }

    private Set getComyanyOrgIDByNumber(Context ctx, String numbers) throws BOSException, SQLException {
        HashSet<String> ids = new HashSet<String>();
        String sql = " select fid  from T_ORG_COMPANY  where FNUMBER  in  " + numbers;
        IRowSet rs = DBUtil.executeQuery((Context)ctx, (String)sql, null);
        while (rs.next()) {
            String id = rs.getString("fid");
            ids.add(id);
        }
        return ids;
    }

    private Set getCompanyOrgIDByParam(Context ctx, String orgManageNumber) throws BOSException, SQLException {
        HashSet<String> ids = new HashSet<String>();
        StringBuffer sb = new StringBuffer();
        sb.append(" SELECT t2.FUNITID orgUnitID FROM T_ORG_Tree t1  ");
        sb.append(" inner join T_ORG_Structure   t2 on t1.FID  = t2.FTREEID  ");
        sb.append(" inner join T_ORG_COMPANY t3 on t2.FUNITID  = t3.FID ");
        sb.append(" where t1. fnumber in ").append(orgManageNumber);
        IRowSet rs = DBUtil.executeQuery((Context)ctx, (String)sb.toString(), null);
        while (rs.next()) {
            ids.add(rs.getString("orgUnitID"));
        }
        return ids;
    }

    public ICalculateContextProvider getContextProvider() {
        return this.contextProvider;
    }
}

