/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.formula;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.excel.io.BookIOUtil;
import com.kingdee.bos.ctrl.excel.model.struct.Parameter;
import com.kingdee.bos.ctrl.excel.model.util.SortedParameterArray;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.fi.newrpt.formula.ICalculateContextProvider;
import com.kingdee.eas.fi.newrpt.formula.IReportPropertyAdapter;
import com.kingdee.eas.fi.rpt.ReportBaseInfo;
import com.kingdee.eas.tm.td.RecordTypeEnum;
import com.kingdee.eas.tm.td.TDUtils;
import com.kingdee.eas.tm.td.TaxDraftRecordFactory;
import com.kingdee.eas.tm.td.TaxDraftRecordInfo;
import com.kingdee.eas.tm.td.basedata.TaxItemTypeInfo;
import com.kingdee.eas.tm.td.est.RealEstateGroupInfo;
import com.kingdee.eas.tm.td.formula.AbstractBatchCalculater;
import com.kingdee.eas.tm.td.formula.ParamsInfo;
import com.kingdee.eas.tm.td.utils.TDSelectorFactory;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class EstReportDataByRuleBatchCalculater
extends AbstractBatchCalculater {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.td.formula.ReportTimeCalculater");

    public EstReportDataByRuleBatchCalculater(ICalculateContextProvider contextProvider) {
        this.contextProvider = contextProvider;
    }

    @Override
    public void execute(SortedParameterArray paramArray) {
        super.execute(paramArray);
        IReportPropertyAdapter reportAdapter = this.contextProvider.getReportAdapter();
        int querySize = paramArray.size();
        ReportBaseInfo info = (ReportBaseInfo)reportAdapter.getReportProperty("editData");
        for (int i = 0; i < querySize; ++i) {
            Parameter params = paramArray.getParameter(i);
            ParamsInfo formulaParam = new ParamsInfo();
            formulaParam.buildEstReportDataByRuleParam(params);
            formulaParam.setInfo(info);
            this.innerExecute(formulaParam);
        }
    }

    protected void innerExecute(ParamsInfo param) {
        ReportBaseInfo seftInfo = param.getInfo();
        String companyNumber = param.getCompany();
        String taxTypeNumber = param.getTaxItemType();
        String recordTypeValue = param.getRecordType();
        String accountConfig = param.getAccountConfig();
        String buildingTaxesGroup = param.getBuildingTaxesGroup();
        String periodValue = param.getPeriodValue();
        String sheetName = param.getSheetName();
        String cellName = param.getCellName();
        RecordTypeEnum recordType = RecordTypeEnum.getEnum(recordTypeValue);
        if (this.isEmpty(periodValue)) {
            periodValue = "0";
        }
        int value = Integer.parseInt(periodValue);
        String periodID = ((PeriodInfo)seftInfo.get("rptPeriod")).getId().toString();
        PeriodInfo prePeriod = (PeriodInfo)seftInfo.get("rptPeriod");
        try {
            for (int i = 0; i < value; ++i) {
                prePeriod = PeriodUtils.getPrePeriodInfo((Context)this.ctx, (IObjectPK)new ObjectUuidPK(periodID));
                if (prePeriod == null) {
                    String destPeriodIsNotExists = TDUtils.getString("com.kingdee.eas.tm.td.TDResource", "destPeriodIsNotExists", this.ctx.getLocale());
                    String badFuntion = TDUtils.getString("com.kingdee.eas.tm.td.TDResource", "BADFUNCTION", this.ctx.getLocale(), new Object[]{destPeriodIsNotExists});
                    param.getBackFiller().setValue((Object)badFuntion);
                    return;
                }
                if (prePeriod.isIsAdjustPeriod() && (prePeriod = PeriodUtils.getPrePeriodInfo((Context)this.ctx, (IObjectPK)new ObjectUuidPK(prePeriod.getId().toString()))) == null) {
                    String destPeriodIsNotExists = TDUtils.getString("com.kingdee.eas.tm.td.TDResource", "destPeriodIsNotExists", this.ctx.getLocale());
                    String badFuntion = TDUtils.getString("com.kingdee.eas.tm.td.TDResource", "BADFUNCTION", this.ctx.getLocale(), new Object[]{destPeriodIsNotExists});
                    param.getBackFiller().setValue((Object)badFuntion);
                    return;
                }
                periodID = prePeriod.getId().toString();
            }
            StringBuffer sql = new StringBuffer();
            ArrayList<Object> paramList = new ArrayList<Object>();
            sql.append(" select t.fid as FRptID from T_TD_TaxDraftRecord t");
            sql.append(" left join T_BD_Period rptPeriod on rptPeriod.fid = t.FRptPeriod");
            sql.append(" left join T_ORG_Company company on company.fid = t.FCompanyOrgUnitID");
            sql.append(" left join T_TM_TaxItemType taxItemType on taxItemType.fid = t.FTaxTypeID");
            sql.append(" left join T_TM_AccountConfig account on account.fid = t.FRelateAccountID");
            sql.append(" left join T_TD_RealEstateGroup estGroup on estGroup.fid = t.FBuildingTaxesGroupID");
            sql.append(" where rptPeriod.fid = ?");
            paramList.add(periodID);
            sql.append(" and t.FRecordType = ?");
            paramList.add(recordType.getValue());
            if (!this.isEmpty(companyNumber)) {
                sql.append(" and company.fnumber = ?");
                paramList.add(companyNumber);
            } else {
                sql.append(" and company.fid = ?");
                String companyID = ((CompanyOrgUnitInfo)seftInfo.get("companyOrgUnit")).getId().toString();
                paramList.add(companyID);
            }
            if (!this.isEmpty(taxTypeNumber)) {
                sql.append(" and taxItemType.fnumber = ?");
                paramList.add(taxTypeNumber);
            } else if (seftInfo.containsKey("taxType") && seftInfo.get("taxType") != null) {
                sql.append(" and taxItemType.fid = ?");
                String taxTypeID = ((TaxItemTypeInfo)seftInfo.get("taxType")).getId().toString();
                paramList.add(taxTypeID);
            }
            if (!this.isEmpty(accountConfig)) {
                sql.append(" and account.fnumber = ?");
                paramList.add(accountConfig);
            }
            if (!this.isEmpty(buildingTaxesGroup)) {
                sql.append(" and estGroup.fnumber = ?");
                paramList.add(buildingTaxesGroup);
            } else if (seftInfo.containsKey("buildingTaxesGroup") && seftInfo.get("buildingTaxesGroup") != null) {
                String buildingTaxesGroupID = ((RealEstateGroupInfo)seftInfo.get("buildingTaxesGroup")).getId().toString();
                sql.append(" and estGroup.fid = ?");
                paramList.add(buildingTaxesGroupID);
            }
            sql.append(" order by t.FDraftRecordType desc;");
            IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString(), (Object[])paramList.toArray());
            String rptID = null;
            if (rs.next()) {
                rptID = rs.getString("FRptID");
            }
            if (rptID == null) {
                param.getBackFiller().setValue((Object)"");
                return;
            }
            TaxDraftRecordInfo info = TaxDraftRecordFactory.getLocalInstance(this.ctx).getTaxDraftRecordInfo((IObjectPK)new ObjectUuidPK(rptID), TDSelectorFactory.getAllReportSelectors());
            if (info.getId().toString().equals(seftInfo.getId().toString())) {
                info = (TaxDraftRecordInfo)seftInfo;
            }
            byte[] data = info.getData();
            String key = (sheetName + "!" + cellName).toUpperCase();
            HashMap map = new HashMap();
            map.put(key, null);
            BookIOUtil.loadSomeCellValues((byte[])data, map);
            if (map.get(key) == null) {
                param.getBackFiller().setValue((Object)"");
            } else {
                param.getBackFiller().setValue(map.get(key));
            }
        }
        catch (Exception e) {
            param.getBackFiller().setException((Throwable)e);
        }
    }
}

