/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.formula;

import com.kingdee.bos.ctrl.excel.io.BookIOUtil;
import com.kingdee.bos.ctrl.excel.model.struct.Parameter;
import com.kingdee.bos.ctrl.excel.model.util.SortedParameterArray;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.fi.newrpt.formula.ICalculateContextProvider;
import com.kingdee.eas.fi.newrpt.formula.IReportPropertyAdapter;
import com.kingdee.eas.fi.rpt.ReportBaseInfo;
import com.kingdee.eas.tm.td.TaxDraftRecordCollection;
import com.kingdee.eas.tm.td.TaxDraftRecordFactory;
import com.kingdee.eas.tm.td.TaxDraftRecordInfo;
import com.kingdee.eas.tm.td.formula.AbstractBatchCalculater;
import com.kingdee.eas.tm.td.formula.ParamsInfo;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class TaxDraftRefBatchCalculater
extends AbstractBatchCalculater {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.td.formula.TaxDraftRefBatchCalculater");

    public TaxDraftRefBatchCalculater(ICalculateContextProvider contextProvider) {
        this.contextProvider = contextProvider;
    }

    @Override
    public void execute(SortedParameterArray paramArray) {
        super.execute(paramArray);
        IReportPropertyAdapter reportAdapter = this.contextProvider.getReportAdapter();
        int querySize = paramArray.size();
        String rptID = reportAdapter.getReportProperty("Report.ID").toString();
        ReportBaseInfo info = (ReportBaseInfo)reportAdapter.getReportProperty("editData");
        for (int i = 0; i < querySize; ++i) {
            Parameter params = paramArray.getParameter(i);
            ParamsInfo formulaParam = new ParamsInfo();
            formulaParam.buildTaxDraftReportParam(params);
            formulaParam.setInfo(info);
            this.innerExecute(formulaParam);
        }
    }

    protected void innerExecute(ParamsInfo param) {
        try {
            String rptNumber = param.getDraftReportNumber();
            String reportID = param.getReportID();
            EntityViewInfo ev = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            ReportBaseInfo seftInfo = param.getInfo();
            if (reportID != null && !"".equals(reportID)) {
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)reportID, CompareType.EQUALS));
            } else if (rptNumber != null && !"".equals(rptNumber)) {
                filter.getFilterItems().add(new FilterItemInfo("number", (Object)rptNumber, CompareType.EQUALS));
            } else {
                String periodID = ((PeriodInfo)seftInfo.get("rptPeriod")).toString();
                filter.getFilterItems().add(new FilterItemInfo("rptPeriod.id", (Object)periodID, CompareType.EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("companyOrgUnit.id", (Object)((CompanyOrgUnitInfo)seftInfo.get("companyOrgUnit")).getId().toString(), CompareType.EQUALS));
            }
            ev.setFilter(filter);
            TaxDraftRecordCollection rtpcoll = TaxDraftRecordFactory.getLocalInstance(this.ctx).getTaxDraftRecordCollection(ev);
            if (rtpcoll == null || rtpcoll.size() == 0) {
                param.getBackFiller().setValue((Object)"");
                return;
            }
            TaxDraftRecordInfo info = rtpcoll.get(0);
            if (info.getId().toString().equals(seftInfo.getId().toString())) {
                info = (TaxDraftRecordInfo)seftInfo;
            }
            byte[] data = info.getData();
            String key = (param.getSheetName() + "!" + param.getCellName()).toUpperCase();
            HashMap map = new HashMap();
            map.put(key, null);
            try {
                BookIOUtil.loadSomeCellValues((byte[])data, map);
            }
            catch (Exception e) {
                return;
            }
            if (map.get(key) == null) {
                param.getBackFiller().setValue((Object)"");
            } else {
                param.getBackFiller().setValue(map.get(key));
            }
        }
        catch (Exception e) {
            param.getBackFiller().setException((Throwable)e);
        }
    }
}

