/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.formula.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.rpt.client.FormulaWizardUI;
import com.kingdee.eas.fi.rpt.client.RptFormulaEnumEntry;
import com.kingdee.eas.tm.td.RecordTypeEnum;
import com.kingdee.eas.tm.td.TDUtils;
import com.kingdee.eas.tm.td.basedata.AccountTypeFactory;
import com.kingdee.eas.tm.td.basedata.AccountTypeInfo;
import com.kingdee.eas.tm.td.basedata.TaxItemTypeFactory;
import com.kingdee.eas.tm.td.basedata.TaxItemTypeInfo;
import com.kingdee.eas.tm.td.formula.client.FormulaWizardUIHelper;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ReportRefFormulaWizardUI
extends FormulaWizardUI {
    private KDComboBox comboRecordType = null;
    private KDBizPromptBox prmtAccountConfig = null;
    private KDBizPromptBox prmtCompany = null;
    private KDBizPromptBox prmtTaxItemType = null;
    private KDTextField txtCompany = null;
    private KDTextField txtAccountConfig = null;
    private KDTextField txtTaxItemType = null;
    private KDTextField txtRecordType = null;
    private KDTextField txtSheetName = null;
    private KDTextField sheetName = null;
    private KDTextField txtCellName = null;
    private KDTextField cellName = null;
    private KDTextField txtPeriodValue = null;
    private DataChangeListener prmtTaxItemTypeListener = null;
    private DataChangeListener prmtCompanyListener = null;
    private ItemListener recordTypeListener = null;
    private List<Integer> GETVALUETAX_RECORDTYPE = new ArrayList<Integer>(Arrays.asList(3, 4, 5, 6));
    private List<Integer> NOTGETVALUETAX_RECORDTYPE = new ArrayList<Integer>(Arrays.asList(0, 1, 2));

    protected void onOpen() {
        this.prmtCompany = (KDBizPromptBox)this.getParamComponent("companyOrgUnit");
        CompanyOrgUnitInfo companyInfo = null;
        if (this.prmtCompany.getValue() instanceof String && !"".equals(this.prmtCompany.getValue())) {
            try {
                companyInfo = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo("where number ='" + this.prmtCompany.getValue() + "'");
            }
            catch (EASBizException e) {
                this.handUIException(e);
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
        }
        this.prmtCompany.setValue(null);
        this.prmtCompany.setEditable(false);
        this.prmtCompany.setHistoryRecordEnabled(false);
        this.prmtCompany.setEnabledMultiSelection(false);
        this.prmtCompany.setValue(companyInfo);
        this.comboRecordType = (KDComboBox)this.getParamComponent("recordType");
        this.prmtAccountConfig = (KDBizPromptBox)this.getParamComponent("accountConfig");
        this.prmtTaxItemType = (KDBizPromptBox)this.getParamComponent("TaxItemType");
        this.sheetName = (KDTextField)this.getParamComponent("sheetName");
        this.cellName = (KDTextField)this.getParamComponent("cellName");
        this.txtTaxItemType = (KDTextField)this.getBaseParamComponent("TaxItemType");
        this.txtAccountConfig = (KDTextField)this.getBaseParamComponent("accountConfig");
        this.txtSheetName = (KDTextField)this.getBaseParamComponent("sheetName");
        this.txtCellName = (KDTextField)this.getBaseParamComponent("cellName");
        this.txtPeriodValue = (KDTextField)this.getBaseParamComponent("periodValue");
        this.txtRecordType = (KDTextField)this.getBaseParamComponent("recordType");
        this.initControlsRequired();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo signFilter = new FilterInfo();
        signFilter.getFilterItems().add(new FilterItemInfo("sign", (Object)"1"));
        view.setFilter(signFilter);
        this.prmtTaxItemType.setEntityViewInfo(view);
        if (this.comboRecordType == null || this.prmtAccountConfig == null) {
            return;
        }
        KDBizPromptBox f7Box = (KDBizPromptBox)this.getParamComponent("accountConfigF7");
        if (f7Box != null) {
            EntityViewInfo ev = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("relation.state", (Object)"2", CompareType.EQUALS));
            ev.setFilter(filter);
            f7Box.setEntityViewInfo(ev);
        }
        RecordTypeEnum recordTypeEnum = RecordTypeEnum.getEnum(((RptFormulaEnumEntry)this.comboRecordType.getSelectedItem()).getName());
        this.setControl(recordTypeEnum);
        try {
            this.initAccountConfigFilter();
            this.setRecordTypeProperties(true);
            this.addListener();
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
    }

    protected void initControlsRequired() {
        this.comboRecordType.setRequired(true);
        this.txtRecordType.setRequired(true);
        this.prmtAccountConfig.setRequired(true);
        this.txtAccountConfig.setRequired(true);
        this.sheetName.setRequired(true);
        this.txtSheetName.setRequired(true);
        this.cellName.setRequired(true);
        this.txtCellName.setRequired(true);
    }

    protected void initCompanyF7() {
        this.prmtCompany = (KDBizPromptBox)this.getParamComponent("companyOrgUnit");
        this.txtCompany = (KDTextField)this.getBaseParamComponent("companyOrgUnit");
        CompanyOrgUnitInfo companyOrgUnitInfo = null;
        if (this.prmtCompany.getValue() instanceof String) {
            if ("".equals(this.prmtCompany.getValue())) {
                this.prmtCompany.setValue(null);
            } else {
                try {
                    companyOrgUnitInfo = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo("where Number ='" + this.prmtCompany.getValue() + "'");
                }
                catch (EASBizException e) {
                    this.handUIException(e);
                }
                catch (BOSException e) {
                    this.handUIException(e);
                }
            }
        } else {
            companyOrgUnitInfo = (CompanyOrgUnitInfo)this.prmtCompany.getValue();
        }
        this.prmtCompany.setValue(null);
        this.prmtCompany.setEditable(false);
        this.prmtCompany.setEnabledMultiSelection(false);
        this.prmtCompany.setHistoryRecordEnabled(false);
        if (companyOrgUnitInfo != null) {
            this.prmtCompany.setValue((Object)companyOrgUnitInfo);
            if (!"".equals(companyOrgUnitInfo.getName())) {
                this.txtCompany.setText(companyOrgUnitInfo.getName());
            }
        }
    }

    private void addListener() {
        if (this.recordTypeListener == null) {
            this.recordTypeListener = new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        RecordTypeEnum recordTypeEnum = RecordTypeEnum.getEnum(((RptFormulaEnumEntry)e.getItem()).getName());
                        ReportRefFormulaWizardUI.this.setControl(recordTypeEnum);
                        ReportRefFormulaWizardUI.this.txtSheetName.setText("");
                        ReportRefFormulaWizardUI.this.txtCellName.setText("");
                        ReportRefFormulaWizardUI.this.sheetName.setText("");
                        ReportRefFormulaWizardUI.this.cellName.setText("");
                    }
                }
            };
        }
        this.comboRecordType.addItemListener(this.recordTypeListener);
        if (this.prmtTaxItemTypeListener == null) {
            this.prmtTaxItemTypeListener = new DataChangeListener(){

                public void dataChanged(DataChangeEvent eventObj) {
                    ReportRefFormulaWizardUI.this.prmtTaxItemType_dataChanged(eventObj);
                }
            };
        }
        this.prmtTaxItemType.addDataChangeListener(this.prmtTaxItemTypeListener);
        if (this.prmtCompanyListener == null) {
            this.prmtCompanyListener = new DataChangeListener(){

                public void dataChanged(DataChangeEvent eventObj) {
                    ReportRefFormulaWizardUI.this.prmtCompany_dataChanged(eventObj);
                }
            };
        }
        this.prmtCompany.addDataChangeListener(this.prmtCompanyListener);
    }

    private void setControl(RecordTypeEnum recordTypeEnum) {
        if (RecordTypeEnum.Account.equals((Object)recordTypeEnum)) {
            this.prmtAccountConfig.setEnabled(true);
            this.prmtAccountConfig.setRequired(true);
            this.txtAccountConfig.setRequired(true);
            this.txtAccountConfig.setEnabled(true);
        } else {
            this.prmtAccountConfig.setValue(null);
            this.prmtAccountConfig.setEnabled(false);
            this.prmtAccountConfig.setRequired(false);
            this.txtAccountConfig.setText("");
            this.txtAccountConfig.setEnabled(false);
            this.txtAccountConfig.setRequired(false);
        }
    }

    protected void prmtTaxItemType_dataChanged(DataChangeEvent e) {
        if (FormulaWizardUIHelper.isEqual(e.getNewValue(), e.getOldValue())) {
            return;
        }
        try {
            this.initAccountConfigFilter();
            this.setRecordTypeProperties(false);
        }
        catch (Exception ex) {
            this.handUIException(ex);
        }
        this.prmtAccountConfig.setValue(null);
        this.txtAccountConfig.setText("");
    }

    protected void prmtCompany_dataChanged(DataChangeEvent e) {
        if (FormulaWizardUIHelper.isEqual(e.getNewValue(), e.getOldValue())) {
            return;
        }
        try {
            this.initAccountConfigFilter();
        }
        catch (Exception ex) {
            this.handUIException(ex);
        }
    }

    private void initAccountConfigFilter() throws EASBizException, BOSException {
        IObjectValue info;
        AccountTypeInfo accountType;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("relation.state", (Object)"2", CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("taxTypeItem.sign", (Object)"1"));
        if (!FormulaWizardUIHelper.isEmpty(this.prmtTaxItemType.getValue())) {
            TaxItemTypeInfo taxType = this.prmtTaxItemType.getValue() instanceof String ? TaxItemTypeFactory.getRemoteInstance().getTaxItemTypeInfo(" where number ='" + this.prmtTaxItemType.getValue() + "'") : (TaxItemTypeInfo)this.prmtTaxItemType.getValue();
            try {
                accountType = AccountTypeFactory.getRemoteInstance().getAccountTypeInfo("where taxTypeItem.id = '" + taxType.getId().toString() + "'");
                filter.getFilterItems().add(new FilterItemInfo("accountType.id", (Object)accountType.getId().toString(), CompareType.EQUALS));
            }
            catch (EASBizException e) {
                this.handUIException(e);
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
        } else {
            info = null;
            if (this.getRptContext() != null && (info = (IObjectValue)this.getRptContext().getPropertyAdapter().getReportProperty("editData")) != null) {
                TaxItemTypeInfo taxTypeInfo = (TaxItemTypeInfo)info.get("taxType");
                accountType = AccountTypeFactory.getRemoteInstance().getAccountTypeInfo("where taxTypeItem.id = '" + taxTypeInfo.getId().toString() + "'");
                filter.getFilterItems().add(new FilterItemInfo("accountType.id", (Object)String.valueOf(accountType.getId()), CompareType.EQUALS));
            }
        }
        if (!FormulaWizardUIHelper.isEmpty(this.prmtCompany.getValue())) {
            if (this.prmtCompany.getValue() instanceof CompanyOrgUnitInfo) {
                CompanyOrgUnitInfo companyOrgUnitInfo = (CompanyOrgUnitInfo)this.prmtCompany.getValue();
                filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)String.valueOf(companyOrgUnitInfo.getId()), CompareType.EQUALS));
            } else if (this.prmtCompany.getValue() instanceof String) {
                String numberString = String.valueOf(this.prmtCompany.getValue());
                filter.getFilterItems().add(new FilterItemInfo("company.number", (Object)numberString, CompareType.EQUALS));
            }
        } else {
            CompanyOrgUnitInfo companyOrgUnitInfo;
            info = null;
            if (this.getRptContext() != null && (info = (IObjectValue)this.getRptContext().getPropertyAdapter().getReportProperty("editData")) != null && (companyOrgUnitInfo = (CompanyOrgUnitInfo)info.get("companyOrgUnit")) != null) {
                filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)String.valueOf(companyOrgUnitInfo.getId()), CompareType.EQUALS));
            }
        }
        view.setFilter(filter);
        this.prmtAccountConfig.setEntityViewInfo(view);
    }

    private void setRecordTypeProperties(boolean isFirstOpen) throws EASBizException, BOSException {
        RecordTypeEnum recordTypeEnum = this.getSelectedRecordType();
        TaxItemTypeInfo taxItemType = null;
        if (this.prmtTaxItemType.getValue() instanceof String) {
            if (!"".equals(this.prmtTaxItemType.getValue())) {
                taxItemType = TaxItemTypeFactory.getRemoteInstance().getTaxItemTypeInfo(" where number ='" + this.prmtTaxItemType.getValue() + "'");
            }
        } else {
            taxItemType = (TaxItemTypeInfo)this.prmtTaxItemType.getValue();
        }
        List<Object> recordTypeList = new ArrayList();
        this.comboRecordType.removeAllItems();
        RecordTypeEnum tempRecordTypeEnum = null;
        if (taxItemType == null) {
            recordTypeList = Arrays.asList(RecordTypeEnum.getEnumList().toArray());
            for (int i = 0; i < recordTypeList.size(); ++i) {
                tempRecordTypeEnum = (RecordTypeEnum)((Object)recordTypeList.get(i));
                this.comboRecordType.addItem((Object)this.getRptFormulaEnumEntry(tempRecordTypeEnum));
            }
        } else if ("Xip1b7mfPS7gU0ETqMBAL9uK96Y=".equals(String.valueOf(taxItemType.getId()))) {
            this.comboRecordType.addItem((Object)this.getRptFormulaEnumEntry(RecordTypeEnum.Account));
            this.comboRecordType.addItem((Object)this.getRptFormulaEnumEntry(RecordTypeEnum.AnnualDraftItem));
            this.comboRecordType.addItem((Object)this.getRptFormulaEnumEntry(RecordTypeEnum.QuarterlyDraftItem));
            this.comboRecordType.addItem((Object)this.getRptFormulaEnumEntry(RecordTypeEnum.AnnualTaxDeclare));
            this.comboRecordType.addItem((Object)this.getRptFormulaEnumEntry(RecordTypeEnum.QuarterlyTaxDeclare));
            recordTypeList.add((Object)RecordTypeEnum.Account);
            recordTypeList.add((Object)RecordTypeEnum.AnnualDraftItem);
            recordTypeList.add((Object)RecordTypeEnum.QuarterlyDraftItem);
            recordTypeList.add((Object)RecordTypeEnum.AnnualTaxDeclare);
            recordTypeList.add((Object)RecordTypeEnum.QuarterlyTaxDeclare);
        } else {
            this.comboRecordType.addItem((Object)this.getRptFormulaEnumEntry(RecordTypeEnum.Account));
            this.comboRecordType.addItem((Object)this.getRptFormulaEnumEntry(RecordTypeEnum.DraftItem));
            this.comboRecordType.addItem((Object)this.getRptFormulaEnumEntry(RecordTypeEnum.TaxDeclare));
            recordTypeList.add((Object)RecordTypeEnum.Account);
            recordTypeList.add((Object)RecordTypeEnum.DraftItem);
            recordTypeList.add((Object)RecordTypeEnum.TaxDeclare);
        }
        if (!recordTypeList.contains((Object)recordTypeEnum)) {
            recordTypeEnum = (RecordTypeEnum)((Object)recordTypeList.get(0));
        }
        if (!isFirstOpen && recordTypeList.contains(this.getRptFormulaEnumEntry(RecordTypeEnum.TaxDeclare))) {
            recordTypeEnum = RecordTypeEnum.TaxDeclare;
        }
        RptFormulaEnumEntry entry = this.getRptFormulaEnumEntry(recordTypeEnum);
        this.comboRecordType.setSelectedItem((Object)entry);
        this.txtRecordType.setText(recordTypeEnum.getAlias());
    }

    private RecordTypeEnum getSelectedRecordType() {
        RecordTypeEnum recordTypeEnum = null;
        if (this.comboRecordType.getSelectedItem() instanceof RptFormulaEnumEntry) {
            recordTypeEnum = RecordTypeEnum.getEnum(((RptFormulaEnumEntry)this.comboRecordType.getSelectedItem()).getName());
        } else if (this.comboRecordType.getSelectedItem() instanceof RecordTypeEnum) {
            recordTypeEnum = (RecordTypeEnum)((Object)this.comboRecordType.getSelectedItem());
        } else if (this.comboRecordType.getSelectedItem() instanceof String) {
            recordTypeEnum = RecordTypeEnum.getEnum(this.comboRecordType.getSelectedItem().toString());
        }
        return recordTypeEnum;
    }

    private RptFormulaEnumEntry getRptFormulaEnumEntry(RecordTypeEnum recordType) {
        String language = SysContext.getSysContext().getLocale().getLanguage();
        RptFormulaEnumEntry entry = new RptFormulaEnumEntry(recordType.getName(), null);
        String[] local = new String[]{"zh_CN", "zh_TW", "en_US"};
        for (int i = 0; i < local.length; ++i) {
            entry.setLocalName(local[i], recordType.getAlias());
            entry.setDescription(local[i], recordType.getAlias());
        }
        return entry;
    }

    public void actionFinish_actionPerformed(ActionEvent e) throws Exception {
        if ("okey".equals(e.getActionCommand())) {
            if (this.checkPeriodValue() && this.checkRequired()) {
                super.actionFinish_actionPerformed(e);
            }
        } else if ("cancel".equals(e.getActionCommand())) {
            super.actionFinish_actionPerformed(e);
        }
    }

    private boolean checkPeriodValue() {
        String periodValueString = this.txtPeriodValue.getText();
        if ("".equals(periodValueString)) {
            return true;
        }
        try {
            int periodValue = Integer.valueOf(periodValueString);
            if (periodValue < 0) {
                MsgBox.showInfo((String)TDUtils.getString("com.kingdee.eas.tm.td.formula.TaxFormulaResource", "PeriodValue_Error", TDUtils.getLocale()));
                return false;
            }
        }
        catch (Exception e) {
            MsgBox.showInfo((String)TDUtils.getString("com.kingdee.eas.tm.td.formula.TaxFormulaResource", "PeriodValue_Error", TDUtils.getLocale()));
            return false;
        }
        return true;
    }

    protected boolean checkRequired() {
        String msg = "";
        StringBuffer buildMsg = new StringBuffer();
        if (this.prmtAccountConfig.isRequired() && (this.prmtAccountConfig.getValue() == null || "".equals(this.prmtAccountConfig.getValue()))) {
            buildMsg.append(TDUtils.getString("com.kingdee.eas.tm.td.formula.TaxFormulaResource", "AccountConfig", TDUtils.getLocale()));
        }
        if ("".equals(this.sheetName.getText().trim())) {
            buildMsg.append(TDUtils.getString("com.kingdee.eas.tm.td.formula.TaxFormulaResource", "SheetName", TDUtils.getLocale()));
        }
        if ("".equals(this.cellName.getText().trim())) {
            buildMsg.append(TDUtils.getString("com.kingdee.eas.tm.td.formula.TaxFormulaResource", "CellName", TDUtils.getLocale()));
        }
        if (buildMsg.length() > 0) {
            msg = TDUtils.getString("com.kingdee.eas.fi.gr.cslrpt.cslcommon.CSLCOMMONAutoGenerateResource", "0_FormulaWizardUI", TDUtils.getLocale(), new Object[]{buildMsg.toString().substring(1)});
        }
        if (buildMsg.length() > 0 && msg.length() > 0) {
            return MsgBox.isYes((int)MsgBox.showConfirm2((String)msg));
        }
        return buildMsg.length() == 0;
    }
}

