/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.formula.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.PreChangeEvent;
import com.kingdee.bos.ctrl.swing.event.PreChangeListener;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.rpt.client.FormulaWizardUI;
import com.kingdee.eas.fi.rpt.client.RptFormulaEnumEntry;
import com.kingdee.eas.tm.td.RecordTypeEnum;
import com.kingdee.eas.tm.td.TDUtils;
import com.kingdee.eas.tm.td.TaxDraftRecordInfo;
import com.kingdee.eas.tm.td.basedata.TaxItemTypeInfo;
import com.kingdee.eas.tm.td.cloud.utils.TDCloudUtil;
import com.kingdee.eas.tm.td.structure.ReportItemDimensionEnum;
import com.kingdee.eas.tm.td.structure.TaxReportItemInfo;
import com.kingdee.eas.tm.td.structure.TaxReportSheetInfo;
import com.kingdee.eas.tm.td.structure.TaxReportTemplateInfo;
import com.kingdee.eas.tm.td.structure.client.TaxReportItemSelector;
import com.kingdee.eas.tm.td.structure.utils.StructureUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;

public class TaxItemFormulaWizardUI
extends FormulaWizardUI {
    private KDBizPromptBox companyF7 = null;
    private KDBizPromptBox taxTypeF7 = null;
    private KDComboBox recordType = null;
    private KDBizPromptBox accountConfigF7 = null;
    private KDBizPromptBox buildingTaxesGroupF7 = null;
    private KDBizPromptBox reportSheetF7 = null;
    private KDBizPromptBox rowItemF7 = null;
    private KDBizPromptBox columnItmeF7 = null;
    private KDTextField reportSheetLabel = null;
    private KDTextField rowItemLabel = null;
    private KDTextField columnItmeLabel = null;
    private KDTextField accountConfigLabel = null;
    private KDTextField buildingTaxesGroupLabel = null;
    private KDTextField taxTypeLabel = null;
    private KDTextField recordTypeLabel = null;
    private KDTextField companyLabel = null;
    private DataChangeListener companyChangeListener = null;
    private ItemListener recordTypeListener = null;
    private DataChangeListener taxTypeLinstener = null;
    private DataChangeListener reportSheetChangeListener = null;
    private IObjectValue editData = null;

    protected void onOpen() {
        this.initCompanyF7();
        this.taxTypeF7 = (KDBizPromptBox)this.getParamComponent("taxItemType");
        this.recordType = (KDComboBox)this.getParamComponent("recordType");
        this.accountConfigF7 = (KDBizPromptBox)this.getParamComponent("accountConfig");
        this.buildingTaxesGroupF7 = (KDBizPromptBox)this.getParamComponent("buildingTaxesGroup");
        this.reportSheetF7 = (KDBizPromptBox)this.getParamComponent("reportSheet");
        this.rowItemF7 = (KDBizPromptBox)this.getParamComponent("rowItem");
        this.columnItmeF7 = (KDBizPromptBox)this.getParamComponent("columnItem");
        this.reportSheetLabel = (KDTextField)this.getBaseParamComponent("reportSheet");
        this.rowItemLabel = (KDTextField)this.getBaseParamComponent("rowItem");
        this.columnItmeLabel = (KDTextField)this.getBaseParamComponent("columnItem");
        this.accountConfigLabel = (KDTextField)this.getBaseParamComponent("accountConfig");
        this.buildingTaxesGroupLabel = (KDTextField)this.getBaseParamComponent("buildingTaxesGroup");
        this.taxTypeLabel = (KDTextField)this.getBaseParamComponent("taxItemType");
        this.recordTypeLabel = (KDTextField)this.getBaseParamComponent("recordType");
        this.loadFields();
    }

    public void loadFields() {
        super.loadFields();
        try {
            this.innerLoadFields();
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        this.initControl();
        this.addListener();
        this.setFilter();
    }

    protected void innerLoadFields() throws BOSException {
        TaxReportItemInfo itemInfo;
        String reportItemNumber;
        if (this.getRptContext() != null) {
            this.editData = (IObjectValue)this.getRptContext().getPropertyAdapter().getReportProperty("editData");
        }
        if (this.companyF7.getValue() != null && this.companyF7.getValue() instanceof String) {
            String companyNumber = (String)this.companyF7.getValue();
            CompanyOrgUnitInfo companyInfo = StructureUtils.getCompanyByNumber(null, companyNumber);
            this.companyF7.setValue((Object)companyInfo);
            this.companyLabel.setText(companyInfo == null ? "" : companyInfo.getName());
        }
        if (this.taxTypeF7.getValue() != null && this.taxTypeF7.getValue() instanceof String) {
            String taxTypeNumber = (String)this.taxTypeF7.getValue();
            TaxItemTypeInfo taxTypeInfo = StructureUtils.getTaxItemTypeByNumber(null, taxTypeNumber);
            this.taxTypeF7.setValue((Object)taxTypeInfo);
            this.taxTypeLabel.setText(taxTypeInfo == null ? "" : taxTypeInfo.getName());
        }
        if (this.reportSheetF7.getValue() != null && this.reportSheetF7.getValue() instanceof String) {
            String reportSheetNumber = (String)this.reportSheetF7.getValue();
            TaxReportSheetInfo sheetInfo = StructureUtils.getTaxReportSheetByNumber(null, reportSheetNumber);
            this.reportSheetF7.setValue((Object)sheetInfo);
            this.reportSheetLabel.setText(sheetInfo == null ? "" : sheetInfo.getName());
        }
        if (this.rowItemF7.getValue() != null && this.rowItemF7.getValue() instanceof String) {
            reportItemNumber = (String)this.rowItemF7.getValue();
            itemInfo = StructureUtils.getTaxReportItemByNumber(null, reportItemNumber);
            this.rowItemF7.setValue((Object)itemInfo);
            this.rowItemLabel.setText(itemInfo == null ? "" : itemInfo.getName());
        }
        if (this.columnItmeF7.getValue() != null && this.columnItmeF7.getValue() instanceof String) {
            reportItemNumber = (String)this.columnItmeF7.getValue();
            itemInfo = StructureUtils.getTaxReportItemByNumber(null, reportItemNumber);
            this.columnItmeF7.setValue((Object)itemInfo);
            this.columnItmeLabel.setText(itemInfo == null ? "" : itemInfo.getName());
        }
    }

    protected void initCompanyF7() {
        this.companyF7 = (KDBizPromptBox)this.getParamComponent("companyOrgUnit");
        this.companyLabel = (KDTextField)this.getBaseParamComponent("companyOrgUnit");
        CompanyOrgUnitInfo companyOrgUnitInfo = null;
        if (this.companyF7.getValue() instanceof String) {
            if ("".equals(this.companyF7.getValue())) {
                this.companyF7.setValue(null);
            } else {
                try {
                    companyOrgUnitInfo = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo("where Number ='" + this.companyF7.getValue() + "'");
                }
                catch (EASBizException e) {
                    this.handUIException(e);
                }
                catch (BOSException e) {
                    this.handUIException(e);
                }
            }
        } else {
            companyOrgUnitInfo = (CompanyOrgUnitInfo)this.companyF7.getValue();
        }
        this.companyF7.setValue(null);
        this.companyF7.setEditable(false);
        this.companyF7.setEnabledMultiSelection(false);
        this.companyF7.setHistoryRecordEnabled(false);
        if (companyOrgUnitInfo != null) {
            this.companyF7.setValue((Object)companyOrgUnitInfo);
            if (!"".equals(companyOrgUnitInfo.getName())) {
                this.companyLabel.setText(companyOrgUnitInfo.getName());
            }
        }
    }

    protected void initControl() {
        this.initItemF7(this.rowItemF7);
        this.initItemF7(this.columnItmeF7);
        this.initAccountConfigF7();
        this.initRecordType();
        this.initControlsRequired();
    }

    protected void initRecordType() {
        RecordTypeEnum recordTypeEnum = this.getSelectedRecordType();
        TaxItemTypeInfo taxType = this.getSelectedTaxType();
        this.recordType.removeAllItems();
        ArrayList<RecordTypeEnum> recordTypeList = new ArrayList<RecordTypeEnum>();
        if (taxType != null && "Xip1b7mfPS7gU0ETqMBAL9uK96Y=".equals(taxType.getId().toString())) {
            this.recordType.addItem((Object)this.getRptFormulaEnumEntry(RecordTypeEnum.Account));
            this.recordType.addItem((Object)this.getRptFormulaEnumEntry(RecordTypeEnum.AnnualDraftItem));
            this.recordType.addItem((Object)this.getRptFormulaEnumEntry(RecordTypeEnum.QuarterlyDraftItem));
            this.recordType.addItem((Object)this.getRptFormulaEnumEntry(RecordTypeEnum.AnnualTaxDeclare));
            this.recordType.addItem((Object)this.getRptFormulaEnumEntry(RecordTypeEnum.QuarterlyTaxDeclare));
            recordTypeList.add(RecordTypeEnum.Account);
            recordTypeList.add(RecordTypeEnum.AnnualDraftItem);
            recordTypeList.add(RecordTypeEnum.QuarterlyDraftItem);
            recordTypeList.add(RecordTypeEnum.AnnualTaxDeclare);
            recordTypeList.add(RecordTypeEnum.QuarterlyTaxDeclare);
        } else {
            this.recordType.addItem((Object)this.getRptFormulaEnumEntry(RecordTypeEnum.Account));
            this.recordType.addItem((Object)this.getRptFormulaEnumEntry(RecordTypeEnum.DraftItem));
            this.recordType.addItem((Object)this.getRptFormulaEnumEntry(RecordTypeEnum.TaxDeclare));
            recordTypeList.add(RecordTypeEnum.Account);
            recordTypeList.add(RecordTypeEnum.DraftItem);
            recordTypeList.add(RecordTypeEnum.TaxDeclare);
        }
        if (!recordTypeList.contains((Object)recordTypeEnum)) {
            recordTypeEnum = (RecordTypeEnum)((Object)recordTypeList.get(0));
        }
        RptFormulaEnumEntry entry = this.getRptFormulaEnumEntry(recordTypeEnum);
        this.recordType.setSelectedItem((Object)entry);
        this.recordTypeLabel.setText(recordTypeEnum.getAlias());
    }

    protected void initControlsRequired() {
        this.recordType.setRequired(true);
        this.recordTypeLabel.setRequired(true);
        this.reportSheetF7.setRequired(true);
        this.reportSheetLabel.setRequired(true);
        this.rowItemF7.setRequired(true);
        this.rowItemLabel.setRequired(true);
        this.columnItmeF7.setRequired(true);
        this.columnItmeLabel.setRequired(true);
    }

    private RptFormulaEnumEntry getRptFormulaEnumEntry(RecordTypeEnum recordType) {
        String language = SysContext.getSysContext().getLocale().getLanguage();
        RptFormulaEnumEntry entry = new RptFormulaEnumEntry(recordType.getName(), null);
        String[] local = new String[]{"zh_CN", "zh_TW", "en_US"};
        for (int i = 0; i < local.length; ++i) {
            entry.setLocalName(local[i], recordType.getAlias());
            entry.setDescription(local[i], recordType.getAlias());
        }
        return entry;
    }

    protected void initItemF7(KDBizPromptBox box) {
        box.setEditable(false);
        box.setRefresh(false);
        box.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                KDPromptBox f7Box = (KDPromptBox)e.getSource();
                Object value = TaxItemFormulaWizardUI.this.reportSheetF7.getValue();
                TaxReportSheetInfo sheetInfo = null;
                if (value != null) {
                    if (value instanceof TaxReportSheetInfo) {
                        sheetInfo = (TaxReportSheetInfo)TaxItemFormulaWizardUI.this.reportSheetF7.getValue();
                    } else if (!TaxItemFormulaWizardUI.isEmpty(value.toString())) {
                        try {
                            sheetInfo = StructureUtils.getTaxReportSheetByNumber(null, value.toString());
                        }
                        catch (BOSException e1) {
                            TaxItemFormulaWizardUI.this.handUIException(e1);
                        }
                    }
                }
                if (sheetInfo == null) {
                    MsgBox.showInfo((String)"\u8bf7\u9009\u62e9\u8868\u9875\u7c7b\u578b!");
                    TaxItemFormulaWizardUI.this.reportSheetLabel.requestFocus();
                    TaxItemFormulaWizardUI.this.reportSheetF7.requestFocus();
                    SysUtil.abort();
                }
                ReportItemDimensionEnum itemDimension = null;
                ArrayList<TaxReportItemInfo> rptItemSelected = new ArrayList<TaxReportItemInfo>();
                value = f7Box.getValue();
                TaxReportItemInfo itemInfo = null;
                if (value != null) {
                    if (value instanceof TaxReportItemInfo) {
                        itemInfo = (TaxReportItemInfo)value;
                        rptItemSelected.add(itemInfo);
                    } else if (!TaxItemFormulaWizardUI.isEmpty(value.toString())) {
                        try {
                            itemInfo = StructureUtils.getTaxReportItemByNumber(null, value.toString());
                            rptItemSelected.add(itemInfo);
                        }
                        catch (BOSException e1) {
                            TaxItemFormulaWizardUI.this.handUIException(e1);
                        }
                    }
                }
                if (f7Box.getName().equals("rowItem")) {
                    itemDimension = ReportItemDimensionEnum.ROW;
                } else if (f7Box.getName().equals("columnItem")) {
                    itemDimension = ReportItemDimensionEnum.COLUMN;
                }
                TaxReportItemSelector selector = new TaxReportItemSelector(sheetInfo, itemDimension, rptItemSelected);
                selector.setEnabledMultiSelection(false);
                f7Box.setSelector((KDPromptSelector)selector);
            }
        });
        box.addPreChangeListener(new PreChangeListener(){

            public void preChange(PreChangeEvent e) {
                KDPromptBox f7Box = (KDPromptBox)e.getSource();
                e.setResult(1);
            }
        });
    }

    private void addListener() {
        this.companyChangeListener = new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                if (TDCloudUtil.isEqual(e.getNewValue(), e.getOldValue())) {
                    return;
                }
                TaxItemFormulaWizardUI.this.company_dataChanged(e);
            }
        };
        this.companyF7.addDataChangeListener(this.companyChangeListener);
        this.taxTypeLinstener = new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                if (TDCloudUtil.isEqual(e.getNewValue(), e.getOldValue())) {
                    return;
                }
                TaxItemFormulaWizardUI.this.taxType_dataChanged(e);
            }
        };
        this.taxTypeF7.addDataChangeListener(this.taxTypeLinstener);
        this.recordTypeListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                TaxItemFormulaWizardUI.this.recordType_dataChanged(e);
            }
        };
        this.recordType.addItemListener(this.recordTypeListener);
        this.reportSheetChangeListener = new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                if (TDCloudUtil.isEqual(e.getNewValue(), e.getOldValue())) {
                    return;
                }
                TaxItemFormulaWizardUI.this.reportSheet_dataChanged(e);
            }
        };
        this.reportSheetF7.addDataChangeListener(this.reportSheetChangeListener);
    }

    protected void company_dataChanged(DataChangeEvent e) {
        this.buildingTaxesGroupF7.setValue(null);
        this.buildingTaxesGroupLabel.setText("");
    }

    protected void taxType_dataChanged(DataChangeEvent e) {
        this.clearItemConfig();
        this.setReportSheetF7Filter();
        this.accountConfigF7.setValue(null);
        this.accountConfigLabel.setText("");
        this.initRecordType();
        this.setAccountConfigFilter();
    }

    private RecordTypeEnum getSelectedRecordType() {
        RecordTypeEnum recordTypeEnum = null;
        if (this.recordType.getSelectedItem() instanceof RptFormulaEnumEntry) {
            recordTypeEnum = RecordTypeEnum.getEnum(((RptFormulaEnumEntry)this.recordType.getSelectedItem()).getName());
        } else if (this.recordType.getSelectedItem() instanceof RecordTypeEnum) {
            recordTypeEnum = (RecordTypeEnum)((Object)this.recordType.getSelectedItem());
        } else if (this.recordType.getSelectedItem() instanceof String) {
            recordTypeEnum = RecordTypeEnum.getEnum(this.recordType.getSelectedItem().toString());
        }
        return recordTypeEnum;
    }

    private void clearItemConfig() {
        this.reportSheetF7.removeDataChangeListener(this.reportSheetChangeListener);
        this.reportSheetF7.setValue(null);
        this.rowItemF7.setValue(null);
        this.columnItmeF7.setValue(null);
        this.reportSheetLabel.setText("");
        this.rowItemLabel.setText("");
        this.columnItmeLabel.setText("");
        this.reportSheetF7.addDataChangeListener(this.reportSheetChangeListener);
    }

    protected void recordType_dataChanged(ItemEvent e) {
        this.clearItemConfig();
        this.setReportSheetF7Filter();
        this.initAccountConfigF7();
        this.buildingTaxesGroupF7.setValue(null);
        this.buildingTaxesGroupLabel.setText("");
    }

    private void initAccountConfigF7() {
        this.accountConfigF7.setValue(null);
        this.accountConfigLabel.setText("");
        RecordTypeEnum recordTypeEnum = this.getSelectedRecordType();
        if (RecordTypeEnum.Account.equals((Object)recordTypeEnum)) {
            this.accountConfigF7.setEnabled(true);
            this.accountConfigF7.setRequired(true);
            this.accountConfigLabel.setEnabled(true);
            this.accountConfigLabel.setRequired(true);
        } else {
            this.accountConfigF7.setEnabled(false);
            this.accountConfigF7.setRequired(false);
            this.accountConfigLabel.setEnabled(false);
            this.accountConfigLabel.setRequired(false);
        }
    }

    protected void reportSheet_dataChanged(DataChangeEvent e) {
        this.rowItemF7.setValue(null);
        this.columnItmeF7.setValue(null);
        this.rowItemLabel.setText("");
        this.columnItmeLabel.setText("");
    }

    private void setFilter() {
        StructureUtils.setTaxTypeFilter(this.taxTypeF7);
        this.setAccountConfigFilter();
        this.setReportSheetF7Filter();
    }

    protected void setReportSheetF7Filter() {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        Object value = this.getSelectedTaxType();
        if (value != null && value instanceof TaxItemTypeInfo) {
            Object taxType = value;
            filter.getFilterItems().add(new FilterItemInfo("taxType.id", (Object)taxType.getId().toString(), CompareType.EQUALS));
        }
        if ((value = this.getSelectedRecordType()) != null && value instanceof RecordTypeEnum) {
            RecordTypeEnum recordType = (RecordTypeEnum)((Object)value);
            filter.getFilterItems().add(new FilterItemInfo("recordType", (Object)recordType.getValue(), CompareType.EQUALS));
        }
        filter.getFilterItems().add(new FilterItemInfo("state", (Object)"2", CompareType.EQUALS));
        view.setFilter(filter);
        this.reportSheetF7.setEntityViewInfo(view);
    }

    protected void setAccountConfigFilter() {
        TaxItemTypeInfo taxType = this.getSelectedTaxType();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (taxType != null) {
            filter.getFilterItems().add(new FilterItemInfo("taxTypeItem.id", (Object)taxType.getId().toString(), CompareType.EQUALS));
        }
        view.setFilter(filter);
        this.accountConfigF7.setEntityViewInfo(view);
    }

    private TaxItemTypeInfo getSelectedTaxType() {
        TaxItemTypeInfo taxType = (TaxItemTypeInfo)this.taxTypeF7.getValue();
        if (taxType == null) {
            if (this.editData instanceof TaxReportTemplateInfo) {
                TaxReportTemplateInfo info = (TaxReportTemplateInfo)this.editData;
                taxType = info.getTaxType();
            } else if (this.editData instanceof TaxDraftRecordInfo) {
                TaxDraftRecordInfo info = (TaxDraftRecordInfo)this.editData;
                taxType = info.getTaxType();
            }
        }
        return taxType;
    }

    public static final boolean isEmpty(String s) {
        return s == null || s.trim().length() == 0;
    }

    public void actionFinish_actionPerformed(ActionEvent e) throws Exception {
        if ("okey".equals(e.getActionCommand())) {
            if (this.checkRequired()) {
                super.actionFinish_actionPerformed(e);
            }
        } else if ("cancel".equals(e.getActionCommand())) {
            super.actionFinish_actionPerformed(e);
        }
    }

    protected boolean checkRequired() {
        String msg = "";
        StringBuffer buildMsg = new StringBuffer();
        if (this.accountConfigF7.isRequired() && (this.accountConfigF7.getValue() == null || "".equals(this.accountConfigF7.getValue()))) {
            buildMsg.append(TDUtils.getString("com.kingdee.eas.tm.td.formula.TaxFormulaResource", "AccountConfig", TDUtils.getLocale()));
        }
        if (this.reportSheetF7.getValue() == null || "".equals(this.reportSheetF7.getValue())) {
            buildMsg.append(TDUtils.getString("com.kingdee.eas.tm.td.formula.TaxFormulaResource", "ReportSheet", TDUtils.getLocale()));
        }
        if (this.rowItemF7.getValue() == null || "".equals(this.rowItemF7.getValue())) {
            buildMsg.append(TDUtils.getString("com.kingdee.eas.tm.td.formula.TaxFormulaResource", "RowItem", TDUtils.getLocale()));
        }
        if (this.columnItmeF7.getValue() == null || "".equals(this.columnItmeF7.getValue())) {
            buildMsg.append(TDUtils.getString("com.kingdee.eas.tm.td.formula.TaxFormulaResource", "ColumnItme", TDUtils.getLocale()));
        }
        if (buildMsg.length() > 0) {
            msg = TDUtils.getString("com.kingdee.eas.fi.gr.cslrpt.cslcommon.CSLCOMMONAutoGenerateResource", "0_FormulaWizardUI", TDUtils.getLocale(), new Object[]{buildMsg.toString().substring(1)});
        }
        if (buildMsg.length() > 0 && msg.length() > 0) {
            return MsgBox.isYes((int)MsgBox.showConfirm2((String)msg));
        }
        return buildMsg.length() == 0;
    }
}

