/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.formula.relate.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.rpt.FormulaHint;
import com.kingdee.eas.tm.td.RecordTypeEnum;
import com.kingdee.eas.tm.td.TDUtils;
import com.kingdee.eas.tm.td.TaxDraftRecordCollection;
import com.kingdee.eas.tm.td.TaxDraftRecordFactory;
import com.kingdee.eas.tm.td.TaxDraftRecordInfo;
import com.kingdee.eas.tm.td.basedata.TaxItemTypeFactory;
import com.kingdee.eas.tm.td.basedata.TaxItemTypeInfo;
import com.kingdee.eas.tm.td.formula.relate.client.TaxFormulaStructure;
import com.kingdee.util.StringUtils;
import java.util.Map;
import javax.swing.SwingUtilities;

public class GetTdReportDataByRuleFormulaStructure
extends TaxFormulaStructure {
    private String companyNumber;
    private String taxItemType;
    private String recordType;
    private String accountConfig;
    private String periodValue;
    private String sheetName;
    private String cellName;
    private TaxDraftRecordInfo targetReport;

    public GetTdReportDataByRuleFormulaStructure(String formula) {
        super(formula);
    }

    public GetTdReportDataByRuleFormulaStructure(FormulaHint hint) {
        super(hint);
    }

    @Override
    public void structure() throws Exception {
        FilterInfo filter;
        EntityViewInfo ev;
        this.companyNumber = (String)this.parameter.get(0);
        this.taxItemType = (String)this.parameter.get(1);
        this.recordType = (String)this.parameter.get(2);
        this.accountConfig = (String)this.parameter.get(3);
        this.periodValue = (String)this.parameter.get(4);
        this.sheetName = (String)this.parameter.get(5);
        this.cellName = (String)this.parameter.get(6);
        TaxDraftRecordInfo seftInfo = (TaxDraftRecordInfo)this.getReport();
        if ("".equals(this.periodValue)) {
            this.periodValue = "0";
        }
        int value = Integer.parseInt(this.periodValue);
        String periodID = seftInfo.getRptPeriod().getId().toString();
        PeriodInfo prePeriod = seftInfo.getRptPeriod();
        RecordTypeEnum recordTypeEnum = RecordTypeEnum.getEnum(this.recordType);
        for (int i = 0; i < value; ++i) {
            prePeriod = PeriodUtils.getPrePeriodInfo(null, (IObjectPK)new ObjectUuidPK(periodID));
            if (prePeriod == null) {
                return;
            }
            if (prePeriod.isIsAdjustPeriod()) {
                prePeriod = PeriodUtils.getPrePeriodInfo(null, (IObjectPK)new ObjectUuidPK(prePeriod.getId().toString()));
            }
            periodID = prePeriod.getId().toString();
        }
        String companyID = seftInfo.getCompanyOrgUnit().getId().toString();
        if (this.companyNumber != null && !"".equals(this.companyNumber)) {
            ev = new EntityViewInfo();
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)this.companyNumber, CompareType.EQUALS));
            ev.setFilter(filter);
            CompanyOrgUnitCollection coll = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitCollection(ev);
            if (coll != null && coll.size() > 0) {
                companyID = coll.get(0).getId().toString();
            }
        }
        ev = new EntityViewInfo();
        filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("rptPeriod.id", (Object)prePeriod.getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("companyOrgUnit.id", (Object)companyID, CompareType.EQUALS));
        if (!StringUtils.isEmpty((String)this.taxItemType)) {
            filter.getFilterItems().add(new FilterItemInfo("taxType.number", (Object)this.taxItemType, CompareType.EQUALS));
        }
        filter.getFilterItems().add(new FilterItemInfo("recordType", (Object)recordTypeEnum.getValue(), CompareType.EQUALS));
        if (recordTypeEnum.equals((Object)RecordTypeEnum.Account)) {
            filter.getFilterItems().add(new FilterItemInfo("relateAccount.number", (Object)this.accountConfig, CompareType.EQUALS));
        }
        ev.setFilter(filter);
        TaxDraftRecordCollection rtpcoll = TaxDraftRecordFactory.getRemoteInstance().getTaxDraftRecordCollection(ev);
        this.targetReport = rtpcoll.get(0);
    }

    @Override
    public void openUI() throws Exception {
        UIContext uiContext = new UIContext(this.getUIContext().get((Object)"Owner"));
        uiContext.put((Object)"InitDataObject", (Object)this.targetReport);
        final IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(this.getTaxDraftRptUI(), (Map)uiContext, null, OprtState.VIEW);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                uiWindow.show();
            }
        });
    }

    protected String getTaxDraftRptUI() throws EASBizException, BOSException {
        RecordTypeEnum recordTypeEnum = RecordTypeEnum.getEnum(this.recordType);
        TaxItemTypeInfo taxItemTypeInfo = TaxItemTypeFactory.getRemoteInstance().getTaxItemTypeInfo(" where number='" + this.taxItemType + "'");
        String taxFlag = taxItemTypeInfo.getSimName();
        String recordType = recordTypeEnum.getName();
        return TDUtils.getTaxDraftRptUI(taxFlag, recordType);
    }

    public String getCompanyNumber() {
        return this.companyNumber;
    }

    public void setCompanyNumber(String companyNumber) {
        this.companyNumber = companyNumber;
    }

    public String getTaxItemType() {
        return this.taxItemType;
    }

    public void setTaxItemType(String taxItemType) {
        this.taxItemType = taxItemType;
    }

    public String getRecordType() {
        return this.recordType;
    }

    public void setRecordType(String recordType) {
        this.recordType = recordType;
    }

    public String getAccountConfig() {
        return this.accountConfig;
    }

    public void setAccountConfig(String accountConfig) {
        this.accountConfig = accountConfig;
    }

    public String getPeriodValue() {
        return this.periodValue;
    }

    public void setPeriodValue(String periodValue) {
        this.periodValue = periodValue;
    }

    public String getSheetName() {
        return this.sheetName;
    }

    public void setSheetName(String sheetName) {
        this.sheetName = sheetName;
    }

    public String getCellName() {
        return this.cellName;
    }

    public void setCellName(String cellName) {
        this.cellName = cellName;
    }
}

