/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.formula.relate.client;

import com.kingdee.bos.ctrl.swing.KDList;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.rpt.FormulaHint;
import com.kingdee.eas.fi.rpt.ReportBaseInfo;
import com.kingdee.eas.fi.rpt.RptSheetParamInfo;
import com.kingdee.eas.fi.rpt.util.RptUtil;
import com.kingdee.eas.tm.td.formula.relate.client.AbstractTaxFindLedger;
import com.kingdee.eas.tm.td.formula.relate.client.TaxFormulaStructure;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import org.apache.log4j.Logger;

public class TaxFindLedger
extends AbstractTaxFindLedger {
    private static final Logger logger = CoreUIObject.getLogger(TaxFindLedger.class);
    public static final String WINDOW_VISIBLE = "Window_Visible";
    ReportBaseInfo editdata;
    RptSheetParamInfo rptSheetParam;
    String type;
    String computeType;
    List formulaList = new ArrayList();
    static Set supportExamine = new HashSet();

    public void onLoad() throws Exception {
        super.onLoad();
        List expressions = (List)this.getUIContext().get("expressions");
        this.editdata = (ReportBaseInfo)this.getUIContext().get("report");
        this.rptSheetParam = (RptSheetParamInfo)this.getUIContext().get("rptSheetParam");
        this.type = (String)this.getUIContext().get("type");
        Vector<String> typeList = new Vector<String>();
        int size = expressions.size();
        for (int i = 0; i < size; ++i) {
            FormulaHint hint = (FormulaHint)expressions.get(i);
            TaxFormulaStructure formulaStructure = TaxFormulaStructure.getFormulaInstance(hint);
            this.formulaList.add(formulaStructure);
            if (typeList.contains(formulaStructure.formulaType)) continue;
            typeList.add(formulaStructure.formulaType);
        }
        this.cbxFormulaType.addItems(typeList);
        this.selfInitListener();
        if (typeList.size() > 0) {
            this.cbxFormulaType.setSelectedIndex(0);
            this.cbxTypeChange();
        }
        if (expressions.size() == 1) {
            this.actionEnter_actionPerformed(null);
        } else {
            boolean isFailure = this.checkFormulaType(typeList);
            if (isFailure) {
                this.getUIContext().put(WINDOW_VISIBLE, Boolean.FALSE);
                return;
            }
        }
    }

    public void open(TaxFormulaStructure formulaStructure) throws Exception {
        formulaStructure.setReport(this.editdata);
        formulaStructure.setRptSheetParam(this.rptSheetParam);
        formulaStructure.setParentUI(this);
        formulaStructure.setParentUI((CoreUIObject)this.getUIContext().get("Owner"));
        formulaStructure.setType(this.type);
        try {
            formulaStructure.open();
        }
        catch (EASBizException e) {
            MsgBox.showWarning((Component)((Object)this), (String)e.getMessage());
            return;
        }
    }

    public void selfInitListener() {
        this.cbxFormulaType.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    TaxFindLedger.this.cbxTypeChange();
                }
            }
        });
        this.lstFormula.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                KDList lst;
                if (e.getClickCount() == 2 && (lst = (KDList)e.getSource()).getSelectedIndex() > -1) {
                    try {
                        TaxFindLedger.this.actionEnter_actionPerformed(null);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
    }

    public void cbxTypeChange() {
        this.lstFormula.removeAllElements();
        String selectType = (String)this.cbxFormulaType.getSelectedItem();
        int size = this.formulaList.size();
        for (int i = 0; i < size; ++i) {
            if (!((TaxFormulaStructure)this.formulaList.get((int)i)).formulaType.equalsIgnoreCase(selectType)) continue;
            this.lstFormula.addElement(this.formulaList.get(i));
        }
        this.lstFormula.setSelectedIndex(0);
    }

    private boolean checkFormulaType(Vector typeList) {
        return true;
    }

    @Override
    public void actionEnter_actionPerformed(ActionEvent e) throws Exception {
        TaxFormulaStructure formulaStructure = (TaxFormulaStructure)this.lstFormula.getSelectedValue();
        if (formulaStructure == null) {
            MsgBox.showInfo((String)RptUtil.getResourceSince51((String)"PleaseChooseFormula"));
            return;
        }
        this.computeType = formulaStructure.getFormulaType();
        if (!this.isSupportExamine(this.computeType)) {
            MsgBox.showInfo((String)RptUtil.getResourceSince51((String)"NoSupportAssnThisKindFormula"));
            return;
        }
        this.disposeUIWindow();
        UIContext uiContext = new UIContext(this.getUIContext().get("Owner"));
        formulaStructure.setUIContext(uiContext);
        this.open(formulaStructure);
    }

    private boolean isSupportExamine(String computeType) {
        return computeType != null && supportExamine.contains(computeType.toUpperCase());
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.disposeUIWindow();
    }

    public String getUITitle() {
        return RptUtil.getResourceSince51((String)"FormulaAssn");
    }

    static {
        supportExamine.add("GETTDREPORTDATABYRULE");
    }
}

