/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.rpt.taxqing;

import com.google.gson.internal.LinkedTreeMap;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.json.JSONUtils;
import com.kingdee.bos.qing.preparedata.handler.controller.model.EntryEntity;
import com.kingdee.bos.qing.preparedata.handler.controller.model.Field;
import com.kingdee.bos.qingReport.common.utils.QingAnalysisFilterSynCacheUtil;
import com.kingdee.bos.qingReport.server.dataProvider.modelWrapper.QingData;
import com.kingdee.bos.qingReport.server.dataProvider.modelWrapper.QingMeta;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.tm.td.basedata.DataTypeEnum;
import com.kingdee.eas.tm.td.cloud.datamodel.ItemAnalysisFacadeFactory;
import com.kingdee.eas.tm.td.cloud.datamodel.ItemDimensionInfo;
import com.kingdee.eas.tm.td.cloud.utils.TDCloudUtil;
import com.kingdee.eas.tm.td.rpt.taxqing.AbstractTaxQingService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class ItemAnalysisTaxQingService
extends AbstractTaxQingService {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.td.rpt.app.taxqing.ItemAnalysisTaxQingDataFetchService");
    private ItemDimensionInfo dimensionInfo = null;
    private String analysisDimensionId = null;
    private String taxTypeId = null;
    private int statPeriod = 0;

    public ItemAnalysisTaxQingService(Context ctx) {
        super(ctx);
    }

    @Override
    protected void initParams(String tag) {
        super.initParams(tag);
        this.analysisDimensionId = this.tagItems[1];
        if (this.tagItems.length > 2) {
            this.taxTypeId = this.tagItems[2];
            this.statPeriod = Integer.parseInt(this.tagItems[3]);
        }
        try {
            this.dimensionInfo = TDCloudUtil.getItemDimensionInfo(null, this.analysisDimensionId);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
        }
    }

    @Override
    public QingMeta getQingMeta(String tag) {
        super.getQingMeta(tag);
        List headColumns = TDCloudUtil.getColumnsByDimension(this.dimensionInfo, this.taxTypeId, this.statPeriod);
        QingMeta qingMeta = new QingMeta();
        Map column = null;
        int size = headColumns.size();
        for (int i = 0; i < size; ++i) {
            column = (Map)headColumns.get(i);
            com.kingdee.bos.qingReport.server.dataProvider.modelWrapper.Field field = new com.kingdee.bos.qingReport.server.dataProvider.modelWrapper.Field();
            field.setAlias((String)column.get("label"));
            field.setName((String)column.get("name"));
            field.setFieldType(this.dataTypeToFieldType((DataTypeEnum)((Object)column.get("dataType"))).toNumber());
            field.setEntity("");
            field.setRefEntity("");
            field.setHide(((Boolean)column.get("hidden")).booleanValue());
            qingMeta.addColumn((Field)field);
            this.fields.add(field);
        }
        com.kingdee.bos.qingReport.server.dataProvider.modelWrapper.EntryEntity entityInfo = new com.kingdee.bos.qingReport.server.dataProvider.modelWrapper.EntryEntity();
        entityInfo.setAlias("");
        entityInfo.setName("");
        entityInfo.setParentName("");
        entityInfo.setPkFieldName("");
        qingMeta.addEntryEntity((EntryEntity)entityInfo);
        return qingMeta;
    }

    @Override
    public QingData getQingData(String tag, int startRow, int limit) {
        RptParams rpt;
        QingData qingData = new QingData();
        HashMap<String, Integer> dataIndex = new HashMap<String, Integer>();
        ArrayList<Object[]> dataList = new ArrayList<Object[]>();
        qingData.setDataindex(dataIndex);
        qingData.setRows(dataList);
        String filter = null;
        try {
            filter = QingAnalysisFilterSynCacheUtil.getFilter((String)tag);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage());
        }
        Map<String, Object> condition = null;
        if (!StringUtil.isEmptyString((String)filter)) {
            HashMap queryParams = null;
            try {
                queryParams = JSONUtils.convertJsonToObject((Context)this.ctx, (String)filter);
                condition = this.buildCondition(this.ctx, queryParams);
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage());
            }
        }
        if (condition == null) {
            return qingData;
        }
        String tempTable = null;
        RptParams params = new RptParams();
        params.clear();
        params.putAll(condition);
        if (tempTable == null || "".equals(tempTable)) {
            try {
                rpt = ItemAnalysisFacadeFactory.getRemoteInstance().createTempTable(params);
                tempTable = rpt.getString("tempTable");
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage());
            }
        }
        params.setString("tempTable", tempTable);
        params.setBoolean("isAll", true);
        params.setInt("FSeq", 99);
        rpt = null;
        try {
            rpt = ItemAnalysisFacadeFactory.getRemoteInstance().query(params, 0, 99999);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
        }
        if (rpt == null) {
            return qingData;
        }
        RptRowSet rs = (RptRowSet)rpt.getObject("rowset");
        Object[] rowData = null;
        String fieldName = null;
        int index = -1;
        while (rs.next()) {
            rowData = new Object[this.fields.size()];
            for (int i = 0; i < rs.getColumnCount(); ++i) {
                fieldName = rs.getColumnName(i).toUpperCase();
                index = this.getFieldIndex(fieldName);
                if (index < 0) continue;
                rowData[index] = rs.getObject(i);
                dataIndex.put(fieldName, index);
            }
            dataList.add(rowData);
        }
        return qingData;
    }

    private int getFieldIndex(String fieldName) {
        com.kingdee.bos.qingReport.server.dataProvider.modelWrapper.Field field = null;
        int size = this.fields.size();
        for (int i = 0; i < size; ++i) {
            field = (com.kingdee.bos.qingReport.server.dataProvider.modelWrapper.Field)this.fields.get(i);
            if (!fieldName.equals(field.getName())) continue;
            return i;
        }
        return -1;
    }

    private Map<String, Object> buildCondition(Context ctx, Map queryParams) {
        LinkedTreeMap map;
        if (queryParams.get("f7Company") != null) {
            HashSet<String> companyIdSet = new HashSet<String>();
            if (queryParams.get("f7Company") instanceof LinkedTreeMap) {
                LinkedTreeMap map2 = (LinkedTreeMap)queryParams.get("f7Company");
                companyIdSet.add(map2.get((Object)"id").toString());
            } else if (queryParams.get("f7Company") instanceof ArrayList) {
                ArrayList list = (ArrayList)queryParams.get("f7Company");
                for (int i = 0; i < list.size(); ++i) {
                    LinkedTreeMap map3 = (LinkedTreeMap)list.get(i);
                    companyIdSet.add(map3.get((Object)"id").toString());
                }
            }
            queryParams.put("companyIds", companyIdSet);
        }
        if (queryParams.get("f7Group") != null) {
            map = (LinkedTreeMap)queryParams.get("f7Group");
            queryParams.put("groupId", map.get((Object)"id").toString());
        }
        if (queryParams.get("f7AnalysisDimension") != null) {
            map = (LinkedTreeMap)queryParams.get("f7AnalysisDimension");
            queryParams.put("itemDimensionId", map.get((Object)"id").toString());
        }
        if (queryParams.get("f7TaxType") != null) {
            map = (LinkedTreeMap)queryParams.get("f7TaxType");
            queryParams.put("taxTypeId", map.get((Object)"id").toString());
        }
        int dimType = 0;
        HashSet<String> dimIdSet = new HashSet<String>();
        if (queryParams.get("f7District") != null) {
            dimType = 5;
            dimIdSet.addAll(this.getF7Value(queryParams, "f7District"));
        } else if (queryParams.get("f7City") != null) {
            dimType = 4;
            dimIdSet.addAll(this.getF7Value(queryParams, "f7City"));
        } else if (queryParams.get("f7Region") != null) {
            dimType = 3;
            dimIdSet.addAll(this.getF7Value(queryParams, "f7Region"));
        } else if (queryParams.get("f7Area") != null) {
            dimType = 2;
            dimIdSet.addAll(this.getF7Value(queryParams, "f7Area"));
        } else if (queryParams.get("f7Country") != null) {
            LinkedTreeMap map4 = (LinkedTreeMap)queryParams.get("f7Country");
            queryParams.put("countryId", map4.get((Object)"id").toString());
            dimType = 1;
            dimIdSet.add(map4.get((Object)"id").toString());
        }
        queryParams.put("dimType", dimType);
        queryParams.put("dimIdSet", dimIdSet);
        return queryParams;
    }

    private Set getF7Value(Map queryParams, String fieldName) {
        HashSet<String> ids = null;
        if (queryParams.get(fieldName) != null) {
            ids = new HashSet<String>();
            if (queryParams.get(fieldName) instanceof LinkedTreeMap) {
                LinkedTreeMap map = (LinkedTreeMap)queryParams.get(fieldName);
                ids.add(map.get((Object)"id").toString());
            } else if (queryParams.get(fieldName) instanceof ArrayList) {
                ArrayList list = (ArrayList)queryParams.get(fieldName);
                for (int i = 0; i < list.size(); ++i) {
                    LinkedTreeMap map = (LinkedTreeMap)list.get(i);
                    ids.add(map.get((Object)"id").toString());
                }
            }
        }
        return ids;
    }

    @Override
    public void disposeProvider(String tag) {
    }

    @Override
    public String setQingFilter(String tag, String filter) {
        return null;
    }

    @Override
    public String getQingFilter(String tag) throws EASBizException, BOSException {
        return null;
    }
}

