/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.solutionmgr.impexp.processor;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.FMIsqlFacadeFactory;
import com.kingdee.eas.tm.td.solutionmgr.SolutionMgrFacadeFactory;
import com.kingdee.eas.tm.td.solutionmgr.impexp.util.FileUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ImpProcessor {
    private String solutionMgrNumber = null;
    private String tableFileName = null;
    private String tableIdFileName = null;
    private List<String> blobFileList = new ArrayList<String>();
    private String basePath = null;
    private String tblName = null;
    private int pageNo = 0;
    private int importType;
    private String tableId = null;
    private Map<String, List<String>> columnFileMap = null;

    public ImpProcessor(int importType, Map params) {
        this.tableFileName = (String)params.get("tableFileName");
        this.tableIdFileName = (String)params.get("tableIdFileName");
        this.blobFileList = (List)params.get("blobFileList");
        this.solutionMgrNumber = (String)params.get("solutionMgrNumber");
        this.basePath = (String)params.get("basePath");
        this.importType = importType;
        this.init();
    }

    private void init() {
        String[] key = FileUtil.getFileNoSuffix(this.tableFileName).split("-");
        this.tblName = key[0];
        this.pageNo = Integer.parseInt(key[1]);
    }

    public void execute() throws BOSException, EASBizException {
        this.beforeExecute();
        this.doExecute();
        this.afterExecute();
    }

    private void beforeExecute() throws BOSException, EASBizException {
        if (this.isMainTable() && 1 == this.importType || this.blobFileList != null && this.blobFileList.size() > 0) {
            this.tableId = FileUtil.readFile2String(this.basePath + File.separator + this.tableIdFileName);
        }
        if (this.isMainTable() && 1 == this.importType) {
            this.deleteOldData(this.solutionMgrNumber, this.tableId);
        }
        this.columnFileMap = new HashMap<String, List<String>>();
        String fileName = null;
        String columnName = null;
        if (this.blobFileList != null && this.blobFileList.size() > 0) {
            int size = this.blobFileList.size();
            for (int i = 0; i < size; ++i) {
                fileName = this.blobFileList.get(i);
                columnName = fileName.split("-")[2];
                if (!this.columnFileMap.containsKey(columnName)) {
                    this.columnFileMap.put(columnName, new ArrayList());
                }
                this.columnFileMap.get(columnName).add(fileName);
            }
        }
    }

    private boolean isMainTable() {
        if (this.tableIdFileName == null) {
            return false;
        }
        String[] keys = this.tableIdFileName.split("-");
        return keys.length == 4;
    }

    private void deleteOldData(String solutionMgrNumber, String mainTableId) throws EASBizException, BOSException {
        SolutionMgrFacadeFactory.getRemoteInstance().deleteOldData(solutionMgrNumber, mainTableId);
    }

    private void doExecute() throws BOSException, EASBizException {
        String sql = FileUtil.readFile2String(this.basePath + File.separator + this.tableFileName);
        this.executeSql(sql);
        if (this.blobFileList != null && this.blobFileList.size() > 0) {
            Map data = this.readBlobFile();
            this.updateBlob(this.tblName, data);
        }
    }

    private Map readBlobFile() throws BOSException {
        String columnName2 = null;
        List<String> fileList = null;
        String fileName = null;
        String fileNoSuffix = null;
        byte[] data = null;
        String[] ids = this.tableId.split(",");
        HashMap blobData = new HashMap();
        HashMap blobId = new HashMap();
        int index = -1;
        for (String columnName2 : this.columnFileMap.keySet()) {
            fileList = this.columnFileMap.get(columnName2);
            blobData.put(columnName2, new ArrayList());
            blobId.put(columnName2, new ArrayList());
            int size = fileList.size();
            for (int i = 0; i < size; ++i) {
                fileName = fileList.get(i);
                fileNoSuffix = FileUtil.getFileNoSuffix(fileName);
                index = Integer.parseInt(fileNoSuffix.substring(fileNoSuffix.lastIndexOf("-") + 1, fileNoSuffix.length()));
                data = FileUtil.readFile2Byte(this.basePath + File.separator + fileName);
                ((List)blobData.get(columnName2)).add(data);
                ((List)blobId.get(columnName2)).add(ids[index]);
            }
        }
        HashMap ret = new HashMap();
        ret.put("blobId", blobId);
        ret.put("blobData", blobData);
        return ret;
    }

    private void executeSql(String sql) throws EASBizException, BOSException {
        FMIsqlFacadeFactory.getRemoteInstance().executeSql(sql);
    }

    private void updateBlob(String tblName, Map data) throws EASBizException, BOSException {
        SolutionMgrFacadeFactory.getRemoteInstance().updateBlob(tblName, data);
    }

    private void afterExecute() throws BOSException, EASBizException {
    }
}

