/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.structure.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.newrpt.client.designer.SpreadManager;
import com.kingdee.eas.fi.rpt.TableToolkit;
import com.kingdee.eas.tm.td.TDUtils;
import com.kingdee.eas.tm.td.TaxDraftRecordInfo;
import com.kingdee.eas.tm.td.basedata.DataTypeEnum;
import com.kingdee.eas.tm.td.cloud.utils.TDCloudUtil;
import com.kingdee.eas.tm.td.structure.ReportItemDimensionEnum;
import com.kingdee.eas.tm.td.structure.TaxReportItemInfo;
import com.kingdee.eas.tm.td.structure.TaxReportSheetCollection;
import com.kingdee.eas.tm.td.structure.TaxReportSheetFactory;
import com.kingdee.eas.tm.td.structure.TaxReportSheetInfo;
import com.kingdee.eas.tm.td.structure.TaxReportTemplateInfo;
import com.kingdee.eas.tm.td.structure.TaxValueTypeEnum;
import com.kingdee.eas.tm.td.structure.client.AbstractTaxReportItemFormulaEditUI;
import com.kingdee.eas.tm.td.structure.client.TaxReportItemSelectedUI;
import com.kingdee.eas.tm.td.structure.utils.StructureUtils;
import com.kingdee.eas.tm.td.structure.utils.TaxItemFormula;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class TaxReportItemFormulaEditUI
extends AbstractTaxReportItemFormulaEditUI {
    private static final Logger logger = CoreUIObject.getLogger(TaxReportItemFormulaEditUI.class);
    private static final String COL_NUMBER = "number";
    private static final String COL_NAME = "name";
    private static final String COL_ID = "id";
    private static final String COL_OBJECT = "object";
    private boolean isNormalDim = true;
    private DataChangeListener reportSheetChangeListener = null;
    private TaxReportSheetInfo tempSheetInfo = null;
    private IObjectValue editData = null;
    private boolean isCanceled = true;
    private SpreadManager spreadManager = null;
    private Sheet rptSheet = null;

    protected void initListener() {
        this.reportSheetChangeListener = new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                if (TDCloudUtil.isEqual(e.getNewValue(), e.getOldValue())) {
                    return;
                }
                try {
                    TaxReportItemFormulaEditUI.this.reportSheet_dataChanged(e);
                }
                catch (Exception e1) {
                    TaxReportItemFormulaEditUI.this.handleException(e1);
                }
            }
        };
        this.prmtReportSheet.addDataChangeListener(this.reportSheetChangeListener);
    }

    protected void reportSheet_dataChanged(DataChangeEvent e) throws Exception {
        if (this.prmtReportSheet.getValue() == null) {
            return;
        }
        if (TDCloudUtil.isEqual(e.getNewValue(), e.getOldValue())) {
            return;
        }
        TaxReportSheetInfo sheetInfo = (TaxReportSheetInfo)this.prmtReportSheet.getValue();
        if (this.tempSheetInfo != null && !this.tempSheetInfo.getId().equals((Object)sheetInfo.getId()) && this.hasVolidData()) {
            int flag = MsgBox.showConfirm2((Component)((Object)this), (String)TDUtils.getString("com.kingdee.eas.tm.td.structure.TaxStructureResource", "ChangeReportSheet", TDUtils.getLocale()));
            if (flag == 0) {
                this.clearData();
            } else {
                this.prmtReportSheet.setValue(e.getOldValue());
                SysUtil.abort();
            }
        }
        this.tempSheetInfo = (TaxReportSheetInfo)this.prmtReportSheet.getValue();
    }

    protected boolean hasVolidData() {
        return this.rowTable.getRowCount() > 0 || this.columnTable.getRowCount() > 0;
    }

    protected void clearData() {
        this.rowTable.removeRows();
        this.columnTable.removeRows();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initContext();
        this.initControl();
        this.setF7Filter();
        this.setDefaultValue();
    }

    protected void setF7Filter() {
        if (this.editData instanceof TaxReportTemplateInfo) {
            TaxReportTemplateInfo templateInfo = (TaxReportTemplateInfo)this.editData;
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("taxType.id", (Object)templateInfo.getTaxType().getId(), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("recordType", (Object)templateInfo.getRecordType().getValue(), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("state", (Object)"2", CompareType.EQUALS));
            view.setFilter(filter);
            this.prmtReportSheet.setEntityViewInfo(view);
        } else if (this.editData instanceof TaxDraftRecordInfo) {
            TaxDraftRecordInfo reportInfo = (TaxDraftRecordInfo)this.editData;
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("taxType.id", (Object)reportInfo.getTaxType().getId(), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("recordType", (Object)reportInfo.getRecordType().getValue(), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("state", (Object)"2", CompareType.EQUALS));
            view.setFilter(filter);
            this.prmtReportSheet.setEntityViewInfo(view);
        }
    }

    protected void setDefaultValue() throws EASBizException, BOSException {
        if (this.editData instanceof TaxReportTemplateInfo) {
            TaxReportTemplateInfo templateInfo = (TaxReportTemplateInfo)this.editData;
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("taxType.id", (Object)templateInfo.getTaxType().getId(), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("recordType", (Object)templateInfo.getRecordType().getValue(), CompareType.EQUALS));
            view.setFilter(filter);
            TaxReportSheetCollection sheetColl = TaxReportSheetFactory.getRemoteInstance().getTaxReportSheetCollection(view);
            if (sheetColl.size() > 0) {
                this.prmtReportSheet.setValue((Object)sheetColl.get(0));
            }
        } else if (this.editData instanceof TaxDraftRecordInfo) {
            TaxDraftRecordInfo reportInfo = (TaxDraftRecordInfo)this.editData;
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("taxType.id", (Object)reportInfo.getTaxType().getId(), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("recordType", (Object)reportInfo.getRecordType().getValue(), CompareType.EQUALS));
            view.setFilter(filter);
            TaxReportSheetCollection sheetColl = TaxReportSheetFactory.getRemoteInstance().getTaxReportSheetCollection(view);
            if (sheetColl.size() > 0) {
                this.prmtReportSheet.setValue((Object)sheetColl.get(0));
            }
        }
        this.cbDataType.setSelectedItem((Object)DataTypeEnum.Amount);
    }

    protected void initContext() {
        this.rptSheet = (Sheet)this.getUIContext().get("rptSheet");
        this.spreadManager = (SpreadManager)this.getUIContext().get("spreadManager");
        this.editData = (IObjectValue)this.getUIContext().get("editData");
    }

    protected void initControl() {
        this.prmtReportSheet.setHistoryRecordEnabled(false);
        this.rowTable.getSelectManager().setSelectMode(2);
        this.columnTable.getSelectManager().setSelectMode(2);
        int top = this.rptSheet.getActiveRow();
        int left = this.rptSheet.getActiveCol();
        top = top < 0 ? 0 : top;
        left = left < 0 ? 0 : left;
        this.txtPosition.setText(TableToolkit.xy2range((int)left, (int)top));
    }

    private void checkSelected() {
        if (this.prmtReportSheet.getValue() == null) {
            MsgBox.showInfo((String)TDUtils.getString("com.kingdee.eas.tm.td.structure.TaxStructureResource", "INPUTREPORTSHEET", TDUtils.getLocale()));
            this.prmtReportSheet.requestFocus();
            SysUtil.abort();
        }
    }

    @Override
    public void actionRowEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"reportSheet", (Object)this.getReportSheetInfo());
        uiContext.put((Object)"itemDimension", (Object)this.getItemDimension(true));
        uiContext.put((Object)"rptItemSelected", this.getRptItemListFromTable(this.rowTable));
        IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
        IUIWindow window = uiFactory.create(TaxReportItemSelectedUI.class.getName(), (Map)uiContext, null, this.getOprtState());
        window.show();
        TaxReportItemSelectedUI selectUI = (TaxReportItemSelectedUI)window.getUIObject();
        if (!selectUI.isCanceled()) {
            this.addArrayListToTable(selectUI.getRptArrSelected(), this.rowTable);
        }
    }

    protected TaxReportSheetInfo getReportSheetInfo() {
        return (TaxReportSheetInfo)this.prmtReportSheet.getValue();
    }

    protected ReportItemDimensionEnum getItemDimension(boolean isRow) {
        if (isRow && this.isNormalDim || !isRow && !this.isNormalDim) {
            return ReportItemDimensionEnum.ROW;
        }
        return ReportItemDimensionEnum.COLUMN;
    }

    private void addArrayListToTable(List rptArr, KDTable table) {
        table.checkParsed();
        table.removeRows();
        table.getStyleAttributes().setLocked(true);
        int count = rptArr.size();
        TaxReportItemInfo info = null;
        IRow row = null;
        for (int i = 0; i < count; ++i) {
            info = (TaxReportItemInfo)rptArr.get(i);
            row = table.addRow();
            row.getCell(COL_NUMBER).setValue((Object)info.getNumber());
            row.getCell(COL_NAME).setValue((Object)info.getName());
            row.getCell(COL_ID).setValue((Object)info.getId().toString());
            row.getCell(COL_OBJECT).setValue((Object)info);
        }
    }

    public List<TaxReportItemInfo> getRptItemListFromTable(KDTable table) {
        ArrayList<TaxReportItemInfo> rptItemSelected = new ArrayList<TaxReportItemInfo>();
        IRow row = null;
        TaxReportItemInfo info = null;
        for (int i = 0; i < table.getRowCount(); ++i) {
            row = table.getRow(i);
            info = (TaxReportItemInfo)row.getCell(COL_OBJECT).getValue();
            rptItemSelected.add(info);
        }
        return rptItemSelected;
    }

    protected String getSelectedUI() {
        return TaxReportItemSelectedUI.class.getName();
    }

    @Override
    public void actionColumnEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"reportSheet", (Object)this.getReportSheetInfo());
        uiContext.put((Object)"itemDimension", (Object)this.getItemDimension(false));
        uiContext.put((Object)"rptItemSelected", this.getRptItemListFromTable(this.columnTable));
        IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
        IUIWindow window = uiFactory.create(TaxReportItemSelectedUI.class.getName(), (Map)uiContext, null, this.getOprtState());
        window.show();
        TaxReportItemSelectedUI selectUI = (TaxReportItemSelectedUI)window.getUIObject();
        if (!selectUI.isCanceled()) {
            this.addArrayListToTable(selectUI.getRptArrSelected(), this.columnTable);
        }
    }

    @Override
    public void actionChangeDim_actionPerformed(ActionEvent e) throws Exception {
        this.isNormalDim = !this.isNormalDim;
        List<TaxReportItemInfo> rowList = this.getRptItemListFromTable(this.rowTable);
        List<TaxReportItemInfo> columnList = this.getRptItemListFromTable(this.columnTable);
        this.addArrayListToTable(rowList, this.columnTable);
        this.addArrayListToTable(columnList, this.rowTable);
    }

    private void checkRequiredFields() {
        StringBuffer sb = new StringBuffer();
        if (this.rowTable.getRowCount() == 0) {
            sb.append(TDUtils.getString("com.kingdee.eas.tm.td.structure.TaxStructureResource", "RowDim", TDUtils.getLocale()));
        }
        if (this.columnTable.getRowCount() == 0) {
            if (sb.length() > 0) {
                sb.append("\u3001");
            }
            sb.append(TDUtils.getString("com.kingdee.eas.tm.td.structure.TaxStructureResource", "ColumnDim", TDUtils.getLocale()));
        }
        if (sb.length() > 0) {
            sb.append(TDUtils.getString("com.kingdee.eas.tm.td.structure.TaxStructureResource", "NotNull", TDUtils.getLocale()));
            MsgBox.showInfo((String)sb.toString());
            SysUtil.abort();
        }
        this.checkItemFormulaUnique();
    }

    private void checkItemFormulaUnique() {
        TaxReportSheetInfo sheetInfo = (TaxReportSheetInfo)this.prmtReportSheet.getValue();
        List<TaxReportItemInfo> rowList = this.getRowData();
        List<TaxReportItemInfo> columnList = this.getColumnData();
        Map itemData = StructureUtils.getItemformulaByBook(this.spreadManager.getSpreadContainer().getBook());
        TaxReportItemInfo rowItem2 = null;
        TaxReportItemInfo columnItem = null;
        StringBuffer key = new StringBuffer();
        StringBuffer sb = new StringBuffer();
        for (TaxReportItemInfo rowItem2 : rowList) {
            int size = columnList.size();
            for (int i = 0; i < size; ++i) {
                columnItem = columnList.get(i);
                key.setLength(0);
                key.append(sheetInfo.getNumber()).append("_");
                key.append(rowItem2.getNumber()).append("_");
                key.append(columnItem.getNumber());
                TaxItemFormula itemFormula = (TaxItemFormula)itemData.get(key.toString());
                if (itemFormula == null) continue;
                sb.append(TDUtils.getString("com.kingdee.eas.tm.td.structure.TaxStructureResource", "BatchSaveItemFormulaDetailEror", TDUtils.getLocale(), new Object[]{sheetInfo.getNumber(), rowItem2.getNumber(), columnItem.getNumber()})).append("\n");
            }
        }
        String error = TDUtils.getString("com.kingdee.eas.tm.td.structure.TaxStructureResource", "BatchSaveItemFormulaError", TDUtils.getLocale());
        String errorDetail = sb.toString();
        if (sb.length() > 0) {
            MsgBox.showDetailAndOK((Component)((Object)this), (String)error, (String)errorDetail, (int)8188);
            SysUtil.abort();
        }
    }

    @Override
    public void actionOK_actionPerformed(ActionEvent e) throws Exception {
        int i;
        int rowsize;
        this.checkRequiredFields();
        Point startP = this.getStartPos();
        int left = startP.x;
        int top = startP.y;
        List<TaxReportItemInfo> rowList = this.getRowData();
        List<TaxReportItemInfo> columnList = this.getColumnData();
        TaxReportSheetInfo sheetInfo = (TaxReportSheetInfo)this.prmtReportSheet.getValue();
        TaxValueTypeEnum valueType = (TaxValueTypeEnum)((Object)this.cbDataType.getSelectedItem());
        TaxReportItemInfo rowData = null;
        TaxReportItemInfo columnData = null;
        int spanRow = 0;
        int spanColumn = 0;
        if (this.cbShowTitle.isSelected()) {
            CellBlock cellBlock;
            rowsize = rowList.size();
            for (i = 0; i < rowsize; ++i) {
                rowData = rowList.get(i);
                this.rptSheet.getRange(top + i + 1 + spanRow, left).setValue(new Variant((Object)rowData.getName()));
                cellBlock = this.rptSheet.getMergeBlock(top + i + 1 + spanRow, left);
                if (cellBlock == null) continue;
                spanRow += cellBlock.getHeight() - 1;
                spanColumn += cellBlock.getWidth() - 1;
            }
            int columnsize = columnList.size();
            for (i = 0; i < columnsize; ++i) {
                columnData = columnList.get(i);
                this.rptSheet.getRange(top, left + i + 1).setValue(new Variant((Object)columnData.getName()));
                cellBlock = this.rptSheet.getMergeBlock(top, left + i + 1 + spanColumn);
                if (cellBlock == null) continue;
                spanRow += cellBlock.getHeight() - 1;
                spanColumn += cellBlock.getWidth() - 1;
            }
            ++left;
            ++top;
        }
        rowsize = rowList.size();
        for (i = 0; i < rowsize; ++i) {
            rowData = rowList.get(i);
            spanRow = 0;
            spanColumn = 0;
            int columnsize = columnList.size();
            for (int j = 0; j < columnsize; ++j) {
                columnData = columnList.get(j);
                String itemFormula = StructureUtils.constructFormula(sheetInfo, rowData, columnData, valueType);
                Range cell = this.rptSheet.getRange(top + i + spanRow, left + j + spanColumn);
                CellBlock cellBlock = this.rptSheet.getMergeBlock(top + i + spanRow, left + j + spanColumn);
                if (cellBlock != null) {
                    spanRow += cellBlock.getHeight() - 1;
                    spanColumn += cellBlock.getWidth() - 1;
                }
                cell.setUserObject("TAXITEM", (Object)new TaxItemFormula(itemFormula));
            }
        }
        this.getSpreadManager().getSpreadContainer().repaint();
        this.isCanceled = false;
        this.destroyWindow();
    }

    public SpreadManager getSpreadManager() {
        return this.spreadManager;
    }

    private Point getStartPos() {
        String str = this.txtPosition.getText();
        Range range = this.rptSheet.getRange(str, true);
        if (range == null || range.getBlock(0).getCol() < 0 || range.getBlock(0).getRow() < 0) {
            MsgBox.showError((String)TDUtils.getString("com.kingdee.eas.tm.td.structure.TaxStructureResource", "FillError", TDUtils.getLocale()));
            SysUtil.abort();
        }
        Point p = new Point(range.getBlock(0).getCol(), range.getBlock(0).getRow());
        return p;
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.isCanceled = true;
        this.getUIWindow().close();
    }

    public boolean isCanceled() {
        return this.isCanceled;
    }

    public List<TaxReportItemInfo> getRowData() {
        return this.getRptItemListFromTable(this.rowTable);
    }

    public List<TaxReportItemInfo> getColumnData() {
        return this.getRptItemListFromTable(this.columnTable);
    }
}

