/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.structure.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.SimpleTextRender;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.BizEnumValueDTO;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.IQuerySolutionFacade;
import com.kingdee.eas.base.commonquery.QuerySolutionFacadeFactory;
import com.kingdee.eas.base.commonquery.ShareTypeEnum;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.IProcessor;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.ITreeBase;
import com.kingdee.eas.framework.TreeBaseInfo;
import com.kingdee.eas.framework.batchHandler.UtilRequest;
import com.kingdee.eas.framework.client.ListUI;
import com.kingdee.eas.framework.client.tree.ILNTreeNodeCtrl;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.framework.client.tree.TreeBuilderFactory;
import com.kingdee.eas.framework.query.QuickFilteringSupportItems;
import com.kingdee.eas.framework.query.QuickFilteringSupportManager;
import com.kingdee.eas.framework.util.FilterUtility;
import com.kingdee.eas.tm.td.FilterCommonStatusEnum;
import com.kingdee.eas.tm.td.RecordTypeEnum;
import com.kingdee.eas.tm.td.TDUtils;
import com.kingdee.eas.tm.td.basedata.TaxItemTypeFactory;
import com.kingdee.eas.tm.td.basedata.TaxItemTypeInfo;
import com.kingdee.eas.tm.td.cloud.utils.TDCloudUtil;
import com.kingdee.eas.tm.td.common.permsupport.IPermSupport4ListUI;
import com.kingdee.eas.tm.td.common.uihelper.ListUIHelper;
import com.kingdee.eas.tm.td.structure.ReportItemDimensionEnum;
import com.kingdee.eas.tm.td.structure.TaxReportItemFactory;
import com.kingdee.eas.tm.td.structure.TaxReportSheetFactory;
import com.kingdee.eas.tm.td.structure.TaxReportSheetInfo;
import com.kingdee.eas.tm.td.structure.client.AbstractTaxReportItemTreeListUI;
import com.kingdee.eas.tm.td.structure.client.TaxReportItemFilterUI;
import com.kingdee.eas.tm.td.structure.utils.StructureCommonProcessor;
import com.kingdee.eas.tm.td.structure.utils.StructureUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.enums.IntEnum;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class TaxReportItemTreeListUI
extends AbstractTaxReportItemTreeListUI
implements IPermSupport4ListUI {
    private static final Logger logger = CoreUIObject.getLogger(TaxReportItemTreeListUI.class);
    public static final String TBL_STATE = "state";
    public static final String TBL_ISSCHEDULED = "isScheduled";
    private TreeSelectionListener treeSelectionListener;
    private final Color freezeColor = new Color(232, 232, 227);
    AccountTreeRender treeRender;
    boolean flag = false;
    private EntityViewInfo commonQuery = null;
    private DataChangeListener taxTypeChangeListener = null;
    private ItemListener recordTypeChangeListener = null;
    private DataChangeListener reportSheetChangeListener = null;
    private ItemListener itemDimChangeListener = null;
    private ListUIHelper uiHelper = null;
    private String currentCUID;
    QuickFilteringSupportItems qfsi = new QuickFilteringSupportItems(true, true);

    public void onLoad() throws Exception {
        this.actionQuery.setVisible(false);
        this.tblMain.checkParsed();
        super.onLoad();
        this.afterLoad();
        this.uiHelper = new ListUIHelper((ListUI)this);
        this.currentCUID = SysContext.getSysContext().getCurrentCtrlUnit().getId().toString();
    }

    protected void initListener() {
        super.initListener();
        this.tblMain.addKDTDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                int start = e.getFirstRow();
                int end = e.getLastRow();
                if (!TaxReportItemTreeListUI.this.flag) {
                    TaxReportItemTreeListUI.this.setTreeDisplayStyle(start, end + 1);
                }
            }
        });
        this.taxTypeChangeListener = new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                if (TDCloudUtil.isEqual(e.getNewValue(), e.getOldValue())) {
                    return;
                }
                try {
                    TaxReportItemTreeListUI.this.taxType_dataChanged(e);
                }
                catch (Exception e1) {
                    TaxReportItemTreeListUI.this.handleException(e1);
                }
            }
        };
        this.prmtTaxType.addDataChangeListener(this.taxTypeChangeListener);
        this.recordTypeChangeListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                try {
                    TaxReportItemTreeListUI.this.recordType_dataChanged(e);
                }
                catch (Exception e1) {
                    TaxReportItemTreeListUI.this.handleException(e1);
                }
            }
        };
        this.comboRecordType.addItemListener(this.recordTypeChangeListener);
        this.reportSheetChangeListener = new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                if (TDCloudUtil.isEqual(e.getNewValue(), e.getOldValue())) {
                    return;
                }
                try {
                    TaxReportItemTreeListUI.this.reportSheet_dataChanged(e);
                }
                catch (Exception e1) {
                    TaxReportItemTreeListUI.this.handleException(e1);
                }
            }
        };
        this.prmtReportSheet.addDataChangeListener(this.reportSheetChangeListener);
        this.itemDimChangeListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                try {
                    TaxReportItemTreeListUI.this.itemDim_dataChanged(e);
                }
                catch (Exception e1) {
                    TaxReportItemTreeListUI.this.handleException(e1);
                }
            }
        };
        this.comboItemDimension.addItemListener(this.itemDimChangeListener);
    }

    protected void taxType_dataChanged(DataChangeEvent e) throws Exception {
        this.prmtReportSheet.removeDataChangeListener(this.reportSheetChangeListener);
        this.prmtReportSheet.setValue(null);
        this.setReportSheetF7Filter();
        this.initTree();
        this.treeMain_valueChanged(null);
        this.treeMain.setSelectionRow(0);
        this.prmtReportSheet.addDataChangeListener(this.reportSheetChangeListener);
    }

    protected void recordType_dataChanged(ItemEvent e) throws Exception {
        this.prmtReportSheet.removeDataChangeListener(this.reportSheetChangeListener);
        this.prmtReportSheet.setValue(null);
        this.setReportSheetF7Filter();
        this.initTree();
        this.treeMain_valueChanged(null);
        this.treeMain.setSelectionRow(0);
        this.prmtReportSheet.addDataChangeListener(this.reportSheetChangeListener);
    }

    protected void reportSheet_dataChanged(DataChangeEvent e) throws Exception {
        this.initTree();
        this.treeMain_valueChanged(null);
        this.treeMain.setSelectionRow(0);
    }

    protected void itemDim_dataChanged(ItemEvent e) throws Exception {
        this.initTree();
        this.treeMain_valueChanged(null);
        this.treeMain.setSelectionRow(0);
    }

    protected void setReportSheetF7Filter() {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        Object value = this.prmtTaxType.getValue();
        if (value != null && value instanceof TaxItemTypeInfo) {
            TaxItemTypeInfo taxType = (TaxItemTypeInfo)value;
            filter.getFilterItems().add(new FilterItemInfo("taxType.id", (Object)taxType.getId().toString(), CompareType.EQUALS));
        }
        if ((value = this.comboRecordType.getSelectedItem()) != null && value instanceof RecordTypeEnum) {
            RecordTypeEnum recordType = (RecordTypeEnum)((Object)value);
            filter.getFilterItems().add(new FilterItemInfo("recordType", (Object)recordType.getValue(), CompareType.EQUALS));
        }
        filter.getFilterItems().add(new FilterItemInfo(TBL_STATE, (Object)"2", CompareType.EQUALS));
        view.setFilter(filter);
        this.prmtReportSheet.setEntityViewInfo(view);
    }

    private void setTreeDisplayStyle(int start, int end) {
        int count = end;
        for (int i = start; i < count; ++i) {
            Object numberValue;
            boolean isCFreeze;
            IRow row = this.tblMain.getRow(i);
            if (row == null) continue;
            if (row.getCell("isCFreeze") != null && (isCFreeze = ((Boolean)row.getCell("isCFreeze").getValue()).booleanValue())) {
                row.getStyleAttributes().setBackground(this.freezeColor);
            }
            String id = (String)row.getCell("id").getValue();
            int level = 1;
            if (row.getCell("level").getValue() != null && row.getCell("level").getValue() instanceof Integer) {
                level = (Integer)row.getCell("level").getValue();
            }
            if (!((numberValue = row.getCell("number").getValue()) instanceof String)) {
                return;
            }
            String acctNumber = (String)numberValue;
            boolean isAcctLeaf = false;
            if (row.getCell("isLeaf").getValue() != null && row.getCell("isLeaf").getValue() instanceof Boolean) {
                isAcctLeaf = (Boolean)row.getCell("isLeaf").getValue();
            }
            NumberExpandInfo acctNumberExpandInfo = new NumberExpandInfo();
            acctNumberExpandInfo.setAcctId(id);
            acctNumberExpandInfo.setLevel(level);
            acctNumberExpandInfo.setLeaf(isAcctLeaf);
            acctNumberExpandInfo.setNumber(acctNumber);
            acctNumberExpandInfo.setExpandStatus(true);
            row.getCell("number").setValue((Object)acctNumberExpandInfo);
        }
    }

    protected String getKeyFieldName() {
        return "id";
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnCancel.setEnabled(true);
        this.btnCancelCancel.setEnabled(true);
        this.btnCancel.setVisible(true);
        this.btnCancelCancel.setVisible(true);
    }

    protected void afterLoad() throws BOSException, EASBizException {
        this.actionQuery.setVisible(true);
        this.initControl();
        this.setDefaultValue();
        this.treeRender = new AccountTreeRender();
        this.tblMain.getColumn("number").setRenderer((IBasicRender)this.treeRender);
        IQuerySolutionFacade iQuery = QuerySolutionFacadeFactory.getRemoteInstance();
        String queryName = TaxReportItemTreeListUI.getQueryInfo((IMetaDataPK)this.mainQueryPK).getFullName();
        EntityViewInfo ev = (EntityViewInfo)iQuery.getDefaultFilterInfo(this.getClass().getName(), queryName);
        EntityViewInfo tempQuery = null;
        if (ev == null) {
            ev = new EntityViewInfo();
        }
        if (ev != null) {
            tempQuery = this.getEntityViewInfo(ev);
        }
        this.buildTreeFilter();
        if (tempQuery != null && FilterUtility.hasFilterItem((FilterInfo)this.mainQuery.getFilter())) {
            this.mainQuery = tempQuery;
        }
        if (this.getCurrentOrder() != null) {
            this.mainQuery.getSorter().add(this.getCurrentOrder());
        } else {
            this.mainQuery.getSorter().add(new SorterItemInfo(this.getLongNumberFieldName()));
        }
        this.execQuery();
        this.setIncludeAllChildren(true);
        this.tblMain.getViewManager().setFreezeView(0, 3);
    }

    private void initControl() {
        this.comboItemDimension.removeAllItems();
        this.comboItemDimension.addItem((Object)FilterCommonStatusEnum.NULL);
        this.comboItemDimension.addItems(ReportItemDimensionEnum.getEnumList().toArray());
        this.comboRecordType.removeAllItems();
        this.comboRecordType.addItem((Object)FilterCommonStatusEnum.NULL);
        this.comboRecordType.addItems(RecordTypeEnum.getEnumList().toArray());
        StructureUtils.setTaxTypeFilter(this.prmtTaxType);
    }

    private void setDefaultValue() throws EASBizException, BOSException {
        TaxItemTypeInfo taxTypeInfo = TaxItemTypeFactory.getRemoteInstance().getTaxItemTypeInfo((IObjectPK)new ObjectUuidPK("Xip0em3cA6rgU0ETqMAGKduK96Y="));
        this.prmtTaxType.setValue((Object)taxTypeInfo);
        this.comboRecordType.setSelectedItem((Object)RecordTypeEnum.TaxDeclare);
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        EntityViewInfo view = (EntityViewInfo)viewInfo.clone();
        FilterInfo filter = this.getTreeFilter();
        try {
            if (view.getFilter() == null) {
                view.setFilter(filter);
            } else {
                view.getFilter().mergeFilter(filter, "and");
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return super.getQueryExecutor(queryPK, view);
    }

    public void actionQuery_actionPerformed(ActionEvent evt) throws Exception {
        super.actionQuery_actionPerformed(evt);
        this.commonQuery = (EntityViewInfo)this.mainQuery.clone();
        this.loadData();
    }

    protected void buildTreeFilter() {
        KDTreeNode treeNode = this.getSelectedTreeNode();
        if (treeNode == null || this.mainQuery == null) {
            return;
        }
        if (this.mainQuery.getFilter() == null) {
            this.mainQuery.setFilter(new FilterInfo());
        }
        FilterItemCollection col = new FilterItemCollection();
        if (treeNode.getUserObject() instanceof TreeBaseInfo) {
            col.add(new FilterItemInfo(this.getLongNumberFieldName(), (Object)((TreeBaseInfo)treeNode.getUserObject()).getLongNumber()));
            col.add(new FilterItemInfo(this.getLongNumberFieldName(), (Object)(((TreeBaseInfo)treeNode.getUserObject()).getLongNumber() + "!%"), CompareType.LIKE));
            if (!this.isIncludeAllChildren()) {
                col.add(new FilterItemInfo("level", (Object)new Integer(((TreeBaseInfo)treeNode.getUserObject()).getLevel() - 1)));
                this.mainQuery.getFilter().setMaskString("#0 or (#1 and #2)");
            } else {
                this.mainQuery.getFilter().setMaskString("#0 or #1");
            }
        } else if (!this.isIncludeAllChildren()) {
            col.add(new FilterItemInfo("level", (Object)new Integer(1)));
        }
        FilterInfo filterInfo = new FilterInfo();
        Iterator iter = col.iterator();
        while (iter.hasNext()) {
            filterInfo.getFilterItems().add((FilterItemInfo)iter.next());
        }
        int count = col.size();
        if (count > 0) {
            StringBuffer master = new StringBuffer();
            for (int i = 0; i < count; ++i) {
                if (i > 0) {
                    master.append(" OR ");
                }
                master.append("#");
                master.append(i);
            }
            filterInfo.setMaskString(master.toString());
        }
        FilterInfo treeFilter = this.getTreeFilter();
        try {
            if (treeFilter != null) {
                filterInfo.mergeFilter(treeFilter, "AND");
            }
        }
        catch (BOSException ex) {
            MsgBox.showError((Component)((Object)this), (String)ex.getMessage());
            super.abort();
        }
        try {
            if (this.getDefaultFilterForQuery() != null && this.getDefaultFilterForQuery().getFilterItems().size() > 0) {
                filterInfo.mergeFilter(this.getDefaultFilterForQuery(), "AND");
            }
        }
        catch (BOSException ex) {
            this.handleException((Exception)((Object)ex));
            this.abort();
        }
        this.mainQuery.setFilter(filterInfo);
        if (this.commonQuery != null) {
            try {
                this.mainQuery.getFilter().mergeFilter(this.commonQuery.getFilter(), "AND");
            }
            catch (BOSException e) {
                this.handleException((Exception)((Object)e));
                this.abort();
            }
        }
        if (this.getCurrentOrder() != null) {
            this.mainQuery.getSorter().add(this.getCurrentOrder());
        }
    }

    protected FilterInfo getTreeFilter() {
        IntEnum recordType;
        FilterInfo filter = new FilterInfo();
        if (this.prmtTaxType.getData() != null && this.prmtTaxType.getData() instanceof TaxItemTypeInfo) {
            TaxItemTypeInfo taxTypeInfo = (TaxItemTypeInfo)this.prmtTaxType.getData();
            filter.getFilterItems().add(new FilterItemInfo("taxType.id", (Object)taxTypeInfo.getId().toString(), CompareType.EQUALS));
        }
        if (this.comboRecordType.getSelectedItem() != null && this.comboRecordType.getSelectedItem() instanceof RecordTypeEnum) {
            recordType = (RecordTypeEnum)((Object)this.comboRecordType.getSelectedItem());
            filter.getFilterItems().add(new FilterItemInfo("reportSheet.recordType", (Object)recordType.getValue(), CompareType.EQUALS));
        }
        if (this.prmtReportSheet.getData() != null && this.prmtReportSheet.getData() instanceof TaxReportSheetInfo) {
            TaxReportSheetInfo reportSheetInfo = (TaxReportSheetInfo)this.prmtReportSheet.getData();
            filter.getFilterItems().add(new FilterItemInfo("reportSheet.id", (Object)reportSheetInfo.getId().toString(), CompareType.EQUALS));
        }
        if (this.comboItemDimension.getSelectedItem() != null && this.comboItemDimension.getSelectedItem() instanceof ReportItemDimensionEnum) {
            recordType = (ReportItemDimensionEnum)((Object)this.comboItemDimension.getSelectedItem());
            filter.getFilterItems().add(new FilterItemInfo("itemDimension", (Object)recordType.getValue(), CompareType.EQUALS));
        }
        return filter;
    }

    protected void loadData() {
        this.prmtTaxType.setData(null);
        this.comboRecordType.setSelectedItem(null);
        this.prmtReportSheet.setData(null);
        this.comboItemDimension.setSelectedItem(null);
        FilterInfo filterInfo = this.commonQuery.getFilter();
        if (filterInfo == null || filterInfo.getFilterItems().size() == 0) {
            return;
        }
        FilterItemCollection currentFilterItemCollection = this.commonQuery.getFilter().getFilterItems();
        for (int i = 0; i < currentFilterItemCollection.size(); ++i) {
            DataBaseInfo data;
            FilterItemInfo filterItemInfo = currentFilterItemCollection.get(i);
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("taxType.id")) {
                String id = (String)filterItemInfo.getCompareValue();
                try {
                    data = TaxItemTypeFactory.getRemoteInstance().getTaxItemTypeInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)id)));
                    this.prmtTaxType.setData((Object)data);
                }
                catch (Exception e) {
                    this.handUIException(e);
                }
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("reportSheet.recordType")) {
                int type = (Integer)filterItemInfo.getCompareValue();
                if ("-1".equals(filterItemInfo.getCompareValue().toString())) {
                    this.comboRecordType.setSelectedItem((Object)FilterCommonStatusEnum.NULL);
                } else {
                    this.comboRecordType.setSelectedItem((Object)RecordTypeEnum.getEnum(type));
                }
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("reportSheet.id")) {
                String id = (String)filterItemInfo.getCompareValue();
                try {
                    data = TaxReportSheetFactory.getRemoteInstance().getTaxReportSheetInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)id)));
                    this.prmtReportSheet.setData((Object)data);
                }
                catch (Exception e) {
                    this.handUIException(e);
                }
            }
            if (!filterItemInfo.getPropertyName().equalsIgnoreCase("itemDimension")) continue;
            int type = (Integer)filterItemInfo.getCompareValue();
            if ("-1".equals(filterItemInfo.getCompareValue().toString())) {
                this.comboItemDimension.setSelectedItem((Object)FilterCommonStatusEnum.NULL);
                continue;
            }
            this.comboItemDimension.setSelectedItem((Object)ReportItemDimensionEnum.getEnum(type));
        }
    }

    protected void initTree() throws Exception {
        TreeSelectionListener[] listeners = this.treeMain.getTreeSelectionListeners();
        this.treeSelectionListener = listeners[0];
        this.treeMain.removeTreeSelectionListener(this.treeSelectionListener);
        this.treeBuilder = TreeBuilderFactory.createTreeBuilder((ILNTreeNodeCtrl)this.getLNTreeNodeCtrl(), (int)3, (int)this.getTreeExpandLevel(), (FilterInfo)this.getDefaultFilterForTree(), (SelectorItemCollection)this.getSelectorForTree());
        if (this.getRootName() != null) {
            KDTreeNode rootNode = new KDTreeNode(this.getRootObject());
            ((DefaultTreeModel)this.treeMain.getModel()).setRoot((TreeNode)rootNode);
        } else {
            ((DefaultTreeModel)this.treeMain.getModel()).setRoot(null);
        }
        this.treeBuilder.buildTree(this.treeMain);
        this.treeMain.addTreeSelectionListener(this.treeSelectionListener);
        this.treeMain.setShowPopMenuDefaultItem(true);
        this.initPopmenu();
        this.SelectNode();
    }

    public void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        int columnIndex;
        if (e.getClickCount() == 1 && (columnIndex = e.getColIndex()) == 1) {
            int rowIndex = e.getRowIndex();
            IRow row = this.tblMain.getRow(rowIndex);
            if (row == null || row.getCell("number") == null) {
                return;
            }
            NumberExpandInfo numberExpandInfo = (NumberExpandInfo)row.getCell("number").getValue();
            if (this.treeRender.inRect(numberExpandInfo, e.getX(), e.getY())) {
                this.setTreeDisplayStyle(row);
            }
            return;
        }
        super.tblMain_tableClicked(e);
    }

    protected String getLongNumberFieldName() {
        return "longNumber";
    }

    protected SelectorItemCollection getSelectorForTree() {
        SelectorItemCollection sc = new SelectorItemCollection();
        sc.add("name");
        sc.add("level");
        sc.add("longnumber");
        sc.add("isLeaf");
        return sc;
    }

    private void setTreeDisplayStyle(IRow row) {
        boolean isAcctLeaf = (Boolean)row.getCell("isLeaf").getValue();
        if (isAcctLeaf) {
            return;
        }
        this.expandAcct(row);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void expandAcct(IRow row) {
        NumberExpandInfo acctNumberExpandInfo = (NumberExpandInfo)row.getCell("number").getValue();
        boolean isExpandStatus = acctNumberExpandInfo.isExpandStatus();
        String acctId = (String)row.getCell("id").getValue();
        int level = 0;
        if (row.getCell("level") != null) {
            level = (Integer)row.getCell("level").getValue();
        }
        if (isExpandStatus) {
            int level2;
            IRow child;
            acctNumberExpandInfo.setExpandStatus(false);
            this.tblMain.setRefresh(false);
            int count = this.tblMain.getRowCount();
            for (int i = row.getRowIndex() + 1; i < count && ((child = this.tblMain.getRow(i)).getCell("level") == null || (level2 = ((Integer)child.getCell("level").getValue()).intValue()) > level); ++i) {
                NumberExpandInfo childInfo = (NumberExpandInfo)child.getCell("number").getValue();
                childInfo.setExpandStatus(false);
                child.getStyleAttributes().setHided(true);
            }
            this.tblMain.setRefresh(true);
            this.tblMain.reLayoutAndPaint();
        } else {
            acctNumberExpandInfo.setExpandStatus(true);
            int i = row.getRowIndex() + 1;
            boolean hasChildrenDataGotten = false;
            if (i < this.tblMain.getRowCount()) {
                IRow next = this.tblMain.getRow(i);
                NumberExpandInfo nextNumberExpandInfo = (NumberExpandInfo)next.getCell("number").getValue();
                hasChildrenDataGotten = true;
            }
            if (!hasChildrenDataGotten) {
                this.setCursorOfWair();
                EntityViewInfo childQuery = new EntityViewInfo();
                FilterInfo childFilter = new FilterInfo();
                childQuery.setFilter(childFilter);
                childFilter.getFilterItems().add(new FilterItemInfo("parent.id", (Object)acctId));
                childFilter.setMaskString("#0");
                IRowSet rowset = null;
                try {
                    rowset = this.getQueryExecutor(this.mainQueryPK, childQuery).executeQuery();
                    if (rowset != null && rowset.size() > 0) {
                        int start = row.getRowIndex() + 1;
                        while (rowset.next()) {
                            IRow child = this.tblMain.addRow(start);
                            ++start;
                            int colcount = this.tblMain.getColumnCount();
                            for (int col = 0; col < colcount; ++col) {
                                IColumn column = this.tblMain.getColumn(col);
                                String field = column.getFieldName();
                                if (field == null || field.length() < 1) continue;
                                Object value = rowset.getObject(field);
                                if (field.equals("number")) {
                                    NumberExpandInfo childNumberExpandInfo = new NumberExpandInfo();
                                    childNumberExpandInfo.setAcctId(rowset.getString("id"));
                                    childNumberExpandInfo.setLevel(rowset.getInt("level"));
                                    childNumberExpandInfo.setLeaf(rowset.getBoolean("isLeaf"));
                                    childNumberExpandInfo.setNumber(rowset.getString("number"));
                                    childNumberExpandInfo.setExpandStatus(false);
                                    value = childNumberExpandInfo;
                                }
                                child.getCell(col).setValue(value);
                            }
                        }
                        this.tblMain.setRowCount(this.tblMain.getRowCount() + rowset.size());
                    }
                }
                catch (BOSException e) {
                    this.handleException((Exception)((Object)e));
                }
                catch (SQLException e) {
                    this.handleException(e);
                }
                finally {
                    this.setCursorOfDefault();
                }
            }
            int count = this.tblMain.getRowCount();
            while (i < count) {
                IRow child = this.tblMain.getRow(i);
                NumberExpandInfo childNumberExpandInfo = (NumberExpandInfo)child.getCell("number").getValue();
                String childNumber = childNumberExpandInfo.getNumber();
                String parentId = (String)child.getCell("parent.id").getValue();
                if (parentId != null && parentId.equals(acctId)) {
                    this.expandChildAcct(child);
                }
                ++i;
            }
        }
    }

    private void expandChildAcct(IRow row) {
        NumberExpandInfo acctNumberExpandInfo = (NumberExpandInfo)row.getCell("number").getValue();
        String acctNumber = acctNumberExpandInfo.getNumber();
        boolean isExpandStatus = acctNumberExpandInfo.isExpandStatus();
        String acctId = (String)row.getCell("id").getValue();
        row.getStyleAttributes().setHided(false);
        if (isExpandStatus) {
            IRow child;
            NumberExpandInfo childNumberExpandInfo;
            String childNumber;
            int count = this.tblMain.getRowCount();
            for (int i = row.getRowIndex() + 1; i < count && (childNumber = (childNumberExpandInfo = (NumberExpandInfo)(child = this.tblMain.getRow(i)).getCell("number").getValue()).getNumber()).startsWith(acctNumber); ++i) {
                String parentId = (String)child.getCell("parent.id").getValue();
                if (!parentId.equals(acctId)) continue;
                this.expandChildAcct(child);
            }
        }
    }

    protected String getRootName() {
        return TDUtils.getString("com.kingdee.eas.tm.td.structure.TaxStructureResource", "REPORTITEM", SysContext.getSysContext().getLocale());
    }

    protected void SelectNode() throws EASBizException, BOSException, Exception {
        this.setTreeSelectionListenersEnable(false);
        DefaultKingdeeTreeNode selectNode = (DefaultKingdeeTreeNode)((DefaultTreeModel)this.treeMain.getModel()).getRoot();
        if (selectNode == null) {
            this.setTreeSelectionListenersEnable(true);
            return;
        }
        Object[] nodeArray = new Object[selectNode.getChildCount()];
        for (int j = 0; j < selectNode.getChildCount(); ++j) {
            nodeArray[j] = selectNode.getChildAt(j);
        }
        TreeBaseInfo selectRow = null;
        try {
            if (this.getSelectedKeyValue() != null) {
                selectRow = this.getTreeInterface().getTreeBaseInfo((IObjectPK)new ObjectUuidPK(this.getSelectedKeyValue()));
            }
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String fullLN = "";
        if (selectRow == null) {
            this.setTreeSelectionListenersEnable(true);
            return;
        }
        fullLN = selectRow.getLongNumber();
        DefaultKingdeeTreeNode selectNode2 = null;
        for (int j = 0; j < nodeArray.length; ++j) {
            TreeBaseInfo tempTree;
            DefaultKingdeeTreeNode tempNode;
            if (nodeArray[j] == null || !(nodeArray[j] instanceof DefaultKingdeeTreeNode) || (tempNode = (DefaultKingdeeTreeNode)nodeArray[j]).getUserObject() == null || fullLN.indexOf((tempTree = (TreeBaseInfo)tempNode.getUserObject()).getLongNumber() + "!") != 0) continue;
            selectNode2 = tempNode;
            break;
        }
        if (selectNode2 != null && selectNode2.getChildCount() > 0 && selectNode2.getChildAt(0) != null && selectNode2.getChildAt(0).toString() == null) {
            if (selectNode2 != null && selectNode2.getPath() != null) {
                TreePath path = new TreePath(selectNode2.getPath());
                this.treeMain.setSelectionPath(path);
            }
            this.setTreeSelectionListenersEnable(true);
        }
        this.setTreeSelectionListenersEnable(false);
        super.SelectNode();
        this.setTreeSelectionListenersEnable(true);
    }

    public void setTreeSelectionListenersEnable(boolean flag) {
        this.treeMain.removeTreeSelectionListener(this.treeSelectionListener);
        if (flag) {
            this.treeMain.addTreeSelectionListener(this.treeSelectionListener);
        }
    }

    protected QuickFilteringSupportItems getQuickFilteringSupport() {
        return this.qfsi.supportExecutionWithoutFilters();
    }

    protected QuickFilteringSupportManager createQuickFilteringSupportManager() throws Exception {
        QuickFilteringSupportManager manager = super.createQuickFilteringSupportManager();
        this.getQuickFilteringSupport().setMustQueryAtFirst(true);
        return manager;
    }

    protected void checkStateEnableEdit() throws Exception {
        Boolean isShcheduled;
        this.checkSelected();
        IRow row = KDTableUtil.getSelectedRow((KDTable)this.getDetailTable());
        BizEnumValueDTO state = (BizEnumValueDTO)row.getCell(TBL_STATE).getValue();
        if ("2".equals(state.getString())) {
            MsgBox.showInfo((String)TDUtils.getString("com.kingdee.eas.tm.td.structure.TaxStructureResource", "ENABLENOEDIT", SysContext.getSysContext().getLocale()));
            SysUtil.abort();
        }
        if ((isShcheduled = (Boolean)row.getCell(TBL_ISSCHEDULED).getValue()).booleanValue()) {
            MsgBox.showInfo((String)TDUtils.getString("com.kingdee.eas.tm.td.structure.TaxStructureResource", "BASEDATA_EIDT_SCHEDULEDERROR", SysContext.getSysContext().getLocale()));
            SysUtil.abort();
        }
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        TDUtils.checkPermission(null, null, null, "td_taxreportitemtree_new");
        super.actionAddNew_actionPerformed(e);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkStateEnableEdit();
        this.uiHelper.checkCanEdit(this.currentCUID, this.getSelectedKeyValue());
        super.actionEdit_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.uiHelper.checkCanRemove(this.currentCUID, this.getSelectedIdValues());
        super.actionRemove_actionPerformed(e);
        this.refreshList();
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        CommonQueryDialog dialog = new CommonQueryDialog();
        if (this.getUIWindow() == null) {
            dialog.setOwner((Component)this.getUIContext().get("OwnerWindow"));
        } else {
            dialog.setOwner((Component)((Object)this));
        }
        dialog.setUiObject((IUIObject)this);
        dialog.setParentUIClassName(this.getClass().getName());
        dialog.setQueryObjectPK(this.getMainQueryPK());
        dialog.setShowShareType(16);
        dialog.setCurrentShareType(ShareTypeEnum.USER_NOORG_LEVEL);
        try {
            dialog.setProcessor((IProcessor)new StructureCommonProcessor((IUIObject)this));
            TaxReportItemFilterUI filterUI = new TaxReportItemFilterUI();
            dialog.addUserPanel((KDPanel)filterUI);
        }
        catch (Exception e) {
            this.handleException(e);
        }
        dialog.setWidth(600);
        dialog.setHeight(400);
        dialog.setShowFilter(true);
        dialog.setShowSorter(false);
        dialog.setShowToolbar(true);
        return dialog;
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.uiHelper.checkBaseDataPermission(this.currentCUID, this.getSelectedIdValues());
        String cancelMsg = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_CancelCancel");
        if (this.confirmDialog(cancelMsg)) {
            if (UtilRequest.isPrepare((String)"ActionCancelCancel", (CoreUIObject)this)) {
                this.prepareCancelCancel(null).callHandler();
            }
            this.cancelCancel();
            this.refreshList();
        }
    }

    public void refreshList() throws Exception {
        this.saveCurrentLocation();
        super.refreshList();
        this.restoreCurrentLocation();
        this.treeMain_valueChanged(null);
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.uiHelper.checkBaseDataPermission(this.currentCUID, this.getSelectedIdValues());
        super.actionCancel_actionPerformed(e);
        this.refreshList();
    }

    protected FilterInfo getDefaultFilterForTree() {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("isleaf", (Object)Constants.FALSE));
        FilterInfo treeFilter = this.getLeftTreeFilter();
        try {
            if (treeFilter != null) {
                filter.mergeFilter(treeFilter, "AND");
            }
        }
        catch (BOSException ex) {
            MsgBox.showError((Component)((Object)this), (String)ex.getMessage());
            super.abort();
        }
        return filter;
    }

    protected FilterInfo getLeftTreeFilter() {
        IntEnum recordType;
        FilterInfo filter = new FilterInfo();
        if (this.prmtTaxType.getData() != null && this.prmtTaxType.getData() instanceof TaxItemTypeInfo) {
            TaxItemTypeInfo taxTypeInfo = (TaxItemTypeInfo)this.prmtTaxType.getData();
            filter.getFilterItems().add(new FilterItemInfo("reportSheet.taxType.id", (Object)taxTypeInfo.getId().toString(), CompareType.EQUALS));
        }
        if (this.comboRecordType.getSelectedItem() != null && this.comboRecordType.getSelectedItem() instanceof RecordTypeEnum) {
            recordType = (RecordTypeEnum)((Object)this.comboRecordType.getSelectedItem());
            filter.getFilterItems().add(new FilterItemInfo("reportSheet.recordType", (Object)recordType.getValue(), CompareType.EQUALS));
        }
        if (this.prmtReportSheet.getData() != null && this.prmtReportSheet.getData() instanceof TaxReportSheetInfo) {
            TaxReportSheetInfo reportSheetInfo = (TaxReportSheetInfo)this.prmtReportSheet.getData();
            filter.getFilterItems().add(new FilterItemInfo("reportSheet.id", (Object)reportSheetInfo.getId().toString(), CompareType.EQUALS));
        }
        if (this.comboItemDimension.getSelectedItem() != null && this.comboItemDimension.getSelectedItem() instanceof ReportItemDimensionEnum) {
            recordType = (ReportItemDimensionEnum)((Object)this.comboItemDimension.getSelectedItem());
            filter.getFilterItems().add(new FilterItemInfo("itemDimension", (Object)recordType.getValue(), CompareType.EQUALS));
        }
        return filter;
    }

    protected boolean isOrderForClickTableHead() {
        return false;
    }

    protected String getEditUIName() {
        return "com.kingdee.eas.tm.td.structure.client.TaxReportItemEditUI";
    }

    protected ITreeBase getTreeInterface() throws Exception {
        return TaxReportItemFactory.getRemoteInstance();
    }

    protected KDTable getDetailTable() {
        return this.tblMain;
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    @Override
    public String getBizOrgProperty(OrgType orgType) throws BOSException, EASBizException {
        return "CU";
    }

    @Override
    public void initPermActions() throws BOSException, EASBizException {
    }

    @Override
    public ICoreBase getPermInterface() throws Exception {
        return this.getBizInterface();
    }

    @Override
    public void initPermMainOrgContext(String orgID) throws Exception {
        this.initUIMainOrgContext(orgID);
    }

    class AccountTreeRender
    implements IBasicRender {
        private int TABSIZE = 8;
        private int ICONSIZE = 10;
        private int margin = 2;
        protected SimpleTextRender simpleRender = new SimpleTextRender();
        protected HashMap acctIdToPos = new HashMap();

        AccountTreeRender() {
        }

        protected void drawExpanded(Graphics g, int x, int y) {
            g.drawRect(x, y, this.ICONSIZE, this.ICONSIZE);
            int lineSize = this.ICONSIZE - 2 * this.margin;
            g.drawLine(x + this.margin, y + this.ICONSIZE / 2, x + this.margin + lineSize, y + this.ICONSIZE / 2);
        }

        protected void drawCollapsed(Graphics g, int x, int y) {
            g.drawRect(x, y, this.ICONSIZE, this.ICONSIZE);
            int lineSize = this.ICONSIZE - 2 * this.margin;
            g.drawLine(x + this.margin, y + this.ICONSIZE / 2, x + this.margin + lineSize, y + this.ICONSIZE / 2);
            g.drawLine(x + this.ICONSIZE / 2, y + this.margin, x + this.ICONSIZE / 2, y + this.margin + lineSize);
        }

        protected void drawLeaf(Graphics g, int x, int y) {
        }

        public boolean inRect(NumberExpandInfo numberExpandInfo, int x, int y) {
            String acctId = numberExpandInfo.getAcctId();
            Rectangle rec = (Rectangle)this.acctIdToPos.get(acctId);
            if (rec != null) {
                return rec.getX() < (double)x && rec.getX() + rec.getWidth() > (double)x;
            }
            return false;
        }

        public void draw(Graphics graphics, Shape clip, Object obj, Style style) {
            if (obj instanceof NumberExpandInfo) {
                NumberExpandInfo numberExpandInfo = (NumberExpandInfo)obj;
                int ident = numberExpandInfo.getLevel() * this.TABSIZE;
                Rectangle rect = clip.getBounds();
                int x = rect.x + ident;
                int y = rect.y + (rect.height - this.ICONSIZE) / 2;
                Rectangle iconRect = new Rectangle(x, y, this.ICONSIZE, this.ICONSIZE);
                this.acctIdToPos.put(numberExpandInfo.getAcctId(), iconRect);
                this.simpleRender.draw(graphics, (Shape)new Rectangle(x + this.ICONSIZE + this.TABSIZE, rect.y, rect.width - x - this.ICONSIZE - this.TABSIZE, rect.height), numberExpandInfo.getNumber(), style);
                this.paintIcon(graphics, numberExpandInfo, iconRect);
            } else if (obj != null) {
                this.simpleRender.draw(graphics, clip, obj.toString(), style);
            }
        }

        private void paintIcon(Graphics graphics, NumberExpandInfo numberExpandInfo, Rectangle iconRect) {
            if (numberExpandInfo.isLeaf()) {
                this.drawLeaf(graphics, iconRect.x, iconRect.y);
            } else if (numberExpandInfo.isExpandStatus()) {
                this.drawExpanded(graphics, iconRect.x, iconRect.y);
            } else if (!numberExpandInfo.isExpandStatus()) {
                this.drawCollapsed(graphics, iconRect.x, iconRect.y);
            }
        }
    }

    class NumberExpandInfo {
        private String acctId;
        private String number;
        private boolean isExpandStatus;
        private int level;
        private boolean isLeaf;

        NumberExpandInfo() {
        }

        public boolean isExpandStatus() {
            return this.isExpandStatus;
        }

        public void setExpandStatus(boolean isExpandStatus) {
            this.isExpandStatus = isExpandStatus;
        }

        public String getNumber() {
            return this.number;
        }

        public void setNumber(String number) {
            this.number = number;
        }

        public String toString() {
            return this.number;
        }

        public int getLevel() {
            return this.level;
        }

        public void setLevel(int level) {
            this.level = level;
        }

        public boolean isLeaf() {
            return this.isLeaf;
        }

        public void setLeaf(boolean isLeaf) {
            this.isLeaf = isLeaf;
        }

        public String getAcctId() {
            return this.acctId;
        }

        public void setAcctId(String acctId) {
            this.acctId = acctId;
        }
    }
}

