/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.structure.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tm.td.PeriodTypeEnum;
import com.kingdee.eas.tm.td.RecordTypeEnum;
import com.kingdee.eas.tm.td.StatusEnum;
import com.kingdee.eas.tm.td.TDException;
import com.kingdee.eas.tm.td.TDUtils;
import com.kingdee.eas.tm.td.basedata.AccountConfigStatusEnum;
import com.kingdee.eas.tm.td.basedata.TaxItemTypeFactory;
import com.kingdee.eas.tm.td.basedata.TaxItemTypeInfo;
import com.kingdee.eas.tm.td.cloud.utils.TDCloudUtil;
import com.kingdee.eas.tm.td.common.uihelper.EditUIHelper;
import com.kingdee.eas.tm.td.structure.TaxReportTemplateFactory;
import com.kingdee.eas.tm.td.structure.TaxReportTemplateInfo;
import com.kingdee.eas.tm.td.structure.TaxTemplateTypeEnum;
import com.kingdee.eas.tm.td.structure.client.AbstractTaxReportTemplateEditUI;
import com.kingdee.eas.tm.td.structure.utils.StructureUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public abstract class TaxReportTemplateEditUI
extends AbstractTaxReportTemplateEditUI {
    private static final Logger logger = CoreUIObject.getLogger(TaxReportTemplateEditUI.class);
    protected static final String TDRESOURCE = "com.kingdee.eas.tm.td.cloud.TDCloudResource";
    protected static final String NEXTLINE = ";\r\n";
    private DataChangeListener taxTypeChangeListener = null;
    private ItemListener recordTypeChangeListener = null;
    protected boolean isCopy = false;
    private Map btnMap;
    private EditUIHelper uiHelper = new EditUIHelper(this);

    public TaxReportTemplateEditUI() throws Exception {
        this.btnMap = new HashMap();
        this.btnMap.put("actionRemove", this.actionRemove);
        this.btnMap.put("actionCancel", this.actionCancel);
        this.btnMap.put("actionCancelCancel", this.actionCancelCancel);
        this.btnMap.put("actionEdit", this.actionEdit);
        this.btnMap.put("actionSave", this.actionSubmit);
        this.btnMap.put("actionCopy", this.actionCopy);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.afterLoad();
        this.setF7Filter();
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.initBtnStatus();
    }

    protected void initBtnStatus() {
        this.btnSave.setVisible(false);
        this.menuItemSave.setVisible(false);
        this.chkMenuItemSubmitAndAddNew.setSelected(false);
        StatusEnum state = this.editData.getState();
        boolean isLight = false;
        if (StatusEnum.DisEnable.equals((Object)state) || StatusEnum.SAVE.equals((Object)state)) {
            isLight = true;
        }
        this.uiHelper.initBtnStatus(this.btnMap, isLight);
        if (StatusEnum.SAVE.equals((Object)state) && !this.getOprtState().equals(OprtState.ADDNEW)) {
            this.actionCancelCancel.setEnabled(true);
            this.actionCancel.setEnabled(true);
        }
    }

    protected void afterLoad() {
        this.initControl();
    }

    protected void initControl() {
    }

    protected void setF7Filter() throws EASBizException, BOSException, SQLException {
        StructureUtils.setTaxTypeFilter(this.prmtTaxType);
        this.setAccountConfigFilter();
        this.setTaxBillRangeFilter();
    }

    protected void setAccountConfigFilter() throws BOSException, SQLException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        Set idSet = this.getAccountCofigFilter();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        view.setFilter(filter);
        this.prmtAccountConfig.setEntityViewInfo(view);
    }

    private Set getAccountCofigFilter() throws BOSException, SQLException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        TaxItemTypeInfo taxType = (TaxItemTypeInfo)this.prmtTaxType.getValue();
        if (taxType != null) {
            filter.getFilterItems().add(new FilterItemInfo("taxTypeItem.id", (Object)taxType.getId().toString(), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("relation.state", (Object)AccountConfigStatusEnum.ACTIVE.getValue(), CompareType.EQUALS));
        }
        view.getSelector().add(new SelectorItemInfo("id"));
        view.setFilter(filter);
        IQueryExecutor exec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)new MetaDataPK("com.kingdee.eas.tm.td.basedata.app.AccountConfigCuQuery"));
        exec.setObjectView(view);
        IRowSet rs = exec.executeQuery();
        HashSet<String> idSet = new HashSet<String>();
        while (rs.next()) {
            idSet.add(rs.getString("id"));
        }
        IQueryExecutor orgExec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)new MetaDataPK("com.kingdee.eas.tm.td.basedata.app.AccountConfigOrgQuery"));
        orgExec.setObjectView(view);
        IRowSet orgRs = orgExec.executeQuery();
        while (orgRs.next()) {
            idSet.add(orgRs.getString("id"));
        }
        return idSet;
    }

    protected void setTaxBillRangeFilter() {
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        TaxItemTypeInfo taxItemTypeInfo = (TaxItemTypeInfo)this.prmtTaxType.getValue();
        RecordTypeEnum recordType = (RecordTypeEnum)((Object)this.comboRecordType.getSelectedItem());
        HashSet<Integer> recordTypeSet = new HashSet<Integer>();
        recordTypeSet.add(recordType.getValue());
        recordTypeSet.add(-1);
        filter.getFilterItems().add(new FilterItemInfo("recordType", recordTypeSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("taxType.number", (Object)(taxItemTypeInfo == null ? "" : taxItemTypeInfo.getNumber()), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("taxType.number", null, CompareType.EMPTY));
        filter.setMaskString("#0 AND (#1 OR #2)");
        ev.setFilter(filter);
        this.prmtBillRange.setEntityViewInfo(ev);
    }

    protected void removeEventLisener() {
        if (this.taxTypeChangeListener != null) {
            this.prmtTaxType.removeDataChangeListener(this.taxTypeChangeListener);
        }
        if (this.recordTypeChangeListener != null) {
            this.comboRecordType.removeItemListener(this.recordTypeChangeListener);
        }
    }

    protected void addEventLisener() {
        if (this.taxTypeChangeListener == null) {
            this.taxTypeChangeListener = new DataChangeListener(){

                public void dataChanged(DataChangeEvent e) {
                    if (TDCloudUtil.isEqual(e.getNewValue(), e.getOldValue())) {
                        return;
                    }
                    try {
                        TaxReportTemplateEditUI.this.taxType_dataChanged(e);
                    }
                    catch (Exception e1) {
                        TaxReportTemplateEditUI.this.handleException(e1);
                    }
                }
            };
        }
        this.prmtTaxType.addDataChangeListener(this.taxTypeChangeListener);
        if (this.comboRecordType == null) {
            this.recordTypeChangeListener = new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    TaxReportTemplateEditUI.this.recordType_dataChanged(e);
                }
            };
        }
        this.comboRecordType.addItemListener(this.recordTypeChangeListener);
    }

    protected void taxType_dataChanged(DataChangeEvent e) throws Exception {
        if (TDUtils.isEqual(e.getNewValue(), e.getOldValue())) {
            return;
        }
        this.initControl();
        this.prmtAccountConfig.setValue(null);
        this.setAccountConfigFilter();
        this.setTaxBillRangeFilter();
    }

    protected void recordType_dataChanged(ItemEvent e) {
        if (e.getStateChange() == 1) {
            this.setTaxBillRangeFilter();
        }
    }

    protected void checkStateEnableEdit() throws Exception {
        if (this.editData.getState().equals((Object)StatusEnum.Enable)) {
            MsgBox.showInfo((String)TDUtils.getString("com.kingdee.eas.tm.td.structure.TaxStructureResource", "ENABLENOEDIT", SysContext.getSysContext().getLocale()));
            SysUtil.abort();
        }
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkStateEnableEdit();
        super.actionEdit_actionPerformed(e);
        this.initBtnStatus();
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancel_actionPerformed(e);
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        if (!this.uiHelper.modifySaveOrExit((ItemAction)this.actionSubmit, this.btnSubmit, (ItemAction)this.actionSave, this.btnSave, this.isModifySave())) {
            return;
        }
        super.actionCancelCancel_actionPerformed(e);
        if (StatusEnum.Enable.equals((Object)this.editData.getState())) {
            this.setOprtState("VIEW");
        } else {
            this.setOprtState("EDIT");
        }
        this.setDataObject((IObjectValue)this.editData);
        this.loadFields();
    }

    protected void checkRequiredFields() {
        StringBuffer sb = new StringBuffer();
        if (StringUtils.isEmpty((String)this.txtNumber.getText())) {
            sb.append(EASResource.getString((String)TDRESOURCE, (String)"NUMBER"));
        }
        if (StringUtils.isEmpty((String)this.txtName.getText())) {
            sb.append(EASResource.getString((String)TDRESOURCE, (String)"NAME"));
        }
        if (this.prmtTaxType.getValue() == null) {
            sb.append(EASResource.getString((String)TDRESOURCE, (String)"TAXTYPE"));
        }
        if (sb.length() > 0) {
            sb.append(EASResource.getString((String)TDRESOURCE, (String)"NOTNULL"));
            MsgBox.showWarning((String)sb.substring(1));
            SysUtil.abort();
        }
        if (sb.length() > 0) {
            sb.append(EASResource.getString((String)TDRESOURCE, (String)"OVER_LENGTH"));
            MsgBox.showWarning((String)sb.substring(1));
            SysUtil.abort();
        }
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.checkRequiredFields();
        boolean isNeedOpenProcessUI = false;
        if (this.getOprtState().equals(OprtState.ADDNEW)) {
            isNeedOpenProcessUI = true;
        }
        super.actionSubmit_actionPerformed(e);
        if (isNeedOpenProcessUI) {
            this.getUIWindow().hide();
            Map uiContext = this.getUIContext();
            this.openProcessUI(uiContext, OprtState.ADDNEW);
        }
    }

    protected void openProcessUI(Map uiContext, String oprtState) throws UIException {
        this.uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(this.getTemplateRptUI(), uiContext, null, oprtState);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TaxReportTemplateEditUI.this.uiWindow.show();
            }
        });
    }

    protected abstract String getTemplateRptUI();

    protected void setFieldsNull(AbstractObjectValue newData) {
        TaxReportTemplateInfo editData = (TaxReportTemplateInfo)newData;
        editData.setNumber(editData.getNumber() + "Copy");
        editData.setName(editData.getName() + "Copy");
        editData.setTemplateType(this.getTemplateType());
        editData.setIsScheduled(false);
        editData.setCU(SysContext.getSysContext().getCurrentCtrlUnit());
        editData.setCreator(null);
        editData.setCreateTime(null);
        editData.setLastUpdateUser(null);
        editData.setLastUpdateTime(null);
        this.isCopy = true;
    }

    protected IObjectValue createNewData() {
        TaxReportTemplateInfo editData = new TaxReportTemplateInfo();
        editData.setState(StatusEnum.SAVE);
        try {
            editData.setTaxType(TaxItemTypeFactory.getRemoteInstance().getTaxItemTypeInfo((IObjectPK)new ObjectUuidPK("Xip0em3cA6rgU0ETqMAGKduK96Y=")));
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        editData.setRecordType(RecordTypeEnum.TaxDeclare);
        editData.setSubPeriodType(PeriodTypeEnum.MONTHLY);
        editData.setTemplateType(this.getTemplateType());
        editData.setCU(SysContext.getSysContext().getCurrentCtrlUnit());
        return editData;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return TaxReportTemplateFactory.getRemoteInstance();
    }

    protected abstract TaxTemplateTypeEnum getTemplateType();

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        this.checkBeforeSave();
        super.actionSave_actionPerformed(e);
        if (!this.getOprtState().equals(OprtState.ADDNEW)) {
            if (StatusEnum.Enable.equals((Object)this.editData.getState())) {
                this.setOprtState("VIEW");
            } else {
                this.setOprtState("EDIT");
            }
        }
        this.setDataObject((IObjectValue)this.editData);
        this.loadFields();
    }

    private void checkBeforeSave() throws TDException {
        StringBuffer errorMsg = new StringBuffer();
        String NotNull = TDUtils.getString("com.kingdee.eas.tm.td.structure.TaxStructureResource", "NotNull", null);
        if (StringUtils.isEmpty((String)this.txtNumber.getText())) {
            String number = TDUtils.getString("com.kingdee.eas.tm.td.structure.TaxStructureResource", "NUMBER", null);
            errorMsg.append(number).append(NotNull).append(NEXTLINE);
        }
        if (StringUtils.isEmpty((String)this.txtName.getText())) {
            String name = TDUtils.getString("com.kingdee.eas.tm.td.structure.TaxStructureResource", "NAME", null);
            if (!StringUtils.isEmpty((String)this.txtNumber.getText())) {
                errorMsg.append(this.txtNumber.getText()).append(":");
            }
            errorMsg.append(name).append(NotNull).append(NEXTLINE);
        }
        if (errorMsg.length() > 0) {
            throw new TDException(TDException.ERROR_MSG, new Object[]{errorMsg});
        }
    }
}

