/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.structure.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.core.IExtRender;
import com.kingdee.bos.ctrl.excel.impl.ActionManager;
import com.kingdee.bos.ctrl.excel.impl.ToolBarManager;
import com.kingdee.bos.ctrl.excel.impl.action.NotifyListener;
import com.kingdee.bos.ctrl.excel.impl.action.SpreadAction;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.FillType;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.event.BookChangeEvent;
import com.kingdee.bos.ctrl.excel.model.struct.validate.ValidationList;
import com.kingdee.bos.ctrl.excel.model.struct.validate.util.MessagedValidate;
import com.kingdee.bos.ctrl.excel.model.struct.validate.util.Validate;
import com.kingdee.bos.ctrl.excel.model.util.SortedCellBlockArray;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.newrpt.DesignerResource;
import com.kingdee.eas.fi.newrpt.client.designer.IItemFormulaProvider;
import com.kingdee.eas.fi.newrpt.client.designer.SpreadManager;
import com.kingdee.eas.fi.newrpt.client.designer.render.IRenderProvider;
import com.kingdee.eas.fi.newrpt.client.designer.render.SumRangeRender;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.tm.td.DraftBillBuildCenter;
import com.kingdee.eas.tm.td.StatusEnum;
import com.kingdee.eas.tm.td.TDFacadeFactory;
import com.kingdee.eas.tm.td.TDUtils;
import com.kingdee.eas.tm.td.basedata.AccountConfigEntryCollection;
import com.kingdee.eas.tm.td.basedata.AccountConfigEntryInfo;
import com.kingdee.eas.tm.td.basedata.AccountConfigFactory;
import com.kingdee.eas.tm.td.basedata.AccountConfigInfo;
import com.kingdee.eas.tm.td.basedata.RptBillRangeEntryCollection;
import com.kingdee.eas.tm.td.basedata.RptBillRangeEntryFactory;
import com.kingdee.eas.tm.td.basedata.RptBillRangeEntryInfo;
import com.kingdee.eas.tm.td.client.AccountFormulaUI;
import com.kingdee.eas.tm.td.structure.TaxReportTemplateFactory;
import com.kingdee.eas.tm.td.structure.TaxReportTemplateInfo;
import com.kingdee.eas.tm.td.structure.TaxTemplateTypeEnum;
import com.kingdee.eas.tm.td.structure.client.AbstractTaxReportTemplateRptUI;
import com.kingdee.eas.tm.td.structure.client.ItemFormulaAnalysisUI;
import com.kingdee.eas.tm.td.structure.client.ItemFormulaLayoutEditUI;
import com.kingdee.eas.tm.td.structure.client.ItemFormulaWizardUI;
import com.kingdee.eas.tm.td.structure.client.TaxReportItemBatchEditUI;
import com.kingdee.eas.tm.td.structure.client.TaxReportItemFormulaEditUI;
import com.kingdee.eas.tm.td.structure.utils.RptTaxItemFormulaProvider;
import com.kingdee.eas.tm.td.structure.utils.StructureUtils;
import com.kingdee.eas.tm.td.structure.utils.TaxReportTemplateBookProvider;
import com.kingdee.eas.tm.td.structure.utils.TaxReportTemplateMenuStrategy;
import com.kingdee.eas.tm.td.structure.utils.TaxReportTemplatePropertyAdapter;
import com.kingdee.eas.tm.td.structure.utils.TaxReportTemplateVariableProvider;
import com.kingdee.eas.tm.td.structure.utils.TaxTableBeforeAction;
import com.kingdee.eas.tm.td.utils.Location;
import com.kingdee.eas.tm.td.utils.render.DefaultRenderProvider;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;

public abstract class TaxReportTemplateRptUI
extends AbstractTaxReportTemplateRptUI {
    private static final Logger logger = CoreUIObject.getLogger(TaxReportTemplateRptUI.class);
    private TaxReportTemplateInfo editData = null;

    public TaxReportTemplateRptUI() throws Exception {
        this.setMenuStrategy(new TaxReportTemplateMenuStrategy());
        this.setBookProvider(new TaxReportTemplateBookProvider());
        this.setVariableProvider(new TaxReportTemplateVariableProvider());
        this.setPropertyAdapter(new TaxReportTemplatePropertyAdapter());
    }

    protected void initToolbar() {
        ToolBarManager toolBarManager = this.getSpreadManager().getSpreadContainer().getToolBarManager();
        this.actionSave.putValue("SmallIcon", (Object)EASResource.getIcon((String)"imgTbtn_save"));
        toolBarManager.addFirstGroupItem((Action)this.actionSave, "common");
        this.actionEdit.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_edit"));
        toolBarManager.addFirstGroupItem((Action)((Object)this.actionEdit), "common");
        this.actionAddAccountFormula.putValue("AcceleratorKey", KeyStroke.getKeyStroke("F6"));
        ActionManager actions = this.getSpreadManager().getSpreadContainer().getActionManager();
        SpreadAction action = actions.getAction("SetCellDisplayMode");
        action.putValue("SmallIcon", (Object)EASResource.getIcon((String)"imgTbtn_showformula"));
        this.actionSheetManager.putValue("SmallIcon", (Object)EASResource.getIcon((String)"imgTbtn_reportparameter"));
        this.actionFormulaValueSwitch.putValue("SmallIcon", (Object)EASResource.getIcon((String)"imgTbtn_showformula"));
        toolBarManager.addLastGroupItem((Action)this.actionFormulaValueSwitch, "common");
        this.toolBar = toolBarManager.getToolBar("common");
        this.toolBar.setIsControlByParent(false);
        this.toolBar.setTextIconDisStyle((short)2);
        this.toolBar.setPopupMenuShowable(true);
        this.getSpreadManager().setUserExtRender((IExtRender)SumRangeRender.getInstance());
    }

    public String getUITitle() {
        return this.getTitle();
    }

    public abstract String getTitle();

    public void onLoad() throws Exception {
        super.onLoad();
        SpreadManager.registerRenderProvider((IRenderProvider)new DefaultRenderProvider());
        this.menuItemViewFormula.doClick();
        this.getBook().setCalculate(false);
        this.editData = (TaxReportTemplateInfo)this.getReportAdapter().getReportProperty("editData");
        for (int i = 0; i < this.getBook().getSheetCount(); ++i) {
            this.getBook().getSheet(i).getSheetOption().setCellDisplayMode(1);
        }
        this.initActions();
        if (OprtState.ADDNEW.equals(this.getOprtState()) && this.editData != null) {
            TaxTemplateTypeEnum templateType = this.editData.getTemplateType();
            this.addDraftConfirmSheet();
            if (TaxTemplateTypeEnum.DRAFTITEM.equals((Object)templateType)) {
                this.actionSave_actionPerformed(null);
            } else if (TaxTemplateTypeEnum.ACCOUNT.equals((Object)templateType)) {
                this.addAccountSheet();
                this.actionSave_actionPerformed(null);
            }
        }
    }

    protected void initActions() {
        this.menuItemClearItemFormula.setCustomAction((Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TaxReportTemplateRptUI.this.getBook().getActiveSelectionRange().clear(false, false, false, false, new String[]{"TAXITEM"});
            }
        });
        this.menuItemRightClearItemFormula.setCustomAction(this.menuItemClearItemFormula.getAction());
        this.itemTaxItemFormula.setCustomAction(this.menuItemTaxItemFormula.getAction());
        this.itemTaxItemFormula.setText(TDUtils.getString("com.kingdee.eas.tm.td.structure.TaxStructureResource", "ItemFormula", TDUtils.getLocale()));
        ActionManager actions = this.getSpreadManager().getSpreadContainer().getActionManager();
        actions.getAction("Show_InsertPaste_Wizzard").setBeforeAction((NotifyListener)new TaxTableBeforeAction("Show_InsertPaste_Wizzard", this.getBookProvider()));
        actions.getAction("Delete_Cell").setBeforeAction((NotifyListener)new TaxTableBeforeAction("Delete_Cell", this.getBookProvider()));
        actions.getAction("Delete_Row").setBeforeAction((NotifyListener)new TaxTableBeforeAction("Delete_Row", this.getBookProvider()));
        actions.getAction("Delete_Col").setBeforeAction((NotifyListener)new TaxTableBeforeAction("Delete_Col", this.getBookProvider()));
        actions.getAction("Insert_Col").setBeforeAction((NotifyListener)new TaxTableBeforeAction("Insert_Col", this.getBookProvider()));
        actions.getAction("Insert_Row").setBeforeAction((NotifyListener)new TaxTableBeforeAction("Insert_Row", this.getBookProvider()));
        actions.getAction("Insert_MultiRow").setBeforeAction((NotifyListener)new TaxTableBeforeAction("Insert_MultiRow", this.getBookProvider()));
        actions.getAction("Insert_Cell").setBeforeAction((NotifyListener)new TaxTableBeforeAction("Insert_Cell", this.getBookProvider()));
        actions.getAction("Sheet_Delete").setBeforeAction((NotifyListener)new TaxTableBeforeAction("Sheet_Delete", this.getBookProvider()));
        actions.getAction("Merge").setBeforeAction((NotifyListener)new TaxTableBeforeAction("Merge", this.getBookProvider()));
        actions.getAction("CLEAR_CELL_ALL").setBeforeAction((NotifyListener)new TaxTableBeforeAction("CLEAR_CELL_ALL", this.getBookProvider()));
        actions.getAction("Clear_CellFormulaAndValue").setBeforeAction((NotifyListener)new TaxTableBeforeAction("CLEAR_CELL_ALL", this.getBookProvider()));
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        this.verify(e);
        this.beforeSave();
        this.getBookProvider().restoreBook(this.getBook());
        try {
            this.getSpreadManager().getSpreadContainer().getStateManager().stopAll();
            IObjectPK pk = this.getBookProvider().getBizInterface().save((CoreBaseInfo)this.getBookProvider().getEditValue());
            this.getBookProvider().setEditValue(this.getBookProvider().queryEditData(pk));
            this.editData = (TaxReportTemplateInfo)this.getBookProvider().getEditValue();
            this.getBookProvider().getEditValue().setBOSUuid(this.getBookProvider().getEditValue().getPKField(), BOSUuid.read((String)pk.toString()));
            if (!this.getUIContext().containsKey("SumRptProcessUI_isSumGrade")) {
                this.showSuccessMsg(DesignerResource.getString((String)"saveOK"));
            }
            this.getSpreadManager().getModifyManager().discardAllEdits();
            this.getSpreadManager().getSpreadContainer().getToolBarManager().changed(new BookChangeEvent(this.getBook().getActiveSheet(), "Sheet_Hide"));
        }
        catch (EASBizException e1) {
            MsgBox.showDetailAndOK((Component)((Object)this), (String)DesignerResource.getString((String)"saveFail").replaceAll("\uff0c", ""), (String)e1.getMessage(), (int)0);
            SysUtil.abort();
        }
    }

    protected void addDraftConfirmSheet() throws BOSException {
        if (this.editData.getBillRange() == null || this.editData.getBillRange().getEntrys() == null) {
            return;
        }
        RptBillRangeEntryCollection billRangeEntrys = null;
        if (this.editData.getBillRange().getId() != null) {
            String billRangeID = this.editData.getBillRange().getId().toString();
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("parent", (Object)billRangeID, CompareType.EQUALS));
            view.setFilter(filter);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("*"));
            view.setSelector(sic);
            billRangeEntrys = RptBillRangeEntryFactory.getRemoteInstance().getRptBillRangeEntryCollection(view);
        }
        if (billRangeEntrys != null) {
            SpreadManager spreadManager = this.getSpreadManager();
            for (int k = 0; k < billRangeEntrys.size(); ++k) {
                RptBillRangeEntryInfo entry = billRangeEntrys.get(k);
                String bosType = entry.getBillBosType();
                String billName = entry.getBillName();
                Sheet exists = this.getBook().getSheet(billName);
                if (exists != null) continue;
                Sheet rptSheet = new Sheet(this.getBook(), billName);
                rptSheet.setUserObject("bosType", (Object)bosType);
                this.getBook().addSheet(rptSheet);
                rptSheet.setSelected(false);
                rptSheet.getRange(0, 0, rptSheet.getMaxRowIndex(), rptSheet.getMaxColIndex()).clear(true, true, false, true, new String[0]);
                int top = rptSheet.getActiveRow();
                int left = rptSheet.getActiveCol();
                DraftBillBuildCenter.initDraftBillInfos(null, bosType);
                List<DraftBillBuildCenter> fieldList = DraftBillBuildCenter.getFieldsList(bosType);
                int index = 0;
                for (int i = 0; i < fieldList.size(); ++i) {
                    DraftBillBuildCenter info = fieldList.get(i);
                    int valueRangeTop = top;
                    if (info.getFieldName().equals("companyOrgUnit") && bosType.equals("ED4D060A")) continue;
                    rptSheet.getRange(valueRangeTop, left + index).setValue(new Variant((Object)info.getFieldDisplayName()));
                    rptSheet.getRange(valueRangeTop, left + index).setUserObject("fieldKey", (Object)info.getFieldName());
                    if (info.getProperty() instanceof LinkPropertyInfo) {
                        StyleAttributes sa = Styles.getEmptySA();
                        sa.setNumberFormat("@");
                        rptSheet.getColRange(left + index, left + index).setStyle(sa, sa);
                    }
                    StructureUtils.autoSetColWidth(spreadManager, rptSheet, valueRangeTop, left + index);
                    ++index;
                }
                Range range = rptSheet.getRange(top, left);
                range.setUserObject("fieldsCount", (Object)fieldList.size());
            }
        }
        this.initSheetSelected();
    }

    protected void addAccountSheet() throws Exception {
        Book book = this.getBook();
        AccountConfigInfo accountConfigInfo = this.editData.getAccountConfig();
        if (accountConfigInfo == null) {
            return;
        }
        String accountID = accountConfigInfo.getId().toString();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("entry.*"));
        AccountConfigInfo config = AccountConfigFactory.getRemoteInstance().getAccountConfigInfo((IObjectPK)new ObjectUuidPK(accountID), sic);
        config.getEntry().sort("seq");
        this.insertAccountSheet(book, config);
        this.insertAccountTotalSheet(book, config);
        this.insertAccountSumSheet(book, config);
        this.initSheetSelected();
    }

    protected void insertAccountSheet(Book book, AccountConfigInfo config) {
        if (config == null) {
            return;
        }
        Sheet sheet = book.getSheet(TDUtils.getString("com.kingdee.eas.tm.td.TDResource", "AccountPeriod", TDUtils.getLocale()));
        if (sheet != null) {
            return;
        }
        sheet = new Sheet(book, TDUtils.getString("com.kingdee.eas.tm.td.TDResource", "AccountPeriod", TDUtils.getLocale()));
        book.addSheet(sheet);
        int top = 0;
        int left = 0;
        AccountConfigEntryCollection coll = config.getEntry();
        AccountConfigEntryInfo entryInfo = null;
        top = config.getFillRow() > 0 ? config.getFillRow() - 1 : config.getFillRow();
        left = config.getFillColumn() > 0 ? config.getFillColumn() - 1 : config.getFillColumn();
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            entryInfo = coll.get(i);
            sheet.getRange(top, left + i).setValue(new Variant((Object)entryInfo.getAlias()));
            sheet.getRange(top, left + i).setUserObject("fieldKey", (Object)entryInfo.getName());
            this.insertCellAttribute(sheet, top, left, i, coll);
        }
    }

    private void insertCellAttribute(Sheet sheet, int top, int left, int i, AccountConfigEntryCollection coll) {
        AccountConfigEntryInfo entryInfo = coll.get(i);
        if (!StringUtils.isEmpty((String)entryInfo.getTxtVolidScope())) {
            sheet.getRange(top + 1, left + i).setValue(new Variant());
            CellBlock cellBlock = CellBlock.getNewCellBlock((int)(top + 1), (int)(left + i));
            sheet.getRange(top + 1, left + i).fill(cellBlock, FillType.DEFAULT_EXCEPT_FORMAT, new FillType(0));
            SortedCellBlockArray sa = new SortedCellBlockArray();
            sa.insert((Object)cellBlock);
            sa.mergeSelf();
            ValidationList vl = sheet.getValidations();
            MessagedValidate retMV = new MessagedValidate();
            retMV.setType(Validate.Type_List);
            retMV.setMin(entryInfo.getTxtVolidScope());
            retMV.setCellRangeList(true);
            vl.insertValidation(retMV, sa);
        }
        if (!StringUtils.isEmpty((String)entryInfo.getFormulaValue())) {
            AccountConfigEntryInfo entry = null;
            String formula = entryInfo.getFormulaValue();
            for (int j = 0; j < coll.size(); ++j) {
                entry = coll.get(j);
                formula = formula.replace("'" + (j + 1) + "#'", Location.getCellName(top + 1, left + j));
            }
            sheet.getRange(top + 1, left + i).setFormula("=" + formula);
        }
    }

    protected void insertAccountTotalSheet(Book book, AccountConfigInfo config) {
        if (config == null || !config.isIsTotal()) {
            return;
        }
        Sheet sheet = book.getSheet(TDUtils.getString("com.kingdee.eas.tm.td.TDResource", "AccountPeriodTotal", TDUtils.getLocale()));
        if (sheet != null) {
            return;
        }
        sheet = new Sheet(book, TDUtils.getString("com.kingdee.eas.tm.td.TDResource", "AccountPeriodTotal", TDUtils.getLocale()));
        book.addSheet(sheet);
        int top = 0;
        int left = 0;
        AccountConfigEntryCollection coll = config.getEntry();
        AccountConfigEntryInfo entryInfo = null;
        top = config.getFillRow() > 0 ? config.getFillRow() - 1 : config.getFillRow();
        left = config.getFillColumn() > 0 ? config.getFillColumn() - 1 : config.getFillColumn();
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            entryInfo = coll.get(i);
            sheet.getRange(top, left + i).setValue(new Variant((Object)entryInfo.getAlias()));
            sheet.getRange(top, left + i).setUserObject("fieldKey", (Object)entryInfo.getName());
            this.insertCellAttribute(sheet, top, left, i, coll);
        }
    }

    protected void insertAccountSumSheet(Book book, AccountConfigInfo config) {
        if (config == null) {
            return;
        }
        AccountConfigEntryCollection entries = config.getEntry();
        ArrayList<String> groupFields = new ArrayList<String>();
        ArrayList<String> sumFields = new ArrayList<String>();
        for (int i = 0; i < entries.size(); ++i) {
            AccountConfigEntryInfo entryInfo = entries.get(i);
            if (entryInfo.isIsGroup()) {
                groupFields.add(entryInfo.getName());
            }
            if (!entryInfo.isIsSum()) continue;
            sumFields.add(entryInfo.getName());
        }
        boolean isShowTotal = false;
        if (groupFields.size() > 0 && sumFields.size() > 0) {
            isShowTotal = true;
        }
        if (!isShowTotal) {
            return;
        }
        Sheet sheet = book.getSheet(TDUtils.getString("com.kingdee.eas.tm.td.TDCommonResource", "TotalSheet", TDUtils.getLocale()));
        if (sheet != null) {
            return;
        }
        sheet = new Sheet(book, TDUtils.getString("com.kingdee.eas.tm.td.TDCommonResource", "TotalSheet", TDUtils.getLocale()));
        book.addSheet(sheet);
        int top = 0;
        int left = 0;
        AccountConfigEntryCollection coll = config.getEntry();
        AccountConfigEntryInfo entryInfo = null;
        top = config.getFillRow() > 0 ? config.getFillRow() - 1 : config.getFillRow();
        left = config.getFillColumn() > 0 ? config.getFillColumn() - 1 : config.getFillColumn();
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            entryInfo = coll.get(i);
            sheet.getRange(top, left + i).setValue(new Variant((Object)entryInfo.getAlias()));
            sheet.getRange(top, left + i).setUserObject("fieldKey", (Object)entryInfo.getName());
            this.insertCellAttribute(sheet, top, left, i, coll);
        }
    }

    @Override
    public void actionTaxReportItemFormulaFill_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"rptSheet", (Object)this.getBook().getActiveSheet());
        uiContext.put((Object)"spreadManager", (Object)this.getSpreadManager());
        uiContext.put((Object)"editData", (Object)this.getBookProvider().getEditValue());
        IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
        IUIWindow window = uiFactory.create(TaxReportItemFormulaEditUI.class.getName(), (Map)uiContext, null, this.getOprtState());
        window.show();
    }

    @Override
    public void actionInsertDraftBill_actionPerformed(ActionEvent e) throws Exception {
        this.addDraftConfirmSheet();
    }

    @Override
    public void actionInsertAccountSheet_actionPerformed(ActionEvent e) throws Exception {
        this.addAccountSheet();
    }

    public void onShow() {
        super.onShow();
        this.getSpreadManager().setItemFormulaShowModel(0);
        this.getSpreadManager().setItemFormulaProvider((IItemFormulaProvider)new RptTaxItemFormulaProvider());
        this.getSpreadManager().setItemFormulaEnable(false);
    }

    @Override
    public void actionAddAccountFormula_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"rptSheet", (Object)this.getBook().getActiveSheet());
        uiContext.put((Object)"spreadManager", (Object)this.getSpreadManager());
        uiContext.put((Object)"editData", (Object)this.getBookProvider().getEditValue());
        IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
        IUIWindow window = uiFactory.create(AccountFormulaUI.class.getName(), (Map)uiContext, null, this.getOprtState());
        window.show();
    }

    private void initSheetSelected() {
        for (int i = 0; i < this.getBook().getSheetCount(); ++i) {
            this.getBook().getSheet(i).setSelected(false);
        }
        this.getBook().getActiveSheet().setSelected(true);
    }

    protected abstract TaxTemplateTypeEnum getTemplateType();

    protected void initWorkButton() {
        if (this.getOprtState().equals(OprtState.VIEW)) {
            this.actionSave.setEnabled(false);
            this.actionEdit.setEnabled(true);
            this.actionImport.setEnabled(false);
        } else {
            this.actionSave.setEnabled(true);
            this.actionEdit.setEnabled(false);
            this.actionImport.setEnabled(true);
        }
    }

    @Override
    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkPermission(this.editData.getCU().getId().toString(), this.getPermissionItem());
        String id = this.editData.getId().toString();
        TaxReportTemplateInfo info = TaxReportTemplateFactory.getRemoteInstance().getTaxReportTemplateInfo((IObjectPK)new ObjectUuidPK(id));
        if (StatusEnum.Enable.equals((Object)info.getState())) {
            MsgBox.showInfo((String)TDUtils.getString("com.kingdee.eas.tm.td.structure.TaxStructureResource", "ENABLENOEDIT", SysContext.getSysContext().getLocale()));
            return;
        }
        String tempOprState = this.getOprtState();
        this.setOprtState("EDIT");
        try {
            this.setDataObject((IObjectValue)this.editData);
        }
        catch (Exception ex) {
            this.setOprtState(tempOprState);
            throw ex;
        }
        this.initWorkButton();
    }

    protected String getPermissionItem() {
        int templateType = this.getTemplateType().getValue();
        String permissionName = "";
        if (0 == templateType) {
            permissionName = "td_accounttemplate_update";
        } else if (1 == templateType) {
            permissionName = "td_draftitemtemplate_update";
        } else if (2 == templateType) {
            permissionName = "td_taxdeclaretemplate_update";
        }
        return permissionName;
    }

    protected void checkPermission(String orgId, String permissionItem) throws EASBizException, BOSException {
        TDFacadeFactory.getRemoteInstance().checkFunctionPermission(orgId, permissionItem);
    }

    @Override
    public void actionTaxItemFormula_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"rptSheet", (Object)this.getBook().getActiveSheet());
        uiContext.put((Object)"spreadManager", (Object)this.getSpreadManager());
        uiContext.put((Object)"editData", (Object)this.getBookProvider().getEditValue());
        IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
        IUIWindow window = uiFactory.create(ItemFormulaWizardUI.class.getName(), (Map)uiContext, null, this.getOprtState());
        window.show();
    }

    @Override
    public void actionReportItemBatchAdd_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"rptSheet", (Object)this.getBook().getActiveSheet());
        uiContext.put((Object)"spreadManager", (Object)this.getSpreadManager());
        uiContext.put((Object)"editData", (Object)this.getBookProvider().getEditValue());
        IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
        IUIWindow window = uiFactory.create(TaxReportItemBatchEditUI.class.getName(), (Map)uiContext, null, this.getOprtState());
        window.show();
    }

    @Override
    public void actionItemFormulaAnalysis_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"rptSheet", (Object)this.getBook().getActiveSheet());
        uiContext.put((Object)"spreadManager", (Object)this.getSpreadManager());
        uiContext.put((Object)"editData", (Object)this.getBookProvider().getEditValue());
        IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
        IUIWindow window = uiFactory.create(ItemFormulaAnalysisUI.class.getName(), (Map)uiContext, null, this.getOprtState());
        window.show();
    }

    @Override
    public void actionTaxItemFormulaLayoutFill_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"rptSheet", (Object)this.getBook().getActiveSheet());
        uiContext.put((Object)"spreadManager", (Object)this.getSpreadManager());
        uiContext.put((Object)"editData", (Object)this.getBookProvider().getEditValue());
        IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
        IUIWindow window = uiFactory.create(ItemFormulaLayoutEditUI.class.getName(), (Map)uiContext, null, this.getOprtState());
        window.show();
    }
}

