/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.structure.rpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.PreChangeEvent;
import com.kingdee.bos.ctrl.swing.event.PreChangeListener;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.basedata.org.client.f7.NewCompanyF7;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.tm.td.DraftRecordTypeEnum;
import com.kingdee.eas.tm.td.RecordTypeEnum;
import com.kingdee.eas.tm.td.TDUtils;
import com.kingdee.eas.tm.td.basedata.TaxItemTypeInfo;
import com.kingdee.eas.tm.td.cloud.utils.TDCloudUtil;
import com.kingdee.eas.tm.td.structure.ReportItemDimensionEnum;
import com.kingdee.eas.tm.td.structure.TaxReportItemInfo;
import com.kingdee.eas.tm.td.structure.TaxReportSheetInfo;
import com.kingdee.eas.tm.td.structure.client.TaxReportItemSelector;
import com.kingdee.eas.tm.td.structure.rpt.client.AbstractTaxItemDataAnalysisConditionUI;
import com.kingdee.eas.tm.td.structure.utils.StructureUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.springframework.util.StringUtils;

public class TaxItemDataAnalysisConditionUI
extends AbstractTaxItemDataAnalysisConditionUI {
    private static final Logger logger = CoreUIObject.getLogger(TaxItemDataAnalysisConditionUI.class);
    private DataChangeListener companyChangeListener = null;
    private ItemListener recordTypeListener = null;
    private DataChangeListener taxTypeLinstener = null;
    private DataChangeListener reportSheetChangeListener = null;

    public void onLoad() throws Exception {
        super.onLoad();
        this.loadFields();
        this.initControl();
        this.setDefaultValue();
    }

    protected void initControl() {
        this.initItemF7(this.prmtRowItem);
        this.initItemF7(this.prmtColumnItem);
        NewCompanyF7 companySelector = new NewCompanyF7((IUIObject)this);
        companySelector.setShowAssistantOrg(false);
        companySelector.setIsCUFilter(false);
        companySelector.setShowVirtual(true);
        companySelector.setContainSealUp(false);
        companySelector.setNeedAddAssistant(true);
        companySelector.setMultiSelect(true);
        companySelector.setPermissionItem("td_TaxItemDataAnalysis_view");
        this.prmtCompany.setSelector((KDPromptSelector)companySelector);
        this.prmtCompany.setHistoryRecordEnabled(false);
        this.prmtReport.setEnabledMultiSelection(true);
    }

    protected void initItemF7(KDBizPromptBox box) {
        box.setEditable(false);
        box.setRefresh(false);
        box.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                KDPromptBox f7Box = (KDPromptBox)e.getSource();
                Object value = TaxItemDataAnalysisConditionUI.this.prmtReportSheet.getValue();
                TaxReportSheetInfo sheetInfo = null;
                if (value != null) {
                    if (value instanceof TaxReportSheetInfo) {
                        sheetInfo = (TaxReportSheetInfo)TaxItemDataAnalysisConditionUI.this.prmtReportSheet.getValue();
                    } else if (!StringUtils.isEmpty((Object)value.toString())) {
                        try {
                            sheetInfo = StructureUtils.getTaxReportSheetByNumber(null, value.toString());
                        }
                        catch (BOSException e1) {
                            TaxItemDataAnalysisConditionUI.this.handUIException(e1);
                        }
                    }
                }
                if (sheetInfo == null) {
                    MsgBox.showInfo((String)TDUtils.getString("com.kingdee.eas.tm.td.structure.TaxStructureResource", "INPUTREPORTSHEET", TDUtils.getLocale()));
                    TaxItemDataAnalysisConditionUI.this.prmtReportSheet.requestFocus();
                    SysUtil.abort();
                }
                ReportItemDimensionEnum itemDimension = null;
                ArrayList<TaxReportItemInfo> rptItemSelected = new ArrayList<TaxReportItemInfo>();
                value = f7Box.getValue();
                TaxReportItemInfo itemInfo = null;
                if (value != null) {
                    if (value instanceof TaxReportItemInfo) {
                        itemInfo = (TaxReportItemInfo)value;
                        rptItemSelected.add(itemInfo);
                    } else if (value instanceof List) {
                        List list = (List)value;
                        for (int i = 0; i < list.size(); ++i) {
                            rptItemSelected.add((TaxReportItemInfo)list.get(i));
                        }
                    }
                }
                if (f7Box.getName().equals("prmtRowItem")) {
                    itemDimension = ReportItemDimensionEnum.ROW;
                } else if (f7Box.getName().equals("prmtColumnItem")) {
                    itemDimension = ReportItemDimensionEnum.COLUMN;
                }
                TaxReportItemSelector selector = new TaxReportItemSelector(sheetInfo, itemDimension, rptItemSelected);
                selector.setEnabledMultiSelection(true);
                f7Box.setSelector((KDPromptSelector)selector);
            }
        });
        box.addPreChangeListener(new PreChangeListener(){

            public void preChange(PreChangeEvent e) {
                KDPromptBox f7Box = (KDPromptBox)e.getSource();
                e.setResult(1);
            }
        });
    }

    @Override
    public void loadFields() {
        this.removeListener();
        super.loadFields();
        this.initListeners();
        this.setFilter();
    }

    protected void setDefaultValue() {
        Calendar cale = Calendar.getInstance();
        int year = cale.get(1);
        int month = cale.get(2) + 1;
        this.spinBeginYear.setValue((Object)year);
        this.spinEndYear.setValue((Object)year);
        this.spinBeginPeriod.setValue((Object)month);
        this.spinEndPeriod.setValue((Object)month);
        this.cbRecordType.setSelectedItem((Object)RecordTypeEnum.TaxDeclare);
        this.cbDraftRecordType.setSelectedItem((Object)DraftRecordTypeEnum.normalRecord);
    }

    private void removeListener() {
        if (this.companyChangeListener != null) {
            this.prmtCompany.removeDataChangeListener(this.companyChangeListener);
        }
        if (this.taxTypeLinstener != null) {
            this.prmtTaxType.removeDataChangeListener(this.taxTypeLinstener);
        }
        if (this.recordTypeListener != null) {
            this.cbRecordType.removeItemListener(this.recordTypeListener);
        }
        if (this.reportSheetChangeListener != null) {
            this.prmtReportSheet.removeDataChangeListener(this.reportSheetChangeListener);
        }
    }

    private void initListeners() {
        this.companyChangeListener = new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                if (TDCloudUtil.isEqual(e.getNewValue(), e.getOldValue())) {
                    return;
                }
                TaxItemDataAnalysisConditionUI.this.company_dataChanged(e);
            }
        };
        this.prmtCompany.addDataChangeListener(this.companyChangeListener);
        this.taxTypeLinstener = new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                if (TDCloudUtil.isEqual(e.getNewValue(), e.getOldValue())) {
                    return;
                }
                TaxItemDataAnalysisConditionUI.this.taxType_dataChanged(e);
            }
        };
        this.prmtTaxType.addDataChangeListener(this.taxTypeLinstener);
        this.recordTypeListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                TaxItemDataAnalysisConditionUI.this.recordType_dataChanged(e);
            }
        };
        this.cbRecordType.addItemListener(this.recordTypeListener);
        this.reportSheetChangeListener = new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                if (TDCloudUtil.isEqual(e.getNewValue(), e.getOldValue())) {
                    return;
                }
                TaxItemDataAnalysisConditionUI.this.reportSheet_dataChanged(e);
            }
        };
        this.prmtReportSheet.addDataChangeListener(this.reportSheetChangeListener);
    }

    protected void company_dataChanged(DataChangeEvent e) {
        this.prmtBuildingTaxesGroup.setValue(null);
        this.setBuildingTaxesGroupFilter();
        this.prmtReport.setValue(null);
        this.setReportFilter();
    }

    protected void setReportFilter() {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        Object company = this.prmtCompany.getValue();
        TaxItemTypeInfo taxType = (TaxItemTypeInfo)this.prmtTaxType.getValue();
        RecordTypeEnum recordType = (RecordTypeEnum)((Object)this.cbRecordType.getSelectedItem());
        if (company != null) {
            List ids = StructureUtils.getF7Value(company);
            filter.getFilterItems().add(new FilterItemInfo("companyOrgUnit.id", new HashSet(ids), CompareType.INCLUDE));
        }
        if (taxType != null) {
            filter.getFilterItems().add(new FilterItemInfo("taxType.id", (Object)taxType.getId().toString(), CompareType.EQUALS));
        }
        if (recordType != null) {
            filter.getFilterItems().add(new FilterItemInfo("recordType", (Object)recordType.getValue(), CompareType.EQUALS));
        }
        view.setFilter(filter);
        this.prmtReport.setEntityViewInfo(view);
    }

    private Map<String, Integer> getPeriodMap() {
        int yearFrom = (Integer)this.spinBeginYear.getValue();
        int monthFrom = (Integer)this.spinBeginPeriod.getValue();
        int yearTo = (Integer)this.spinEndYear.getValue();
        int monthTo = (Integer)this.spinEndPeriod.getValue();
        HashMap<String, Integer> periodMap = new HashMap<String, Integer>();
        periodMap.put("periodFrom", yearFrom * 100 + monthFrom);
        periodMap.put("periodTo", yearTo * 100 + monthTo);
        return periodMap;
    }

    protected void taxType_dataChanged(DataChangeEvent e) {
        this.clearItemConfig();
        this.setReportSheetF7Filter();
        this.prmtAccount.setValue(null);
        this.prmtBuildingTaxesGroup.setValue(null);
        this.initBuildingTaxesGroupF7();
        this.initRecordType();
        this.setAccountConfigFilter();
        this.prmtReport.setValue(null);
        this.setReportFilter();
    }

    protected void initRecordType() {
        RecordTypeEnum recordTypeEnum = (RecordTypeEnum)((Object)this.cbRecordType.getSelectedItem());
        TaxItemTypeInfo taxType = (TaxItemTypeInfo)this.prmtTaxType.getValue();
        this.cbRecordType.removeAllItems();
        ArrayList<RecordTypeEnum> recordTypeList = new ArrayList<RecordTypeEnum>();
        if (taxType != null && "Xip1b7mfPS7gU0ETqMBAL9uK96Y=".equals(taxType.getId().toString())) {
            this.cbRecordType.addItem((Object)RecordTypeEnum.Account);
            this.cbRecordType.addItem((Object)RecordTypeEnum.AnnualDraftItem);
            this.cbRecordType.addItem((Object)RecordTypeEnum.QuarterlyDraftItem);
            this.cbRecordType.addItem((Object)RecordTypeEnum.AnnualTaxDeclare);
            this.cbRecordType.addItem((Object)RecordTypeEnum.QuarterlyTaxDeclare);
            recordTypeList.add(RecordTypeEnum.Account);
            recordTypeList.add(RecordTypeEnum.AnnualDraftItem);
            recordTypeList.add(RecordTypeEnum.QuarterlyDraftItem);
            recordTypeList.add(RecordTypeEnum.AnnualTaxDeclare);
            recordTypeList.add(RecordTypeEnum.QuarterlyTaxDeclare);
        } else {
            this.cbRecordType.addItem((Object)RecordTypeEnum.Account);
            this.cbRecordType.addItem((Object)RecordTypeEnum.DraftItem);
            this.cbRecordType.addItem((Object)RecordTypeEnum.TaxDeclare);
            recordTypeList.add(RecordTypeEnum.Account);
            recordTypeList.add(RecordTypeEnum.DraftItem);
            recordTypeList.add(RecordTypeEnum.TaxDeclare);
        }
        if (!recordTypeList.contains((Object)recordTypeEnum)) {
            recordTypeEnum = (RecordTypeEnum)((Object)recordTypeList.get(0));
        }
        this.cbRecordType.setSelectedItem((Object)recordTypeEnum);
    }

    private void initBuildingTaxesGroupF7() {
        RecordTypeEnum recordTypeEnum = (RecordTypeEnum)((Object)this.cbRecordType.getSelectedItem());
        TaxItemTypeInfo taxType = (TaxItemTypeInfo)this.prmtTaxType.getValue();
        if (taxType != null && RecordTypeEnum.TaxDeclare.equals((Object)recordTypeEnum) && taxType.getId().toString().equals("ZCyrvv6oAnPgU0ETqMCc49uK96Y=")) {
            this.prmtBuildingTaxesGroup.setEnabled(true);
        } else {
            this.prmtBuildingTaxesGroup.setEnabled(false);
        }
    }

    private void clearItemConfig() {
        this.prmtReportSheet.removeDataChangeListener(this.reportSheetChangeListener);
        this.prmtReportSheet.setValue(null);
        this.prmtRowItem.setValue(null);
        this.prmtColumnItem.setValue(null);
        this.prmtReportSheet.addDataChangeListener(this.reportSheetChangeListener);
    }

    protected void recordType_dataChanged(ItemEvent e) {
        this.clearItemConfig();
        this.setReportSheetF7Filter();
        this.initAccountConfigF7();
        this.initBuildingTaxesGroupF7();
        this.prmtReport.setValue(null);
        this.setReportFilter();
    }

    private void initAccountConfigF7() {
        this.prmtAccount.setValue(null);
        RecordTypeEnum recordTypeEnum = (RecordTypeEnum)((Object)this.cbRecordType.getSelectedItem());
        if (RecordTypeEnum.Account.equals((Object)recordTypeEnum)) {
            this.prmtAccount.setEnabled(true);
        } else {
            this.prmtAccount.setEnabled(false);
        }
    }

    protected void reportSheet_dataChanged(DataChangeEvent e) {
        this.prmtRowItem.setValue(null);
        this.prmtColumnItem.setValue(null);
    }

    private void setFilter() {
        StructureUtils.setTaxTypeFilter(this.prmtTaxType);
        this.setAccountConfigFilter();
        this.setReportSheetF7Filter();
        this.setBuildingTaxesGroupFilter();
    }

    protected void setReportSheetF7Filter() {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        Object value = this.prmtTaxType.getValue();
        if (value != null && value instanceof TaxItemTypeInfo) {
            TaxItemTypeInfo taxType = (TaxItemTypeInfo)value;
            filter.getFilterItems().add(new FilterItemInfo("taxType.id", (Object)taxType.getId().toString(), CompareType.EQUALS));
        }
        if ((value = this.cbRecordType.getSelectedItem()) != null && value instanceof RecordTypeEnum) {
            RecordTypeEnum recordType = (RecordTypeEnum)((Object)value);
            filter.getFilterItems().add(new FilterItemInfo("recordType", (Object)recordType.getValue(), CompareType.EQUALS));
        }
        filter.getFilterItems().add(new FilterItemInfo("state", (Object)"2", CompareType.EQUALS));
        view.setFilter(filter);
        this.prmtReportSheet.setEntityViewInfo(view);
    }

    protected void setAccountConfigFilter() {
        TaxItemTypeInfo taxType = (TaxItemTypeInfo)this.prmtTaxType.getValue();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (taxType != null) {
            filter.getFilterItems().add(new FilterItemInfo("taxTypeItem.id", (Object)taxType.getId().toString(), CompareType.EQUALS));
        }
        view.setFilter(filter);
        this.prmtAccount.setEntityViewInfo(view);
    }

    protected void setBuildingTaxesGroupFilter() {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("state", (Object)"1", CompareType.EQUALS));
        view.setFilter(filter);
        this.prmtBuildingTaxesGroup.setEntityViewInfo(view);
    }

    public void onInit(RptParams initParams) throws Exception {
    }

    public RptParams getCustomCondition() {
        RptParams para = new RptParams();
        para.setObject("company", this.prmtCompany.getValue());
        para.setObject("yearFrom", this.spinBeginYear.getValue());
        para.setObject("monthFrom", this.spinBeginPeriod.getValue());
        para.setObject("yearTo", this.spinEndYear.getValue());
        para.setObject("monthTo", this.spinEndPeriod.getValue());
        para.setObject("taxType", this.prmtTaxType.getValue());
        para.setObject("recordType", this.cbRecordType.getSelectedItem());
        para.setObject("report", this.prmtReport.getValue());
        para.setObject("subRecordType", this.cbDraftRecordType.getSelectedItem());
        para.setObject("account", this.prmtAccount.getValue());
        para.setObject("buildingTaxesGroup", this.prmtBuildingTaxesGroup.getValue());
        para.setObject("reportSheet", this.prmtReportSheet.getValue());
        para.setObject("rowItem", this.prmtRowItem.getValue());
        para.setObject("columnItem", this.prmtColumnItem.getValue());
        return para;
    }

    public void setCustomCondition(RptParams params) {
        this.prmtCompany.setValue(params.getObject("company"));
        this.spinBeginYear.setValue(params.getObject("yearFrom"));
        this.spinBeginPeriod.setValue(params.getObject("monthFrom"));
        this.spinEndYear.setValue(params.getObject("yearTo"));
        this.spinEndPeriod.setValue(params.getObject("monthTo"));
        this.prmtTaxType.setValue(params.getObject("taxType"));
        this.cbRecordType.setSelectedItem(params.getObject("recordType"));
        this.prmtReport.setValue(params.getObject("report"));
        this.cbDraftRecordType.setSelectedItem(params.getObject("subRecordType"));
        this.prmtAccount.setValue(params.getObject("account"));
        this.prmtBuildingTaxesGroup.setValue(params.getObject("buildingTaxesGroup"));
        this.prmtReportSheet.setValue(params.getObject("reportSheet"));
        this.prmtRowItem.setValue(params.getObject("rowItem"));
        this.prmtColumnItem.setValue(params.getObject("columnItem"));
    }

    public void clear() {
        this.prmtCompany.setValue(null);
        this.prmtTaxType.setValue(null);
        this.prmtReport.setValue(null);
        this.prmtAccount.setValue(null);
        this.prmtBuildingTaxesGroup.setValue(null);
        this.prmtReportSheet.setValue(null);
        this.prmtRowItem.setValue(null);
        this.prmtColumnItem.setValue(null);
        this.setDefaultValue();
    }

    public boolean verify() {
        StringBuffer sb = new StringBuffer();
        if (this.prmtCompany.getValue() == null) {
            sb.append("\u3001");
            sb.append(TDUtils.getString("com.kingdee.eas.tm.td.structure.TaxStructureResource", "CompanyName", TDUtils.getLocale()));
        }
        if (this.prmtTaxType.getValue() == null) {
            sb.append("\u3001");
            sb.append(TDUtils.getString("com.kingdee.eas.tm.td.structure.TaxStructureResource", "TaxType", TDUtils.getLocale()));
        }
        if (sb.length() > 0) {
            sb.append(TDUtils.getString("com.kingdee.eas.tm.td.structure.TaxStructureResource", "NotNull", TDUtils.getLocale()));
            MsgBox.showWarning((String)sb.substring(1));
            SysUtil.abort();
        }
        return true;
    }
}

