/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.structure.template.taxotherreport.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tm.td.PeriodTypeEnum;
import com.kingdee.eas.tm.td.StatusEnum;
import com.kingdee.eas.tm.td.TDUtils;
import com.kingdee.eas.tm.td.common.permsupport.IPermSupport4EditUI;
import com.kingdee.eas.tm.td.common.uihelper.EditUIHelper;
import com.kingdee.eas.tm.td.structure.TaxOtherReportTemplateFactory;
import com.kingdee.eas.tm.td.structure.TaxOtherReportTemplateInfo;
import com.kingdee.eas.tm.td.structure.template.taxotherreport.client.AbstractTaxOtherReportTemplateEditUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class TaxOtherReportTemplateEditUI
extends AbstractTaxOtherReportTemplateEditUI
implements IPermSupport4EditUI {
    private static final Logger logger = CoreUIObject.getLogger(TaxOtherReportTemplateEditUI.class);
    private static final String RES = "com.kingdee.eas.tm.td.basedata.TaxBaseResource";
    protected static final String NEXTLINE = ";\r\n";
    private static String currentCUid;
    private static EditUIHelper uiHelper;

    public TaxOtherReportTemplateEditUI() throws Exception {
        uiHelper = new EditUIHelper(this);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        currentCUid = SysContext.getSysContext().getCurrentCtrlUnit().getId().toString();
        this.initControl();
        this.initFilter();
        this.initDefaultValue();
    }

    private void initDefaultValue() {
        this.comboStatePeriod.setSelectedItem((Object)PeriodTypeEnum.MONTHLY);
    }

    private void initFilter() {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)0, CompareType.EQUALS));
        view.setFilter(filter);
        this.prmtReportType.setEntityViewInfo(view);
        EntityViewInfo view1 = new EntityViewInfo();
        FilterInfo filter1 = new FilterInfo();
        filter1.getFilterItems().add(new FilterItemInfo("status", (Object)"1", CompareType.EQUALS));
        view1.setFilter(filter1);
        this.prmtBillRange.setEntityViewInfo(view1);
    }

    private void initControl() {
        if (this.editData.getId() != null) {
            this.btnCancel.setEnabled(false);
            this.btnCancelCancel.setEnabled(false);
        }
        if (StatusEnum.DisEnable.equals((Object)this.editData.getState())) {
            this.btnCancel.setEnabled(false);
            this.btnCancelCancel.setEnabled(true);
            this.btnEdit.setVisible(true);
        } else if (StatusEnum.Enable.equals((Object)this.editData.getState())) {
            this.btnCancel.setEnabled(true);
            this.btnCancelCancel.setEnabled(false);
            this.btnEdit.setVisible(false);
        }
        this.btnSave.setVisible(false);
        this.btnPrint.setVisible(false);
        this.btnPrintPreview.setVisible(false);
        this.menuItemPrint.setVisible(false);
        this.menuItemPrintPreview.setVisible(false);
    }

    private void checkFields() {
        String number = this.txtNumber.getText();
        String name = this.txtName.getText();
        if (StringUtils.isEmpty((String)number)) {
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"Number_NULL"));
            SysUtil.abort();
        }
        if (StringUtils.isEmpty((String)name)) {
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"Name_NULL"));
            SysUtil.abort();
        }
        if (this.prmtReportType.getValue() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"NOT_SELECT_REPORTTYPE"));
            SysUtil.abort();
        }
    }

    private void refresh(IObjectPK pk) throws Exception {
        this.setDataObject(this.getValue(pk));
        this.loadFields();
        this.initOldData((IObjectValue)this.editData);
        this.initControl();
    }

    protected void setFieldsNull(AbstractObjectValue newData) {
        if (newData instanceof TaxOtherReportTemplateInfo) {
            TaxOtherReportTemplateInfo editData = (TaxOtherReportTemplateInfo)newData;
            editData.setName(editData.getName() + "_copy");
            editData.setNumber(editData.getNumber() + "_copy");
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.checkFields();
        super.actionSubmit_actionPerformed(e);
        this.setOprtState("VIEW");
        if (this.editData != null && this.editData.getId() != null) {
            String billId = this.editData.getId().toString();
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)billId));
            this.refresh((IObjectPK)pk);
        }
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        uiHelper.checkCanAddnew(currentCUid);
        super.actionAddNew_actionPerformed(e);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        uiHelper.checkCanEdit(currentCUid, this.editData.getId().toString());
        super.actionEdit_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(this.editData.getId().toString());
        uiHelper.checkCanRemove(currentCUid, ids);
        super.actionRemove_actionPerformed(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionCancel_actionPerformed(ActionEvent e) {
        ArrayList<String> ids = new ArrayList<String>();
        try {
            if (this.editData != null && this.editData.getId() != null) {
                String billId = this.editData.getId().toString();
                ids.add(billId);
                uiHelper.checkBaseDataPermission(currentCUid, ids);
                TDUtils.tryLock(ids);
                this.comboState.setSelectedItem((Object)StatusEnum.DisEnable);
                super.actionCancel_actionPerformed(e);
                ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)billId));
                this.refresh((IObjectPK)pk);
            }
        }
        catch (Exception e2) {
            this.handUIException(e2);
        }
        finally {
            TDUtils.releaseLock(ids);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionCancelCancel_actionPerformed(ActionEvent e) {
        ArrayList<String> ids = new ArrayList<String>();
        try {
            if (this.editData != null && this.editData.getId() != null) {
                String billId = this.editData.getId().toString();
                ids.add(billId);
                uiHelper.checkBaseDataPermission(currentCUid, ids);
                TDUtils.tryLock(ids);
                this.comboState.setSelectedItem((Object)StatusEnum.Enable);
                super.actionCancelCancel_actionPerformed(e);
                ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)billId));
                this.refresh((IObjectPK)pk);
            }
        }
        catch (Exception e2) {
            this.handUIException(e2);
        }
        finally {
            TDUtils.releaseLock(ids);
        }
    }

    protected IObjectValue createNewData() {
        TaxOtherReportTemplateInfo info = new TaxOtherReportTemplateInfo();
        info.setCU(SysContext.getSysContext().getCurrentCtrlUnit());
        info.setState(StatusEnum.SAVE);
        return info;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return TaxOtherReportTemplateFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
    }

    @Override
    public String getBizOrgProperty(OrgType orgType) throws BOSException, EASBizException {
        return "CU";
    }

    @Override
    public ICoreBase getPermInterface() throws Exception {
        return this.getBizInterface();
    }

    @Override
    public String getPermItem(String status) {
        return null;
    }

    @Override
    public KDBizPromptBox getPermMainBizOrg() {
        return null;
    }

    @Override
    public IObjectValue getValueObject() {
        return this.editData;
    }
}

