/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.structure.template.taxotherreport.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.core.IExtRender;
import com.kingdee.bos.ctrl.excel.impl.ActionManager;
import com.kingdee.bos.ctrl.excel.impl.ToolBarManager;
import com.kingdee.bos.ctrl.excel.impl.action.SpreadAction;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.event.BookChangeEvent;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.newrpt.DesignerResource;
import com.kingdee.eas.fi.newrpt.client.designer.IItemFormulaProvider;
import com.kingdee.eas.fi.newrpt.client.designer.SpreadManager;
import com.kingdee.eas.fi.newrpt.client.designer.render.IRenderProvider;
import com.kingdee.eas.fi.newrpt.client.designer.render.SumRangeRender;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.tm.td.DraftBillBuildCenter;
import com.kingdee.eas.tm.td.TDUtils;
import com.kingdee.eas.tm.td.basedata.RptBillRangeEntryCollection;
import com.kingdee.eas.tm.td.basedata.RptBillRangeEntryInfo;
import com.kingdee.eas.tm.td.basedata.RptBillRangeFactory;
import com.kingdee.eas.tm.td.basedata.RptBillRangeInfo;
import com.kingdee.eas.tm.td.client.AccountFormulaUI;
import com.kingdee.eas.tm.td.structure.TaxOtherReportTemplateInfo;
import com.kingdee.eas.tm.td.structure.template.taxotherreport.client.AbstractTaxOtherReportTemplateRptUI;
import com.kingdee.eas.tm.td.structure.template.taxotherreport.client.TaxOtherReportTemplateBookProvider;
import com.kingdee.eas.tm.td.structure.template.taxotherreport.client.TaxOtherReportTemplateMenuStrategy;
import com.kingdee.eas.tm.td.structure.template.taxotherreport.client.TaxOtherReportTemplatePropertyAdapter;
import com.kingdee.eas.tm.td.structure.template.taxotherreport.client.TaxOtherReportTemplateVariableProvider;
import com.kingdee.eas.tm.td.structure.utils.RptTaxItemFormulaProvider;
import com.kingdee.eas.tm.td.structure.utils.StructureUtils;
import com.kingdee.eas.tm.td.utils.render.DefaultRenderProvider;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;

public class TaxOtherReportTemplateRptUI
extends AbstractTaxOtherReportTemplateRptUI {
    private static final Logger logger = CoreUIObject.getLogger(TaxOtherReportTemplateRptUI.class);
    private TaxOtherReportTemplateInfo editData = null;

    public TaxOtherReportTemplateRptUI() throws Exception {
        this.setMenuStrategy(new TaxOtherReportTemplateMenuStrategy());
        this.setBookProvider(new TaxOtherReportTemplateBookProvider());
        this.setVariableProvider(new TaxOtherReportTemplateVariableProvider());
        this.setPropertyAdapter(new TaxOtherReportTemplatePropertyAdapter());
    }

    protected void initToolbar() {
        ToolBarManager toolBarManager = this.getSpreadManager().getSpreadContainer().getToolBarManager();
        this.actionSave.putValue("SmallIcon", (Object)EASResource.getIcon((String)"imgTbtn_save"));
        toolBarManager.addFirstGroupItem((Action)this.actionSave, "common");
        this.actionEdit.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_edit"));
        toolBarManager.addFirstGroupItem((Action)((Object)this.actionEdit), "common");
        this.actionAddAccountFormula.putValue("AcceleratorKey", KeyStroke.getKeyStroke("F6"));
        ActionManager actions = this.getSpreadManager().getSpreadContainer().getActionManager();
        SpreadAction action = actions.getAction("SetCellDisplayMode");
        action.putValue("SmallIcon", (Object)EASResource.getIcon((String)"imgTbtn_showformula"));
        this.actionSheetManager.putValue("SmallIcon", (Object)EASResource.getIcon((String)"imgTbtn_reportparameter"));
        this.actionFormulaValueSwitch.putValue("SmallIcon", (Object)EASResource.getIcon((String)"imgTbtn_showformula"));
        toolBarManager.addLastGroupItem((Action)this.actionFormulaValueSwitch, "common");
        this.toolBar = toolBarManager.getToolBar("common");
        this.toolBar.setIsControlByParent(false);
        this.toolBar.setTextIconDisStyle((short)2);
        this.toolBar.setPopupMenuShowable(true);
        this.getSpreadManager().setUserExtRender((IExtRender)SumRangeRender.getInstance());
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public String getUITitle() {
        return TDUtils.getString("com.kingdee.eas.tm.td.structure.TaxStructureResource", "TAXOTHERRPT", TDUtils.getLocale());
    }

    public void onLoad() throws Exception {
        super.onLoad();
        SpreadManager.registerRenderProvider((IRenderProvider)new DefaultRenderProvider());
        this.menuItemViewFormula.doClick();
        this.getBook().setCalculate(false);
        this.editData = (TaxOtherReportTemplateInfo)this.getReportAdapter().getReportProperty("editData");
        for (int i = 0; i < this.getBook().getSheetCount(); ++i) {
            this.getBook().getSheet(i).getSheetOption().setCellDisplayMode(1);
        }
        this.initActions();
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            this.addDataSheet();
        }
    }

    private void initActions() {
        this.menuItemMenuDriftBill.setVisible(true);
        this.menuItemMenuDriftBill.setEnabled(true);
    }

    @Override
    public void actionAddAccountFormula_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext();
        uiContext.put((Object)"rptSheet", (Object)this.getBook().getActiveSheet());
        uiContext.put((Object)"spreadManager", (Object)this.getSpreadManager());
        uiContext.put((Object)"editData", (Object)this.getBookProvider().getEditValue());
        uiContext.put((Object)"templateType", (Object)"OtherTemplate");
        IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
        IUIWindow window = uiFactory.create(AccountFormulaUI.class.getName(), (Map)uiContext, null, this.getOprtState());
        window.show();
    }

    @Override
    public void actionInsertDraftBill_actionPerformed(ActionEvent e) throws Exception {
        this.addDataSheet();
    }

    private void initSheetSelected() {
        for (int i = 0; i < this.getBook().getSheetCount(); ++i) {
            this.getBook().getSheet(i).setSelected(false);
        }
        this.getBook().getActiveSheet().setSelected(true);
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        this.verify(e);
        this.beforeSave();
        this.getBookProvider().restoreBook(this.getBook());
        try {
            this.getSpreadManager().getSpreadContainer().getStateManager().stopAll();
            IObjectPK pk = this.getBookProvider().getBizInterface().save((CoreBaseInfo)this.getBookProvider().getEditValue());
            this.getBookProvider().setEditValue(this.getBookProvider().queryEditData(pk));
            this.editData = (TaxOtherReportTemplateInfo)this.getBookProvider().getEditValue();
            if (!this.getUIContext().containsKey("SumRptProcessUI_isSumGrade")) {
                this.showSuccessMsg(DesignerResource.getString((String)"saveOK"));
            }
            this.getSpreadManager().getModifyManager().discardAllEdits();
            this.getSpreadManager().getSpreadContainer().getToolBarManager().changed(new BookChangeEvent(this.getBook().getActiveSheet(), "Sheet_Hide"));
        }
        catch (Exception e2) {
            MsgBox.showDetailAndOK((Component)((Object)this), (String)DesignerResource.getString((String)"saveFail").replaceAll("\uff0c", ""), (String)e2.getMessage(), (int)0);
            SysUtil.abort();
        }
        this.actionEdit.setEnabled(true);
        this.actionSave.setEnabled(false);
    }

    private void addDataSheet() throws EASBizException, BOSException {
        if (this.editData.getBillRange() == null) {
            MsgBox.showInfo((String)TDUtils.getString("com.kingdee.eas.tm.td.TDResource", "INSERT_ERROR_NOBILLS", TDUtils.getLocale()));
            return;
        }
        String billId = this.editData.getBillRange().getId().toString();
        ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)billId));
        RptBillRangeInfo rangeInfo = RptBillRangeFactory.getRemoteInstance().getRptBillRangeInfo((IObjectPK)pk);
        RptBillRangeEntryCollection billRangeEntrys = rangeInfo.getEntrys();
        if (billRangeEntrys.size() == 0) {
            return;
        }
        SpreadManager spreadManager = this.getSpreadManager();
        for (int k = 0; k < billRangeEntrys.size(); ++k) {
            RptBillRangeEntryInfo entry = billRangeEntrys.get(k);
            String bosType = entry.getBillBosType();
            String billName = entry.getBillName();
            Sheet exists = this.getBook().getSheet(billName);
            if (exists != null) continue;
            Sheet rptSheet = new Sheet(this.getBook(), billName);
            rptSheet.setUserObject("bosType", (Object)bosType);
            this.getBook().addSheet(rptSheet);
            rptSheet.setSelected(false);
            rptSheet.getRange(0, 0, rptSheet.getMaxRowIndex(), rptSheet.getMaxColIndex()).clear(true, true, false, true, new String[0]);
            int top = rptSheet.getActiveRow();
            int left = rptSheet.getActiveCol();
            DraftBillBuildCenter.initDraftBillInfos(null, bosType);
            List<DraftBillBuildCenter> fieldList = DraftBillBuildCenter.getFieldsList(bosType);
            int index = 0;
            for (int i = 0; i < fieldList.size(); ++i) {
                DraftBillBuildCenter info = fieldList.get(i);
                int valueRangeTop = top;
                if (info.getFieldName().equals("companyOrgUnit") && bosType.equals("ED4D060A")) continue;
                rptSheet.getRange(valueRangeTop, left + index).setValue(new Variant((Object)info.getFieldDisplayName()));
                rptSheet.getRange(valueRangeTop, left + index).setUserObject("fieldKey", (Object)info.getFieldName());
                if (info.getProperty() instanceof LinkPropertyInfo) {
                    StyleAttributes sa = Styles.getEmptySA();
                    sa.setNumberFormat("@");
                    rptSheet.getColRange(left + index, left + index).setStyle(sa, sa);
                }
                StructureUtils.autoSetColWidth(spreadManager, rptSheet, valueRangeTop, left + index);
                ++index;
            }
            Range range = rptSheet.getRange(top, left);
            range.setUserObject("fieldsCount", (Object)fieldList.size());
        }
        this.initSheetSelected();
    }

    @Override
    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.actionEdit.setEnabled(false);
        this.actionSave.setEnabled(true);
        super.actionEdit_actionPerformed(e);
        String tempOprState = this.getOprtState();
        this.setOprtState("EDIT");
        try {
            this.setDataObject((IObjectValue)this.editData);
        }
        catch (Exception ex) {
            this.setOprtState(tempOprState);
            throw ex;
        }
    }

    public void onShow() {
        super.onShow();
        this.getSpreadManager().setItemFormulaShowModel(0);
        this.getSpreadManager().setItemFormulaProvider((IItemFormulaProvider)new RptTaxItemFormulaProvider());
        this.getSpreadManager().setItemFormulaEnable(false);
    }
}

