/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.structure.utils;

import com.google.gson.Gson;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.fi.rpt.util.UserObjectHelper;
import com.kingdee.eas.tm.td.structure.TaxReportItemCollection;
import com.kingdee.eas.tm.td.structure.TaxReportItemFactory;
import com.kingdee.eas.tm.td.structure.utils.ItemLayoutParams;
import com.kingdee.eas.tm.td.utils.Location;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class StructureUIHelper {
    public static final String ITEM_LAYOUT_PARAMS = "ItemLayoutParams";

    public static ArrayList getBasePointList(Sheet sheet) {
        int rowCount = sheet.getRows().getMaxIntMark() + 1;
        int columnCount = sheet.getCols().getMaxIntMark() + 1;
        ArrayList<Point> list = new ArrayList<Point>();
        Point point = null;
        for (int i = 0; i < rowCount; ++i) {
            for (int j = 0; j < columnCount; ++j) {
                if (!StructureUIHelper.isBasePointCell(sheet, i, j)) continue;
                point = new Point(j, i);
                list.add(point);
            }
        }
        return list;
    }

    public static Point getBasePoint(Sheet sheet, Point point, ArrayList basePointList) {
        for (int i = basePointList.size() - 1; i >= 0; --i) {
            Point element = (Point)basePointList.get(i);
            if (!StructureUIHelper.getRectangle(sheet, element).contains(point)) continue;
            return element;
        }
        return null;
    }

    public static Rectangle getRectangle(Sheet sheet, Point basePoint) {
        ItemLayoutParams itemParams = StructureUIHelper.getParametersFromCell(sheet, basePoint.y, basePoint.x);
        if (itemParams != null) {
            int headWidth = itemParams.getEntry().size();
            int bodyHeight = itemParams.getRowCounter();
            if (bodyHeight == 0) {
                bodyHeight = 1;
            }
            return new Rectangle(basePoint.x, basePoint.y, headWidth, bodyHeight);
        }
        return null;
    }

    public static boolean isBasePointCell(Sheet sheet, int rowIndex, int colIndex) {
        Range range = sheet.getRange(rowIndex, colIndex);
        String json = (String)range.getUserObject(ITEM_LAYOUT_PARAMS);
        return !StringUtils.isEmpty((String)json);
    }

    public static ItemLayoutParams getParametersFromCell(Sheet sheet, int rowIndex, int colIndex) {
        Range range = sheet.getRange(rowIndex, colIndex);
        range = UserObjectHelper.getUnprotectedRange((Range)range);
        String json = (String)range.getUserObject(ITEM_LAYOUT_PARAMS);
        ItemLayoutParams itemParams = null;
        if (!StringUtils.isEmpty((String)json)) {
            Gson gson = new Gson();
            itemParams = (ItemLayoutParams)gson.fromJson(json, ItemLayoutParams.class);
        }
        return itemParams;
    }

    public static void saveBasePointCell(Sheet sheet, Point basePoint, ItemLayoutParams formulaParams) {
        Range range = sheet.getRange(basePoint.y, basePoint.x);
        range = UserObjectHelper.getUnprotectedRange((Range)range);
        Gson gson = new Gson();
        range.setUserObject(ITEM_LAYOUT_PARAMS, (Object)gson.toJson((Object)formulaParams));
    }

    public static void saveBasePointCell(Range range, ItemLayoutParams formulaParams) {
        range = UserObjectHelper.getUnprotectedRange((Range)range);
        Gson gson = new Gson();
        range.setUserObject(ITEM_LAYOUT_PARAMS, (Object)gson.toJson((Object)formulaParams));
    }

    public static TaxReportItemCollection getTaxReportItemByNumber(Set numberSet) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)numberSet, CompareType.INCLUDE));
        view.setFilter(filter);
        TaxReportItemCollection itemColl = TaxReportItemFactory.getRemoteInstance().getTaxReportItemCollection(view);
        return itemColl;
    }

    public static int getDefaultCounter(String analysisRange) {
        if (!StringUtils.isEmpty((String)analysisRange)) {
            String[] str = analysisRange.split("!");
            String[] cells = null;
            int[] point1 = null;
            int[] point2 = null;
            if (str.length > 1) {
                cells = str[1].split(":");
                if (cells.length > 1) {
                    point1 = Location.getCellRowAndColumn(cells[0]);
                    point2 = Location.getCellRowAndColumn(cells[1]);
                    return point2[0] - point1[0] + 1;
                }
                return 1;
            }
        }
        return 0;
    }

    public static boolean beforeAddRow(Sheet sheet) {
        return StructureUIHelper.beforeEditRowCol(sheet, true, true);
    }

    public static boolean beforeAddColumn(Sheet sheet) {
        return StructureUIHelper.beforeEditRowCol(sheet, false, true);
    }

    public static boolean beforeDeleteRow(Sheet table) {
        return StructureUIHelper.beforeEditRowCol(table, true, false);
    }

    public static boolean beforeDeleteColumn(Sheet table) {
        return StructureUIHelper.beforeEditRowCol(table, false, false);
    }

    public static boolean beforeEditRowCol(Sheet sheet, boolean isRow, boolean isInsert) {
        ArrayList baseList = StructureUIHelper.getBasePointList(sheet);
        if (baseList == null || baseList.size() == 0) {
            return false;
        }
        Range selection = sheet.getSelectionRange();
        HashMap transaction = new HashMap();
        for (int i = 0; i < selection.size(); ++i) {
            CellBlock block = selection.getBlock(i);
            int start = isRow ? block.getRow() : block.getCol();
            int end = isRow ? block.getRow2() : block.getCol2();
            for (int j = start; j <= end; ++j) {
                boolean b = StructureUIHelper.beforeRowColEdit(sheet, isInsert ? start : j, isRow, isInsert, transaction, baseList);
                if (!b) continue;
                return true;
            }
        }
        for (Map.Entry element : transaction.entrySet()) {
            Point p = (Point)element.getKey();
            ItemLayoutParams value = (ItemLayoutParams)element.getValue();
            Range range = UserObjectHelper.getUnprotectedRange((Range)sheet.getRange(p.y, p.x));
            StructureUIHelper.saveBasePointCell(range, value);
        }
        return false;
    }

    private static boolean beforeRowColEdit(Sheet sheet, int index, boolean isRow, boolean isInsert, Map transaction, List baseList) {
        int minimum = 0;
        Point basePoint = null;
        ItemLayoutParams param = null;
        for (int i = 0; i < baseList.size(); ++i) {
            basePoint = (Point)baseList.get(i);
            param = StructureUIHelper.getParametersFromCell(sheet, basePoint.y, basePoint.x);
            minimum = basePoint.y + 1;
            if (!isInsert && (isRow && basePoint.y == index || !isRow && basePoint.x == index)) {
                MsgBox.showError((String)"\u57fa\u51c6\u70b9\u4e0d\u80fd\u5220\u9664");
                return true;
            }
            int counter = param.getRowCounter();
            int maximum = minimum + counter - 1;
            if (index < minimum || index > maximum) continue;
            ItemLayoutParams param2 = (ItemLayoutParams)transaction.get(basePoint);
            if (param2 == null) {
                param2 = param;
            }
            int counter2 = param2.getRowCounter();
            counter2 = isInsert ? counter2 + 1 : counter2 - 1;
            param2.setRowCounter(counter2);
            transaction.put(basePoint, param2);
            break;
        }
        return false;
    }
}

