/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.taxes.at.client;

import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.tm.td.OwnerMenuEnum;
import com.kingdee.eas.tm.td.RecordTypeEnum;
import com.kingdee.eas.tm.td.basedata.AccountTypeFactory;
import com.kingdee.eas.tm.td.basedata.AccountTypeInfo;
import com.kingdee.eas.tm.td.basedata.TaxItemTypeFactory;
import com.kingdee.eas.tm.td.basedata.TaxItemTypeInfo;
import com.kingdee.eas.tm.td.taxes.at.client.AbstractAtTaxDeclareTaxDraftEditUI;
import com.kingdee.eas.tm.td.taxes.at.client.AtTaxDeclareTaxDraftRptUI;
import com.kingdee.eas.tm.td.utils.TDPermissionUtil;
import com.kingdee.eas.tm.td.utils.TDSelectorFactory;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import org.apache.log4j.Logger;

public class AtTaxDeclareTaxDraftEditUI
extends AbstractAtTaxDeclareTaxDraftEditUI {
    private static final Logger logger = CoreUIObject.getLogger(AtTaxDeclareTaxDraftEditUI.class);
    private TaxItemTypeInfo taxType = null;
    private AccountTypeInfo accountType = null;

    @Override
    public void loadFields() {
        this.removeListener();
        super.loadFields();
        this.addListener();
        this.initControl();
        if (this.getUIContext().get("Owner") != null && this.getUIContext().get("Owner").toString().contains("ErtAdditionalTaxDeclareTaxDraftListUI")) {
            this.prmtBuildingTaxesGroup.setRequired(true);
        } else {
            this.prmtBuildingTaxesGroup.setRequired(false);
        }
    }

    @Override
    protected void checkBeforeSaveOrSubmit(boolean isSubmit, boolean isCopy) throws Exception {
        super.checkBeforeSaveOrSubmit(isSubmit, isCopy);
        if (this.prmtBuildingTaxesGroup.isRequired() && this.prmtBuildingTaxesGroup.getValue() == null) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.tm.td.TaxDraftResource", (String)"buildingTaxesGroupNotNull"));
            SysUtil.abort();
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
        if (this.prmtPeriod.getValue() != null) {
            PeriodInfo period = (PeriodInfo)this.prmtPeriod.getValue();
            this.editData.setYear(period.getPeriodYear());
            this.editData.setPeriod((short)period.getPeriodNumber());
        }
    }

    @Override
    protected String getTaxDraftRptUI() {
        return AtTaxDeclareTaxDraftRptUI.class.getName();
    }

    @Override
    public SelectorItemCollection getSelectors() {
        return TDSelectorFactory.getTaxDraftRecordSelectors();
    }

    @Override
    protected AccountTypeInfo getAccountTypeInfo() throws Exception {
        if (this.accountType == null) {
            try {
                this.accountType = AccountTypeFactory.getRemoteInstance().getAccountTypeInfo((IObjectPK)new ObjectUuidPK("y0IwQQL/QU+khfcOuJESPj2YoPU="));
            }
            catch (Exception e) {
                return null;
            }
        }
        return this.accountType;
    }

    @Override
    protected String getPermissionItem(String actionType) {
        return TDPermissionUtil.getTaxDraftPermissionItem(actionType, "at", "taxdeclare");
    }

    @Override
    protected TaxItemTypeInfo getTaxTypeInfo() throws Exception {
        if (this.taxType == null) {
            try {
                this.taxType = TaxItemTypeFactory.getRemoteInstance().getTaxItemTypeInfo((IObjectPK)new ObjectUuidPK("ZCyrvv6nAnPgU0ETqMCc49uK96Y="));
            }
            catch (Exception e) {
                return null;
            }
        }
        return this.taxType;
    }

    @Override
    protected RecordTypeEnum getRecordType() {
        return RecordTypeEnum.TaxDeclare;
    }

    @Override
    protected OwnerMenuEnum getOwnerMenu() {
        return OwnerMenuEnum.AtTaxDeclareTaxDraft;
    }
}

