/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.taxes.ert.client;

import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.framework.util.KDTableUtil;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.tm.td.RecordTypeEnum;
import com.kingdee.eas.tm.td.TDUtils;
import com.kingdee.eas.tm.td.basedata.AccountTypeFactory;
import com.kingdee.eas.tm.td.basedata.AccountTypeInfo;
import com.kingdee.eas.tm.td.basedata.TaxItemTypeFactory;
import com.kingdee.eas.tm.td.basedata.TaxItemTypeInfo;
import com.kingdee.eas.tm.td.taxes.ert.client.AbstractErtDraftItemTaxDraftListUI;
import com.kingdee.eas.tm.td.taxes.ert.client.ErtDraftItemTaxDraftEditUI;
import com.kingdee.eas.tm.td.taxes.ert.client.ErtDraftItemTaxDraftRptUI;
import com.kingdee.eas.tm.td.utils.TDPermissionUtil;
import com.kingdee.eas.tm.td.utils.TDSelectorFactory;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import org.apache.log4j.Logger;

public class ErtDraftItemTaxDraftListUI
extends AbstractErtDraftItemTaxDraftListUI {
    private static final Logger logger = CoreUIObject.getLogger(ErtDraftItemTaxDraftListUI.class);
    private TaxItemTypeInfo taxType = null;
    private AccountTypeInfo accountType = null;

    @Override
    protected String getEditUIName() {
        return ErtDraftItemTaxDraftRptUI.class.getName();
    }

    @Override
    protected String getEditHeadUIName() {
        return ErtDraftItemTaxDraftEditUI.class.getName();
    }

    @Override
    protected TaxItemTypeInfo getTaxItemTypeInfo() {
        if (this.taxType == null) {
            try {
                this.taxType = TaxItemTypeFactory.getRemoteInstance().getTaxItemTypeInfo((IObjectPK)new ObjectUuidPK("ZCyrvv6oAnPgU0ETqMCc49uK96Y="));
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage());
                return null;
            }
        }
        return this.taxType;
    }

    @Override
    protected AccountTypeInfo getAccountTypeInfo() throws Exception {
        if (this.accountType == null) {
            try {
                this.accountType = AccountTypeFactory.getRemoteInstance().getAccountTypeInfo((IObjectPK)new ObjectUuidPK("nJREYCMKQxixsNoL09ZUjT2YoPU="));
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage());
                return null;
            }
        }
        return this.accountType;
    }

    @Override
    protected RecordTypeEnum getRecordTypeEnum() {
        return RecordTypeEnum.DraftItem;
    }

    @Override
    protected String getPermissionItem(String actionType) {
        return TDPermissionUtil.getTaxDraftPermissionItem(actionType, "ert", "taxdraftitem");
    }

    @Override
    public SelectorItemCollection getSelectors() {
        return TDSelectorFactory.getTaxDraftRecordSelectors();
    }

    @Override
    public void actionUnAudit_actionPerformed(ActionEvent e) throws Exception {
        String[] companyIds = KDTableUtil.getSelectRowFieldValue((KDTable)this.tblMain, (String)"company.id");
        String[] companyNames = KDTableUtil.getSelectRowFieldValue((KDTable)this.tblMain, (String)"company.name");
        String[] auditors = KDTableUtil.getSelectRowFieldValue((KDTable)this.tblMain, (String)"auditor");
        UserInfo unAuditor = SysContext.getSysContext().getCurrentUserInfo();
        String unAudit = unAuditor.getName();
        if (companyIds != null) {
            for (int i = 0; i < companyIds.length; ++i) {
                boolean isSupportAuditBill = TDUtils.getBooleanParam(null, companyIds[i], "VATD006");
                if (!isSupportAuditBill || auditors == null || unAudit.equals(auditors[i])) continue;
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.tm.td.TDResource", (String)"UNAUDITNOTAUDIT", (Object[])new String[]{companyNames[i]}));
                SysUtil.abort();
            }
        }
        super.actionUnAudit_actionPerformed(e);
    }
}

