/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IAdminOrgUnit;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.IPurchaseOrgUnit;
import com.kingdee.eas.basedata.org.ISaleOrgUnit;
import com.kingdee.eas.basedata.org.IStorageOrgUnit;
import com.kingdee.eas.basedata.org.ITransportOrgUnit;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitCollection;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitFactory;
import com.kingdee.eas.basedata.org.SaleOrgUnitCollection;
import com.kingdee.eas.basedata.org.SaleOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitCollection;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.TransportOrgUnitCollection;
import com.kingdee.eas.basedata.org.TransportOrgUnitFactory;
import com.kingdee.eas.basedata.org.client.f7.NewOrgUnitFilterInfoProducer;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;

public class TDPermissionUtil {
    public static CompanyOrgUnitInfo getPermissionCompany(String permissionItem) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        NewOrgUnitFilterInfoProducer iProducer = new NewOrgUnitFilterInfoProducer(OrgType.Company, permissionItem);
        FilterInfo tmpFilter = iProducer.getFilterInfo();
        view.setFilter(tmpFilter);
        CompanyOrgUnitCollection companyOrgUnitCollection = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitCollection(view);
        if (companyOrgUnitCollection.isEmpty()) {
            return null;
        }
        String companyId = SysContext.getSysContext().getCurrentFIUnit().getId().toString();
        for (int i = 0; i < companyOrgUnitCollection.size(); ++i) {
            CompanyOrgUnitInfo companyOrgUnitInfo = companyOrgUnitCollection.get(i);
            if (!companyOrgUnitInfo.getId().toString().equals(companyId)) continue;
            return companyOrgUnitInfo;
        }
        return companyOrgUnitCollection.get(0);
    }

    public static OrgUnitInfo[] getAuthOrgByPermItem(Context ctx, IObjectPK user, OrgType orgType, String permItem) throws BOSException, EASBizException {
        IPermission permission;
        UserInfo userInfo = SysContext.getSysContext().getCurrentUserInfo();
        FullOrgUnitCollection orgCollection = null;
        IPermission iPermission = permission = ctx == null ? PermissionFactory.getRemoteInstance() : PermissionFactory.getLocalInstance((Context)ctx);
        if (user == null) {
            user = new ObjectUuidPK(userInfo.getId());
        }
        orgCollection = permission.getAuthorizedOrg(user, orgType, null, permItem);
        FullOrgUnitInfo fullInfo = null;
        OrgUnitCollection collection = new OrgUnitCollection();
        for (int i = 0; i < orgCollection.size(); ++i) {
            fullInfo = orgCollection.get(i);
            collection.add((OrgUnitInfo)fullInfo);
        }
        OrgUnitCollection bizOrgs = TDPermissionUtil.getOrgUnitInfosByType(ctx, collection, orgType, null);
        if (bizOrgs == null) {
            return null;
        }
        int size = bizOrgs.size();
        OrgUnitInfo[] results = new OrgUnitInfo[size];
        if (size > 0) {
            Object[] objects = bizOrgs.toArray();
            System.arraycopy(objects, 0, results, 0, size);
        }
        return results;
    }

    public static OrgUnitCollection getOrgUnitInfosByType(Context ctx, OrgUnitCollection orgs, OrgType orgType, SorterItemCollection sorter) {
        OrgUnitCollection results = null;
        int type = -1;
        if (results != null && (results == null || type == orgType.getValue())) {
            return results;
        }
        results = new OrgUnitCollection();
        if (orgs == null || orgs.size() == 0) {
            return results;
        }
        LinkedHashSet<String> keys = new LinkedHashSet<String>();
        for (int i = 0; i < orgs.size(); ++i) {
            keys.add(orgs.get(i).getId().toString());
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", keys, CompareType.INCLUDE));
        view.setFilter(filter);
        view.setSelector(TDPermissionUtil.getOrgInfoSelector(orgType));
        try {
            switch (orgType.getValue()) {
                case 0: {
                    AdminOrgUnitCollection collection;
                    IAdminOrgUnit iAdmin;
                    type = 0;
                    IAdminOrgUnit iAdminOrgUnit = iAdmin = ctx == null ? AdminOrgUnitFactory.getRemoteInstance() : AdminOrgUnitFactory.getLocalInstance((Context)ctx);
                    if (sorter != null) {
                        view.setSorter(sorter);
                    }
                    if ((collection = iAdmin.getAdminOrgUnitCollection(view)) != null && collection.size() > 0) {
                        for (int i = 0; i < collection.size(); ++i) {
                            results.add((OrgUnitInfo)collection.get(i));
                        }
                    }
                    return results;
                }
                case 1: {
                    type = 1;
                    ICompanyOrgUnit iCompany = ctx == null ? CompanyOrgUnitFactory.getRemoteInstance() : CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
                    CompanyOrgUnitCollection collection = iCompany.getCompanyOrgUnitCollection(view);
                    if (collection != null && collection.size() > 0) {
                        for (int i = 0; i < collection.size(); ++i) {
                            results.add((OrgUnitInfo)collection.get(i));
                        }
                    }
                    return results;
                }
                case 2: {
                    type = 2;
                    ISaleOrgUnit iSale = ctx == null ? SaleOrgUnitFactory.getRemoteInstance() : SaleOrgUnitFactory.getLocalInstance((Context)ctx);
                    SaleOrgUnitCollection collection = iSale.getSaleOrgUnitCollection(view);
                    if (collection != null && collection.size() > 0) {
                        for (int i = 0; i < collection.size(); ++i) {
                            results.add((OrgUnitInfo)collection.get(i));
                        }
                    }
                    return results;
                }
                case 3: {
                    type = 3;
                    IPurchaseOrgUnit iPurchase = ctx == null ? PurchaseOrgUnitFactory.getRemoteInstance() : PurchaseOrgUnitFactory.getLocalInstance((Context)ctx);
                    PurchaseOrgUnitCollection collection = iPurchase.getPurchaseOrgUnitCollection(view);
                    if (collection != null && collection.size() > 0) {
                        for (int i = 0; i < collection.size(); ++i) {
                            results.add((OrgUnitInfo)collection.get(i));
                        }
                    }
                    return results;
                }
                case 4: {
                    type = 4;
                    IStorageOrgUnit iStorage = ctx == null ? StorageOrgUnitFactory.getRemoteInstance() : StorageOrgUnitFactory.getLocalInstance((Context)ctx);
                    StorageOrgUnitCollection collection = iStorage.getStorageOrgUnitCollection(view);
                    if (collection != null && collection.size() > 0) {
                        for (int i = 0; i < collection.size(); ++i) {
                            results.add((OrgUnitInfo)collection.get(i));
                        }
                    }
                    return results;
                }
                case 24: {
                    type = 24;
                    ITransportOrgUnit iTransport = ctx == null ? TransportOrgUnitFactory.getRemoteInstance() : TransportOrgUnitFactory.getLocalInstance((Context)ctx);
                    TransportOrgUnitCollection collection = iTransport.getTransportOrgUnitCollection(view);
                    if (collection != null && collection.size() > 0) {
                        for (int i = 0; i < collection.size(); ++i) {
                            results.add((OrgUnitInfo)collection.get(i));
                        }
                    }
                    return results;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static Set getPermissionUnits(OrgType orgType, String permItem) throws BOSException, EASBizException {
        UserInfo userInfo = SysContext.getSysContext().getCurrentUserInfo();
        FullOrgUnitCollection orgUnits = TDPermissionUtil.getAuthOrgByPermItem((IObjectPK)new ObjectUuidPK(userInfo.getId()), orgType, permItem);
        FullOrgUnitInfo unitInfo = null;
        HashSet<String> existIDs = new HashSet<String>();
        if (orgUnits != null && orgUnits.size() > 0) {
            int size = orgUnits.size();
            for (int i = 0; i < size; ++i) {
                unitInfo = orgUnits.get(i);
                existIDs.add(unitInfo.getId().toString());
            }
        } else {
            existIDs.add("1111111111111111111");
        }
        return existIDs;
    }

    public static FullOrgUnitCollection getAuthOrgByPermItem(IObjectPK user, OrgType orgType, String permItem) throws BOSException, EASBizException {
        FullOrgUnitCollection result = null;
        IPermission permission = PermissionFactory.getRemoteInstance();
        result = permission.getAuthorizedOrg(user, orgType, null, permItem);
        return result;
    }

    public static SelectorItemCollection getOrgInfoSelector() {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("number"));
        selector.add(new SelectorItemInfo("name"));
        selector.add(new SelectorItemInfo("CU.id"));
        selector.add(new SelectorItemInfo("isCU"));
        selector.add(new SelectorItemInfo("isBizUnit"));
        selector.add(new SelectorItemInfo("isSaleOrgUnit"));
        selector.add(new SelectorItemInfo("isAdminOrgUnit"));
        selector.add(new SelectorItemInfo("isPurchaseOrgUnit"));
        selector.add(new SelectorItemInfo("isStorageOrgUnit"));
        selector.add(new SelectorItemInfo("isCompanyOrgUnit"));
        selector.add(new SelectorItemInfo("isTransportOrgUnit"));
        selector.add(new SelectorItemInfo("isFreeze"));
        selector.add(new SelectorItemInfo("isGrouping"));
        selector.add(new SelectorItemInfo("isCostOrgUnit"));
        selector.add(new SelectorItemInfo("isStart"));
        selector.add(new SelectorItemInfo("code"));
        selector.add(new SelectorItemInfo("orgTypeStr"));
        return selector;
    }

    public static SelectorItemCollection getOrgInfoSelector(OrgType orgType) {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("number"));
        selector.add(new SelectorItemInfo("name"));
        selector.add(new SelectorItemInfo("CU.id"));
        selector.add(new SelectorItemInfo("isCU"));
        selector.add(new SelectorItemInfo("isBizUnit"));
        selector.add(new SelectorItemInfo("isSaleOrgUnit"));
        selector.add(new SelectorItemInfo("isAdminOrgUnit"));
        selector.add(new SelectorItemInfo("isPurchaseOrgUnit"));
        selector.add(new SelectorItemInfo("isStorageOrgUnit"));
        selector.add(new SelectorItemInfo("isCompanyOrgUnit"));
        selector.add(new SelectorItemInfo("isTransportOrgUnit"));
        selector.add(new SelectorItemInfo("isFreeze"));
        selector.add(new SelectorItemInfo("isGrouping"));
        selector.add(new SelectorItemInfo("isCostOrgUnit"));
        selector.add(new SelectorItemInfo("isStart"));
        selector.add(new SelectorItemInfo("code"));
        selector.add(new SelectorItemInfo("orgTypeStr"));
        if (orgType.getValue() == 1) {
            selector.add(new SelectorItemInfo("baseCurrency.id"));
            selector.add(new SelectorItemInfo("baseCurrency.name"));
            selector.add(new SelectorItemInfo("baseCurrency.number"));
            selector.add(new SelectorItemInfo("accountTable.id"));
            selector.add(new SelectorItemInfo("accountTable.name"));
            selector.add(new SelectorItemInfo("accountTable.number"));
            selector.add(new SelectorItemInfo("accountPeriodType.id"));
            selector.add(new SelectorItemInfo("accountPeriodType.name"));
            selector.add(new SelectorItemInfo("accountPeriodType.number"));
        }
        return selector;
    }

    public static String getAccountConfigPermissionItem(String actionType, String taxFlag, boolean isOu) {
        String permissionItem = "";
        String orgFlag = "";
        if (isOu) {
            orgFlag = "_org";
        }
        permissionItem = "view".equals(actionType) ? taxFlag + orgFlag + "_accountconfig_view" : ("add".equals(actionType) ? taxFlag + orgFlag + "_accountconfig_new" : ("edit".equals(actionType) ? taxFlag + orgFlag + "_accountconfig_edit" : ("remove".equals(actionType) ? taxFlag + orgFlag + "_accountconfig_delete" : ("cancelcancel".equals(actionType) ? taxFlag + orgFlag + "_accountconfig_cancelcancel" : ("cancel".equals(actionType) ? taxFlag + orgFlag + "_accountconfig_cancel" : ("datasource".equals(actionType) ? taxFlag + orgFlag + "_accountconfig_datasource" : ("getdata".equals(actionType) ? taxFlag + orgFlag + "_accountconfig_getdata" : ("import".equals(actionType) ? taxFlag + orgFlag + "_accountconfig_import" : taxFlag + orgFlag + "_accountconfig_view"))))))));
        return permissionItem;
    }

    public static String getDraftItemPermissionItem(String actionType, String taxFlag, boolean isOu) {
        String permissionItem = "";
        String orgFlag = "";
        if (isOu) {
            orgFlag = "_company";
        }
        permissionItem = "view".equals(actionType) ? taxFlag + orgFlag + "_draftitem_view" : ("add".equals(actionType) ? taxFlag + orgFlag + "_draftitem_new" : ("edit".equals(actionType) ? taxFlag + orgFlag + "_draftitem_edit" : ("remove".equals(actionType) ? taxFlag + orgFlag + "_draftitem_delete" : ("cancelcancel".equals(actionType) ? taxFlag + orgFlag + "_draftitem_cancelcancel" : ("cancel".equals(actionType) ? taxFlag + orgFlag + "_draftitem_cancel" : ("datasource".equals(actionType) ? taxFlag + orgFlag + "_draftitem_datasource" : ("getdata".equals(actionType) ? taxFlag + orgFlag + "_draftitem_getdata" : ("import".equals(actionType) ? taxFlag + orgFlag + "_draftitem_import" : taxFlag + orgFlag + "_draftitem_view"))))))));
        return permissionItem;
    }

    public static String getTaxDraftPermissionItem(String actionType, String taxFlag, String recordFlag) {
        String permissionItem = "";
        permissionItem = "view".equals(actionType) ? taxFlag + "_" + recordFlag + "_view" : ("add".equals(actionType) ? taxFlag + "_" + recordFlag + "_new" : ("edit".equals(actionType) ? taxFlag + "_" + recordFlag + "_edit" : ("remove".equals(actionType) ? taxFlag + "_" + recordFlag + "_delete" : ("submit".equals(actionType) ? taxFlag + "_" + recordFlag + "_submit" : ("audit".equals(actionType) ? taxFlag + "_" + recordFlag + "_audit" : ("unaudit".equals(actionType) ? taxFlag + "_" + recordFlag + "_unaudit" : ("confirmsave".equals(actionType) ? taxFlag + "_" + recordFlag + "_comfire_save" : ("confirmdelete".equals(actionType) ? taxFlag + "_" + recordFlag + "_comfire_delete" : ("voucher".equals(actionType) ? taxFlag + "_" + recordFlag + "_comfire_certificate" : ("delvoucher".equals(actionType) ? taxFlag + "_" + recordFlag + "_comfire_delcertificate" : ("comfirmdeclare".equals(actionType) ? taxFlag + "_" + recordFlag + "_comfire_declare" : ("canceldeclare".equals(actionType) ? taxFlag + "_" + recordFlag + "_cancel_declare" : taxFlag + "_" + recordFlag + "_view"))))))))))));
        return permissionItem;
    }
}

