/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.utils.render;

import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.eas.fi.newrpt.client.designer.render.IRenderProvider;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;

public class DefaultRenderProvider
implements IRenderProvider {
    private static final IBasicRender bst = new BasePointRender();
    private static final ItemFormulaRender lrt = new ItemFormulaRender();

    public IBasicRender getRender(Cell cell, int viewMode) {
        String obj = (String)cell.getUserObjectValue("AccountFormulaParams");
        if (obj != null) {
            return bst;
        }
        Object itemObj = cell.getUserObjectValue("TAXITEM");
        if (itemObj != null) {
            return lrt;
        }
        String dItemObj = (String)cell.getUserObjectValue("ItemLayoutParams");
        if (dItemObj != null) {
            return lrt;
        }
        return null;
    }

    protected static final class ItemFormulaRender
    implements IBasicRender {
        boolean formulaInvalid = false;
        boolean itemNotExists = false;
        boolean isFormulaDuplicate = false;
        int[] dx = new int[]{0, 0, 0};
        int[] dy = new int[]{0, 0, 0};

        protected ItemFormulaRender() {
        }

        public void draw(Graphics graphics, Shape clip, Object object, Style cellStyle) {
            Rectangle bd = clip.getBounds();
            Color cl = graphics.getColor();
            int x = bd.x + bd.width;
            int y = bd.y - 1;
            int offset = 7;
            this.dx[0] = x - offset;
            this.dx[1] = x;
            this.dx[2] = x;
            this.dy[0] = y;
            this.dy[1] = y;
            this.dy[2] = y + offset;
            graphics.setColor(Color.GRAY);
            graphics.drawPolygon(this.dx, this.dy, 3);
            x = bd.x;
            y = bd.y;
            if (this.formulaInvalid) {
                this.dx[0] = x + 5;
                this.dx[1] = x;
                this.dx[2] = x;
                this.dy[0] = y;
                this.dy[1] = y;
                this.dy[2] = y + 5;
                graphics.setColor(Color.magenta);
                graphics.fillPolygon(this.dx, this.dy, 3);
            }
            if (this.itemNotExists) {
                graphics.setColor(Color.magenta);
                graphics.drawLine(x + 7, y, x, y + 7);
            }
            if (this.isFormulaDuplicate) {
                graphics.setColor(Color.magenta);
                graphics.drawLine(x + 7, y, x, y + 7);
                graphics.drawLine(x + 5, y, x, y + 5);
            }
            graphics.setColor(cl);
        }
    }

    protected static final class BasePointRender
    implements IBasicRender {
        protected BasePointRender() {
        }

        public void draw(Graphics graphics, Shape clip, Object object, Style cellStyle) {
            Rectangle bd = clip.getBounds();
            Color cl = graphics.getColor();
            Object oldhint = ((Graphics2D)graphics).getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics.setColor(Color.blue);
            graphics.fillOval(bd.x + bd.width - 6, bd.y, 6, 6);
            ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, oldhint);
            graphics.setColor(cl);
        }
    }
}

