/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos;

import com.kingdee.bos.Context;
import com.kingdee.bos.IBOSObject;
import com.kingdee.bos.InvokeResponseIntercepter;
import com.kingdee.bos.dao.ormCacheService.ORMCacheUtil;
import com.kingdee.bos.dao.ormCacheService.ORMValueCacheService;
import com.kingdee.bos.framework.cache.MultiParamKey;
import com.kingdee.bos.framework.cache.Utils;
import com.kingdee.bos.framework.cache.config.CacheConfigManager;
import com.kingdee.bos.framework.cache.config.ICacheConfig;
import com.kingdee.bos.framework.cache.config.MethodIntent;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.MultiParamKeyString;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class ResponseInvocationHandler
implements InvocationHandler {
    public Object target;
    public Class bizInterface;
    private BOSObjectType bosType;
    private Context ctx;

    public ResponseInvocationHandler(Class bizInterface, Object target, Context ctx) {
        this.bizInterface = bizInterface;
        this.target = target;
        this.ctx = ctx;
        if (target instanceof IBOSObject) {
            this.bosType = ((IBOSObject)target).getType();
        }
    }

    public ResponseInvocationHandler(Class bizInterface, Object target) {
        this.bizInterface = bizInterface;
        this.target = target;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        InvokeResponseIntercepter iri = InvokeResponseIntercepter.get();
        String md5 = null;
        if (iri != null) {
            iri.pushStack();
            if (iri.getStackLevle() == 1) {
                md5 = MultiParamKeyString.toString((String)(this.bizInterface.getName() + "#" + method.getName()), (Object[])args);
            }
        }
        Object retVal = null;
        try {
            ICacheConfig config = CacheConfigManager.getConfig();
            if (this.ctx != null && config != null && config.needServerCache() && config.needQueryCache(this.bosType)) {
                MethodIntent intent = this.getMethodIntent(method);
                BOSObjectType realType = config.getFacadeRealBosType(this.bosType, method);
                if (realType == null) {
                    realType = this.bosType;
                }
                if (MethodIntent.WRITE.equals((Object)intent)) {
                    retVal = method.invoke(this.target, args);
                    ORMCacheUtil.getInstance().removeInfosByBosType(this.ctx, realType);
                } else {
                    retVal = method.invoke(this.target, args);
                }
            } else if (this.bizInterface.getName().equals("com.kingdee.bos.dao.query.server.IQueryDataAccess") && (method.getName().equals("getRowCount") || method.getName().equals("getRowSet"))) {
                if (args == null || args[0] == null || !(args[0] instanceof IMetaDataPK)) {
                    retVal = method.invoke(this.target, args);
                } else {
                    IMetaDataPK queryPK = (IMetaDataPK)args[0];
                    BOSObjectType queryType = Utils.getBOSTypeFromQueryPK(queryPK);
                    if (this.ctx != null && config != null && config.needServerCache() && config.needCache(queryType)) {
                        MultiParamKey key = MultiParamKey.create(this.ctx.getAIS() + "_" + this.ctx.getUserName() + "_com.kingdee.bos.dao.query.server.IQueryDataAccess#" + method.getName(), args);
                        ORMValueCacheService svc = ORMValueCacheService.getInstance();
                        retVal = svc.getQueryRs(this.ctx, queryType, key);
                        if (retVal == null && (retVal = method.invoke(this.target, args)) instanceof Serializable) {
                            ByteArrayOutputStream bos = new ByteArrayOutputStream();
                            ObjectOutputStream oos = new ObjectOutputStream(bos);
                            oos.writeObject(retVal);
                            oos.flush();
                            oos.close();
                            byte[] buffer = bos.toByteArray();
                            ByteArrayInputStream bis = new ByteArrayInputStream(buffer);
                            ObjectInputStream ois = new ObjectInputStream(bis);
                            Object cloneVal = ois.readObject();
                            svc.putQueryRs(this.ctx, queryType, key, cloneVal);
                        }
                    } else {
                        retVal = method.invoke(this.target, args);
                    }
                }
            } else {
                retVal = method.invoke(this.target, args);
            }
            if (iri == null) return retVal;
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() == null) return retVal;
            throw e.getTargetException();
        }
        finally {
            if (iri != null) {
                if (iri.getStackLevle() == 1) {
                    iri.endInvoke(md5, retVal);
                }
                iri.popupStack();
            }
        }
        if (iri.getStackLevle() == 1) {
            iri.endInvoke(md5, retVal);
        }
        iri.popupStack();
        return retVal;
    }

    private MethodIntent getMethodIntent(Method mthd) {
        MethodIntent intent;
        if (mthd.getName().equals("getType") && this.bosType != null) {
            return MethodIntent.GET_TYPE;
        }
        ICacheConfig config = CacheConfigManager.getConfig();
        if (config != null && (intent = config.getMethodIntent(this.bosType, mthd)) != null) {
            return intent;
        }
        return MethodIntent.UNKNOWN;
    }
}

