/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.framework.batchinvoke;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.IBOSObject;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.framework.batchinvoke.IBatchInvokeFacade;
import com.kingdee.bos.framework.batchinvoke.impl.BatchInvokeImpl;
import com.kingdee.bos.framework.batchinvoke.impl.BatchInvokeInterceptor;
import com.kingdee.bos.framework.batchinvoke.impl.BatchRequest;
import com.kingdee.bos.framework.batchinvoke.impl.IBatchInvoke;
import com.kingdee.bos.framework.cache.CacheServiceFactory;
import com.kingdee.bos.framework.cache.ICacheService;
import com.kingdee.bos.framework.cache.InvokeStackCache;
import com.kingdee.bos.framework.cache.MultiParamKey;
import com.kingdee.bos.framework.cache.config.CacheConfigManager;
import com.kingdee.bos.framework.cache.config.ICacheConfig;
import com.kingdee.bos.framework.cache.config.MethodIntent;
import com.kingdee.bos.util.BOSObjectType;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

public class BatchInvokeFacade
implements IBatchInvokeFacade {
    private BatchRequest batchReq = new BatchRequest();

    public static final IBatchInvokeFacade getInstance() {
        return new BatchInvokeFacade();
    }

    private BatchInvokeFacade() {
    }

    @Override
    public IBOSObject createInterface(BOSObjectType bosType, Class model) throws BOSException {
        return this.createInterface(bosType, model, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IBOSObject createInterface(BOSObjectType bosType, Class model, Context objCtx) throws BOSException {
        BatchRequest batchRequest = this.batchReq;
        synchronized (batchRequest) {
            IBOSObject bosObj = BOSObjectFactory.createRemoteBOSObject((BOSObjectType)bosType, (Class)model);
            int objIndex = this.batchReq.addObject(bosType, model, objCtx);
            bosObj = (IBOSObject)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{model}, (InvocationHandler)new BatchInvokeInterceptor(objIndex, this.batchReq));
            return bosObj;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        BatchRequest batchRequest = this.batchReq;
        synchronized (batchRequest) {
            this.batchReq.clear();
        }
    }

    @Override
    public void prepare() throws Exception {
        this.innerExecute(true);
    }

    @Override
    public Object[] execute() throws Exception {
        return this.innerExecute(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object[] innerExecute(boolean handleThreadCache) throws Exception {
        BatchRequest batchRequest = this.batchReq;
        synchronized (batchRequest) {
            Object[] objectArray;
            if (this.batchReq.isEmpty()) {
                throw new IllegalStateException("do something!");
            }
            try {
                MethodCachingDesc[] cachingDescs = this.preHandleCaching(this.batchReq);
                IBatchInvoke inv = (IBatchInvoke)BOSObjectFactory.createRemoteBOSObject((String)BatchInvokeImpl.class.getName(), IBatchInvoke.class);
                Object[] rtvs = inv.invoke(this.batchReq);
                objectArray = this.postHandleCaching(cachingDescs, rtvs, handleThreadCache);
                this.clear();
            }
            catch (Throwable throwable) {
                this.clear();
                throw throwable;
            }
            return objectArray;
        }
    }

    private MethodCachingDesc[] preHandleCaching(BatchRequest batchReq) {
        ICacheConfig config = CacheConfigManager.getConfig();
        ICacheService svc = CacheServiceFactory.getInstance();
        MethodCachingDesc[] descs = new MethodCachingDesc[batchReq.requestSize()];
        int n = descs.length;
        for (int i = 0; i < n; ++i) {
            MethodCachingDesc desc = new MethodCachingDesc(batchReq.getRequest(i), batchReq.getConstructorByRequestIndex(i));
            desc.needCache = config != null && config.needCache(desc.bosType);
            desc.needCache = false;
            if (desc.needCache) {
                desc.cachingIntend = config.getMethodIntent(desc.bosType, desc.method);
                if (desc.cachingIntend == null) {
                    desc.cachingIntend = MethodIntent.UNKNOWN;
                }
                desc.cachingType = config.getFacadeRealBosType(desc.bosType, desc.method);
                if (desc.cachingType == null) {
                    desc.cachingType = desc.bosType;
                }
                if (MethodIntent.GET.equals((Object)desc.cachingIntend)) {
                    MultiParamKey key = MultiParamKey.create(desc.method.getName(), desc.args);
                    if (svc.contains(desc.cachingType, key)) {
                        desc.cacheHit = true;
                        desc.cachingValue = svc.get(desc.cachingType, key);
                    }
                } else if (MethodIntent.GETOBJECT.equals((Object)desc.cachingIntend)) {
                    assert (desc.args.length == 1 && desc.args[0] instanceof IObjectPK);
                    if (svc.containsObjectValue(desc.cachingType, (IObjectPK)desc.args[0])) {
                        desc.cacheHit = true;
                        desc.cachingValue = svc.getObjectValue(desc.cachingType, (IObjectPK)desc.args[0]);
                    }
                } else if (MethodIntent.GETCOLLECTION.equals((Object)desc.cachingIntend)) {
                    assert (desc.args.length == 0);
                    if (svc.containsObjectCollection(desc.cachingType)) {
                        desc.cacheHit = true;
                        desc.cachingValue = svc.getObjectCollection(desc.cachingType);
                    }
                }
                if (desc.cacheHit) {
                    batchReq.getRequest(i).setIgnored(true);
                }
            }
            descs[i] = desc;
        }
        return descs;
    }

    private Object[] postHandleCaching(MethodCachingDesc[] descs, Object[] rtvs, boolean handleThreadCache) {
        ICacheService svc = CacheServiceFactory.getInstance();
        int n = descs.length;
        for (int i = 0; i < n; ++i) {
            InvokeStackCache localCache;
            MultiParamKey key;
            boolean cacheReady = false;
            MethodCachingDesc desc = descs[i];
            desc.needCache = false;
            if (desc.needCache) {
                if (MethodIntent.WRITE.equals((Object)desc.cachingIntend)) {
                    svc.discardType(desc.cachingType);
                } else if (desc.cacheHit) {
                    rtvs[i] = desc.cachingValue;
                    cacheReady = true;
                } else {
                    int size = BatchInvokeFacade.objectSize(rtvs[i]);
                    if (MethodIntent.GET.equals((Object)desc.cachingIntend)) {
                        key = MultiParamKey.create(desc.method.getName(), desc.args);
                        svc.put(desc.cachingType, key, rtvs[i], size);
                        cacheReady = true;
                    } else if (MethodIntent.GETOBJECT.equals((Object)desc.cachingIntend)) {
                        svc.putObjectValue(desc.cachingType, (IObjectPK)desc.args[0], (IObjectValue)rtvs[i], size);
                        cacheReady = true;
                    } else if (MethodIntent.GETCOLLECTION.equals((Object)desc.cachingIntend)) {
                        svc.putObjectCollection(desc.cachingType, (IObjectCollection)rtvs[i], size);
                        cacheReady = true;
                    }
                }
            }
            if (!handleThreadCache || cacheReady || desc.method.getReturnType() == null || (localCache = InvokeStackCache.getInstance()).depth() <= 0) continue;
            key = MultiParamKey.create(desc.model, desc.method, desc.args);
            localCache.put(key, rtvs[i]);
        }
        return rtvs;
    }

    private static final int objectSize(Object o) {
        if (o == null) {
            return 0;
        }
        if (!Serializable.class.isAssignableFrom(o.getClass())) {
            throw new InternalError();
        }
        try {
            ByteArrayOutputStream baOut = new ByteArrayOutputStream();
            new ObjectOutputStream(baOut).writeObject(o);
            return baOut.size();
        }
        catch (IOException ioe) {
            throw new InternalError();
        }
    }

    private static final class MethodCachingDesc {
        public final BOSObjectType bosType;
        public final Context objectContext;
        public final Method method;
        public final Class model;
        public final Object[] args;
        public boolean needCache;
        public MethodIntent cachingIntend;
        public BOSObjectType cachingType;
        public boolean cacheHit;
        public Object cachingValue;

        private MethodCachingDesc(BatchRequest.Request req, BatchRequest.Constructor constructor) {
            this.bosType = constructor.bosObjectType;
            this.model = constructor.model;
            this.objectContext = constructor.objectContext;
            this.method = req.getMethod();
            this.args = req.getParameters();
        }
    }
}

