/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.framework.batchinvoke.impl;

import com.kingdee.bos.AbstractBOSObject;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.IBOSObject;
import com.kingdee.bos.ReflectException;
import com.kingdee.bos.framework.batchinvoke.impl.BatchRequest;
import com.kingdee.bos.framework.batchinvoke.impl.IBatchInvoke;
import com.kingdee.bos.util.BOSObjectType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class BatchInvokeImpl
extends AbstractBOSObject
implements IBatchInvoke {
    public BatchInvokeImpl() {
    }

    public BatchInvokeImpl(Context ctx) {
        super(ctx);
    }

    @Override
    public Object[] invoke(BatchRequest batchReq) throws Exception {
        assert (!batchReq.isEmpty());
        if (batchReq.isEmpty()) {
            return new Object[0];
        }
        BatchRequest.Constructor[] constructors = batchReq.getConstructors();
        BatchRequest.Request[] requests = batchReq.getRequests();
        IBOSObject[] objs = new IBOSObject[constructors.length];
        Object[] rtvs = new Object[requests.length];
        for (BatchRequest.Request req : requests) {
            if (req.isIgnored()) continue;
            int objIndex = req.getObjectIndex();
            IBOSObject obj = objs[objIndex];
            if (obj == null) {
                BOSObjectType bosType = constructors[objIndex].bosObjectType;
                Context ctx = constructors[objIndex].objectContext;
                if (ctx == null) {
                    ctx = this.getContext();
                }
                objs[objIndex] = obj = BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)bosType);
            }
            try {
                Method mthd = this.getMethod(obj, req.getMethodName(), req.getParameterTypes());
                rtvs[i] = mthd.invoke((Object)obj, req.getParameters());
            }
            catch (ClassNotFoundException cnfe) {
                assert (false);
                throw new ReflectException((Throwable)cnfe);
            }
            catch (NoSuchMethodException nse) {
                assert (false);
                throw new ReflectException((Throwable)nse);
            }
            catch (IllegalAccessException iae) {
                throw new ReflectException((Throwable)iae);
            }
            catch (InvocationTargetException ite) {
                Throwable e = ite.getTargetException();
                if (e instanceof Exception) {
                    throw (Exception)e;
                }
                throw new ReflectException(e);
            }
        }
        return rtvs;
    }

    private final Method getMethod(IBOSObject obj, String mthdName, String[] parameterTypes) throws NoSuchMethodException, ClassNotFoundException {
        Class[] types = new Class[parameterTypes.length];
        int n = types.length;
        for (int i = 0; i < n; ++i) {
            types[i] = Class.forName(parameterTypes[i]);
        }
        return obj.getClass().getMethod(mthdName, types);
    }

    public BOSObjectType getType() {
        return null;
    }
}

