/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.framework.batchinvoke.impl;

import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSObjectType;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class BatchRequest
implements Serializable {
    private static final long serialVersionUID = -3875108405119197157L;
    private final List constructorList = new ArrayList(1);
    private final List requestList = new ArrayList();

    public int addObject(BOSObjectType bosObjectType, Class model) {
        return this.addObject(bosObjectType, model, null);
    }

    public int addObject(BOSObjectType bosObjectType, Class model, Context objectContext) {
        this.constructorList.add(new Constructor(bosObjectType, model, objectContext));
        return this.constructorList.size() - 1;
    }

    public Request addRequest(int objectIndex, Method method, Object[] parameters) {
        Request req = new Request(objectIndex, method, parameters);
        this.requestList.add(req);
        return req;
    }

    public Constructor[] getConstructors() {
        return this.constructorList.toArray(new Constructor[0]);
    }

    public Constructor getConstructor(int index) {
        return (Constructor)this.constructorList.get(index);
    }

    public Request[] getRequests() {
        return this.requestList.toArray(new Request[0]);
    }

    public Request getRequest(int index) {
        return (Request)this.requestList.get(index);
    }

    public Constructor getConstructorByRequestIndex(int reqIndex) {
        return (Constructor)this.constructorList.get(this.getRequest(reqIndex).objectIndex);
    }

    public void clear() {
        this.requestList.clear();
    }

    public boolean isEmpty() {
        return this.constructorList.isEmpty() || this.requestList.isEmpty();
    }

    public int requestSize() {
        return this.requestList.size();
    }

    public static class Request
    implements Serializable {
        private static final long serialVersionUID = 4585912869868247650L;
        private int objectIndex;
        private transient Method method;
        private String methodName;
        private String[] parameterTypes;
        private Object[] parameters;
        private transient boolean isIgnored;

        private Request(int objectIndex, Method method, Object[] parameters) {
            assert (objectIndex >= 0);
            this.objectIndex = objectIndex;
            this.method = method;
            this.methodName = method.getName();
            Class<?>[] types = method.getParameterTypes();
            this.parameterTypes = new String[types.length];
            int n = types.length;
            for (int i = 0; i < n; ++i) {
                this.parameterTypes[i] = types[i].getName();
            }
            this.parameters = parameters;
        }

        public int getObjectIndex() {
            return this.objectIndex;
        }

        public Method getMethod() {
            return this.method;
        }

        public String getMethodName() {
            return this.methodName;
        }

        public String[] getParameterTypes() {
            return this.parameterTypes;
        }

        public Object[] getParameters() {
            return this.parameters;
        }

        public boolean isIgnored() {
            return this.isIgnored;
        }

        public void setIgnored(boolean isIgnored) {
            this.isIgnored = isIgnored;
        }

        private synchronized void writeObject(ObjectOutputStream s) throws IOException {
            s.defaultWriteObject();
            s.writeInt(this.objectIndex);
            s.writeObject(this.isIgnored ? null : this.methodName);
            s.writeObject(this.isIgnored ? null : this.parameterTypes);
            s.writeObject(this.isIgnored ? null : this.parameters);
        }

        private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
            s.defaultReadObject();
            this.objectIndex = s.readInt();
            this.methodName = (String)s.readObject();
            this.parameterTypes = (String[])s.readObject();
            this.parameters = (Object[])s.readObject();
            this.isIgnored = this.methodName == null;
        }
    }

    public static class Constructor
    implements Serializable {
        private static final long serialVersionUID = 4308271284115824642L;
        public final BOSObjectType bosObjectType;
        public final Context objectContext;
        public final Class model;

        private Constructor(BOSObjectType bosObjectType, Class model, Context objectContext) {
            if (bosObjectType == null) {
                throw new IllegalArgumentException("BOSObjectType cannot be null.");
            }
            this.bosObjectType = bosObjectType;
            this.objectContext = objectContext;
            this.model = model;
        }
    }
}

