/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.framework.cache;

import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.framework.cache.ICacheRegion;
import com.kingdee.bos.framework.cache.ICacheService;
import com.kingdee.bos.framework.cache.MultiParamKey;
import com.kingdee.bos.framework.cache.Utils;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.Identity;
import java.util.HashMap;
import java.util.LinkedList;
import org.apache.log4j.Logger;

public abstract class AbstractCacheService
implements ICacheService {
    private static Logger logger = Logger.getLogger(AbstractCacheService.class);
    protected static final String REGION_ROOT = "LocalCacheRoot";
    protected static final String REGION_OBJECTS = "Objects";
    protected static final String OBJECT_COLLECTIONS = "Collections";
    private LinkedList keyLRUList = new LinkedList();
    private HashMap objSizeMap = new HashMap();
    private long totalSize = 0L;
    private long maxSize = 0x2000000L;
    private int readNum = 0;
    private int hitNum = 0;
    private int discardAllNum = 0;
    private int discardRegionNum = 0;

    @Override
    public boolean containsObjectValue(BOSObjectType bosType, Object objPk) {
        boolean isHit = this.getObjectRegion(bosType).containsKey(objPk);
        ++this.readNum;
        if (isHit) {
            ++this.hitNum;
        }
        return isHit;
    }

    @Override
    public synchronized void putObjectValue(BOSObjectType bosType, Object objPk, IObjectValue objVal, long objSize) {
        this.beforePut(bosType, objPk, objVal, objSize);
        this.getObjectRegion(bosType).put(objPk, objVal);
    }

    @Override
    public synchronized IObjectValue getObjectValue(BOSObjectType bosType, Object objPk) {
        Object obj = this.getObjectRegion(bosType).get(objPk);
        assert (obj instanceof IObjectValue);
        this.afterGet(bosType, objPk);
        return (IObjectValue)obj;
    }

    @Override
    public boolean containsObjectCollection(BOSObjectType bosType) {
        boolean isHit = this.getTypeRegion(bosType).containsKey(OBJECT_COLLECTIONS);
        ++this.readNum;
        if (isHit) {
            ++this.hitNum;
        }
        return isHit;
    }

    @Override
    public synchronized void putObjectCollection(BOSObjectType bosType, IObjectCollection objCol, long objSize) {
        int colSize;
        if (objCol != null && (colSize = objCol.size()) > 0) {
            long itemSize = objSize / (long)colSize;
            for (int i = 0; i < colSize; ++i) {
                IObjectValue objVal = objCol.getObject(i);
                if (!(objVal instanceof Identity)) continue;
                this.putObjectValue(bosType, ((Identity)objVal).getIdentity(), objVal, itemSize);
            }
        }
        this.beforePut(bosType, null, objCol, 0L);
        this.getTypeRegion(bosType).put(OBJECT_COLLECTIONS, objCol);
    }

    @Override
    public synchronized IObjectCollection getObjectCollection(BOSObjectType bosType) {
        Object col = this.getTypeRegion(bosType).get(OBJECT_COLLECTIONS);
        this.afterGet(bosType, null);
        return (IObjectCollection)col;
    }

    @Override
    public boolean contains(BOSObjectType bosType, MultiParamKey key) {
        boolean isHit = this.getTypeRegion(bosType).containsKey(key);
        ++this.readNum;
        if (isHit) {
            ++this.hitNum;
        }
        return isHit;
    }

    @Override
    public synchronized void put(BOSObjectType bosType, MultiParamKey key, Object obj, long objSize) {
        this.beforePut(bosType, key, obj, objSize);
        this.getTypeRegion(bosType).put(key, obj);
    }

    @Override
    public synchronized Object get(BOSObjectType bosType, MultiParamKey key) {
        Object obj = this.getTypeRegion(bosType).get(key);
        this.afterGet(bosType, key);
        return obj;
    }

    @Override
    public synchronized void discardType(BOSObjectType bosType) {
        ICacheRegion typeRegion;
        boolean isTypeRegionEmpty = true;
        boolean isObjectRegionEmpty = true;
        ICacheRegion objectRegion = this.getObjectRegion(bosType);
        if (objectRegion != null && !(isObjectRegionEmpty = objectRegion.isEmpty())) {
            objectRegion.clear();
        }
        if ((typeRegion = this.getTypeRegion(bosType)) != null) {
            typeRegion.remove(REGION_OBJECTS);
            isTypeRegionEmpty = typeRegion.isEmpty();
            if (!isTypeRegionEmpty) {
                typeRegion.clear();
            }
        }
        if (!isTypeRegionEmpty || !isObjectRegionEmpty) {
            this.afterDiscardType(bosType);
            ++this.discardRegionNum;
        }
    }

    @Override
    public synchronized void discardQuery(IMetaDataPK queryPk) {
        this.discardType(Utils.getBOSTypeFromQueryPK(queryPk));
    }

    @Override
    public synchronized void discardQuery(BOSObjectType bosType) {
        this.discardType(bosType);
    }

    @Override
    public synchronized void discardAll() {
        this.getRootRegion().clear();
        this.afterDiscardAll();
        ++this.discardAllNum;
    }

    protected abstract ICacheRegion getRootRegion();

    protected abstract ICacheRegion getTypeRegion(BOSObjectType var1);

    protected abstract ICacheRegion getObjectRegion(BOSObjectType var1);

    @Override
    public synchronized long getMaxSize() {
        return this.maxSize;
    }

    @Override
    public synchronized void setMaxSize(long size) {
        if (size >= 0x1000000L && size <= Long.MAX_VALUE) {
            this.maxSize = size;
        }
    }

    private void afterGet(BOSObjectType bosType, Object key) {
        if (key == null) {
            int n;
            Object[] arrLRUKey = this.keyLRUList.toArray();
            for (int i = n = arrLRUKey.length - 1; i >= 0; --i) {
                LRUKey lruKey = (LRUKey)arrLRUKey[i];
                if (!lruKey.bosType.equals((Object)bosType) || lruKey.subKey == null || !(lruKey.subKey instanceof BOSUuid)) continue;
                this.moveToFirst(lruKey);
            }
        }
        this.moveToFirst(new LRUKey(bosType, key));
    }

    private final void moveToFirst(LRUKey lruKey) {
        if (this.keyLRUList.remove(lruKey)) {
            this.keyLRUList.addFirst(lruKey);
        }
    }

    private void beforePut(BOSObjectType bosType, Object key, Object objVal, long objSize) {
        this.totalSize += objSize;
        LRUKey lruKey = new LRUKey(bosType, key);
        assert (!this.keyLRUList.contains(lruKey));
        this.keyLRUList.addFirst(lruKey);
        assert (!this.objSizeMap.containsKey(lruKey));
        this.objSizeMap.put(lruKey, new Long(objSize));
        while (this.totalSize > this.maxSize) {
            this.dicardLRU();
        }
    }

    private void dicardLRU() {
        LRUKey lruKey = (LRUKey)this.keyLRUList.getLast();
        this.keyLRUList.removeLast();
        if (this.objSizeMap.containsKey(lruKey) && this.objSizeMap.get(lruKey) != null) {
            this.totalSize -= ((Long)this.objSizeMap.get(lruKey)).longValue();
            this.objSizeMap.remove(lruKey);
        }
        if (lruKey.subKey == null) {
            this.getTypeRegion(lruKey.bosType).remove(OBJECT_COLLECTIONS);
        } else if (lruKey.subKey instanceof BOSUuid) {
            this.getObjectRegion(lruKey.bosType).remove(lruKey.subKey);
            if (this.getTypeRegion(lruKey.bosType).containsKey(OBJECT_COLLECTIONS)) {
                LRUKey colKey = new LRUKey(lruKey.bosType, null);
                this.keyLRUList.remove(colKey);
                this.objSizeMap.remove(colKey);
                this.getTypeRegion(lruKey.bosType).remove(OBJECT_COLLECTIONS);
            }
        } else if (lruKey.subKey instanceof MultiParamKey) {
            this.getTypeRegion(lruKey.bosType).remove(lruKey);
        } else assert (false);
    }

    private void afterDiscardType(BOSObjectType bosType) {
        int n;
        for (int i = n = this.keyLRUList.size() - 1; i >= 0; --i) {
            LRUKey key = (LRUKey)this.keyLRUList.get(i);
            if (!key.bosType.equals((Object)bosType)) continue;
            this.keyLRUList.remove(i);
            if (!this.objSizeMap.containsKey(key) || this.objSizeMap.get(key) == null) continue;
            this.totalSize -= ((Long)this.objSizeMap.get(key)).longValue();
            this.objSizeMap.remove(key);
        }
    }

    private void afterDiscardAll() {
        this.keyLRUList.clear();
        this.objSizeMap.clear();
        this.totalSize = 0L;
    }

    public synchronized void printCache() {
        logger.info((Object)("Item Count: " + this.getItemCount() + "\tTotalt Size:" + this.getTotalSize()));
        int n = this.keyLRUList.size();
        for (int i = 0; i < n; ++i) {
            LRUKey lruKey = (LRUKey)this.keyLRUList.get(i);
            logger.info((Object)(lruKey + "\tSize:" + this.objSizeMap.get(lruKey)));
        }
    }

    @Override
    public final synchronized long getItemCount() {
        assert (this.keyLRUList.size() == this.objSizeMap.size());
        return this.keyLRUList.size();
    }

    @Override
    public final synchronized long getTotalSize() {
        return this.totalSize;
    }

    @Override
    public long getReadNum() {
        return this.readNum;
    }

    @Override
    public long getHitNum() {
        return this.hitNum;
    }

    @Override
    public long getDiscardAllNum() {
        return this.discardAllNum;
    }

    @Override
    public long getDiscardRegionNum() {
        return this.discardRegionNum;
    }

    private class LRUKey {
        public final BOSObjectType bosType;
        public final Object subKey;

        public LRUKey(BOSObjectType bosType, Object subKey) {
            assert (bosType != null);
            this.bosType = bosType;
            this.subKey = subKey;
        }

        public int hashCode() {
            return this.bosType.hashCode() + (this.subKey == null ? 0 : this.subKey.hashCode());
        }

        public boolean equals(Object that) {
            if (that == this) {
                return true;
            }
            if (!(that instanceof LRUKey)) {
                return false;
            }
            if (!this.getClass().getName().equals(that.getClass().getName())) {
                return false;
            }
            if (!this.bosType.equals((Object)((LRUKey)that).bosType)) {
                return false;
            }
            if (this.subKey == null) {
                return ((LRUKey)that).subKey == null;
            }
            return this.subKey.equals(((LRUKey)that).subKey);
        }

        public String toString() {
            return "ObjectType: " + this.bosType + "\tSubKey:" + this.subKey;
        }
    }
}

