/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.framework.cache;

import com.kingdee.bos.framework.cache.UIActionListener;
import com.kingdee.bos.framework.cache.UIActionMonitor;
import com.kingdee.util.ObjectUtils;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class ActionCache
implements UIActionListener {
    private static ActionCache monitor = new ActionCache();
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.bos.framework.cache.ActionCache");
    private static ThreadLocal stackLevel = new ThreadLocal(){

        protected Object initialValue() {
            return 0;
        }
    };
    private static ThreadLocal response = new ThreadLocal(){

        protected Object initialValue() {
            return new HashMap();
        }
    };

    public static boolean containsKey(Object key) {
        boolean isExist = false;
        if (key != null) {
            Map responseMap = (Map)response.get();
            isExist = responseMap.containsKey(key);
        }
        return isExist;
    }

    public static Object get(Object key) {
        Object result = null;
        if (key != null) {
            Map responseMap = (Map)response.get();
            result = responseMap.get(key);
        }
        if (result != null) {
            try {
                result = ObjectUtils.createCopy(result);
            }
            catch (CloneNotSupportedException e) {
                logger.info((Object)("CacheObject is not cloneable: " + key.toString()));
            }
        }
        return result;
    }

    public static void put(Map res) {
        Map responseMap = (Map)response.get();
        responseMap.putAll(res);
        response.set(responseMap);
    }

    public static void clear() {
        Map responseMap = (Map)response.get();
        responseMap.clear();
    }

    public static void init() {
        UIActionMonitor.addListener(monitor);
    }

    @Override
    public void endAction(String ui, String action, long actionTime) {
        Integer level = (Integer)stackLevel.get();
        if (level == 1) {
            ActionCache.clear();
        }
        level = level - 1;
        stackLevel.set(level);
    }

    @Override
    public void startAction(String ui, String action) {
        Integer level = (Integer)stackLevel.get();
        level = level + 1;
        stackLevel.set(level);
    }

    public static boolean isEmpty() {
        Map responseMap = (Map)response.get();
        return responseMap.isEmpty();
    }

    @Override
    public void clearAction() {
    }
}

