/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.framework.cache;

import com.kingdee.bos.framework.cache.config.CacheConfigManager;
import com.kingdee.bos.framework.cache.notify.CacheCleanByTable;
import com.kingdee.bos.framework.cache.notify.CacheCleanImp;
import com.kingdee.bos.framework.cache.notify.CacheCleanManager;
import com.kingdee.bos.framework.cache.notify.CacheCleanStore;
import com.kingdee.bos.framework.session.ISessionManager;
import com.kingdee.bos.framework.session.SessionInfo;
import com.kingdee.bos.framework.session.SessionManager;
import com.kingdee.bos.jcache.CacheEngine;
import com.kingdee.bos.jcache.DistributeNotifier;
import com.kingdee.bos.jcache.Event;
import com.kingdee.bos.jcache.EventListener;
import com.kingdee.bos.jcache.jgroups.JGroupsNotifier;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;

public class CacheCleanSender
implements Runnable {
    private static Logger logger = Logger.getLogger((String)CacheCleanSender.class.getName());
    private boolean distribute = false;
    private String channelStack;
    private String channelName;
    private static final String defaultChannelName = "CacheNotifierGroup";
    private static final String defaultChannelStack = "UDP(down_thread=false;mcast_addr=228.1.2.3;mcast_port=45566;ip_ttl=32;up_thread=false):PING(timeout=3000;down_thread=false;num_initial_members=6;up_thread=false):FD(down_thread=false;timeout=3000;up_thread=false):VERIFY_SUSPECT(down_thread=false;timeout=1500;up_thread=false):pbcast.NAKACK(down_thread=false;gc_lag=10;retransmit_timeout=600,1200,2400,4800;up_thread=false):UNICAST(down_thread=false;timeout=600,1200,2400,4800;up_thread=false):pbcast.STABLE(down_thread=false;desired_avg_gossip=10000;up_thread=false):FRAG(down_thread=false;up_thread=false):pbcast.GMS(down_thread=false;join_timeout=5000;join_retry_timeout=2000;shun=true;print_local_addr=true;up_thread=false)";

    CacheCleanSender() {
        this.intitDistributeConfig();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void intitDistributeConfig() {
        String propertiesFileName = "CacheDistribute.properties";
        String pathEnv = "eas.deploy";
        String cfgFilePath = new StringBuffer().append(System.getProperty("eas.deploy", "")).append(File.separator).append("CacheDistribute.properties").toString();
        File cfgFile = new File(cfgFilePath);
        if (cfgFile.exists()) {
            FileInputStream fs = null;
            try {
                fs = new FileInputStream(cfgFile);
                Properties props = new Properties();
                props.load(fs);
                String sdistribute = props.getProperty("distribute");
                this.distribute = Boolean.valueOf(sdistribute);
                this.channelStack = props.getProperty("channelStack", defaultChannelStack);
                this.channelName = props.getProperty("channelName", defaultChannelName);
            }
            catch (IOException ioe) {
                logger.warn((Object)"can not found CacheDistribute.properties");
            }
            finally {
                if (fs != null) {
                    try {
                        fs.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    public static void start() {
        boolean isCache = CacheConfigManager.getConfig().needCache();
        if (!isCache) {
            return;
        }
        CacheCleanManager.registerCacheCleanListener(new CacheCleanImp());
        CacheCleanSender sender = new CacheCleanSender();
        if (sender.distribute) {
            sender.acceptNotify();
        }
        Thread run = new Thread((Runnable)sender, "CacheCleanSender");
        run.start();
        logger.debug((Object)"+++CacheCleanSender service started.");
    }

    @Override
    public void run() {
        try {
            while (true) {
                this.updateSessionList();
                Thread.sleep(30000L);
            }
        }
        catch (InterruptedException e) {
            logger.error((Object)e);
            return;
        }
    }

    private void updateSessionList() {
        List tempMethodList = CacheCleanStore.getMethodList();
        List tempUserList = CacheCleanStore.getUserList();
        ArrayList methodList = new ArrayList();
        ArrayList userList = new ArrayList();
        methodList.addAll(tempMethodList);
        userList.addAll(tempUserList);
        tempMethodList.clear();
        tempUserList.clear();
        HashSet typeSet = CacheCleanByTable.getGlobalTypeSet();
        typeSet.addAll(methodList);
        if (typeSet.size() == 0 && tempUserList.size() == 0) {
            return;
        }
        ISessionManager sessionManager = SessionManager.getInstance();
        List sessionList = sessionManager.getSessionList();
        for (SessionInfo info : sessionList) {
            String userId = info.getContext().getCaller().toString();
            if (userId != null && userList.contains(userId)) {
                info.put((Object)"CLEANCACHE", (Object)Boolean.TRUE);
                userList.remove(userId);
                continue;
            }
            if (typeSet.size() <= 0) continue;
            ArrayList oldList = (ArrayList)info.get((Object)"CLEANMETHOD");
            if (oldList != null) {
                typeSet.addAll(oldList);
            }
            oldList = new ArrayList(typeSet);
            info.put((Object)"CLEANMETHOD", oldList);
        }
        if (this.distribute && (userList.size() > 0 || methodList.size() > 0)) {
            this.broadNotify(userList, methodList);
        }
    }

    private void broadNotify(List userList, List methodList) {
        int id = 5000;
        try {
            HashMap<String, List> notifyMap = new HashMap<String, List>();
            notifyMap.put("CLEANCACHE", userList);
            notifyMap.put("CLEANMETHOD", methodList);
            String ip = InetAddress.getLocalHost().getHostAddress();
            Event event = new Event(id, notifyMap, (Object)ip);
            CacheEngine.postDistributeEvent((Event)event);
        }
        catch (Exception e) {
            logger.error((Object)"broadNotify error", (Throwable)e);
        }
    }

    private void acceptNotify() {
        EventListener listener = new EventListener(){

            public void onEvent(Event event) {
                if (event.id != 5000) {
                    return;
                }
                try {
                    Map notifyMap;
                    String parameter = "";
                    String ip = InetAddress.getLocalHost().getHostAddress();
                    if (event.parameter != null && event.parameter instanceof String) {
                        parameter = (String)event.parameter;
                    }
                    if (parameter.equals(ip)) {
                        return;
                    }
                    Object source = event.source;
                    if (source != null && source instanceof Map && (notifyMap = (Map)source).size() == 2) {
                        List userList = (List)notifyMap.get("CLEANCACHE");
                        List localUserList = CacheCleanStore.getUserList();
                        for (int i = 0; i < userList.size(); ++i) {
                            if (localUserList.contains(userList.get(i))) continue;
                            localUserList.add(userList.get(i));
                        }
                    }
                }
                catch (Exception e) {
                    logger.error((Object)"process event error", (Throwable)e);
                }
            }
        };
        int from = 0;
        int to = 1000;
        try {
            JGroupsNotifier notifier = null;
            notifier = new JGroupsNotifier(this.channelStack, this.channelName);
            CacheEngine.initDistributeNotifier((DistributeNotifier)notifier);
            CacheEngine.addEventListener((int)from, (int)to, (EventListener)listener);
        }
        catch (Exception e) {
            logger.error((Object)"init Cache notify listener error", (Throwable)e);
        }
    }
}

