/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.framework.cache;

import com.kingdee.bos.framework.cache.CacheManageMBean;
import com.kingdee.bos.framework.cache.CacheServiceFactory;
import com.kingdee.bos.framework.cache.ICacheService;
import com.kingdee.bos.framework.cache.config.CacheConfigManager;
import com.kingdee.bos.framework.cache.config.ICacheConfig;
import com.kingdee.bos.framework.cache.service.memcache.MemcacheManager;
import com.kingdee.bos.framework.cache.service.memcache.MemcacheService;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public class CacheManage
implements CacheManageMBean {
    @Override
    public boolean isServerCache() {
        ICacheConfig config = CacheConfigManager.getConfig();
        if (config != null) {
            return config.needServerCache();
        }
        return false;
    }

    @Override
    public void setServerCache(boolean isValid) {
        ICacheConfig config = CacheConfigManager.getConfig();
        if (config != null) {
            config.setServerCache(isValid);
            if (!isValid) {
                ICacheService svc = CacheServiceFactory.getInstance();
                svc.discardAll();
            }
        }
    }

    @Override
    public Map stats() {
        return MemcacheManager.getInstance().getMemClient().stats();
    }

    @Override
    public String getMemcachedServerlist() {
        HashSet<String> lvset = MemcacheService.getInstance().getMemcacheServerLiveList();
        if (lvset != null && lvset.size() > 0) {
            StringBuffer sbr = new StringBuffer();
            Iterator<String> iterator = lvset.iterator();
            while (iterator.hasNext()) {
                sbr = sbr.append(iterator.next()).append(";");
                System.out.println(iterator.next());
            }
            return sbr.toString();
        }
        return null;
    }

    @Override
    public long getTotalSize() {
        return MemcacheManager.getInstance().getBytes();
    }

    @Override
    public long getHitNum() {
        return MemcacheManager.getInstance().getHits();
    }

    @Override
    public long getReadNum() {
        return MemcacheManager.getInstance().getReads();
    }

    @Override
    public long getItemCount() {
        return MemcacheManager.getInstance().getItems();
    }

    @Override
    public double getHitRatio() {
        if (this.getMemcachedServerlist() != null && this.getReadNum() != 0L) {
            return (double)this.getHitNum() / (double)this.getReadNum();
        }
        return 0.0;
    }

    @Override
    public long getPuts() {
        return MemcacheManager.getInstance().getPuts();
    }
}

