/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.framework.cache;

import com.kingdee.bos.framework.cache.CacheStatInfo;
import com.kingdee.bos.framework.cache.CacheStatKey;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.log4j.Logger;

public class CacheStat {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.bos.framework.cache.CacheStat");
    private static final CacheStat cacheStat = new CacheStat();
    private final Hashtable stats = new Hashtable();
    private boolean enable = false;

    protected CacheStat() {
    }

    public static CacheStat getInstance() {
        return cacheStat;
    }

    public final synchronized void setEnable(boolean enable) {
        this.enable = enable;
    }

    public final synchronized boolean isEnable() {
        return this.enable;
    }

    public synchronized void clearStat() {
        this.stats.clear();
    }

    public synchronized CacheStatInfo getStat(CacheStatKey key) {
        if (!this.stats.containsKey(key)) {
            this.stats.put(key, new CacheStatInfo());
        }
        return (CacheStatInfo)this.stats.get(key);
    }

    public synchronized void doStat(CacheStatKey key, boolean isHit) {
        if (this.stats.containsKey(key)) {
            ((CacheStatInfo)this.stats.get(key)).addAccess(isHit);
        } else {
            this.stats.put(key, new CacheStatInfo(isHit));
        }
    }

    public synchronized void printStat() {
        int fromDb = 0;
        int totalAccess = 0;
        String out = null;
        logger.info((Object)"=== stat begin ===");
        Enumeration e = this.stats.keys();
        while (e.hasMoreElements()) {
            CacheStatKey key = (CacheStatKey)e.nextElement();
            CacheStatInfo info = (CacheStatInfo)this.stats.get(key);
            out = key.toString();
            out = out + "\t" + Integer.valueOf(info.getTotalAccess() - info.getFromDb());
            out = out + "\t" + Integer.valueOf(info.getFromDb());
            out = out + "\t" + new Float(1.0 - (double)info.getFromDb() * 1.0 / (double)info.getTotalAccess());
            logger.info((Object)out);
            fromDb += info.getFromDb();
            totalAccess += info.getTotalAccess();
        }
        out = "CacheStat Total:";
        out = out + "\t" + Integer.valueOf(totalAccess - fromDb);
        out = out + "\t" + Integer.valueOf(fromDb);
        out = out + "\t" + new Float(1.0 - (double)fromDb * 1.0 / (double)totalAccess);
        logger.info((Object)out);
    }
}

