/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.framework.cache;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.LazyRemoteObjectCreator;
import com.kingdee.bos.framework.cache.ActionCache;
import com.kingdee.bos.framework.cache.CacheServiceFactory;
import com.kingdee.bos.framework.cache.CachedInvokeMonitor;
import com.kingdee.bos.framework.cache.ICacheService;
import com.kingdee.bos.framework.cache.InvokeStackCache;
import com.kingdee.bos.framework.cache.MultiParamKey;
import com.kingdee.bos.framework.cache.config.CacheConfigManager;
import com.kingdee.bos.framework.cache.config.ICacheConfig;
import com.kingdee.bos.framework.cache.config.MethodIntent;
import com.kingdee.bos.util.BOSObjectType;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class CachedInvokeInterceptor
implements InvocationHandler {
    private static final Logger logger = Logger.getLogger(CachedInvokeInterceptor.class);
    private final BOSObjectType bosType;
    private LazyRemoteObjectCreator lazyCreator;
    private final Class model;
    protected Object target;
    private static final HashSet<CachedInvokeMonitor> monitorSet = new HashSet(1);

    public static void addMonitor(CachedInvokeMonitor monitor) {
        monitorSet.add(monitor);
    }

    public static void removeMonitor(CachedInvokeMonitor monitor) {
        monitorSet.remove(monitor);
    }

    public void notifyMonitorSet(Method method, long timespan) {
        for (CachedInvokeMonitor monitor : monitorSet) {
            monitor.passCachedInvokeInfo(method, timespan);
        }
    }

    public CachedInvokeInterceptor(Object target, BOSObjectType bosType, Class model, LazyRemoteObjectCreator lazyCreator) {
        this.bosType = bosType;
        this.target = target;
        this.lazyCreator = lazyCreator;
        this.model = model;
    }

    public CachedInvokeInterceptor(Object target, BOSObjectType bosType, Class model, Context ctx, LazyRemoteObjectCreator lazyCreator) {
        this.bosType = bosType;
        this.target = target;
        this.model = model;
        this.lazyCreator = lazyCreator;
    }

    public CachedInvokeInterceptor(Object target, Class model, LazyRemoteObjectCreator lazyCreator) {
        this.bosType = null;
        this.target = target;
        this.model = model;
        this.lazyCreator = lazyCreator;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        MultiParamKey key;
        InvokeStackCache localCache;
        MultiParamKey responseKey;
        if (method != null && this.bosType != null && method.getName().equals("getType") && (args == null || args.length == 0)) {
            return this.bosType;
        }
        if (!ActionCache.isEmpty() && ActionCache.containsKey(((Object)(responseKey = MultiParamKey.create(this.model, method, args))).toString())) {
            return ActionCache.get(((Object)responseKey).toString());
        }
        if (!method.getReturnType().equals(Void.TYPE) && (localCache = InvokeStackCache.getInstance()).depth() > 0 && localCache.containsKey(key = MultiParamKey.create(this.model, method, args))) {
            return localCache.get(key);
        }
        try {
            return this.cachedInvoke(proxy, method, args);
        }
        catch (IllegalAccessException illAccEx) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Proxy invoke catch a IllegalAccessException", (Throwable)illAccEx);
            }
            throw illAccEx;
        }
        catch (IllegalArgumentException illArgEx) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Prxoy invoke catch a IllegalArgumentException", (Throwable)illArgEx);
            }
            throw illArgEx;
        }
        catch (InvocationTargetException ie) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Proxy Invoke catch a target Exception, process continue", (Throwable)ie);
            }
            Throwable t = ie.getCause();
            throw t;
        }
    }

    private Object cachedInvoke(Object proxy, Method method, Object[] args) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, BOSException {
        ICacheConfig config = CacheConfigManager.getConfig();
        ICacheService svc = CacheServiceFactory.getInstance();
        if (config == null) {
            return method.invoke(this.lazyCreateObject(), args);
        }
        if (this.bosType == null) {
            return method.invoke(this.lazyCreateObject(), args);
        }
        Object retVal = null;
        MethodIntent intent = this.getMethodIntent(method);
        BOSObjectType realType = config.getFacadeRealBosType(this.bosType, method);
        if (realType == null) {
            realType = this.bosType;
        }
        if (MethodIntent.GET_TYPE.equals((Object)intent)) {
            retVal = realType;
        } else {
            retVal = method.invoke(this.lazyCreateObject(), args);
            if (MethodIntent.WRITE.equals((Object)intent) && config.needQueryCache(realType)) {
                svc.discardType(realType);
            }
        }
        return retVal;
    }

    private MethodIntent getMethodIntent(Method mthd) {
        MethodIntent intent;
        if (mthd.getName().equals("getType") && this.bosType != null) {
            return MethodIntent.GET_TYPE;
        }
        ICacheConfig config = CacheConfigManager.getConfig();
        if (config != null && (intent = config.getMethodIntent(this.bosType, mthd)) != null) {
            return intent;
        }
        return MethodIntent.UNKNOWN;
    }

    private synchronized Object lazyCreateObject() {
        if (this.lazyCreator != null) {
            this.target = this.lazyCreator.lazyCreate();
            this.lazyCreator = null;
        }
        return this.target;
    }
}

