/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.framework.cache;

import com.kingdee.bos.Context;
import com.kingdee.bos.LazyRemoteObjectCreator;
import com.kingdee.bos.RemoteBOSObjectFactory;
import com.kingdee.bos.framework.cache.CachedInvokeInterceptor;
import com.kingdee.bos.rpc.RPCException;
import com.kingdee.bos.rpc.ce.RPCConnectException;
import com.kingdee.bos.rpc.impl.RPCService;
import com.kingdee.bos.util.BOSObjectType;
import java.io.StreamCorruptedException;
import java.lang.reflect.Method;
import org.apache.log4j.Logger;

public class CachedInvokeInterceptor2
extends CachedInvokeInterceptor {
    private static final Logger logger = Logger.getLogger(CachedInvokeInterceptor2.class);
    private final String rpcURL;
    private final String objectName;
    private final Class model;
    private final Class[] argTypes;
    private final Object[] args;
    private static boolean redistributed = false;

    public CachedInvokeInterceptor2(Object target, BOSObjectType bosType, LazyRemoteObjectCreator lazyCreator, String rpcURL, String objectName, Class model, Class[] argTypes, Object[] args) {
        super(target, bosType, model, lazyCreator);
        this.rpcURL = rpcURL;
        this.objectName = objectName;
        this.model = model;
        this.argTypes = argTypes;
        this.args = args;
    }

    public CachedInvokeInterceptor2(Object target, BOSObjectType bosType, Context context, LazyRemoteObjectCreator lazyCreator, String rpcURL, String objectName, Class model, Class[] argTypes, Object[] args) {
        super(target, bosType, model, context, lazyCreator);
        this.rpcURL = rpcURL;
        this.objectName = objectName;
        this.model = model;
        this.argTypes = argTypes;
        this.args = args;
    }

    public CachedInvokeInterceptor2(Object target, String className, LazyRemoteObjectCreator lazyCreator, String rpcURL, String objectName, Class model, Class[] argTypes, Object[] args) {
        super(target, model, lazyCreator);
        this.rpcURL = rpcURL;
        this.objectName = objectName;
        this.model = model;
        this.argTypes = argTypes;
        this.args = args;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] arguments) throws Throwable {
        try {
            return super.invoke(proxy, method, arguments);
        }
        catch (Throwable e) {
            if (this.canReInvoke(e)) {
                if (this.isSlaver2MasterSCE(e)) {
                    RemoteBOSObjectFactory.getInstance((String)this.rpcURL).clearSession();
                }
                this.target = RemoteBOSObjectFactory.getInstance((String)this.rpcURL).getSession().createObject(this.objectName, this.model, this.argTypes, this.args);
                return super.invoke(proxy, method, arguments);
            }
            throw e;
        }
    }

    private boolean canReInvoke(Throwable e) {
        if (RPCException.getErrorCode((Throwable)e) == 1001) {
            return true;
        }
        if (RPCException.getErrorCode((Throwable)e) == 1005 && RPCService.inServiceInvoke.get() != null && e instanceof RPCConnectException) {
            return ((RPCConnectException)e).getType() == 6002 || ((RPCConnectException)e).getType() == 6005;
        }
        if (this.isSlaver2MasterSCE(e)) {
            return true;
        }
        return redistributed && RPCException.getErrorCode((Throwable)e) == 1002;
    }

    private boolean isSlaver2MasterSCE(Throwable t) {
        return RPCService.inServiceInvoke.get() != null && this.isStreamCorruptedException(t);
    }

    private boolean isStreamCorruptedException(Throwable t) {
        if (t instanceof Exception) {
            Exception e = (Exception)t;
            if (e instanceof StreamCorruptedException) {
                return true;
            }
            return this.isStreamCorruptedException(e.getCause());
        }
        return false;
    }

    public static boolean isRedistributed() {
        return redistributed;
    }

    public static void setRedistributed(boolean redistributed) {
        CachedInvokeInterceptor2.redistributed = redistributed;
    }
}

