/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.framework.cache;

import com.kingdee.bos.framework.cache.ICustomCacheService;
import com.kingdee.bos.framework.cache.service.CacheService;

public class CustomCacheService {
    private String type;
    private ICustomCacheService service;

    public CustomCacheService(String type) {
        this.type = type;
        this.service = CacheService.getInstance();
    }

    public boolean contains(String key) {
        if (this.service == null) {
            return false;
        }
        return this.service.contains(this.type, key);
    }

    public void put(String key, Object obj) {
        if (this.service != null && obj != null) {
            this.service.put(this.type, key, obj);
        }
    }

    public Object get(String key) {
        if (this.service == null) {
            return null;
        }
        return this.service.get(this.type, key);
    }

    public void remove(String key) {
        if (this.service != null) {
            this.service.remove(this.type, key);
        }
    }

    public void remove(String key, boolean realRemove) {
        if (this.service != null) {
            this.service.remove(this.type, key, realRemove);
        }
    }

    public void removeAll() {
        if (this.service != null) {
            this.service.removeAll(this.type);
        }
    }

    public boolean contains(String aix, String key) {
        if (this.service == null) {
            return false;
        }
        return this.service.containsByAix(aix, this.type, key);
    }

    public void put(String aix, String key, Object obj) {
        if (this.service != null) {
            this.service.putByAix(aix, this.type, key, obj);
        }
    }

    public Object get(String aix, String key) {
        if (this.service == null) {
            return null;
        }
        return this.service.getByAix(aix, this.type, key);
    }

    public void remove(String aix, String key) {
        if (this.service != null) {
            this.service.removeByAix(aix, this.type, key);
        }
    }

    public void remove(String aix, String key, boolean realRemove) {
        if (this.service != null) {
            this.service.removeByAix(aix, this.type, key, realRemove);
        }
    }

    public void hset(String key, String field, Object obj) {
        if (this.service != null) {
            this.service.hset(this.type, key, field, obj);
        }
    }

    public Object hget(String key, String field) {
        if (this.service != null) {
            return this.service.hget(this.type, key, field);
        }
        return null;
    }

    public void hdel(String key) {
        if (this.service != null) {
            this.service.hdel(this.type, key);
        }
    }

    public void hdel(String key, String field) {
        if (this.service != null) {
            this.service.hdel(this.type, key, field);
        }
    }

    public void removeLocal(String key) {
        if (this.service != null) {
            this.service.removeLocal(this.type, key);
        }
    }
}

